/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ItemModelMesher {
    private final Map<Integer, ModelResourceLocation> simpleShapes = Maps.newHashMap();
    private final Map<Integer, IBakedModel> simpleShapesCache = Maps.newHashMap();
    private final Map<Item, ItemMeshDefinition> shapers = Maps.newHashMap();
    private final ModelManager modelManager;

    public ItemModelMesher(ModelManager p_i46250_1_) {
        this.modelManager = p_i46250_1_;
    }

    public TextureAtlasSprite getParticleIcon(Item p_getParticleIcon_1_) {
        return this.getParticleIcon(p_getParticleIcon_1_, 0);
    }

    public TextureAtlasSprite getParticleIcon(Item p_getParticleIcon_1_, int p_getParticleIcon_2_) {
        ItemStack stack = new ItemStack(p_getParticleIcon_1_, 1, p_getParticleIcon_2_);
        IBakedModel model = this.getItemModel(stack);
        return model.getOverrides().handleItemState(model, stack, null, null).getParticleTexture();
    }

    public IBakedModel getItemModel(ItemStack p_getItemModel_1_) {
        ItemMeshDefinition itemmeshdefinition;
        Item item = p_getItemModel_1_.getItem();
        IBakedModel ibakedmodel = this.getItemModel(item, this.getMetadata(p_getItemModel_1_));
        if (ibakedmodel == null && (itemmeshdefinition = this.shapers.get(item)) != null) {
            ibakedmodel = this.modelManager.getModel(itemmeshdefinition.getModelLocation(p_getItemModel_1_));
        }
        if (ibakedmodel == null) {
            ibakedmodel = this.modelManager.getMissingModel();
        }
        return ibakedmodel;
    }

    protected int getMetadata(ItemStack p_getMetadata_1_) {
        return p_getMetadata_1_.getMaxDamage() > 0 ? 0 : p_getMetadata_1_.getMetadata();
    }

    @Nullable
    protected IBakedModel getItemModel(Item p_getItemModel_1_, int p_getItemModel_2_) {
        return this.simpleShapesCache.get(this.getIndex(p_getItemModel_1_, p_getItemModel_2_));
    }

    private int getIndex(Item p_getIndex_1_, int p_getIndex_2_) {
        return Item.getIdFromItem(p_getIndex_1_) << 16 | p_getIndex_2_;
    }

    public void register(Item p_register_1_, int p_register_2_, ModelResourceLocation p_register_3_) {
        this.simpleShapes.put(this.getIndex(p_register_1_, p_register_2_), p_register_3_);
        this.simpleShapesCache.put(this.getIndex(p_register_1_, p_register_2_), this.modelManager.getModel(p_register_3_));
    }

    public void register(Item p_register_1_, ItemMeshDefinition p_register_2_) {
        this.shapers.put(p_register_1_, p_register_2_);
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }

    public void rebuildCache() {
        this.simpleShapesCache.clear();
        for (Map.Entry<Integer, ModelResourceLocation> entry : this.simpleShapes.entrySet()) {
            this.simpleShapesCache.put(entry.getKey(), this.modelManager.getModel(entry.getValue()));
        }
    }
}

