/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.base.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ItemRenderer {
    private static final ResourceLocation RES_MAP_BACKGROUND = new ResourceLocation("textures/map/map_background.png");
    private static final ResourceLocation RES_UNDERWATER_OVERLAY = new ResourceLocation("textures/misc/underwater.png");
    private final Minecraft mc;
    private ItemStack itemStackMainHand = ItemStack.EMPTY;
    private ItemStack itemStackOffHand = ItemStack.EMPTY;
    private float equippedProgressMainHand;
    private float prevEquippedProgressMainHand;
    private float equippedProgressOffHand;
    private float prevEquippedProgressOffHand;
    private final RenderManager renderManager;
    private final RenderItem itemRenderer;

    public ItemRenderer(Minecraft p_i1247_1_) {
        this.mc = p_i1247_1_;
        this.renderManager = p_i1247_1_.getRenderManager();
        this.itemRenderer = p_i1247_1_.getRenderItem();
    }

    public void renderItem(EntityLivingBase p_renderItem_1_, ItemStack p_renderItem_2_, ItemCameraTransforms.TransformType p_renderItem_3_) {
        this.renderItemSide(p_renderItem_1_, p_renderItem_2_, p_renderItem_3_, false);
    }

    public void renderItemSide(EntityLivingBase p_renderItemSide_1_, ItemStack p_renderItemSide_2_, ItemCameraTransforms.TransformType p_renderItemSide_3_, boolean p_renderItemSide_4_) {
        if (!p_renderItemSide_2_.isEmpty()) {
            boolean flag;
            Item item = p_renderItemSide_2_.getItem();
            Block block = Block.getBlockFromItem(item);
            GlStateManager.pushMatrix();
            boolean bl = flag = this.itemRenderer.shouldRenderItemIn3D(p_renderItemSide_2_) && block.getBlockLayer() == BlockRenderLayer.TRANSLUCENT;
            if (flag) {
                GlStateManager.depthMask(false);
            }
            this.itemRenderer.renderItem(p_renderItemSide_2_, p_renderItemSide_1_, p_renderItemSide_3_, p_renderItemSide_4_);
            if (flag) {
                GlStateManager.depthMask(true);
            }
            GlStateManager.popMatrix();
        }
    }

    private void rotateArroundXAndY(float p_rotateArroundXAndY_1_, float p_rotateArroundXAndY_2_) {
        GlStateManager.pushMatrix();
        GlStateManager.rotate(p_rotateArroundXAndY_1_, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate(p_rotateArroundXAndY_2_, 0.0f, 1.0f, 0.0f);
        RenderHelper.enableStandardItemLighting();
        GlStateManager.popMatrix();
    }

    private void setLightmap() {
        EntityPlayerSP abstractclientplayer = this.mc.player;
        int i = this.mc.world.getCombinedLight(new BlockPos(abstractclientplayer.posX, abstractclientplayer.posY + (double)abstractclientplayer.getEyeHeight(), abstractclientplayer.posZ), 0);
        float f = i & 0xFFFF;
        float f1 = i >> 16;
        OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, f, f1);
    }

    private void rotateArm(float p_rotateArm_1_) {
        EntityPlayerSP entityplayersp = this.mc.player;
        float f = entityplayersp.prevRenderArmPitch + (entityplayersp.renderArmPitch - entityplayersp.prevRenderArmPitch) * p_rotateArm_1_;
        float f1 = entityplayersp.prevRenderArmYaw + (entityplayersp.renderArmYaw - entityplayersp.prevRenderArmYaw) * p_rotateArm_1_;
        GlStateManager.rotate((entityplayersp.rotationPitch - f) * 0.1f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate((entityplayersp.rotationYaw - f1) * 0.1f, 0.0f, 1.0f, 0.0f);
    }

    private float getMapAngleFromPitch(float p_getMapAngleFromPitch_1_) {
        float f = 1.0f - p_getMapAngleFromPitch_1_ / 45.0f + 0.1f;
        f = MathHelper.clamp(f, 0.0f, 1.0f);
        f = -MathHelper.cos(f * (float)Math.PI) * 0.5f + 0.5f;
        return f;
    }

    private void renderArms() {
        if (!this.mc.player.isInvisible()) {
            GlStateManager.disableCull();
            GlStateManager.pushMatrix();
            GlStateManager.rotate(90.0f, 0.0f, 1.0f, 0.0f);
            this.renderArm(EnumHandSide.RIGHT);
            this.renderArm(EnumHandSide.LEFT);
            GlStateManager.popMatrix();
            GlStateManager.enableCull();
        }
    }

    private void renderArm(EnumHandSide p_renderArm_1_) {
        this.mc.getTextureManager().bindTexture(this.mc.player.getLocationSkin());
        Render<EntityPlayerSP> render = this.renderManager.getEntityRenderObject(this.mc.player);
        RenderPlayer renderplayer = (RenderPlayer)render;
        GlStateManager.pushMatrix();
        float f = p_renderArm_1_ == EnumHandSide.RIGHT ? 1.0f : -1.0f;
        GlStateManager.rotate(92.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate(45.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate(f * -41.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.translate(f * 0.3f, -1.1f, 0.45f);
        if (p_renderArm_1_ == EnumHandSide.RIGHT) {
            renderplayer.renderRightArm(this.mc.player);
        } else {
            renderplayer.renderLeftArm(this.mc.player);
        }
        GlStateManager.popMatrix();
    }

    private void renderMapFirstPersonSide(float p_renderMapFirstPersonSide_1_, EnumHandSide p_renderMapFirstPersonSide_2_, float p_renderMapFirstPersonSide_3_, ItemStack p_renderMapFirstPersonSide_4_) {
        float f = p_renderMapFirstPersonSide_2_ == EnumHandSide.RIGHT ? 1.0f : -1.0f;
        GlStateManager.translate(f * 0.125f, -0.125f, 0.0f);
        if (!this.mc.player.isInvisible()) {
            GlStateManager.pushMatrix();
            GlStateManager.rotate(f * 10.0f, 0.0f, 0.0f, 1.0f);
            this.renderArmFirstPerson(p_renderMapFirstPersonSide_1_, p_renderMapFirstPersonSide_3_, p_renderMapFirstPersonSide_2_);
            GlStateManager.popMatrix();
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate(f * 0.51f, -0.08f + p_renderMapFirstPersonSide_1_ * -1.2f, -0.75f);
        float f1 = MathHelper.sqrt(p_renderMapFirstPersonSide_3_);
        float f2 = MathHelper.sin(f1 * (float)Math.PI);
        float f3 = -0.5f * f2;
        float f4 = 0.4f * MathHelper.sin(f1 * ((float)Math.PI * 2));
        float f5 = -0.3f * MathHelper.sin(p_renderMapFirstPersonSide_3_ * (float)Math.PI);
        GlStateManager.translate(f * f3, f4 - 0.3f * f2, f5);
        GlStateManager.rotate(f2 * -45.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate(f * f2 * -30.0f, 0.0f, 1.0f, 0.0f);
        this.renderMapFirstPerson(p_renderMapFirstPersonSide_4_);
        GlStateManager.popMatrix();
    }

    private void renderMapFirstPerson(float p_renderMapFirstPerson_1_, float p_renderMapFirstPerson_2_, float p_renderMapFirstPerson_3_) {
        float f = MathHelper.sqrt(p_renderMapFirstPerson_3_);
        float f1 = -0.2f * MathHelper.sin(p_renderMapFirstPerson_3_ * (float)Math.PI);
        float f2 = -0.4f * MathHelper.sin(f * (float)Math.PI);
        GlStateManager.translate(0.0f, -f1 / 2.0f, f2);
        float f3 = this.getMapAngleFromPitch(p_renderMapFirstPerson_1_);
        GlStateManager.translate(0.0f, 0.04f + p_renderMapFirstPerson_2_ * -1.2f + f3 * -0.5f, -0.72f);
        GlStateManager.rotate(f3 * -85.0f, 1.0f, 0.0f, 0.0f);
        this.renderArms();
        float f4 = MathHelper.sin(f * (float)Math.PI);
        GlStateManager.rotate(f4 * 20.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.scale(2.0f, 2.0f, 2.0f);
        this.renderMapFirstPerson(this.itemStackMainHand);
    }

    private void renderMapFirstPerson(ItemStack p_renderMapFirstPerson_1_) {
        GlStateManager.rotate(180.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate(180.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.scale(0.38f, 0.38f, 0.38f);
        GlStateManager.disableLighting();
        this.mc.getTextureManager().bindTexture(RES_MAP_BACKGROUND);
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        GlStateManager.translate(-0.5f, -0.5f, 0.0f);
        GlStateManager.scale(0.0078125f, 0.0078125f, 0.0078125f);
        vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        vertexbuffer.pos(-7.0, 135.0, 0.0).tex(0.0, 1.0).endVertex();
        vertexbuffer.pos(135.0, 135.0, 0.0).tex(1.0, 1.0).endVertex();
        vertexbuffer.pos(135.0, -7.0, 0.0).tex(1.0, 0.0).endVertex();
        vertexbuffer.pos(-7.0, -7.0, 0.0).tex(0.0, 0.0).endVertex();
        tessellator.draw();
        MapData mapdata = Items.FILLED_MAP.getMapData(p_renderMapFirstPerson_1_, this.mc.world);
        if (mapdata != null) {
            this.mc.entityRenderer.getMapItemRenderer().renderMap(mapdata, false);
        }
        GlStateManager.enableLighting();
    }

    private void renderArmFirstPerson(float p_renderArmFirstPerson_1_, float p_renderArmFirstPerson_2_, EnumHandSide p_renderArmFirstPerson_3_) {
        boolean flag = p_renderArmFirstPerson_3_ != EnumHandSide.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = MathHelper.sqrt(p_renderArmFirstPerson_2_);
        float f2 = -0.3f * MathHelper.sin(f1 * (float)Math.PI);
        float f3 = 0.4f * MathHelper.sin(f1 * ((float)Math.PI * 2));
        float f4 = -0.4f * MathHelper.sin(p_renderArmFirstPerson_2_ * (float)Math.PI);
        GlStateManager.translate(f * (f2 + 0.64000005f), f3 + -0.6f + p_renderArmFirstPerson_1_ * -0.6f, f4 + -0.71999997f);
        GlStateManager.rotate(f * 45.0f, 0.0f, 1.0f, 0.0f);
        float f5 = MathHelper.sin(p_renderArmFirstPerson_2_ * p_renderArmFirstPerson_2_ * (float)Math.PI);
        float f6 = MathHelper.sin(f1 * (float)Math.PI);
        GlStateManager.rotate(f * f6 * 70.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate(f * f5 * -20.0f, 0.0f, 0.0f, 1.0f);
        EntityPlayerSP abstractclientplayer = this.mc.player;
        this.mc.getTextureManager().bindTexture(abstractclientplayer.getLocationSkin());
        GlStateManager.translate(f * -1.0f, 3.6f, 3.5f);
        GlStateManager.rotate(f * 120.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.rotate(200.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate(f * -135.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.translate(f * 5.6f, 0.0f, 0.0f);
        RenderPlayer renderplayer = (RenderPlayer)this.renderManager.getEntityRenderObject(abstractclientplayer);
        GlStateManager.disableCull();
        if (flag) {
            renderplayer.renderRightArm(abstractclientplayer);
        } else {
            renderplayer.renderLeftArm(abstractclientplayer);
        }
        GlStateManager.enableCull();
    }

    private void transformEatFirstPerson(float p_transformEatFirstPerson_1_, EnumHandSide p_transformEatFirstPerson_2_, ItemStack p_transformEatFirstPerson_3_) {
        float f = (float)this.mc.player.getItemInUseCount() - p_transformEatFirstPerson_1_ + 1.0f;
        float f1 = f / (float)p_transformEatFirstPerson_3_.getMaxItemUseDuration();
        if (f1 < 0.8f) {
            float f2 = MathHelper.abs(MathHelper.cos(f / 4.0f * (float)Math.PI) * 0.1f);
            GlStateManager.translate(0.0f, f2, 0.0f);
        }
        float f3 = 1.0f - (float)Math.pow(f1, 27.0);
        int i = p_transformEatFirstPerson_2_ == EnumHandSide.RIGHT ? 1 : -1;
        GlStateManager.translate(f3 * 0.6f * (float)i, f3 * -0.5f, f3 * 0.0f);
        GlStateManager.rotate((float)i * f3 * 90.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate(f3 * 10.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate((float)i * f3 * 30.0f, 0.0f, 0.0f, 1.0f);
    }

    private void transformFirstPerson(EnumHandSide p_transformFirstPerson_1_, float p_transformFirstPerson_2_) {
        int i = p_transformFirstPerson_1_ == EnumHandSide.RIGHT ? 1 : -1;
        float f = MathHelper.sin(p_transformFirstPerson_2_ * p_transformFirstPerson_2_ * (float)Math.PI);
        GlStateManager.rotate((float)i * (45.0f + f * -20.0f), 0.0f, 1.0f, 0.0f);
        float f1 = MathHelper.sin(MathHelper.sqrt(p_transformFirstPerson_2_) * (float)Math.PI);
        GlStateManager.rotate((float)i * f1 * -20.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.rotate(f1 * -80.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate((float)i * -45.0f, 0.0f, 1.0f, 0.0f);
    }

    private void transformSideFirstPerson(EnumHandSide p_transformSideFirstPerson_1_, float p_transformSideFirstPerson_2_) {
        int i = p_transformSideFirstPerson_1_ == EnumHandSide.RIGHT ? 1 : -1;
        GlStateManager.translate((float)i * 0.56f, -0.52f + p_transformSideFirstPerson_2_ * -0.6f, -0.72f);
    }

    public void renderItemInFirstPerson(float p_renderItemInFirstPerson_1_) {
        float f6;
        float f4;
        float f5;
        float f3;
        ItemStack itemstack;
        EntityPlayerSP abstractclientplayer = this.mc.player;
        float f = abstractclientplayer.getSwingProgress(p_renderItemInFirstPerson_1_);
        EnumHand enumhand = (EnumHand)((Object)Objects.firstNonNull((Object)((Object)abstractclientplayer.swingingHand), (Object)((Object)EnumHand.MAIN_HAND)));
        float f1 = abstractclientplayer.prevRotationPitch + (abstractclientplayer.rotationPitch - abstractclientplayer.prevRotationPitch) * p_renderItemInFirstPerson_1_;
        float f2 = abstractclientplayer.prevRotationYaw + (abstractclientplayer.rotationYaw - abstractclientplayer.prevRotationYaw) * p_renderItemInFirstPerson_1_;
        boolean flag = true;
        boolean flag1 = true;
        if (((EntityLivingBase)abstractclientplayer).isHandActive() && (itemstack = abstractclientplayer.getActiveItemStack()) != null && itemstack.getItem() == Items.BOW) {
            EnumHand enumhand1 = ((EntityLivingBase)abstractclientplayer).getActiveHand();
            flag = enumhand1 == EnumHand.MAIN_HAND;
            flag1 = !flag;
        }
        this.rotateArroundXAndY(f1, f2);
        this.setLightmap();
        this.rotateArm(p_renderItemInFirstPerson_1_);
        GlStateManager.enableRescaleNormal();
        if (flag && !ForgeHooksClient.renderSpecificFirstPersonHand(EnumHand.MAIN_HAND, p_renderItemInFirstPerson_1_, f1, f3 = enumhand == EnumHand.MAIN_HAND ? f : 0.0f, f5 = 1.0f - (this.prevEquippedProgressMainHand + (this.equippedProgressMainHand - this.prevEquippedProgressMainHand) * p_renderItemInFirstPerson_1_), this.itemStackMainHand)) {
            this.renderItemInFirstPerson(abstractclientplayer, p_renderItemInFirstPerson_1_, f1, EnumHand.MAIN_HAND, f3, this.itemStackMainHand, f5);
        }
        if (flag1 && !ForgeHooksClient.renderSpecificFirstPersonHand(EnumHand.OFF_HAND, p_renderItemInFirstPerson_1_, f1, f4 = enumhand == EnumHand.OFF_HAND ? f : 0.0f, f6 = 1.0f - (this.prevEquippedProgressOffHand + (this.equippedProgressOffHand - this.prevEquippedProgressOffHand) * p_renderItemInFirstPerson_1_), this.itemStackOffHand)) {
            this.renderItemInFirstPerson(abstractclientplayer, p_renderItemInFirstPerson_1_, f1, EnumHand.OFF_HAND, f4, this.itemStackOffHand, f6);
        }
        GlStateManager.disableRescaleNormal();
        RenderHelper.disableStandardItemLighting();
    }

    public void renderItemInFirstPerson(AbstractClientPlayer p_renderItemInFirstPerson_1_, float p_renderItemInFirstPerson_2_, float p_renderItemInFirstPerson_3_, EnumHand p_renderItemInFirstPerson_4_, float p_renderItemInFirstPerson_5_, ItemStack p_renderItemInFirstPerson_6_, float p_renderItemInFirstPerson_7_) {
        boolean flag = p_renderItemInFirstPerson_4_ == EnumHand.MAIN_HAND;
        EnumHandSide enumhandside = flag ? p_renderItemInFirstPerson_1_.getPrimaryHand() : p_renderItemInFirstPerson_1_.getPrimaryHand().opposite();
        GlStateManager.pushMatrix();
        if (p_renderItemInFirstPerson_6_.isEmpty()) {
            if (flag && !p_renderItemInFirstPerson_1_.isInvisible()) {
                this.renderArmFirstPerson(p_renderItemInFirstPerson_7_, p_renderItemInFirstPerson_5_, enumhandside);
            }
        } else if (p_renderItemInFirstPerson_6_.getItem() instanceof ItemMap) {
            if (flag && this.itemStackOffHand.isEmpty()) {
                this.renderMapFirstPerson(p_renderItemInFirstPerson_3_, p_renderItemInFirstPerson_7_, p_renderItemInFirstPerson_5_);
            } else {
                this.renderMapFirstPersonSide(p_renderItemInFirstPerson_7_, enumhandside, p_renderItemInFirstPerson_5_, p_renderItemInFirstPerson_6_);
            }
        } else {
            boolean flag1;
            boolean bl = flag1 = enumhandside == EnumHandSide.RIGHT;
            if (p_renderItemInFirstPerson_1_.isHandActive() && p_renderItemInFirstPerson_1_.getItemInUseCount() > 0 && p_renderItemInFirstPerson_1_.getActiveHand() == p_renderItemInFirstPerson_4_) {
                int j = flag1 ? 1 : -1;
                switch (p_renderItemInFirstPerson_6_.getItemUseAction()) {
                    case NONE: {
                        this.transformSideFirstPerson(enumhandside, p_renderItemInFirstPerson_7_);
                        break;
                    }
                    case EAT: 
                    case DRINK: {
                        this.transformEatFirstPerson(p_renderItemInFirstPerson_2_, enumhandside, p_renderItemInFirstPerson_6_);
                        this.transformSideFirstPerson(enumhandside, p_renderItemInFirstPerson_7_);
                        break;
                    }
                    case BLOCK: {
                        this.transformSideFirstPerson(enumhandside, p_renderItemInFirstPerson_7_);
                        break;
                    }
                    case BOW: {
                        this.transformSideFirstPerson(enumhandside, p_renderItemInFirstPerson_7_);
                        GlStateManager.translate((float)j * -0.2785682f, 0.18344387f, 0.15731531f);
                        GlStateManager.rotate(-13.935f, 1.0f, 0.0f, 0.0f);
                        GlStateManager.rotate((float)j * 35.3f, 0.0f, 1.0f, 0.0f);
                        GlStateManager.rotate((float)j * -9.785f, 0.0f, 0.0f, 1.0f);
                        float f5 = (float)p_renderItemInFirstPerson_6_.getMaxItemUseDuration() - ((float)this.mc.player.getItemInUseCount() - p_renderItemInFirstPerson_2_ + 1.0f);
                        float f6 = f5 / 20.0f;
                        f6 = (f6 * f6 + f6 * 2.0f) / 3.0f;
                        if (f6 > 1.0f) {
                            f6 = 1.0f;
                        }
                        if (f6 > 0.1f) {
                            float f7 = MathHelper.sin((f5 - 0.1f) * 1.3f);
                            float f3 = f6 - 0.1f;
                            float f4 = f7 * f3;
                            GlStateManager.translate(f4 * 0.0f, f4 * 0.004f, f4 * 0.0f);
                        }
                        GlStateManager.translate(f6 * 0.0f, f6 * 0.0f, f6 * 0.04f);
                        GlStateManager.scale(1.0f, 1.0f, 1.0f + f6 * 0.2f);
                        GlStateManager.rotate((float)j * 45.0f, 0.0f, -1.0f, 0.0f);
                    }
                }
            } else {
                float f = -0.4f * MathHelper.sin(MathHelper.sqrt(p_renderItemInFirstPerson_5_) * (float)Math.PI);
                float f1 = 0.2f * MathHelper.sin(MathHelper.sqrt(p_renderItemInFirstPerson_5_) * ((float)Math.PI * 2));
                float f2 = -0.2f * MathHelper.sin(p_renderItemInFirstPerson_5_ * (float)Math.PI);
                int i = flag1 ? 1 : -1;
                GlStateManager.translate((float)i * f, f1, f2);
                this.transformSideFirstPerson(enumhandside, p_renderItemInFirstPerson_7_);
                this.transformFirstPerson(enumhandside, p_renderItemInFirstPerson_5_);
            }
            this.renderItemSide(p_renderItemInFirstPerson_1_, p_renderItemInFirstPerson_6_, flag1 ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !flag1);
        }
        GlStateManager.popMatrix();
    }

    public void renderOverlays(float p_renderOverlays_1_) {
        GlStateManager.disableAlpha();
        if (this.mc.player.isEntityInsideOpaqueBlock()) {
            IBlockState iblockstate = this.mc.world.getBlockState(new BlockPos(this.mc.player));
            BlockPos overlayPos = new BlockPos(this.mc.player);
            EntityPlayerSP entityplayer = this.mc.player;
            for (int i = 0; i < 8; ++i) {
                double d0 = entityplayer.posX + (double)(((float)((i >> 0) % 2) - 0.5f) * entityplayer.width * 0.8f);
                double d1 = entityplayer.posY + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
                double d2 = entityplayer.posZ + (double)(((float)((i >> 2) % 2) - 0.5f) * entityplayer.width * 0.8f);
                BlockPos blockpos = new BlockPos(d0, d1 + (double)entityplayer.getEyeHeight(), d2);
                IBlockState iblockstate1 = this.mc.world.getBlockState(blockpos);
                if (!iblockstate1.causesSuffocation()) continue;
                iblockstate = iblockstate1;
                overlayPos = blockpos;
            }
            if (iblockstate.getRenderType() != EnumBlockRenderType.INVISIBLE && !ForgeEventFactory.renderBlockOverlay(this.mc.player, p_renderOverlays_1_, RenderBlockOverlayEvent.OverlayType.BLOCK, iblockstate, overlayPos)) {
                this.renderBlockInHand(p_renderOverlays_1_, this.mc.getBlockRendererDispatcher().getBlockModelShapes().getTexture(iblockstate));
            }
        }
        if (!this.mc.player.isSpectator()) {
            if (this.mc.player.isInsideOfMaterial(Material.WATER) && !ForgeEventFactory.renderWaterOverlay(this.mc.player, p_renderOverlays_1_)) {
                this.renderWaterOverlayTexture(p_renderOverlays_1_);
            }
            if (this.mc.player.isBurning() && !ForgeEventFactory.renderFireOverlay(this.mc.player, p_renderOverlays_1_)) {
                this.renderFireInFirstPerson(p_renderOverlays_1_);
            }
        }
        GlStateManager.enableAlpha();
    }

    private void renderBlockInHand(float p_renderBlockInHand_1_, TextureAtlasSprite p_renderBlockInHand_2_) {
        this.mc.getTextureManager().bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        float f = 0.1f;
        GlStateManager.color(0.1f, 0.1f, 0.1f, 0.5f);
        GlStateManager.pushMatrix();
        float f1 = -1.0f;
        float f2 = 1.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        float f5 = -0.5f;
        float f6 = p_renderBlockInHand_2_.getMinU();
        float f7 = p_renderBlockInHand_2_.getMaxU();
        float f8 = p_renderBlockInHand_2_.getMinV();
        float f9 = p_renderBlockInHand_2_.getMaxV();
        vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        vertexbuffer.pos(-1.0, -1.0, -0.5).tex(f7, f9).endVertex();
        vertexbuffer.pos(1.0, -1.0, -0.5).tex(f6, f9).endVertex();
        vertexbuffer.pos(1.0, 1.0, -0.5).tex(f6, f8).endVertex();
        vertexbuffer.pos(-1.0, 1.0, -0.5).tex(f7, f8).endVertex();
        tessellator.draw();
        GlStateManager.popMatrix();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderWaterOverlayTexture(float p_renderWaterOverlayTexture_1_) {
        this.mc.getTextureManager().bindTexture(RES_UNDERWATER_OVERLAY);
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        float f = this.mc.player.getBrightness(p_renderWaterOverlayTexture_1_);
        GlStateManager.color(f, f, f, 0.5f);
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.pushMatrix();
        float f1 = 4.0f;
        float f2 = -1.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        float f5 = 1.0f;
        float f6 = -0.5f;
        float f7 = -this.mc.player.rotationYaw / 64.0f;
        float f8 = this.mc.player.rotationPitch / 64.0f;
        vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        vertexbuffer.pos(-1.0, -1.0, -0.5).tex(4.0f + f7, 4.0f + f8).endVertex();
        vertexbuffer.pos(1.0, -1.0, -0.5).tex(0.0f + f7, 4.0f + f8).endVertex();
        vertexbuffer.pos(1.0, 1.0, -0.5).tex(0.0f + f7, 0.0f + f8).endVertex();
        vertexbuffer.pos(-1.0, 1.0, -0.5).tex(4.0f + f7, 0.0f + f8).endVertex();
        tessellator.draw();
        GlStateManager.popMatrix();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableBlend();
    }

    private void renderFireInFirstPerson(float p_renderFireInFirstPerson_1_) {
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 0.9f);
        GlStateManager.depthFunc(519);
        GlStateManager.depthMask(false);
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        float f = 1.0f;
        for (int i = 0; i < 2; ++i) {
            GlStateManager.pushMatrix();
            TextureAtlasSprite textureatlassprite = this.mc.getTextureMapBlocks().getAtlasSprite("minecraft:blocks/fire_layer_1");
            this.mc.getTextureManager().bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
            float f1 = textureatlassprite.getMinU();
            float f2 = textureatlassprite.getMaxU();
            float f3 = textureatlassprite.getMinV();
            float f4 = textureatlassprite.getMaxV();
            float f5 = -0.5f;
            float f6 = 0.5f;
            float f7 = -0.5f;
            float f8 = 0.5f;
            float f9 = -0.5f;
            GlStateManager.translate((float)(-(i * 2 - 1)) * 0.24f, -0.3f, 0.0f);
            GlStateManager.rotate((float)(i * 2 - 1) * 10.0f, 0.0f, 1.0f, 0.0f);
            vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
            vertexbuffer.pos(-0.5, -0.5, -0.5).tex(f2, f4).endVertex();
            vertexbuffer.pos(0.5, -0.5, -0.5).tex(f1, f4).endVertex();
            vertexbuffer.pos(0.5, 0.5, -0.5).tex(f1, f3).endVertex();
            vertexbuffer.pos(-0.5, 0.5, -0.5).tex(f2, f3).endVertex();
            tessellator.draw();
            GlStateManager.popMatrix();
        }
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableBlend();
        GlStateManager.depthMask(true);
        GlStateManager.depthFunc(515);
    }

    public void updateEquippedItem() {
        this.prevEquippedProgressMainHand = this.equippedProgressMainHand;
        this.prevEquippedProgressOffHand = this.equippedProgressOffHand;
        EntityPlayerSP entityplayersp = this.mc.player;
        ItemStack itemstack = entityplayersp.getHeldItemMainhand();
        ItemStack itemstack1 = entityplayersp.getHeldItemOffhand();
        if (entityplayersp.isRowingBoat()) {
            this.equippedProgressMainHand = MathHelper.clamp(this.equippedProgressMainHand - 0.4f, 0.0f, 1.0f);
            this.equippedProgressOffHand = MathHelper.clamp(this.equippedProgressOffHand - 0.4f, 0.0f, 1.0f);
        } else {
            float f = entityplayersp.getCooledAttackStrength(1.0f);
            this.equippedProgressMainHand += MathHelper.clamp((!ForgeHooksClient.shouldCauseReequipAnimation(this.itemStackMainHand, itemstack, entityplayersp.inventory.currentItem) ? f * f * f : 0.0f) - this.equippedProgressMainHand, -0.4f, 0.4f);
            this.equippedProgressOffHand += MathHelper.clamp((float)(!ForgeHooksClient.shouldCauseReequipAnimation(this.itemStackOffHand, itemstack1, -1) ? 1 : 0) - this.equippedProgressOffHand, -0.4f, 0.4f);
        }
        if (this.equippedProgressMainHand < 0.1f) {
            this.itemStackMainHand = itemstack;
        }
        if (this.equippedProgressOffHand < 0.1f) {
            this.itemStackOffHand = itemstack1;
        }
    }

    public void resetEquippedProgress(EnumHand p_resetEquippedProgress_1_) {
        if (p_resetEquippedProgress_1_ == EnumHand.MAIN_HAND) {
            this.equippedProgressMainHand = 0.0f;
        } else {
            this.equippedProgressOffHand = 0.0f;
        }
    }
}

