/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.Util;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.Sys;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTBlendFuncSeparate;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;
import oshi.SystemInfo;
import oshi.hardware.Processor;

@SideOnly(value=Side.CLIENT)
public class OpenGlHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean nvidia;
    public static boolean ati;
    public static int GL_FRAMEBUFFER;
    public static int GL_RENDERBUFFER;
    public static int GL_COLOR_ATTACHMENT0;
    public static int GL_DEPTH_ATTACHMENT;
    public static int GL_FRAMEBUFFER_COMPLETE;
    public static int GL_FB_INCOMPLETE_ATTACHMENT;
    public static int GL_FB_INCOMPLETE_MISS_ATTACH;
    public static int GL_FB_INCOMPLETE_DRAW_BUFFER;
    public static int GL_FB_INCOMPLETE_READ_BUFFER;
    private static FboMode framebufferType;
    public static boolean framebufferSupported;
    private static boolean shadersAvailable;
    private static boolean arbShaders;
    public static int GL_LINK_STATUS;
    public static int GL_COMPILE_STATUS;
    public static int GL_VERTEX_SHADER;
    public static int GL_FRAGMENT_SHADER;
    private static boolean arbMultitexture;
    public static int defaultTexUnit;
    public static int lightmapTexUnit;
    public static int GL_TEXTURE2;
    private static boolean arbTextureEnvCombine;
    public static int GL_COMBINE;
    public static int GL_INTERPOLATE;
    public static int GL_PRIMARY_COLOR;
    public static int GL_CONSTANT;
    public static int GL_PREVIOUS;
    public static int GL_COMBINE_RGB;
    public static int GL_SOURCE0_RGB;
    public static int GL_SOURCE1_RGB;
    public static int GL_SOURCE2_RGB;
    public static int GL_OPERAND0_RGB;
    public static int GL_OPERAND1_RGB;
    public static int GL_OPERAND2_RGB;
    public static int GL_COMBINE_ALPHA;
    public static int GL_SOURCE0_ALPHA;
    public static int GL_SOURCE1_ALPHA;
    public static int GL_SOURCE2_ALPHA;
    public static int GL_OPERAND0_ALPHA;
    public static int GL_OPERAND1_ALPHA;
    public static int GL_OPERAND2_ALPHA;
    private static boolean openGL14;
    public static boolean extBlendFuncSeparate;
    public static boolean openGL21;
    public static boolean shadersSupported;
    private static String logText;
    private static String cpu;
    public static boolean vboSupported;
    public static boolean vboSupportedAti;
    private static boolean arbVbo;
    public static int GL_ARRAY_BUFFER;
    public static int GL_STATIC_DRAW;
    public static float lastBrightnessX;
    public static float lastBrightnessY;

    public static void initializeTextures() {
        ContextCapabilities contextcapabilities = GLContext.getCapabilities();
        arbMultitexture = contextcapabilities.GL_ARB_multitexture && !contextcapabilities.OpenGL13;
        boolean bl = arbTextureEnvCombine = contextcapabilities.GL_ARB_texture_env_combine && !contextcapabilities.OpenGL13;
        if (arbMultitexture) {
            logText = logText + "Using ARB_multitexture.\n";
            defaultTexUnit = 33984;
            lightmapTexUnit = 33985;
            GL_TEXTURE2 = 33986;
        } else {
            logText = logText + "Using GL 1.3 multitexturing.\n";
            defaultTexUnit = 33984;
            lightmapTexUnit = 33985;
            GL_TEXTURE2 = 33986;
        }
        if (arbTextureEnvCombine) {
            logText = logText + "Using ARB_texture_env_combine.\n";
            GL_COMBINE = 34160;
            GL_INTERPOLATE = 34165;
            GL_PRIMARY_COLOR = 34167;
            GL_CONSTANT = 34166;
            GL_PREVIOUS = 34168;
            GL_COMBINE_RGB = 34161;
            GL_SOURCE0_RGB = 34176;
            GL_SOURCE1_RGB = 34177;
            GL_SOURCE2_RGB = 34178;
            GL_OPERAND0_RGB = 34192;
            GL_OPERAND1_RGB = 34193;
            GL_OPERAND2_RGB = 34194;
            GL_COMBINE_ALPHA = 34162;
            GL_SOURCE0_ALPHA = 34184;
            GL_SOURCE1_ALPHA = 34185;
            GL_SOURCE2_ALPHA = 34186;
            GL_OPERAND0_ALPHA = 34200;
            GL_OPERAND1_ALPHA = 34201;
            GL_OPERAND2_ALPHA = 34202;
        } else {
            logText = logText + "Using GL 1.3 texture combiners.\n";
            GL_COMBINE = 34160;
            GL_INTERPOLATE = 34165;
            GL_PRIMARY_COLOR = 34167;
            GL_CONSTANT = 34166;
            GL_PREVIOUS = 34168;
            GL_COMBINE_RGB = 34161;
            GL_SOURCE0_RGB = 34176;
            GL_SOURCE1_RGB = 34177;
            GL_SOURCE2_RGB = 34178;
            GL_OPERAND0_RGB = 34192;
            GL_OPERAND1_RGB = 34193;
            GL_OPERAND2_RGB = 34194;
            GL_COMBINE_ALPHA = 34162;
            GL_SOURCE0_ALPHA = 34184;
            GL_SOURCE1_ALPHA = 34185;
            GL_SOURCE2_ALPHA = 34186;
            GL_OPERAND0_ALPHA = 34200;
            GL_OPERAND1_ALPHA = 34201;
            GL_OPERAND2_ALPHA = 34202;
        }
        extBlendFuncSeparate = contextcapabilities.GL_EXT_blend_func_separate && !contextcapabilities.OpenGL14;
        openGL14 = contextcapabilities.OpenGL14 || contextcapabilities.GL_EXT_blend_func_separate;
        boolean bl2 = framebufferSupported = openGL14 && (contextcapabilities.GL_ARB_framebuffer_object || contextcapabilities.GL_EXT_framebuffer_object || contextcapabilities.OpenGL30);
        if (framebufferSupported) {
            logText = logText + "Using framebuffer objects because ";
            if (contextcapabilities.OpenGL30) {
                logText = logText + "OpenGL 3.0 is supported and separate blending is supported.\n";
                framebufferType = FboMode.BASE;
                GL_FRAMEBUFFER = 36160;
                GL_RENDERBUFFER = 36161;
                GL_COLOR_ATTACHMENT0 = 36064;
                GL_DEPTH_ATTACHMENT = 36096;
                GL_FRAMEBUFFER_COMPLETE = 36053;
                GL_FB_INCOMPLETE_ATTACHMENT = 36054;
                GL_FB_INCOMPLETE_MISS_ATTACH = 36055;
                GL_FB_INCOMPLETE_DRAW_BUFFER = 36059;
                GL_FB_INCOMPLETE_READ_BUFFER = 36060;
            } else if (contextcapabilities.GL_ARB_framebuffer_object) {
                logText = logText + "ARB_framebuffer_object is supported and separate blending is supported.\n";
                framebufferType = FboMode.ARB;
                GL_FRAMEBUFFER = 36160;
                GL_RENDERBUFFER = 36161;
                GL_COLOR_ATTACHMENT0 = 36064;
                GL_DEPTH_ATTACHMENT = 36096;
                GL_FRAMEBUFFER_COMPLETE = 36053;
                GL_FB_INCOMPLETE_MISS_ATTACH = 36055;
                GL_FB_INCOMPLETE_ATTACHMENT = 36054;
                GL_FB_INCOMPLETE_DRAW_BUFFER = 36059;
                GL_FB_INCOMPLETE_READ_BUFFER = 36060;
            } else if (contextcapabilities.GL_EXT_framebuffer_object) {
                logText = logText + "EXT_framebuffer_object is supported.\n";
                framebufferType = FboMode.EXT;
                GL_FRAMEBUFFER = 36160;
                GL_RENDERBUFFER = 36161;
                GL_COLOR_ATTACHMENT0 = 36064;
                GL_DEPTH_ATTACHMENT = 36096;
                GL_FRAMEBUFFER_COMPLETE = 36053;
                GL_FB_INCOMPLETE_MISS_ATTACH = 36055;
                GL_FB_INCOMPLETE_ATTACHMENT = 36054;
                GL_FB_INCOMPLETE_DRAW_BUFFER = 36059;
                GL_FB_INCOMPLETE_READ_BUFFER = 36060;
            }
        } else {
            logText = logText + "Not using framebuffer objects because ";
            logText = logText + "OpenGL 1.4 is " + (contextcapabilities.OpenGL14 ? "" : "not ") + "supported, ";
            logText = logText + "EXT_blend_func_separate is " + (contextcapabilities.GL_EXT_blend_func_separate ? "" : "not ") + "supported, ";
            logText = logText + "OpenGL 3.0 is " + (contextcapabilities.OpenGL30 ? "" : "not ") + "supported, ";
            logText = logText + "ARB_framebuffer_object is " + (contextcapabilities.GL_ARB_framebuffer_object ? "" : "not ") + "supported, and ";
            logText = logText + "EXT_framebuffer_object is " + (contextcapabilities.GL_EXT_framebuffer_object ? "" : "not ") + "supported.\n";
        }
        openGL21 = contextcapabilities.OpenGL21;
        shadersAvailable = openGL21 || contextcapabilities.GL_ARB_vertex_shader && contextcapabilities.GL_ARB_fragment_shader && contextcapabilities.GL_ARB_shader_objects;
        logText = logText + "Shaders are " + (shadersAvailable ? "" : "not ") + "available because ";
        if (shadersAvailable) {
            if (contextcapabilities.OpenGL21) {
                logText = logText + "OpenGL 2.1 is supported.\n";
                arbShaders = false;
                GL_LINK_STATUS = 35714;
                GL_COMPILE_STATUS = 35713;
                GL_VERTEX_SHADER = 35633;
                GL_FRAGMENT_SHADER = 35632;
            } else {
                logText = logText + "ARB_shader_objects, ARB_vertex_shader, and ARB_fragment_shader are supported.\n";
                arbShaders = true;
                GL_LINK_STATUS = 35714;
                GL_COMPILE_STATUS = 35713;
                GL_VERTEX_SHADER = 35633;
                GL_FRAGMENT_SHADER = 35632;
            }
        } else {
            logText = logText + "OpenGL 2.1 is " + (contextcapabilities.OpenGL21 ? "" : "not ") + "supported, ";
            logText = logText + "ARB_shader_objects is " + (contextcapabilities.GL_ARB_shader_objects ? "" : "not ") + "supported, ";
            logText = logText + "ARB_vertex_shader is " + (contextcapabilities.GL_ARB_vertex_shader ? "" : "not ") + "supported, and ";
            logText = logText + "ARB_fragment_shader is " + (contextcapabilities.GL_ARB_fragment_shader ? "" : "not ") + "supported.\n";
        }
        shadersSupported = framebufferSupported && shadersAvailable;
        String s = GL11.glGetString((int)7936).toLowerCase(Locale.ROOT);
        nvidia = s.contains("nvidia");
        arbVbo = !contextcapabilities.OpenGL15 && contextcapabilities.GL_ARB_vertex_buffer_object;
        vboSupported = contextcapabilities.OpenGL15 || arbVbo;
        logText = logText + "VBOs are " + (vboSupported ? "" : "not ") + "available because ";
        if (vboSupported) {
            if (arbVbo) {
                logText = logText + "ARB_vertex_buffer_object is supported.\n";
                GL_STATIC_DRAW = 35044;
                GL_ARRAY_BUFFER = 34962;
            } else {
                logText = logText + "OpenGL 1.5 is supported.\n";
                GL_STATIC_DRAW = 35044;
                GL_ARRAY_BUFFER = 34962;
            }
        }
        if (ati = s.contains("ati")) {
            if (vboSupported) {
                vboSupportedAti = true;
            } else {
                GameSettings.Options.RENDER_DISTANCE.setValueMax(16.0f);
            }
        }
        try {
            Processor[] aprocessor = new SystemInfo().getHardware().getProcessors();
            cpu = String.format("%dx %s", aprocessor.length, aprocessor[0]).replaceAll("\\s+", " ");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean areShadersSupported() {
        return shadersSupported;
    }

    public static String getLogText() {
        return logText;
    }

    public static int glGetProgrami(int p_glGetProgrami_0_, int p_glGetProgrami_1_) {
        return arbShaders ? ARBShaderObjects.glGetObjectParameteriARB((int)p_glGetProgrami_0_, (int)p_glGetProgrami_1_) : GL20.glGetProgrami((int)p_glGetProgrami_0_, (int)p_glGetProgrami_1_);
    }

    public static void glAttachShader(int p_glAttachShader_0_, int p_glAttachShader_1_) {
        if (arbShaders) {
            ARBShaderObjects.glAttachObjectARB((int)p_glAttachShader_0_, (int)p_glAttachShader_1_);
        } else {
            GL20.glAttachShader((int)p_glAttachShader_0_, (int)p_glAttachShader_1_);
        }
    }

    public static void glDeleteShader(int p_glDeleteShader_0_) {
        if (arbShaders) {
            ARBShaderObjects.glDeleteObjectARB((int)p_glDeleteShader_0_);
        } else {
            GL20.glDeleteShader((int)p_glDeleteShader_0_);
        }
    }

    public static int glCreateShader(int p_glCreateShader_0_) {
        return arbShaders ? ARBShaderObjects.glCreateShaderObjectARB((int)p_glCreateShader_0_) : GL20.glCreateShader((int)p_glCreateShader_0_);
    }

    public static void glShaderSource(int p_glShaderSource_0_, ByteBuffer p_glShaderSource_1_) {
        if (arbShaders) {
            ARBShaderObjects.glShaderSourceARB((int)p_glShaderSource_0_, (ByteBuffer)p_glShaderSource_1_);
        } else {
            GL20.glShaderSource((int)p_glShaderSource_0_, (ByteBuffer)p_glShaderSource_1_);
        }
    }

    public static void glCompileShader(int p_glCompileShader_0_) {
        if (arbShaders) {
            ARBShaderObjects.glCompileShaderARB((int)p_glCompileShader_0_);
        } else {
            GL20.glCompileShader((int)p_glCompileShader_0_);
        }
    }

    public static int glGetShaderi(int p_glGetShaderi_0_, int p_glGetShaderi_1_) {
        return arbShaders ? ARBShaderObjects.glGetObjectParameteriARB((int)p_glGetShaderi_0_, (int)p_glGetShaderi_1_) : GL20.glGetShaderi((int)p_glGetShaderi_0_, (int)p_glGetShaderi_1_);
    }

    public static String glGetShaderInfoLog(int p_glGetShaderInfoLog_0_, int p_glGetShaderInfoLog_1_) {
        return arbShaders ? ARBShaderObjects.glGetInfoLogARB((int)p_glGetShaderInfoLog_0_, (int)p_glGetShaderInfoLog_1_) : GL20.glGetShaderInfoLog((int)p_glGetShaderInfoLog_0_, (int)p_glGetShaderInfoLog_1_);
    }

    public static String glGetProgramInfoLog(int p_glGetProgramInfoLog_0_, int p_glGetProgramInfoLog_1_) {
        return arbShaders ? ARBShaderObjects.glGetInfoLogARB((int)p_glGetProgramInfoLog_0_, (int)p_glGetProgramInfoLog_1_) : GL20.glGetProgramInfoLog((int)p_glGetProgramInfoLog_0_, (int)p_glGetProgramInfoLog_1_);
    }

    public static void glUseProgram(int p_glUseProgram_0_) {
        if (arbShaders) {
            ARBShaderObjects.glUseProgramObjectARB((int)p_glUseProgram_0_);
        } else {
            GL20.glUseProgram((int)p_glUseProgram_0_);
        }
    }

    public static int glCreateProgram() {
        return arbShaders ? ARBShaderObjects.glCreateProgramObjectARB() : GL20.glCreateProgram();
    }

    public static void glDeleteProgram(int p_glDeleteProgram_0_) {
        if (arbShaders) {
            ARBShaderObjects.glDeleteObjectARB((int)p_glDeleteProgram_0_);
        } else {
            GL20.glDeleteProgram((int)p_glDeleteProgram_0_);
        }
    }

    public static void glLinkProgram(int p_glLinkProgram_0_) {
        if (arbShaders) {
            ARBShaderObjects.glLinkProgramARB((int)p_glLinkProgram_0_);
        } else {
            GL20.glLinkProgram((int)p_glLinkProgram_0_);
        }
    }

    public static int glGetUniformLocation(int p_glGetUniformLocation_0_, CharSequence p_glGetUniformLocation_1_) {
        return arbShaders ? ARBShaderObjects.glGetUniformLocationARB((int)p_glGetUniformLocation_0_, (CharSequence)p_glGetUniformLocation_1_) : GL20.glGetUniformLocation((int)p_glGetUniformLocation_0_, (CharSequence)p_glGetUniformLocation_1_);
    }

    public static void glUniform1(int p_glUniform1_0_, IntBuffer p_glUniform1_1_) {
        if (arbShaders) {
            ARBShaderObjects.glUniform1ARB((int)p_glUniform1_0_, (IntBuffer)p_glUniform1_1_);
        } else {
            GL20.glUniform1((int)p_glUniform1_0_, (IntBuffer)p_glUniform1_1_);
        }
    }

    public static void glUniform1i(int p_glUniform1i_0_, int p_glUniform1i_1_) {
        if (arbShaders) {
            ARBShaderObjects.glUniform1iARB((int)p_glUniform1i_0_, (int)p_glUniform1i_1_);
        } else {
            GL20.glUniform1i((int)p_glUniform1i_0_, (int)p_glUniform1i_1_);
        }
    }

    public static void glUniform1(int p_glUniform1_0_, FloatBuffer p_glUniform1_1_) {
        if (arbShaders) {
            ARBShaderObjects.glUniform1ARB((int)p_glUniform1_0_, (FloatBuffer)p_glUniform1_1_);
        } else {
            GL20.glUniform1((int)p_glUniform1_0_, (FloatBuffer)p_glUniform1_1_);
        }
    }

    public static void glUniform2(int p_glUniform2_0_, IntBuffer p_glUniform2_1_) {
        if (arbShaders) {
            ARBShaderObjects.glUniform2ARB((int)p_glUniform2_0_, (IntBuffer)p_glUniform2_1_);
        } else {
            GL20.glUniform2((int)p_glUniform2_0_, (IntBuffer)p_glUniform2_1_);
        }
    }

    public static void glUniform2(int p_glUniform2_0_, FloatBuffer p_glUniform2_1_) {
        if (arbShaders) {
            ARBShaderObjects.glUniform2ARB((int)p_glUniform2_0_, (FloatBuffer)p_glUniform2_1_);
        } else {
            GL20.glUniform2((int)p_glUniform2_0_, (FloatBuffer)p_glUniform2_1_);
        }
    }

    public static void glUniform3(int p_glUniform3_0_, IntBuffer p_glUniform3_1_) {
        if (arbShaders) {
            ARBShaderObjects.glUniform3ARB((int)p_glUniform3_0_, (IntBuffer)p_glUniform3_1_);
        } else {
            GL20.glUniform3((int)p_glUniform3_0_, (IntBuffer)p_glUniform3_1_);
        }
    }

    public static void glUniform3(int p_glUniform3_0_, FloatBuffer p_glUniform3_1_) {
        if (arbShaders) {
            ARBShaderObjects.glUniform3ARB((int)p_glUniform3_0_, (FloatBuffer)p_glUniform3_1_);
        } else {
            GL20.glUniform3((int)p_glUniform3_0_, (FloatBuffer)p_glUniform3_1_);
        }
    }

    public static void glUniform4(int p_glUniform4_0_, IntBuffer p_glUniform4_1_) {
        if (arbShaders) {
            ARBShaderObjects.glUniform4ARB((int)p_glUniform4_0_, (IntBuffer)p_glUniform4_1_);
        } else {
            GL20.glUniform4((int)p_glUniform4_0_, (IntBuffer)p_glUniform4_1_);
        }
    }

    public static void glUniform4(int p_glUniform4_0_, FloatBuffer p_glUniform4_1_) {
        if (arbShaders) {
            ARBShaderObjects.glUniform4ARB((int)p_glUniform4_0_, (FloatBuffer)p_glUniform4_1_);
        } else {
            GL20.glUniform4((int)p_glUniform4_0_, (FloatBuffer)p_glUniform4_1_);
        }
    }

    public static void glUniformMatrix2(int p_glUniformMatrix2_0_, boolean p_glUniformMatrix2_1_, FloatBuffer p_glUniformMatrix2_2_) {
        if (arbShaders) {
            ARBShaderObjects.glUniformMatrix2ARB((int)p_glUniformMatrix2_0_, (boolean)p_glUniformMatrix2_1_, (FloatBuffer)p_glUniformMatrix2_2_);
        } else {
            GL20.glUniformMatrix2((int)p_glUniformMatrix2_0_, (boolean)p_glUniformMatrix2_1_, (FloatBuffer)p_glUniformMatrix2_2_);
        }
    }

    public static void glUniformMatrix3(int p_glUniformMatrix3_0_, boolean p_glUniformMatrix3_1_, FloatBuffer p_glUniformMatrix3_2_) {
        if (arbShaders) {
            ARBShaderObjects.glUniformMatrix3ARB((int)p_glUniformMatrix3_0_, (boolean)p_glUniformMatrix3_1_, (FloatBuffer)p_glUniformMatrix3_2_);
        } else {
            GL20.glUniformMatrix3((int)p_glUniformMatrix3_0_, (boolean)p_glUniformMatrix3_1_, (FloatBuffer)p_glUniformMatrix3_2_);
        }
    }

    public static void glUniformMatrix4(int p_glUniformMatrix4_0_, boolean p_glUniformMatrix4_1_, FloatBuffer p_glUniformMatrix4_2_) {
        if (arbShaders) {
            ARBShaderObjects.glUniformMatrix4ARB((int)p_glUniformMatrix4_0_, (boolean)p_glUniformMatrix4_1_, (FloatBuffer)p_glUniformMatrix4_2_);
        } else {
            GL20.glUniformMatrix4((int)p_glUniformMatrix4_0_, (boolean)p_glUniformMatrix4_1_, (FloatBuffer)p_glUniformMatrix4_2_);
        }
    }

    public static int glGetAttribLocation(int p_glGetAttribLocation_0_, CharSequence p_glGetAttribLocation_1_) {
        return arbShaders ? ARBVertexShader.glGetAttribLocationARB((int)p_glGetAttribLocation_0_, (CharSequence)p_glGetAttribLocation_1_) : GL20.glGetAttribLocation((int)p_glGetAttribLocation_0_, (CharSequence)p_glGetAttribLocation_1_);
    }

    public static int glGenBuffers() {
        return arbVbo ? ARBVertexBufferObject.glGenBuffersARB() : GL15.glGenBuffers();
    }

    public static void glBindBuffer(int p_glBindBuffer_0_, int p_glBindBuffer_1_) {
        if (arbVbo) {
            ARBVertexBufferObject.glBindBufferARB((int)p_glBindBuffer_0_, (int)p_glBindBuffer_1_);
        } else {
            GL15.glBindBuffer((int)p_glBindBuffer_0_, (int)p_glBindBuffer_1_);
        }
    }

    public static void glBufferData(int p_glBufferData_0_, ByteBuffer p_glBufferData_1_, int p_glBufferData_2_) {
        if (arbVbo) {
            ARBVertexBufferObject.glBufferDataARB((int)p_glBufferData_0_, (ByteBuffer)p_glBufferData_1_, (int)p_glBufferData_2_);
        } else {
            GL15.glBufferData((int)p_glBufferData_0_, (ByteBuffer)p_glBufferData_1_, (int)p_glBufferData_2_);
        }
    }

    public static void glDeleteBuffers(int p_glDeleteBuffers_0_) {
        if (arbVbo) {
            ARBVertexBufferObject.glDeleteBuffersARB((int)p_glDeleteBuffers_0_);
        } else {
            GL15.glDeleteBuffers((int)p_glDeleteBuffers_0_);
        }
    }

    public static boolean useVbo() {
        return vboSupported && Minecraft.getMinecraft().gameSettings.useVbo;
    }

    public static void glBindFramebuffer(int p_glBindFramebuffer_0_, int p_glBindFramebuffer_1_) {
        if (framebufferSupported) {
            switch (framebufferType) {
                case BASE: {
                    GL30.glBindFramebuffer((int)p_glBindFramebuffer_0_, (int)p_glBindFramebuffer_1_);
                    break;
                }
                case ARB: {
                    ARBFramebufferObject.glBindFramebuffer((int)p_glBindFramebuffer_0_, (int)p_glBindFramebuffer_1_);
                    break;
                }
                case EXT: {
                    EXTFramebufferObject.glBindFramebufferEXT((int)p_glBindFramebuffer_0_, (int)p_glBindFramebuffer_1_);
                }
            }
        }
    }

    public static void glBindRenderbuffer(int p_glBindRenderbuffer_0_, int p_glBindRenderbuffer_1_) {
        if (framebufferSupported) {
            switch (framebufferType) {
                case BASE: {
                    GL30.glBindRenderbuffer((int)p_glBindRenderbuffer_0_, (int)p_glBindRenderbuffer_1_);
                    break;
                }
                case ARB: {
                    ARBFramebufferObject.glBindRenderbuffer((int)p_glBindRenderbuffer_0_, (int)p_glBindRenderbuffer_1_);
                    break;
                }
                case EXT: {
                    EXTFramebufferObject.glBindRenderbufferEXT((int)p_glBindRenderbuffer_0_, (int)p_glBindRenderbuffer_1_);
                }
            }
        }
    }

    public static void glDeleteRenderbuffers(int p_glDeleteRenderbuffers_0_) {
        if (framebufferSupported) {
            switch (framebufferType) {
                case BASE: {
                    GL30.glDeleteRenderbuffers((int)p_glDeleteRenderbuffers_0_);
                    break;
                }
                case ARB: {
                    ARBFramebufferObject.glDeleteRenderbuffers((int)p_glDeleteRenderbuffers_0_);
                    break;
                }
                case EXT: {
                    EXTFramebufferObject.glDeleteRenderbuffersEXT((int)p_glDeleteRenderbuffers_0_);
                }
            }
        }
    }

    public static void glDeleteFramebuffers(int p_glDeleteFramebuffers_0_) {
        if (framebufferSupported) {
            switch (framebufferType) {
                case BASE: {
                    GL30.glDeleteFramebuffers((int)p_glDeleteFramebuffers_0_);
                    break;
                }
                case ARB: {
                    ARBFramebufferObject.glDeleteFramebuffers((int)p_glDeleteFramebuffers_0_);
                    break;
                }
                case EXT: {
                    EXTFramebufferObject.glDeleteFramebuffersEXT((int)p_glDeleteFramebuffers_0_);
                }
            }
        }
    }

    public static int glGenFramebuffers() {
        if (!framebufferSupported) {
            return -1;
        }
        switch (framebufferType) {
            case BASE: {
                return GL30.glGenFramebuffers();
            }
            case ARB: {
                return ARBFramebufferObject.glGenFramebuffers();
            }
            case EXT: {
                return EXTFramebufferObject.glGenFramebuffersEXT();
            }
        }
        return -1;
    }

    public static int glGenRenderbuffers() {
        if (!framebufferSupported) {
            return -1;
        }
        switch (framebufferType) {
            case BASE: {
                return GL30.glGenRenderbuffers();
            }
            case ARB: {
                return ARBFramebufferObject.glGenRenderbuffers();
            }
            case EXT: {
                return EXTFramebufferObject.glGenRenderbuffersEXT();
            }
        }
        return -1;
    }

    public static void glRenderbufferStorage(int p_glRenderbufferStorage_0_, int p_glRenderbufferStorage_1_, int p_glRenderbufferStorage_2_, int p_glRenderbufferStorage_3_) {
        if (framebufferSupported) {
            switch (framebufferType) {
                case BASE: {
                    GL30.glRenderbufferStorage((int)p_glRenderbufferStorage_0_, (int)p_glRenderbufferStorage_1_, (int)p_glRenderbufferStorage_2_, (int)p_glRenderbufferStorage_3_);
                    break;
                }
                case ARB: {
                    ARBFramebufferObject.glRenderbufferStorage((int)p_glRenderbufferStorage_0_, (int)p_glRenderbufferStorage_1_, (int)p_glRenderbufferStorage_2_, (int)p_glRenderbufferStorage_3_);
                    break;
                }
                case EXT: {
                    EXTFramebufferObject.glRenderbufferStorageEXT((int)p_glRenderbufferStorage_0_, (int)p_glRenderbufferStorage_1_, (int)p_glRenderbufferStorage_2_, (int)p_glRenderbufferStorage_3_);
                }
            }
        }
    }

    public static void glFramebufferRenderbuffer(int p_glFramebufferRenderbuffer_0_, int p_glFramebufferRenderbuffer_1_, int p_glFramebufferRenderbuffer_2_, int p_glFramebufferRenderbuffer_3_) {
        if (framebufferSupported) {
            switch (framebufferType) {
                case BASE: {
                    GL30.glFramebufferRenderbuffer((int)p_glFramebufferRenderbuffer_0_, (int)p_glFramebufferRenderbuffer_1_, (int)p_glFramebufferRenderbuffer_2_, (int)p_glFramebufferRenderbuffer_3_);
                    break;
                }
                case ARB: {
                    ARBFramebufferObject.glFramebufferRenderbuffer((int)p_glFramebufferRenderbuffer_0_, (int)p_glFramebufferRenderbuffer_1_, (int)p_glFramebufferRenderbuffer_2_, (int)p_glFramebufferRenderbuffer_3_);
                    break;
                }
                case EXT: {
                    EXTFramebufferObject.glFramebufferRenderbufferEXT((int)p_glFramebufferRenderbuffer_0_, (int)p_glFramebufferRenderbuffer_1_, (int)p_glFramebufferRenderbuffer_2_, (int)p_glFramebufferRenderbuffer_3_);
                }
            }
        }
    }

    public static int glCheckFramebufferStatus(int p_glCheckFramebufferStatus_0_) {
        if (!framebufferSupported) {
            return -1;
        }
        switch (framebufferType) {
            case BASE: {
                return GL30.glCheckFramebufferStatus((int)p_glCheckFramebufferStatus_0_);
            }
            case ARB: {
                return ARBFramebufferObject.glCheckFramebufferStatus((int)p_glCheckFramebufferStatus_0_);
            }
            case EXT: {
                return EXTFramebufferObject.glCheckFramebufferStatusEXT((int)p_glCheckFramebufferStatus_0_);
            }
        }
        return -1;
    }

    public static void glFramebufferTexture2D(int p_glFramebufferTexture2D_0_, int p_glFramebufferTexture2D_1_, int p_glFramebufferTexture2D_2_, int p_glFramebufferTexture2D_3_, int p_glFramebufferTexture2D_4_) {
        if (framebufferSupported) {
            switch (framebufferType) {
                case BASE: {
                    GL30.glFramebufferTexture2D((int)p_glFramebufferTexture2D_0_, (int)p_glFramebufferTexture2D_1_, (int)p_glFramebufferTexture2D_2_, (int)p_glFramebufferTexture2D_3_, (int)p_glFramebufferTexture2D_4_);
                    break;
                }
                case ARB: {
                    ARBFramebufferObject.glFramebufferTexture2D((int)p_glFramebufferTexture2D_0_, (int)p_glFramebufferTexture2D_1_, (int)p_glFramebufferTexture2D_2_, (int)p_glFramebufferTexture2D_3_, (int)p_glFramebufferTexture2D_4_);
                    break;
                }
                case EXT: {
                    EXTFramebufferObject.glFramebufferTexture2DEXT((int)p_glFramebufferTexture2D_0_, (int)p_glFramebufferTexture2D_1_, (int)p_glFramebufferTexture2D_2_, (int)p_glFramebufferTexture2D_3_, (int)p_glFramebufferTexture2D_4_);
                }
            }
        }
    }

    public static void setActiveTexture(int p_setActiveTexture_0_) {
        if (arbMultitexture) {
            ARBMultitexture.glActiveTextureARB((int)p_setActiveTexture_0_);
        } else {
            GL13.glActiveTexture((int)p_setActiveTexture_0_);
        }
    }

    public static void setClientActiveTexture(int p_setClientActiveTexture_0_) {
        if (arbMultitexture) {
            ARBMultitexture.glClientActiveTextureARB((int)p_setClientActiveTexture_0_);
        } else {
            GL13.glClientActiveTexture((int)p_setClientActiveTexture_0_);
        }
    }

    public static void setLightmapTextureCoords(int p_setLightmapTextureCoords_0_, float p_setLightmapTextureCoords_1_, float p_setLightmapTextureCoords_2_) {
        if (arbMultitexture) {
            ARBMultitexture.glMultiTexCoord2fARB((int)p_setLightmapTextureCoords_0_, (float)p_setLightmapTextureCoords_1_, (float)p_setLightmapTextureCoords_2_);
        } else {
            GL13.glMultiTexCoord2f((int)p_setLightmapTextureCoords_0_, (float)p_setLightmapTextureCoords_1_, (float)p_setLightmapTextureCoords_2_);
        }
        if (p_setLightmapTextureCoords_0_ == lightmapTexUnit) {
            lastBrightnessX = p_setLightmapTextureCoords_1_;
            lastBrightnessY = p_setLightmapTextureCoords_2_;
        }
    }

    public static void glBlendFunc(int p_glBlendFunc_0_, int p_glBlendFunc_1_, int p_glBlendFunc_2_, int p_glBlendFunc_3_) {
        if (openGL14) {
            if (extBlendFuncSeparate) {
                EXTBlendFuncSeparate.glBlendFuncSeparateEXT((int)p_glBlendFunc_0_, (int)p_glBlendFunc_1_, (int)p_glBlendFunc_2_, (int)p_glBlendFunc_3_);
            } else {
                GL14.glBlendFuncSeparate((int)p_glBlendFunc_0_, (int)p_glBlendFunc_1_, (int)p_glBlendFunc_2_, (int)p_glBlendFunc_3_);
            }
        } else {
            GL11.glBlendFunc((int)p_glBlendFunc_0_, (int)p_glBlendFunc_1_);
        }
    }

    public static boolean isFramebufferEnabled() {
        return framebufferSupported && Minecraft.getMinecraft().gameSettings.fboEnable;
    }

    public static String getCpu() {
        return cpu == null ? "<unknown>" : cpu;
    }

    public static void renderDirections(int p_renderDirections_0_) {
        GlStateManager.disableTexture2D();
        GlStateManager.depthMask(false);
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        GL11.glLineWidth((float)4.0f);
        vertexbuffer.begin(1, DefaultVertexFormats.POSITION_COLOR);
        vertexbuffer.pos(0.0, 0.0, 0.0).color(0, 0, 0, 255).endVertex();
        vertexbuffer.pos(p_renderDirections_0_, 0.0, 0.0).color(0, 0, 0, 255).endVertex();
        vertexbuffer.pos(0.0, 0.0, 0.0).color(0, 0, 0, 255).endVertex();
        vertexbuffer.pos(0.0, p_renderDirections_0_, 0.0).color(0, 0, 0, 255).endVertex();
        vertexbuffer.pos(0.0, 0.0, 0.0).color(0, 0, 0, 255).endVertex();
        vertexbuffer.pos(0.0, 0.0, p_renderDirections_0_).color(0, 0, 0, 255).endVertex();
        tessellator.draw();
        GL11.glLineWidth((float)2.0f);
        vertexbuffer.begin(1, DefaultVertexFormats.POSITION_COLOR);
        vertexbuffer.pos(0.0, 0.0, 0.0).color(255, 0, 0, 255).endVertex();
        vertexbuffer.pos(p_renderDirections_0_, 0.0, 0.0).color(255, 0, 0, 255).endVertex();
        vertexbuffer.pos(0.0, 0.0, 0.0).color(0, 255, 0, 255).endVertex();
        vertexbuffer.pos(0.0, p_renderDirections_0_, 0.0).color(0, 255, 0, 255).endVertex();
        vertexbuffer.pos(0.0, 0.0, 0.0).color(127, 127, 255, 255).endVertex();
        vertexbuffer.pos(0.0, 0.0, p_renderDirections_0_).color(127, 127, 255, 255).endVertex();
        tessellator.draw();
        GL11.glLineWidth((float)1.0f);
        GlStateManager.depthMask(true);
        GlStateManager.enableTexture2D();
    }

    public static void openFile(File p_openFile_0_) {
        String s = p_openFile_0_.getAbsolutePath();
        if (Util.getOSType() == Util.EnumOS.OSX) {
            try {
                LOGGER.info(s);
                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", s});
                return;
            }
            catch (IOException ioexception1) {
                LOGGER.error("Couldn't open file", (Throwable)ioexception1);
            }
        } else if (Util.getOSType() == Util.EnumOS.WINDOWS) {
            String s1 = String.format("cmd.exe /C start \"Open file\" \"%s\"", s);
            try {
                Runtime.getRuntime().exec(s1);
                return;
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't open file", (Throwable)ioexception);
            }
        }
        boolean flag = false;
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, p_openFile_0_.toURI());
        }
        catch (Throwable throwable) {
            LOGGER.error("Couldn't open link", throwable);
            flag = true;
        }
        if (flag) {
            LOGGER.info("Opening via system class!");
            Sys.openURL((String)("file://" + s));
        }
    }

    static {
        logText = "";
        lastBrightnessX = 0.0f;
        lastBrightnessY = 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    static enum FboMode {
        BASE,
        ARB,
        EXT;

    }
}

