/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.ChunkRenderContainer;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderList;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VboRenderList;
import net.minecraft.client.renderer.Vector3d;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.IRenderChunkFactory;
import net.minecraft.client.renderer.chunk.ListChunkFactory;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.chunk.VboChunkFactory;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemRecord;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

@SideOnly(value=Side.CLIENT)
public class RenderGlobal
implements IWorldEventListener,
IResourceManagerReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation MOON_PHASES_TEXTURES = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_TEXTURES = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation CLOUDS_TEXTURES = new ResourceLocation("textures/environment/clouds.png");
    private static final ResourceLocation END_SKY_TEXTURES = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation FORCEFIELD_TEXTURES = new ResourceLocation("textures/misc/forcefield.png");
    private final Minecraft mc;
    private final TextureManager renderEngine;
    private final RenderManager renderManager;
    private WorldClient world;
    private Set<RenderChunk> chunksToUpdate = Sets.newLinkedHashSet();
    private List<ContainerLocalRenderInformation> renderInfos = Lists.newArrayListWithCapacity((int)69696);
    private final Set<TileEntity> setTileEntities = Sets.newHashSet();
    private ViewFrustum viewFrustum;
    private int starGLCallList = -1;
    private int glSkyList = -1;
    private int glSkyList2 = -1;
    private final VertexFormat vertexBufferFormat;
    private net.minecraft.client.renderer.vertex.VertexBuffer starVBO;
    private net.minecraft.client.renderer.vertex.VertexBuffer skyVBO;
    private net.minecraft.client.renderer.vertex.VertexBuffer sky2VBO;
    private int cloudTickCounter;
    private final Map<Integer, DestroyBlockProgress> damagedBlocks = Maps.newHashMap();
    private final Map<BlockPos, ISound> mapSoundPositions = Maps.newHashMap();
    private final TextureAtlasSprite[] destroyBlockIcons = new TextureAtlasSprite[10];
    private Framebuffer entityOutlineFramebuffer;
    private ShaderGroup entityOutlineShader;
    private double frustumUpdatePosX = Double.MIN_VALUE;
    private double frustumUpdatePosY = Double.MIN_VALUE;
    private double frustumUpdatePosZ = Double.MIN_VALUE;
    private int frustumUpdatePosChunkX = Integer.MIN_VALUE;
    private int frustumUpdatePosChunkY = Integer.MIN_VALUE;
    private int frustumUpdatePosChunkZ = Integer.MIN_VALUE;
    private double lastViewEntityX = Double.MIN_VALUE;
    private double lastViewEntityY = Double.MIN_VALUE;
    private double lastViewEntityZ = Double.MIN_VALUE;
    private double lastViewEntityPitch = Double.MIN_VALUE;
    private double lastViewEntityYaw = Double.MIN_VALUE;
    private ChunkRenderDispatcher renderDispatcher;
    private ChunkRenderContainer renderContainer;
    private int renderDistanceChunks = -1;
    private int renderEntitiesStartupCounter = 2;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    private boolean debugFixTerrainFrustum;
    private ClippingHelper debugFixedClippingHelper;
    private final Vector4f[] debugTerrainMatrix = new Vector4f[8];
    private final Vector3d debugTerrainFrustumPosition = new Vector3d();
    private boolean vboEnabled;
    IRenderChunkFactory renderChunkFactory;
    private double prevRenderSortX;
    private double prevRenderSortY;
    private double prevRenderSortZ;
    private boolean displayListEntitiesDirty = true;
    private boolean entityOutlinesRendered;
    private final Set<BlockPos> setLightUpdates = Sets.newHashSet();

    public RenderGlobal(Minecraft p_i1249_1_) {
        this.mc = p_i1249_1_;
        this.renderManager = p_i1249_1_.getRenderManager();
        this.renderEngine = p_i1249_1_.getTextureManager();
        this.renderEngine.bindTexture(FORCEFIELD_TEXTURES);
        GlStateManager.glTexParameteri(3553, 10242, 10497);
        GlStateManager.glTexParameteri(3553, 10243, 10497);
        GlStateManager.bindTexture(0);
        this.updateDestroyBlockIcons();
        this.vboEnabled = OpenGlHelper.useVbo();
        if (this.vboEnabled) {
            this.renderContainer = new VboRenderList();
            this.renderChunkFactory = new VboChunkFactory();
        } else {
            this.renderContainer = new RenderList();
            this.renderChunkFactory = new ListChunkFactory();
        }
        this.vertexBufferFormat = new VertexFormat();
        this.vertexBufferFormat.addElement(new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.POSITION, 3));
        this.generateStars();
        this.generateSky();
        this.generateSky2();
    }

    @Override
    public void onResourceManagerReload(IResourceManager p_onResourceManagerReload_1_) {
        this.updateDestroyBlockIcons();
    }

    private void updateDestroyBlockIcons() {
        TextureMap texturemap = this.mc.getTextureMapBlocks();
        for (int i = 0; i < this.destroyBlockIcons.length; ++i) {
            this.destroyBlockIcons[i] = texturemap.getAtlasSprite("minecraft:blocks/destroy_stage_" + i);
        }
    }

    public void makeEntityOutlineShader() {
        if (OpenGlHelper.shadersSupported) {
            if (ShaderLinkHelper.getStaticShaderLinkHelper() == null) {
                ShaderLinkHelper.setNewStaticShaderLinkHelper();
            }
            ResourceLocation resourcelocation = new ResourceLocation("shaders/post/entity_outline.json");
            try {
                this.entityOutlineShader = new ShaderGroup(this.mc.getTextureManager(), this.mc.getResourceManager(), this.mc.getFramebuffer(), resourcelocation);
                this.entityOutlineShader.createBindFramebuffers(this.mc.displayWidth, this.mc.displayHeight);
                this.entityOutlineFramebuffer = this.entityOutlineShader.getFramebufferRaw("final");
            }
            catch (IOException ioexception) {
                LOGGER.warn("Failed to load shader: {}", new Object[]{resourcelocation, ioexception});
                this.entityOutlineShader = null;
                this.entityOutlineFramebuffer = null;
            }
            catch (JsonSyntaxException jsonsyntaxexception) {
                LOGGER.warn("Failed to load shader: {}", new Object[]{resourcelocation, jsonsyntaxexception});
                this.entityOutlineShader = null;
                this.entityOutlineFramebuffer = null;
            }
        } else {
            this.entityOutlineShader = null;
            this.entityOutlineFramebuffer = null;
        }
    }

    public void renderEntityOutlineFramebuffer() {
        if (this.isRenderEntityOutlines()) {
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
            this.entityOutlineFramebuffer.framebufferRenderExt(this.mc.displayWidth, this.mc.displayHeight, false);
            GlStateManager.disableBlend();
        }
    }

    protected boolean isRenderEntityOutlines() {
        return this.entityOutlineFramebuffer != null && this.entityOutlineShader != null && this.mc.player != null;
    }

    private void generateSky2() {
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        if (this.sky2VBO != null) {
            this.sky2VBO.deleteGlBuffers();
        }
        if (this.glSkyList2 >= 0) {
            GLAllocation.deleteDisplayLists(this.glSkyList2);
            this.glSkyList2 = -1;
        }
        if (this.vboEnabled) {
            this.sky2VBO = new net.minecraft.client.renderer.vertex.VertexBuffer(this.vertexBufferFormat);
            this.renderSky(vertexbuffer, -16.0f, true);
            vertexbuffer.finishDrawing();
            vertexbuffer.reset();
            this.sky2VBO.bufferData(vertexbuffer.getByteBuffer());
        } else {
            this.glSkyList2 = GLAllocation.generateDisplayLists(1);
            GlStateManager.glNewList(this.glSkyList2, 4864);
            this.renderSky(vertexbuffer, -16.0f, true);
            tessellator.draw();
            GlStateManager.glEndList();
        }
    }

    private void generateSky() {
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        if (this.skyVBO != null) {
            this.skyVBO.deleteGlBuffers();
        }
        if (this.glSkyList >= 0) {
            GLAllocation.deleteDisplayLists(this.glSkyList);
            this.glSkyList = -1;
        }
        if (this.vboEnabled) {
            this.skyVBO = new net.minecraft.client.renderer.vertex.VertexBuffer(this.vertexBufferFormat);
            this.renderSky(vertexbuffer, 16.0f, false);
            vertexbuffer.finishDrawing();
            vertexbuffer.reset();
            this.skyVBO.bufferData(vertexbuffer.getByteBuffer());
        } else {
            this.glSkyList = GLAllocation.generateDisplayLists(1);
            GlStateManager.glNewList(this.glSkyList, 4864);
            this.renderSky(vertexbuffer, 16.0f, false);
            tessellator.draw();
            GlStateManager.glEndList();
        }
    }

    private void renderSky(VertexBuffer p_renderSky_1_, float p_renderSky_2_, boolean p_renderSky_3_) {
        int i = 64;
        int j = 6;
        p_renderSky_1_.begin(7, DefaultVertexFormats.POSITION);
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -384; l <= 384; l += 64) {
                float f = k;
                float f1 = k + 64;
                if (p_renderSky_3_) {
                    f1 = k;
                    f = k + 64;
                }
                p_renderSky_1_.pos(f, p_renderSky_2_, l).endVertex();
                p_renderSky_1_.pos(f1, p_renderSky_2_, l).endVertex();
                p_renderSky_1_.pos(f1, p_renderSky_2_, l + 64).endVertex();
                p_renderSky_1_.pos(f, p_renderSky_2_, l + 64).endVertex();
            }
        }
    }

    private void generateStars() {
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        if (this.starVBO != null) {
            this.starVBO.deleteGlBuffers();
        }
        if (this.starGLCallList >= 0) {
            GLAllocation.deleteDisplayLists(this.starGLCallList);
            this.starGLCallList = -1;
        }
        if (this.vboEnabled) {
            this.starVBO = new net.minecraft.client.renderer.vertex.VertexBuffer(this.vertexBufferFormat);
            this.renderStars(vertexbuffer);
            vertexbuffer.finishDrawing();
            vertexbuffer.reset();
            this.starVBO.bufferData(vertexbuffer.getByteBuffer());
        } else {
            this.starGLCallList = GLAllocation.generateDisplayLists(1);
            GlStateManager.pushMatrix();
            GlStateManager.glNewList(this.starGLCallList, 4864);
            this.renderStars(vertexbuffer);
            tessellator.draw();
            GlStateManager.glEndList();
            GlStateManager.popMatrix();
        }
    }

    private void renderStars(VertexBuffer p_renderStars_1_) {
        Random random = new Random(10842L);
        p_renderStars_1_.begin(7, DefaultVertexFormats.POSITION);
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = 0.0;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                p_renderStars_1_.pos(d5 + d25, d6 + d23, d7 + d26).endVertex();
            }
        }
    }

    public void setWorldAndLoadRenderers(WorldClient p_setWorldAndLoadRenderers_1_) {
        if (this.world != null) {
            this.world.removeEventListener(this);
        }
        this.frustumUpdatePosX = Double.MIN_VALUE;
        this.frustumUpdatePosY = Double.MIN_VALUE;
        this.frustumUpdatePosZ = Double.MIN_VALUE;
        this.frustumUpdatePosChunkX = Integer.MIN_VALUE;
        this.frustumUpdatePosChunkY = Integer.MIN_VALUE;
        this.frustumUpdatePosChunkZ = Integer.MIN_VALUE;
        this.renderManager.setWorld(p_setWorldAndLoadRenderers_1_);
        this.world = p_setWorldAndLoadRenderers_1_;
        if (p_setWorldAndLoadRenderers_1_ != null) {
            p_setWorldAndLoadRenderers_1_.addEventListener(this);
            this.loadRenderers();
        } else {
            this.chunksToUpdate.clear();
            this.renderInfos.clear();
            if (this.viewFrustum != null) {
                this.viewFrustum.deleteGlResources();
                this.viewFrustum = null;
            }
            if (this.renderDispatcher != null) {
                this.renderDispatcher.stopWorkerThreads();
            }
            this.renderDispatcher = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRenderers() {
        if (this.world != null) {
            Entity entity;
            if (this.renderDispatcher == null) {
                this.renderDispatcher = new ChunkRenderDispatcher();
            }
            this.displayListEntitiesDirty = true;
            Blocks.LEAVES.setGraphicsLevel(this.mc.gameSettings.fancyGraphics);
            Blocks.LEAVES2.setGraphicsLevel(this.mc.gameSettings.fancyGraphics);
            this.renderDistanceChunks = this.mc.gameSettings.renderDistanceChunks;
            boolean flag = this.vboEnabled;
            this.vboEnabled = OpenGlHelper.useVbo();
            if (flag && !this.vboEnabled) {
                this.renderContainer = new RenderList();
                this.renderChunkFactory = new ListChunkFactory();
            } else if (!flag && this.vboEnabled) {
                this.renderContainer = new VboRenderList();
                this.renderChunkFactory = new VboChunkFactory();
            }
            if (flag != this.vboEnabled) {
                this.generateStars();
                this.generateSky();
                this.generateSky2();
            }
            if (this.viewFrustum != null) {
                this.viewFrustum.deleteGlResources();
            }
            this.stopChunkUpdates();
            Set<TileEntity> set = this.setTileEntities;
            synchronized (set) {
                this.setTileEntities.clear();
            }
            this.viewFrustum = new ViewFrustum(this.world, this.mc.gameSettings.renderDistanceChunks, this, this.renderChunkFactory);
            if (this.world != null && (entity = this.mc.getRenderViewEntity()) != null) {
                this.viewFrustum.updateChunkPositions(entity.posX, entity.posZ);
            }
            this.renderEntitiesStartupCounter = 2;
        }
    }

    protected void stopChunkUpdates() {
        this.chunksToUpdate.clear();
        this.renderDispatcher.stopChunkUpdates();
    }

    public void createBindEntityOutlineFbs(int p_createBindEntityOutlineFbs_1_, int p_createBindEntityOutlineFbs_2_) {
        if (OpenGlHelper.shadersSupported && this.entityOutlineShader != null) {
            this.entityOutlineShader.createBindFramebuffers(p_createBindEntityOutlineFbs_1_, p_createBindEntityOutlineFbs_2_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderEntities(Entity p_renderEntities_1_, ICamera p_renderEntities_2_, float p_renderEntities_3_) {
        int pass = MinecraftForgeClient.getRenderPass();
        if (this.renderEntitiesStartupCounter > 0) {
            if (pass > 0) {
                return;
            }
            --this.renderEntitiesStartupCounter;
        } else {
            double d0 = p_renderEntities_1_.prevPosX + (p_renderEntities_1_.posX - p_renderEntities_1_.prevPosX) * (double)p_renderEntities_3_;
            double d1 = p_renderEntities_1_.prevPosY + (p_renderEntities_1_.posY - p_renderEntities_1_.prevPosY) * (double)p_renderEntities_3_;
            double d2 = p_renderEntities_1_.prevPosZ + (p_renderEntities_1_.posZ - p_renderEntities_1_.prevPosZ) * (double)p_renderEntities_3_;
            this.world.theProfiler.startSection("prepare");
            TileEntityRendererDispatcher.instance.prepare(this.world, this.mc.getTextureManager(), this.mc.fontRendererObj, this.mc.getRenderViewEntity(), this.mc.objectMouseOver, p_renderEntities_3_);
            this.renderManager.cacheActiveRenderInfo(this.world, this.mc.fontRendererObj, this.mc.getRenderViewEntity(), this.mc.pointedEntity, this.mc.gameSettings, p_renderEntities_3_);
            if (pass == 0) {
                this.countEntitiesTotal = 0;
                this.countEntitiesRendered = 0;
                this.countEntitiesHidden = 0;
            }
            Entity entity = this.mc.getRenderViewEntity();
            double d3 = entity.lastTickPosX + (entity.posX - entity.lastTickPosX) * (double)p_renderEntities_3_;
            double d4 = entity.lastTickPosY + (entity.posY - entity.lastTickPosY) * (double)p_renderEntities_3_;
            double d5 = entity.lastTickPosZ + (entity.posZ - entity.lastTickPosZ) * (double)p_renderEntities_3_;
            TileEntityRendererDispatcher.staticPlayerX = d3;
            TileEntityRendererDispatcher.staticPlayerY = d4;
            TileEntityRendererDispatcher.staticPlayerZ = d5;
            this.renderManager.setRenderPosition(d3, d4, d5);
            this.mc.entityRenderer.enableLightmap();
            this.world.theProfiler.endStartSection("global");
            List<Entity> list = this.world.getLoadedEntityList();
            if (pass == 0) {
                this.countEntitiesTotal = list.size();
            }
            for (int i = 0; i < this.world.weatherEffects.size(); ++i) {
                Entity entity1 = (Entity)this.world.weatherEffects.get(i);
                if (!entity1.shouldRenderInPass(pass)) continue;
                ++this.countEntitiesRendered;
                if (!entity1.isInRangeToRender3d(d0, d1, d2)) continue;
                this.renderManager.renderEntityStatic(entity1, p_renderEntities_3_, false);
            }
            this.world.theProfiler.endStartSection("entities");
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.retain();
            for (ContainerLocalRenderInformation containerLocalRenderInformation : this.renderInfos) {
                Chunk chunk = this.world.getChunkFromBlockCoords(containerLocalRenderInformation.renderChunk.getPosition());
                ClassInheritanceMultiMap<Entity> classinheritancemultimap = chunk.getEntityLists()[containerLocalRenderInformation.renderChunk.getPosition().getY() / 16];
                if (classinheritancemultimap.isEmpty()) continue;
                for (Entity entity2 : classinheritancemultimap) {
                    boolean flag1;
                    boolean flag;
                    if (!entity2.shouldRenderInPass(pass) || !(flag = this.renderManager.shouldRender(entity2, p_renderEntities_2_, d0, d1, d2) || entity2.isRidingOrBeingRiddenBy(this.mc.player))) continue;
                    boolean bl = flag1 = this.mc.getRenderViewEntity() instanceof EntityLivingBase ? ((EntityLivingBase)this.mc.getRenderViewEntity()).isPlayerSleeping() : false;
                    if (entity2 == this.mc.getRenderViewEntity() && this.mc.gameSettings.thirdPersonView == 0 && !flag1 || !(entity2.posY < 0.0) && !(entity2.posY >= 256.0) && !this.world.isBlockLoaded(blockpos$pooledmutableblockpos.setPos(entity2))) continue;
                    ++this.countEntitiesRendered;
                    this.renderManager.renderEntityStatic(entity2, p_renderEntities_3_, false);
                    if (this.isOutlineActive(entity2, entity, p_renderEntities_2_)) {
                        list1.add(entity2);
                    }
                    if (!this.renderManager.isRenderMultipass(entity2)) continue;
                    list2.add(entity2);
                }
            }
            blockpos$pooledmutableblockpos.release();
            if (!list2.isEmpty()) {
                for (Entity entity2 : list2) {
                    this.renderManager.renderMultipass(entity2, p_renderEntities_3_);
                }
            }
            if (pass == 0 && this.isRenderEntityOutlines() && (!list1.isEmpty() || this.entityOutlinesRendered)) {
                this.world.theProfiler.endStartSection("entityOutlines");
                this.entityOutlineFramebuffer.framebufferClear();
                boolean bl = this.entityOutlinesRendered = !list1.isEmpty();
                if (!list1.isEmpty()) {
                    GlStateManager.depthFunc(519);
                    GlStateManager.disableFog();
                    this.entityOutlineFramebuffer.bindFramebuffer(false);
                    RenderHelper.disableStandardItemLighting();
                    this.renderManager.setRenderOutlines(true);
                    for (int j = 0; j < list1.size(); ++j) {
                        this.renderManager.renderEntityStatic((Entity)list1.get(j), p_renderEntities_3_, false);
                    }
                    this.renderManager.setRenderOutlines(false);
                    RenderHelper.enableStandardItemLighting();
                    GlStateManager.depthMask(false);
                    this.entityOutlineShader.loadShaderGroup(p_renderEntities_3_);
                    GlStateManager.enableLighting();
                    GlStateManager.depthMask(true);
                    GlStateManager.enableFog();
                    GlStateManager.enableBlend();
                    GlStateManager.enableColorMaterial();
                    GlStateManager.depthFunc(515);
                    GlStateManager.enableDepth();
                    GlStateManager.enableAlpha();
                }
                this.mc.getFramebuffer().bindFramebuffer(false);
            }
            this.world.theProfiler.endStartSection("blockentities");
            RenderHelper.enableStandardItemLighting();
            TileEntityRendererDispatcher.instance.preDrawBatch();
            for (ContainerLocalRenderInformation containerLocalRenderInformation : this.renderInfos) {
                List<TileEntity> list3 = containerLocalRenderInformation.renderChunk.getCompiledChunk().getTileEntities();
                if (list3.isEmpty()) continue;
                for (TileEntity tileentity2 : list3) {
                    if (!tileentity2.shouldRenderInPass(pass) || !p_renderEntities_2_.isBoundingBoxInFrustum(tileentity2.getRenderBoundingBox())) continue;
                    TileEntityRendererDispatcher.instance.renderTileEntity(tileentity2, p_renderEntities_3_, -1);
                }
            }
            Iterator<DestroyBlockProgress> iterator = this.setTileEntities;
            synchronized (iterator) {
                for (TileEntity tileentity : this.setTileEntities) {
                    if (!tileentity.shouldRenderInPass(pass) || !p_renderEntities_2_.isBoundingBoxInFrustum(tileentity.getRenderBoundingBox())) continue;
                    TileEntityRendererDispatcher.instance.renderTileEntity(tileentity, p_renderEntities_3_, -1);
                }
            }
            TileEntityRendererDispatcher.instance.drawBatch(pass);
            this.preRenderDamagedBlocks();
            for (DestroyBlockProgress destroyBlockProgress : this.damagedBlocks.values()) {
                BlockPos blockpos = destroyBlockProgress.getPosition();
                if (!this.world.getBlockState(blockpos).getBlock().hasTileEntity()) continue;
                TileEntity tileentity1 = this.world.getTileEntity(blockpos);
                if (tileentity1 instanceof TileEntityChest) {
                    TileEntityChest tileentitychest = (TileEntityChest)tileentity1;
                    if (tileentitychest.adjacentChestXNeg != null) {
                        blockpos = blockpos.offset(EnumFacing.WEST);
                        tileentity1 = this.world.getTileEntity(blockpos);
                    } else if (tileentitychest.adjacentChestZNeg != null) {
                        blockpos = blockpos.offset(EnumFacing.NORTH);
                        tileentity1 = this.world.getTileEntity(blockpos);
                    }
                }
                IBlockState iblockstate = this.world.getBlockState(blockpos);
                if (tileentity1 == null || !iblockstate.hasCustomBreakingProgress()) continue;
                TileEntityRendererDispatcher.instance.renderTileEntity(tileentity1, p_renderEntities_3_, destroyBlockProgress.getPartialBlockDamage());
            }
            this.postRenderDamagedBlocks();
            this.mc.entityRenderer.disableLightmap();
            this.mc.mcProfiler.endSection();
        }
    }

    private boolean isOutlineActive(Entity p_isOutlineActive_1_, Entity p_isOutlineActive_2_, ICamera p_isOutlineActive_3_) {
        boolean flag;
        boolean bl = flag = p_isOutlineActive_2_ instanceof EntityLivingBase && ((EntityLivingBase)p_isOutlineActive_2_).isPlayerSleeping();
        return p_isOutlineActive_1_ == p_isOutlineActive_2_ && this.mc.gameSettings.thirdPersonView == 0 && !flag ? false : (p_isOutlineActive_1_.isGlowing() ? true : (this.mc.player.isSpectator() && this.mc.gameSettings.keyBindSpectatorOutlines.isKeyDown() && p_isOutlineActive_1_ instanceof EntityPlayer ? p_isOutlineActive_1_.ignoreFrustumCheck || p_isOutlineActive_3_.isBoundingBoxInFrustum(p_isOutlineActive_1_.getEntityBoundingBox()) || p_isOutlineActive_1_.isRidingOrBeingRiddenBy(this.mc.player) : false));
    }

    public String getDebugInfoRenders() {
        int i = this.viewFrustum.renderChunks.length;
        int j = this.getRenderedChunks();
        return String.format("C: %d/%d %sD: %d, L: %d, %s", j, i, this.mc.renderChunksMany ? "(s) " : "", this.renderDistanceChunks, this.setLightUpdates.size(), this.renderDispatcher == null ? "null" : this.renderDispatcher.getDebugInfo());
    }

    protected int getRenderedChunks() {
        int i = 0;
        for (ContainerLocalRenderInformation renderglobal$containerlocalrenderinformation : this.renderInfos) {
            CompiledChunk compiledchunk = renderglobal$containerlocalrenderinformation.renderChunk.compiledChunk;
            if (compiledchunk == CompiledChunk.DUMMY || compiledchunk.isEmpty()) continue;
            ++i;
        }
        return i;
    }

    public String getDebugInfoEntities() {
        return "E: " + this.countEntitiesRendered + "/" + this.countEntitiesTotal + ", B: " + this.countEntitiesHidden;
    }

    public void setupTerrain(Entity p_setupTerrain_1_, double p_setupTerrain_2_, ICamera p_setupTerrain_4_, int p_setupTerrain_5_, boolean p_setupTerrain_6_) {
        if (this.mc.gameSettings.renderDistanceChunks != this.renderDistanceChunks) {
            this.loadRenderers();
        }
        this.world.theProfiler.startSection("camera");
        double d0 = p_setupTerrain_1_.posX - this.frustumUpdatePosX;
        double d1 = p_setupTerrain_1_.posY - this.frustumUpdatePosY;
        double d2 = p_setupTerrain_1_.posZ - this.frustumUpdatePosZ;
        if (this.frustumUpdatePosChunkX != p_setupTerrain_1_.chunkCoordX || this.frustumUpdatePosChunkY != p_setupTerrain_1_.chunkCoordY || this.frustumUpdatePosChunkZ != p_setupTerrain_1_.chunkCoordZ || d0 * d0 + d1 * d1 + d2 * d2 > 16.0) {
            this.frustumUpdatePosX = p_setupTerrain_1_.posX;
            this.frustumUpdatePosY = p_setupTerrain_1_.posY;
            this.frustumUpdatePosZ = p_setupTerrain_1_.posZ;
            this.frustumUpdatePosChunkX = p_setupTerrain_1_.chunkCoordX;
            this.frustumUpdatePosChunkY = p_setupTerrain_1_.chunkCoordY;
            this.frustumUpdatePosChunkZ = p_setupTerrain_1_.chunkCoordZ;
            this.viewFrustum.updateChunkPositions(p_setupTerrain_1_.posX, p_setupTerrain_1_.posZ);
        }
        this.world.theProfiler.endStartSection("renderlistcamera");
        double d3 = p_setupTerrain_1_.lastTickPosX + (p_setupTerrain_1_.posX - p_setupTerrain_1_.lastTickPosX) * p_setupTerrain_2_;
        double d4 = p_setupTerrain_1_.lastTickPosY + (p_setupTerrain_1_.posY - p_setupTerrain_1_.lastTickPosY) * p_setupTerrain_2_;
        double d5 = p_setupTerrain_1_.lastTickPosZ + (p_setupTerrain_1_.posZ - p_setupTerrain_1_.lastTickPosZ) * p_setupTerrain_2_;
        this.renderContainer.initialize(d3, d4, d5);
        this.world.theProfiler.endStartSection("cull");
        if (this.debugFixedClippingHelper != null) {
            Frustum frustum = new Frustum(this.debugFixedClippingHelper);
            frustum.setPosition(this.debugTerrainFrustumPosition.x, this.debugTerrainFrustumPosition.y, this.debugTerrainFrustumPosition.z);
            p_setupTerrain_4_ = frustum;
        }
        this.mc.mcProfiler.endStartSection("culling");
        BlockPos blockpos1 = new BlockPos(d3, d4 + (double)p_setupTerrain_1_.getEyeHeight(), d5);
        RenderChunk renderchunk = this.viewFrustum.getRenderChunk(blockpos1);
        BlockPos blockpos = new BlockPos(MathHelper.floor(d3 / 16.0) * 16, MathHelper.floor(d4 / 16.0) * 16, MathHelper.floor(d5 / 16.0) * 16);
        this.displayListEntitiesDirty = this.displayListEntitiesDirty || !this.chunksToUpdate.isEmpty() || p_setupTerrain_1_.posX != this.lastViewEntityX || p_setupTerrain_1_.posY != this.lastViewEntityY || p_setupTerrain_1_.posZ != this.lastViewEntityZ || (double)p_setupTerrain_1_.rotationPitch != this.lastViewEntityPitch || (double)p_setupTerrain_1_.rotationYaw != this.lastViewEntityYaw;
        this.lastViewEntityX = p_setupTerrain_1_.posX;
        this.lastViewEntityY = p_setupTerrain_1_.posY;
        this.lastViewEntityZ = p_setupTerrain_1_.posZ;
        this.lastViewEntityPitch = p_setupTerrain_1_.rotationPitch;
        this.lastViewEntityYaw = p_setupTerrain_1_.rotationYaw;
        boolean flag = this.debugFixedClippingHelper != null;
        this.mc.mcProfiler.endStartSection("update");
        if (!flag && this.displayListEntitiesDirty) {
            this.displayListEntitiesDirty = false;
            this.renderInfos = Lists.newArrayList();
            ArrayDeque queue = Queues.newArrayDeque();
            Entity.setRenderDistanceWeight(MathHelper.clamp((double)this.mc.gameSettings.renderDistanceChunks / 8.0, 1.0, 2.5));
            boolean flag1 = this.mc.renderChunksMany;
            if (renderchunk != null) {
                boolean flag2 = false;
                ContainerLocalRenderInformation renderglobal$containerlocalrenderinformation3 = new ContainerLocalRenderInformation(renderchunk, null, 0);
                Set<EnumFacing> set1 = this.getVisibleFacings(blockpos1);
                if (set1.size() == 1) {
                    Vector3f vector3f = this.getViewVector(p_setupTerrain_1_, p_setupTerrain_2_);
                    EnumFacing enumfacing = EnumFacing.getFacingFromVector(vector3f.x, vector3f.y, vector3f.z).getOpposite();
                    set1.remove(enumfacing);
                }
                if (set1.isEmpty()) {
                    flag2 = true;
                }
                if (flag2 && !p_setupTerrain_6_) {
                    this.renderInfos.add(renderglobal$containerlocalrenderinformation3);
                } else {
                    if (p_setupTerrain_6_ && this.world.getBlockState(blockpos1).isOpaqueCube()) {
                        flag1 = false;
                    }
                    renderchunk.setFrameIndex(p_setupTerrain_5_);
                    queue.add(renderglobal$containerlocalrenderinformation3);
                }
            } else {
                int i = blockpos1.getY() > 0 ? 248 : 8;
                for (int j = -this.renderDistanceChunks; j <= this.renderDistanceChunks; ++j) {
                    for (int k = -this.renderDistanceChunks; k <= this.renderDistanceChunks; ++k) {
                        RenderChunk renderchunk1 = this.viewFrustum.getRenderChunk(new BlockPos((j << 4) + 8, i, (k << 4) + 8));
                        if (renderchunk1 == null || !p_setupTerrain_4_.isBoundingBoxInFrustum(renderchunk1.boundingBox)) continue;
                        renderchunk1.setFrameIndex(p_setupTerrain_5_);
                        queue.add(new ContainerLocalRenderInformation(renderchunk1, null, 0));
                    }
                }
            }
            this.mc.mcProfiler.startSection("iteration");
            while (!queue.isEmpty()) {
                ContainerLocalRenderInformation renderglobal$containerlocalrenderinformation1 = (ContainerLocalRenderInformation)queue.poll();
                RenderChunk renderchunk3 = renderglobal$containerlocalrenderinformation1.renderChunk;
                EnumFacing enumfacing2 = renderglobal$containerlocalrenderinformation1.facing;
                this.renderInfos.add(renderglobal$containerlocalrenderinformation1);
                for (EnumFacing enumfacing1 : EnumFacing.values()) {
                    RenderChunk renderchunk2 = this.getRenderChunkOffset(blockpos, renderchunk3, enumfacing1);
                    if (flag1 && renderglobal$containerlocalrenderinformation1.hasDirection(enumfacing1.getOpposite()) || flag1 && enumfacing2 != null && !renderchunk3.getCompiledChunk().isVisible(enumfacing2.getOpposite(), enumfacing1) || renderchunk2 == null || !renderchunk2.setFrameIndex(p_setupTerrain_5_) || !p_setupTerrain_4_.isBoundingBoxInFrustum(renderchunk2.boundingBox)) continue;
                    ContainerLocalRenderInformation renderglobal$containerlocalrenderinformation = new ContainerLocalRenderInformation(renderchunk2, enumfacing1, renderglobal$containerlocalrenderinformation1.counter + 1);
                    renderglobal$containerlocalrenderinformation.setDirection(renderglobal$containerlocalrenderinformation1.setFacing, enumfacing1);
                    queue.add(renderglobal$containerlocalrenderinformation);
                }
            }
            this.mc.mcProfiler.endSection();
        }
        this.mc.mcProfiler.endStartSection("captureFrustum");
        if (this.debugFixTerrainFrustum) {
            this.fixTerrainFrustum(d3, d4, d5);
            this.debugFixTerrainFrustum = false;
        }
        this.mc.mcProfiler.endStartSection("rebuildNear");
        Set<RenderChunk> set = this.chunksToUpdate;
        this.chunksToUpdate = Sets.newLinkedHashSet();
        for (ContainerLocalRenderInformation renderglobal$containerlocalrenderinformation2 : this.renderInfos) {
            boolean flag3;
            RenderChunk renderchunk4 = renderglobal$containerlocalrenderinformation2.renderChunk;
            if (!renderchunk4.isNeedsUpdate() && !set.contains(renderchunk4)) continue;
            this.displayListEntitiesDirty = true;
            BlockPos blockpos2 = renderchunk4.getPosition().add(8, 8, 8);
            boolean bl = flag3 = blockpos2.distanceSq(blockpos1) < 768.0;
            if (ForgeModContainer.alwaysSetupTerrainOffThread || !renderchunk4.isNeedsUpdateCustom() && !flag3) {
                this.chunksToUpdate.add(renderchunk4);
                continue;
            }
            this.mc.mcProfiler.startSection("build near");
            this.renderDispatcher.updateChunkNow(renderchunk4);
            renderchunk4.clearNeedsUpdate();
            this.mc.mcProfiler.endSection();
        }
        this.chunksToUpdate.addAll(set);
        this.mc.mcProfiler.endSection();
    }

    private Set<EnumFacing> getVisibleFacings(BlockPos p_getVisibleFacings_1_) {
        VisGraph visgraph = new VisGraph();
        BlockPos blockpos = new BlockPos(p_getVisibleFacings_1_.getX() >> 4 << 4, p_getVisibleFacings_1_.getY() >> 4 << 4, p_getVisibleFacings_1_.getZ() >> 4 << 4);
        Chunk chunk = this.world.getChunkFromBlockCoords(blockpos);
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.getAllInBoxMutable(blockpos, blockpos.add(15, 15, 15))) {
            if (!chunk.getBlockState(blockpos$mutableblockpos).isOpaqueCube()) continue;
            visgraph.setOpaqueCube(blockpos$mutableblockpos);
        }
        return visgraph.getVisibleFacings(p_getVisibleFacings_1_);
    }

    @Nullable
    private RenderChunk getRenderChunkOffset(BlockPos p_getRenderChunkOffset_1_, RenderChunk p_getRenderChunkOffset_2_, EnumFacing p_getRenderChunkOffset_3_) {
        BlockPos blockpos = p_getRenderChunkOffset_2_.getBlockPosOffset16(p_getRenderChunkOffset_3_);
        return MathHelper.abs(p_getRenderChunkOffset_1_.getX() - blockpos.getX()) > this.renderDistanceChunks * 16 ? null : (blockpos.getY() >= 0 && blockpos.getY() < 256 ? (MathHelper.abs(p_getRenderChunkOffset_1_.getZ() - blockpos.getZ()) > this.renderDistanceChunks * 16 ? null : this.viewFrustum.getRenderChunk(blockpos)) : null);
    }

    private void fixTerrainFrustum(double p_fixTerrainFrustum_1_, double p_fixTerrainFrustum_3_, double p_fixTerrainFrustum_5_) {
        this.debugFixedClippingHelper = new ClippingHelperImpl();
        ((ClippingHelperImpl)this.debugFixedClippingHelper).init();
        Matrix4f matrix4f = new Matrix4f(this.debugFixedClippingHelper.modelviewMatrix);
        matrix4f.transpose();
        Matrix4f matrix4f1 = new Matrix4f(this.debugFixedClippingHelper.projectionMatrix);
        matrix4f1.transpose();
        Matrix4f matrix4f2 = new Matrix4f();
        Matrix4f.mul((org.lwjgl.util.vector.Matrix4f)matrix4f1, (org.lwjgl.util.vector.Matrix4f)matrix4f, (org.lwjgl.util.vector.Matrix4f)matrix4f2);
        matrix4f2.invert();
        this.debugTerrainFrustumPosition.x = p_fixTerrainFrustum_1_;
        this.debugTerrainFrustumPosition.y = p_fixTerrainFrustum_3_;
        this.debugTerrainFrustumPosition.z = p_fixTerrainFrustum_5_;
        this.debugTerrainMatrix[0] = new Vector4f(-1.0f, -1.0f, -1.0f, 1.0f);
        this.debugTerrainMatrix[1] = new Vector4f(1.0f, -1.0f, -1.0f, 1.0f);
        this.debugTerrainMatrix[2] = new Vector4f(1.0f, 1.0f, -1.0f, 1.0f);
        this.debugTerrainMatrix[3] = new Vector4f(-1.0f, 1.0f, -1.0f, 1.0f);
        this.debugTerrainMatrix[4] = new Vector4f(-1.0f, -1.0f, 1.0f, 1.0f);
        this.debugTerrainMatrix[5] = new Vector4f(1.0f, -1.0f, 1.0f, 1.0f);
        this.debugTerrainMatrix[6] = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.debugTerrainMatrix[7] = new Vector4f(-1.0f, 1.0f, 1.0f, 1.0f);
        for (int i = 0; i < 8; ++i) {
            Matrix4f.transform((org.lwjgl.util.vector.Matrix4f)matrix4f2, (Vector4f)this.debugTerrainMatrix[i], (Vector4f)this.debugTerrainMatrix[i]);
            this.debugTerrainMatrix[i].x /= this.debugTerrainMatrix[i].w;
            this.debugTerrainMatrix[i].y /= this.debugTerrainMatrix[i].w;
            this.debugTerrainMatrix[i].z /= this.debugTerrainMatrix[i].w;
            this.debugTerrainMatrix[i].w = 1.0f;
        }
    }

    protected Vector3f getViewVector(Entity p_getViewVector_1_, double p_getViewVector_2_) {
        float f = (float)((double)p_getViewVector_1_.prevRotationPitch + (double)(p_getViewVector_1_.rotationPitch - p_getViewVector_1_.prevRotationPitch) * p_getViewVector_2_);
        float f1 = (float)((double)p_getViewVector_1_.prevRotationYaw + (double)(p_getViewVector_1_.rotationYaw - p_getViewVector_1_.prevRotationYaw) * p_getViewVector_2_);
        if (Minecraft.getMinecraft().gameSettings.thirdPersonView == 2) {
            f += 180.0f;
        }
        float f2 = MathHelper.cos(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f3 = MathHelper.sin(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f4 = -MathHelper.cos(-f * ((float)Math.PI / 180));
        float f5 = MathHelper.sin(-f * ((float)Math.PI / 180));
        return new Vector3f(f3 * f4, f5, f2 * f4);
    }

    public int renderBlockLayer(BlockRenderLayer p_renderBlockLayer_1_, double p_renderBlockLayer_2_, int p_renderBlockLayer_4_, Entity p_renderBlockLayer_5_) {
        RenderHelper.disableStandardItemLighting();
        if (p_renderBlockLayer_1_ == BlockRenderLayer.TRANSLUCENT) {
            this.mc.mcProfiler.startSection("translucent_sort");
            double d0 = p_renderBlockLayer_5_.posX - this.prevRenderSortX;
            double d1 = p_renderBlockLayer_5_.posY - this.prevRenderSortY;
            double d2 = p_renderBlockLayer_5_.posZ - this.prevRenderSortZ;
            if (d0 * d0 + d1 * d1 + d2 * d2 > 1.0) {
                this.prevRenderSortX = p_renderBlockLayer_5_.posX;
                this.prevRenderSortY = p_renderBlockLayer_5_.posY;
                this.prevRenderSortZ = p_renderBlockLayer_5_.posZ;
                int k = 0;
                for (ContainerLocalRenderInformation renderglobal$containerlocalrenderinformation : this.renderInfos) {
                    if (!renderglobal$containerlocalrenderinformation.renderChunk.compiledChunk.isLayerStarted(p_renderBlockLayer_1_) || k++ >= 15) continue;
                    this.renderDispatcher.updateTransparencyLater(renderglobal$containerlocalrenderinformation.renderChunk);
                }
            }
            this.mc.mcProfiler.endSection();
        }
        this.mc.mcProfiler.startSection("filterempty");
        int l = 0;
        boolean flag = p_renderBlockLayer_1_ == BlockRenderLayer.TRANSLUCENT;
        int i1 = flag ? this.renderInfos.size() - 1 : 0;
        int i = flag ? -1 : this.renderInfos.size();
        int j1 = flag ? -1 : 1;
        for (int j = i1; j != i; j += j1) {
            RenderChunk renderchunk = this.renderInfos.get((int)j).renderChunk;
            if (renderchunk.getCompiledChunk().isLayerEmpty(p_renderBlockLayer_1_)) continue;
            ++l;
            this.renderContainer.addRenderChunk(renderchunk, p_renderBlockLayer_1_);
        }
        this.mc.mcProfiler.endStartSection("render_" + (Object)((Object)p_renderBlockLayer_1_));
        this.renderBlockLayer(p_renderBlockLayer_1_);
        this.mc.mcProfiler.endSection();
        return l;
    }

    private void renderBlockLayer(BlockRenderLayer p_renderBlockLayer_1_) {
        this.mc.entityRenderer.enableLightmap();
        if (OpenGlHelper.useVbo()) {
            GlStateManager.glEnableClientState(32884);
            OpenGlHelper.setClientActiveTexture(OpenGlHelper.defaultTexUnit);
            GlStateManager.glEnableClientState(32888);
            OpenGlHelper.setClientActiveTexture(OpenGlHelper.lightmapTexUnit);
            GlStateManager.glEnableClientState(32888);
            OpenGlHelper.setClientActiveTexture(OpenGlHelper.defaultTexUnit);
            GlStateManager.glEnableClientState(32886);
        }
        this.renderContainer.renderChunkLayer(p_renderBlockLayer_1_);
        if (OpenGlHelper.useVbo()) {
            for (VertexFormatElement vertexformatelement : DefaultVertexFormats.BLOCK.getElements()) {
                VertexFormatElement.EnumUsage vertexformatelement$enumusage = vertexformatelement.getUsage();
                int i = vertexformatelement.getIndex();
                switch (vertexformatelement$enumusage) {
                    case POSITION: {
                        GlStateManager.glDisableClientState(32884);
                        break;
                    }
                    case UV: {
                        OpenGlHelper.setClientActiveTexture(OpenGlHelper.defaultTexUnit + i);
                        GlStateManager.glDisableClientState(32888);
                        OpenGlHelper.setClientActiveTexture(OpenGlHelper.defaultTexUnit);
                        break;
                    }
                    case COLOR: {
                        GlStateManager.glDisableClientState(32886);
                        GlStateManager.resetColor();
                    }
                }
            }
        }
        this.mc.entityRenderer.disableLightmap();
    }

    private void cleanupDamagedBlocks(Iterator<DestroyBlockProgress> p_cleanupDamagedBlocks_1_) {
        while (p_cleanupDamagedBlocks_1_.hasNext()) {
            DestroyBlockProgress destroyblockprogress = p_cleanupDamagedBlocks_1_.next();
            int i = destroyblockprogress.getCreationCloudUpdateTick();
            if (this.cloudTickCounter - i <= 400) continue;
            p_cleanupDamagedBlocks_1_.remove();
        }
    }

    public void updateClouds() {
        ++this.cloudTickCounter;
        if (this.cloudTickCounter % 20 == 0) {
            this.cleanupDamagedBlocks(this.damagedBlocks.values().iterator());
        }
        if (!this.setLightUpdates.isEmpty() && !this.renderDispatcher.hasNoFreeRenderBuilders() && this.chunksToUpdate.isEmpty()) {
            Iterator<BlockPos> iterator = this.setLightUpdates.iterator();
            while (iterator.hasNext()) {
                BlockPos blockpos = iterator.next();
                iterator.remove();
                int i = blockpos.getX();
                int j = blockpos.getY();
                int k = blockpos.getZ();
                this.markBlocksForUpdate(i - 1, j - 1, k - 1, i + 1, j + 1, k + 1, false);
            }
        }
    }

    private void renderSkyEnd() {
        GlStateManager.disableFog();
        GlStateManager.disableAlpha();
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        RenderHelper.disableStandardItemLighting();
        GlStateManager.depthMask(false);
        this.renderEngine.bindTexture(END_SKY_TEXTURES);
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        for (int i = 0; i < 6; ++i) {
            GlStateManager.pushMatrix();
            if (i == 1) {
                GlStateManager.rotate(90.0f, 1.0f, 0.0f, 0.0f);
            }
            if (i == 2) {
                GlStateManager.rotate(-90.0f, 1.0f, 0.0f, 0.0f);
            }
            if (i == 3) {
                GlStateManager.rotate(180.0f, 1.0f, 0.0f, 0.0f);
            }
            if (i == 4) {
                GlStateManager.rotate(90.0f, 0.0f, 0.0f, 1.0f);
            }
            if (i == 5) {
                GlStateManager.rotate(-90.0f, 0.0f, 0.0f, 1.0f);
            }
            vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
            vertexbuffer.pos(-100.0, -100.0, -100.0).tex(0.0, 0.0).color(40, 40, 40, 255).endVertex();
            vertexbuffer.pos(-100.0, -100.0, 100.0).tex(0.0, 16.0).color(40, 40, 40, 255).endVertex();
            vertexbuffer.pos(100.0, -100.0, 100.0).tex(16.0, 16.0).color(40, 40, 40, 255).endVertex();
            vertexbuffer.pos(100.0, -100.0, -100.0).tex(16.0, 0.0).color(40, 40, 40, 255).endVertex();
            tessellator.draw();
            GlStateManager.popMatrix();
        }
        GlStateManager.depthMask(true);
        GlStateManager.enableTexture2D();
        GlStateManager.enableAlpha();
    }

    public void renderSky(float p_renderSky_1_, int p_renderSky_2_) {
        IRenderHandler renderer = this.world.provider.getSkyRenderer();
        if (renderer != null) {
            renderer.render(p_renderSky_1_, this.world, this.mc);
            return;
        }
        if (this.mc.world.provider.getDimensionType().getId() == 1) {
            this.renderSkyEnd();
        } else if (this.mc.world.provider.isSurfaceWorld()) {
            GlStateManager.disableTexture2D();
            Vec3d vec3d = this.world.getSkyColor(this.mc.getRenderViewEntity(), p_renderSky_1_);
            float f = (float)vec3d.xCoord;
            float f1 = (float)vec3d.yCoord;
            float f2 = (float)vec3d.zCoord;
            if (p_renderSky_2_ != 2) {
                float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
                float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
                float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
                f = f3;
                f1 = f4;
                f2 = f5;
            }
            GlStateManager.color(f, f1, f2);
            Tessellator tessellator = Tessellator.getInstance();
            VertexBuffer vertexbuffer = tessellator.getBuffer();
            GlStateManager.depthMask(false);
            GlStateManager.enableFog();
            GlStateManager.color(f, f1, f2);
            if (this.vboEnabled) {
                this.skyVBO.bindBuffer();
                GlStateManager.glEnableClientState(32884);
                GlStateManager.glVertexPointer(3, 5126, 12, 0);
                this.skyVBO.drawArrays(7);
                this.skyVBO.unbindBuffer();
                GlStateManager.glDisableClientState(32884);
            } else {
                GlStateManager.callList(this.glSkyList);
            }
            GlStateManager.disableFog();
            GlStateManager.disableAlpha();
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            RenderHelper.disableStandardItemLighting();
            float[] afloat = this.world.provider.calcSunriseSunsetColors(this.world.getCelestialAngle(p_renderSky_1_), p_renderSky_1_);
            if (afloat != null) {
                GlStateManager.disableTexture2D();
                GlStateManager.shadeModel(7425);
                GlStateManager.pushMatrix();
                GlStateManager.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                GlStateManager.rotate(MathHelper.sin(this.world.getCelestialAngleRadians(p_renderSky_1_)) < 0.0f ? 180.0f : 0.0f, 0.0f, 0.0f, 1.0f);
                GlStateManager.rotate(90.0f, 0.0f, 0.0f, 1.0f);
                float f6 = afloat[0];
                float f7 = afloat[1];
                float f8 = afloat[2];
                if (p_renderSky_2_ != 2) {
                    float f9 = (f6 * 30.0f + f7 * 59.0f + f8 * 11.0f) / 100.0f;
                    float f10 = (f6 * 30.0f + f7 * 70.0f) / 100.0f;
                    float f11 = (f6 * 30.0f + f8 * 70.0f) / 100.0f;
                    f6 = f9;
                    f7 = f10;
                    f8 = f11;
                }
                vertexbuffer.begin(6, DefaultVertexFormats.POSITION_COLOR);
                vertexbuffer.pos(0.0, 100.0, 0.0).color(f6, f7, f8, afloat[3]).endVertex();
                int j = 16;
                for (int l = 0; l <= 16; ++l) {
                    float f21 = (float)l * ((float)Math.PI * 2) / 16.0f;
                    float f12 = MathHelper.sin(f21);
                    float f13 = MathHelper.cos(f21);
                    vertexbuffer.pos(f12 * 120.0f, f13 * 120.0f, -f13 * 40.0f * afloat[3]).color(afloat[0], afloat[1], afloat[2], 0.0f).endVertex();
                }
                tessellator.draw();
                GlStateManager.popMatrix();
                GlStateManager.shadeModel(7424);
            }
            GlStateManager.enableTexture2D();
            GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            GlStateManager.pushMatrix();
            float f16 = 1.0f - this.world.getRainStrength(p_renderSky_1_);
            GlStateManager.color(1.0f, 1.0f, 1.0f, f16);
            GlStateManager.rotate(-90.0f, 0.0f, 1.0f, 0.0f);
            GlStateManager.rotate(this.world.getCelestialAngle(p_renderSky_1_) * 360.0f, 1.0f, 0.0f, 0.0f);
            float f17 = 30.0f;
            this.renderEngine.bindTexture(SUN_TEXTURES);
            vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
            vertexbuffer.pos(-f17, 100.0, -f17).tex(0.0, 0.0).endVertex();
            vertexbuffer.pos(f17, 100.0, -f17).tex(1.0, 0.0).endVertex();
            vertexbuffer.pos(f17, 100.0, f17).tex(1.0, 1.0).endVertex();
            vertexbuffer.pos(-f17, 100.0, f17).tex(0.0, 1.0).endVertex();
            tessellator.draw();
            f17 = 20.0f;
            this.renderEngine.bindTexture(MOON_PHASES_TEXTURES);
            int i = this.world.getMoonPhase();
            int k = i % 4;
            int i1 = i / 4 % 2;
            float f22 = (float)(k + 0) / 4.0f;
            float f23 = (float)(i1 + 0) / 2.0f;
            float f24 = (float)(k + 1) / 4.0f;
            float f14 = (float)(i1 + 1) / 2.0f;
            vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
            vertexbuffer.pos(-f17, -100.0, f17).tex(f24, f14).endVertex();
            vertexbuffer.pos(f17, -100.0, f17).tex(f22, f14).endVertex();
            vertexbuffer.pos(f17, -100.0, -f17).tex(f22, f23).endVertex();
            vertexbuffer.pos(-f17, -100.0, -f17).tex(f24, f23).endVertex();
            tessellator.draw();
            GlStateManager.disableTexture2D();
            float f15 = this.world.getStarBrightness(p_renderSky_1_) * f16;
            if (f15 > 0.0f) {
                GlStateManager.color(f15, f15, f15, f15);
                if (this.vboEnabled) {
                    this.starVBO.bindBuffer();
                    GlStateManager.glEnableClientState(32884);
                    GlStateManager.glVertexPointer(3, 5126, 12, 0);
                    this.starVBO.drawArrays(7);
                    this.starVBO.unbindBuffer();
                    GlStateManager.glDisableClientState(32884);
                } else {
                    GlStateManager.callList(this.starGLCallList);
                }
            }
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            GlStateManager.disableBlend();
            GlStateManager.enableAlpha();
            GlStateManager.enableFog();
            GlStateManager.popMatrix();
            GlStateManager.disableTexture2D();
            GlStateManager.color(0.0f, 0.0f, 0.0f);
            double d0 = this.mc.player.getPositionEyes((float)p_renderSky_1_).yCoord - this.world.getHorizon();
            if (d0 < 0.0) {
                GlStateManager.pushMatrix();
                GlStateManager.translate(0.0f, 12.0f, 0.0f);
                if (this.vboEnabled) {
                    this.sky2VBO.bindBuffer();
                    GlStateManager.glEnableClientState(32884);
                    GlStateManager.glVertexPointer(3, 5126, 12, 0);
                    this.sky2VBO.drawArrays(7);
                    this.sky2VBO.unbindBuffer();
                    GlStateManager.glDisableClientState(32884);
                } else {
                    GlStateManager.callList(this.glSkyList2);
                }
                GlStateManager.popMatrix();
                float f18 = 1.0f;
                float f19 = -((float)(d0 + 65.0));
                float f20 = -1.0f;
                vertexbuffer.begin(7, DefaultVertexFormats.POSITION_COLOR);
                vertexbuffer.pos(-1.0, f19, 1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(1.0, f19, 1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(1.0, -1.0, 1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(-1.0, -1.0, 1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(-1.0, -1.0, -1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(1.0, -1.0, -1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(1.0, f19, -1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(-1.0, f19, -1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(1.0, -1.0, -1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(1.0, -1.0, 1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(1.0, f19, 1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(1.0, f19, -1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(-1.0, f19, -1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(-1.0, f19, 1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(-1.0, -1.0, 1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(-1.0, -1.0, -1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(-1.0, -1.0, -1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(-1.0, -1.0, 1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(1.0, -1.0, 1.0).color(0, 0, 0, 255).endVertex();
                vertexbuffer.pos(1.0, -1.0, -1.0).color(0, 0, 0, 255).endVertex();
                tessellator.draw();
            }
            if (this.world.provider.isSkyColored()) {
                GlStateManager.color(f * 0.2f + 0.04f, f1 * 0.2f + 0.04f, f2 * 0.6f + 0.1f);
            } else {
                GlStateManager.color(f, f1, f2);
            }
            GlStateManager.pushMatrix();
            GlStateManager.translate(0.0f, -((float)(d0 - 16.0)), 0.0f);
            GlStateManager.callList(this.glSkyList2);
            GlStateManager.popMatrix();
            GlStateManager.enableTexture2D();
            GlStateManager.depthMask(true);
        }
    }

    public void renderClouds(float p_renderClouds_1_, int p_renderClouds_2_, double p_renderClouds_3_, double p_renderClouds_5_, double p_renderClouds_7_) {
        IRenderHandler renderer = this.mc.world.provider.getCloudRenderer();
        if (renderer != null) {
            renderer.render(p_renderClouds_1_, this.mc.world, this.mc);
            return;
        }
        if (this.mc.world.provider.isSurfaceWorld()) {
            if (this.mc.gameSettings.shouldRenderClouds() == 2) {
                this.renderCloudsFancy(p_renderClouds_1_, p_renderClouds_2_, p_renderClouds_3_, p_renderClouds_5_, p_renderClouds_7_);
            } else {
                GlStateManager.disableCull();
                int i = 32;
                int j = 8;
                Tessellator tessellator = Tessellator.getInstance();
                VertexBuffer vertexbuffer = tessellator.getBuffer();
                this.renderEngine.bindTexture(CLOUDS_TEXTURES);
                GlStateManager.enableBlend();
                GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
                Vec3d vec3d = this.world.getCloudColour(p_renderClouds_1_);
                float f = (float)vec3d.xCoord;
                float f1 = (float)vec3d.yCoord;
                float f2 = (float)vec3d.zCoord;
                if (p_renderClouds_2_ != 2) {
                    float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
                    float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
                    float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
                    f = f3;
                    f1 = f4;
                    f2 = f5;
                }
                float f9 = 4.8828125E-4f;
                double d2 = (float)this.cloudTickCounter + p_renderClouds_1_;
                double d0 = p_renderClouds_3_ + d2 * (double)0.03f;
                int k = MathHelper.floor(d0 / 2048.0);
                int l = MathHelper.floor(p_renderClouds_7_ / 2048.0);
                double lvt_22_1_ = p_renderClouds_7_ - (double)(l * 2048);
                float f6 = this.world.provider.getCloudHeight() - (float)p_renderClouds_5_ + 0.33f;
                float f7 = (float)((d0 -= (double)(k * 2048)) * 4.8828125E-4);
                float f8 = (float)(lvt_22_1_ * 4.8828125E-4);
                vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
                for (int i1 = -256; i1 < 256; i1 += 32) {
                    for (int j1 = -256; j1 < 256; j1 += 32) {
                        vertexbuffer.pos(i1 + 0, f6, j1 + 32).tex((float)(i1 + 0) * 4.8828125E-4f + f7, (float)(j1 + 32) * 4.8828125E-4f + f8).color(f, f1, f2, 0.8f).endVertex();
                        vertexbuffer.pos(i1 + 32, f6, j1 + 32).tex((float)(i1 + 32) * 4.8828125E-4f + f7, (float)(j1 + 32) * 4.8828125E-4f + f8).color(f, f1, f2, 0.8f).endVertex();
                        vertexbuffer.pos(i1 + 32, f6, j1 + 0).tex((float)(i1 + 32) * 4.8828125E-4f + f7, (float)(j1 + 0) * 4.8828125E-4f + f8).color(f, f1, f2, 0.8f).endVertex();
                        vertexbuffer.pos(i1 + 0, f6, j1 + 0).tex((float)(i1 + 0) * 4.8828125E-4f + f7, (float)(j1 + 0) * 4.8828125E-4f + f8).color(f, f1, f2, 0.8f).endVertex();
                    }
                }
                tessellator.draw();
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                GlStateManager.disableBlend();
                GlStateManager.enableCull();
            }
        }
    }

    public boolean hasCloudFog(double p_hasCloudFog_1_, double p_hasCloudFog_3_, double p_hasCloudFog_5_, float p_hasCloudFog_7_) {
        return false;
    }

    private void renderCloudsFancy(float p_renderCloudsFancy_1_, int p_renderCloudsFancy_2_, double p_renderCloudsFancy_3_, double p_renderCloudsFancy_5_, double p_renderCloudsFancy_7_) {
        GlStateManager.disableCull();
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        float f = 12.0f;
        float f1 = 4.0f;
        double d0 = (float)this.cloudTickCounter + p_renderCloudsFancy_1_;
        double d1 = (p_renderCloudsFancy_3_ + d0 * (double)0.03f) / 12.0;
        double d2 = p_renderCloudsFancy_7_ / 12.0 + (double)0.33f;
        float f2 = this.world.provider.getCloudHeight() - (float)p_renderCloudsFancy_5_ + 0.33f;
        int i = MathHelper.floor(d1 / 2048.0);
        int j = MathHelper.floor(d2 / 2048.0);
        d1 -= (double)(i * 2048);
        d2 -= (double)(j * 2048);
        this.renderEngine.bindTexture(CLOUDS_TEXTURES);
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        Vec3d vec3d = this.world.getCloudColour(p_renderCloudsFancy_1_);
        float f3 = (float)vec3d.xCoord;
        float f4 = (float)vec3d.yCoord;
        float f5 = (float)vec3d.zCoord;
        if (p_renderCloudsFancy_2_ != 2) {
            float f6 = (f3 * 30.0f + f4 * 59.0f + f5 * 11.0f) / 100.0f;
            float f7 = (f3 * 30.0f + f4 * 70.0f) / 100.0f;
            float f8 = (f3 * 30.0f + f5 * 70.0f) / 100.0f;
            f3 = f6;
            f4 = f7;
            f5 = f8;
        }
        float f25 = f3 * 0.9f;
        float f26 = f4 * 0.9f;
        float f27 = f5 * 0.9f;
        float f9 = f3 * 0.7f;
        float f10 = f4 * 0.7f;
        float f11 = f5 * 0.7f;
        float f12 = f3 * 0.8f;
        float f13 = f4 * 0.8f;
        float f14 = f5 * 0.8f;
        float f15 = 0.00390625f;
        float f16 = (float)MathHelper.floor(d1) * 0.00390625f;
        float f17 = (float)MathHelper.floor(d2) * 0.00390625f;
        float f18 = (float)(d1 - (double)MathHelper.floor(d1));
        float f19 = (float)(d2 - (double)MathHelper.floor(d2));
        int k = 8;
        int l = 4;
        float f20 = 9.765625E-4f;
        GlStateManager.scale(12.0f, 1.0f, 12.0f);
        for (int i1 = 0; i1 < 2; ++i1) {
            if (i1 == 0) {
                GlStateManager.colorMask(false, false, false, false);
            } else {
                switch (p_renderCloudsFancy_2_) {
                    case 0: {
                        GlStateManager.colorMask(false, true, true, true);
                        break;
                    }
                    case 1: {
                        GlStateManager.colorMask(true, false, false, true);
                        break;
                    }
                    case 2: {
                        GlStateManager.colorMask(true, true, true, true);
                    }
                }
            }
            for (int j1 = -3; j1 <= 4; ++j1) {
                for (int k1 = -3; k1 <= 4; ++k1) {
                    vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR_NORMAL);
                    float f21 = j1 * 8;
                    float f22 = k1 * 8;
                    float f23 = f21 - f18;
                    float f24 = f22 - f19;
                    if (f2 > -5.0f) {
                        vertexbuffer.pos(f23 + 0.0f, f2 + 0.0f, f24 + 8.0f).tex((f21 + 0.0f) * 0.00390625f + f16, (f22 + 8.0f) * 0.00390625f + f17).color(f9, f10, f11, 0.8f).normal(0.0f, -1.0f, 0.0f).endVertex();
                        vertexbuffer.pos(f23 + 8.0f, f2 + 0.0f, f24 + 8.0f).tex((f21 + 8.0f) * 0.00390625f + f16, (f22 + 8.0f) * 0.00390625f + f17).color(f9, f10, f11, 0.8f).normal(0.0f, -1.0f, 0.0f).endVertex();
                        vertexbuffer.pos(f23 + 8.0f, f2 + 0.0f, f24 + 0.0f).tex((f21 + 8.0f) * 0.00390625f + f16, (f22 + 0.0f) * 0.00390625f + f17).color(f9, f10, f11, 0.8f).normal(0.0f, -1.0f, 0.0f).endVertex();
                        vertexbuffer.pos(f23 + 0.0f, f2 + 0.0f, f24 + 0.0f).tex((f21 + 0.0f) * 0.00390625f + f16, (f22 + 0.0f) * 0.00390625f + f17).color(f9, f10, f11, 0.8f).normal(0.0f, -1.0f, 0.0f).endVertex();
                    }
                    if (f2 <= 5.0f) {
                        vertexbuffer.pos(f23 + 0.0f, f2 + 4.0f - 9.765625E-4f, f24 + 8.0f).tex((f21 + 0.0f) * 0.00390625f + f16, (f22 + 8.0f) * 0.00390625f + f17).color(f3, f4, f5, 0.8f).normal(0.0f, 1.0f, 0.0f).endVertex();
                        vertexbuffer.pos(f23 + 8.0f, f2 + 4.0f - 9.765625E-4f, f24 + 8.0f).tex((f21 + 8.0f) * 0.00390625f + f16, (f22 + 8.0f) * 0.00390625f + f17).color(f3, f4, f5, 0.8f).normal(0.0f, 1.0f, 0.0f).endVertex();
                        vertexbuffer.pos(f23 + 8.0f, f2 + 4.0f - 9.765625E-4f, f24 + 0.0f).tex((f21 + 8.0f) * 0.00390625f + f16, (f22 + 0.0f) * 0.00390625f + f17).color(f3, f4, f5, 0.8f).normal(0.0f, 1.0f, 0.0f).endVertex();
                        vertexbuffer.pos(f23 + 0.0f, f2 + 4.0f - 9.765625E-4f, f24 + 0.0f).tex((f21 + 0.0f) * 0.00390625f + f16, (f22 + 0.0f) * 0.00390625f + f17).color(f3, f4, f5, 0.8f).normal(0.0f, 1.0f, 0.0f).endVertex();
                    }
                    if (j1 > -1) {
                        for (int l1 = 0; l1 < 8; ++l1) {
                            vertexbuffer.pos(f23 + (float)l1 + 0.0f, f2 + 0.0f, f24 + 8.0f).tex((f21 + (float)l1 + 0.5f) * 0.00390625f + f16, (f22 + 8.0f) * 0.00390625f + f17).color(f25, f26, f27, 0.8f).normal(-1.0f, 0.0f, 0.0f).endVertex();
                            vertexbuffer.pos(f23 + (float)l1 + 0.0f, f2 + 4.0f, f24 + 8.0f).tex((f21 + (float)l1 + 0.5f) * 0.00390625f + f16, (f22 + 8.0f) * 0.00390625f + f17).color(f25, f26, f27, 0.8f).normal(-1.0f, 0.0f, 0.0f).endVertex();
                            vertexbuffer.pos(f23 + (float)l1 + 0.0f, f2 + 4.0f, f24 + 0.0f).tex((f21 + (float)l1 + 0.5f) * 0.00390625f + f16, (f22 + 0.0f) * 0.00390625f + f17).color(f25, f26, f27, 0.8f).normal(-1.0f, 0.0f, 0.0f).endVertex();
                            vertexbuffer.pos(f23 + (float)l1 + 0.0f, f2 + 0.0f, f24 + 0.0f).tex((f21 + (float)l1 + 0.5f) * 0.00390625f + f16, (f22 + 0.0f) * 0.00390625f + f17).color(f25, f26, f27, 0.8f).normal(-1.0f, 0.0f, 0.0f).endVertex();
                        }
                    }
                    if (j1 <= 1) {
                        for (int i2 = 0; i2 < 8; ++i2) {
                            vertexbuffer.pos(f23 + (float)i2 + 1.0f - 9.765625E-4f, f2 + 0.0f, f24 + 8.0f).tex((f21 + (float)i2 + 0.5f) * 0.00390625f + f16, (f22 + 8.0f) * 0.00390625f + f17).color(f25, f26, f27, 0.8f).normal(1.0f, 0.0f, 0.0f).endVertex();
                            vertexbuffer.pos(f23 + (float)i2 + 1.0f - 9.765625E-4f, f2 + 4.0f, f24 + 8.0f).tex((f21 + (float)i2 + 0.5f) * 0.00390625f + f16, (f22 + 8.0f) * 0.00390625f + f17).color(f25, f26, f27, 0.8f).normal(1.0f, 0.0f, 0.0f).endVertex();
                            vertexbuffer.pos(f23 + (float)i2 + 1.0f - 9.765625E-4f, f2 + 4.0f, f24 + 0.0f).tex((f21 + (float)i2 + 0.5f) * 0.00390625f + f16, (f22 + 0.0f) * 0.00390625f + f17).color(f25, f26, f27, 0.8f).normal(1.0f, 0.0f, 0.0f).endVertex();
                            vertexbuffer.pos(f23 + (float)i2 + 1.0f - 9.765625E-4f, f2 + 0.0f, f24 + 0.0f).tex((f21 + (float)i2 + 0.5f) * 0.00390625f + f16, (f22 + 0.0f) * 0.00390625f + f17).color(f25, f26, f27, 0.8f).normal(1.0f, 0.0f, 0.0f).endVertex();
                        }
                    }
                    if (k1 > -1) {
                        for (int j2 = 0; j2 < 8; ++j2) {
                            vertexbuffer.pos(f23 + 0.0f, f2 + 4.0f, f24 + (float)j2 + 0.0f).tex((f21 + 0.0f) * 0.00390625f + f16, (f22 + (float)j2 + 0.5f) * 0.00390625f + f17).color(f12, f13, f14, 0.8f).normal(0.0f, 0.0f, -1.0f).endVertex();
                            vertexbuffer.pos(f23 + 8.0f, f2 + 4.0f, f24 + (float)j2 + 0.0f).tex((f21 + 8.0f) * 0.00390625f + f16, (f22 + (float)j2 + 0.5f) * 0.00390625f + f17).color(f12, f13, f14, 0.8f).normal(0.0f, 0.0f, -1.0f).endVertex();
                            vertexbuffer.pos(f23 + 8.0f, f2 + 0.0f, f24 + (float)j2 + 0.0f).tex((f21 + 8.0f) * 0.00390625f + f16, (f22 + (float)j2 + 0.5f) * 0.00390625f + f17).color(f12, f13, f14, 0.8f).normal(0.0f, 0.0f, -1.0f).endVertex();
                            vertexbuffer.pos(f23 + 0.0f, f2 + 0.0f, f24 + (float)j2 + 0.0f).tex((f21 + 0.0f) * 0.00390625f + f16, (f22 + (float)j2 + 0.5f) * 0.00390625f + f17).color(f12, f13, f14, 0.8f).normal(0.0f, 0.0f, -1.0f).endVertex();
                        }
                    }
                    if (k1 <= 1) {
                        for (int k2 = 0; k2 < 8; ++k2) {
                            vertexbuffer.pos(f23 + 0.0f, f2 + 4.0f, f24 + (float)k2 + 1.0f - 9.765625E-4f).tex((f21 + 0.0f) * 0.00390625f + f16, (f22 + (float)k2 + 0.5f) * 0.00390625f + f17).color(f12, f13, f14, 0.8f).normal(0.0f, 0.0f, 1.0f).endVertex();
                            vertexbuffer.pos(f23 + 8.0f, f2 + 4.0f, f24 + (float)k2 + 1.0f - 9.765625E-4f).tex((f21 + 8.0f) * 0.00390625f + f16, (f22 + (float)k2 + 0.5f) * 0.00390625f + f17).color(f12, f13, f14, 0.8f).normal(0.0f, 0.0f, 1.0f).endVertex();
                            vertexbuffer.pos(f23 + 8.0f, f2 + 0.0f, f24 + (float)k2 + 1.0f - 9.765625E-4f).tex((f21 + 8.0f) * 0.00390625f + f16, (f22 + (float)k2 + 0.5f) * 0.00390625f + f17).color(f12, f13, f14, 0.8f).normal(0.0f, 0.0f, 1.0f).endVertex();
                            vertexbuffer.pos(f23 + 0.0f, f2 + 0.0f, f24 + (float)k2 + 1.0f - 9.765625E-4f).tex((f21 + 0.0f) * 0.00390625f + f16, (f22 + (float)k2 + 0.5f) * 0.00390625f + f17).color(f12, f13, f14, 0.8f).normal(0.0f, 0.0f, 1.0f).endVertex();
                        }
                    }
                    tessellator.draw();
                }
            }
        }
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableBlend();
        GlStateManager.enableCull();
    }

    public void updateChunks(long p_updateChunks_1_) {
        this.displayListEntitiesDirty |= this.renderDispatcher.runChunkUploads(p_updateChunks_1_);
        if (!this.chunksToUpdate.isEmpty()) {
            RenderChunk renderchunk;
            boolean flag;
            Iterator<RenderChunk> iterator = this.chunksToUpdate.iterator();
            while (iterator.hasNext() && (flag = (renderchunk = iterator.next()).isNeedsUpdateCustom() ? this.renderDispatcher.updateChunkNow(renderchunk) : this.renderDispatcher.updateChunkLater(renderchunk))) {
                renderchunk.clearNeedsUpdate();
                iterator.remove();
                long i = p_updateChunks_1_ - System.nanoTime();
                if (i >= 0L) continue;
                break;
            }
        }
    }

    public void renderWorldBorder(Entity p_renderWorldBorder_1_, float p_renderWorldBorder_2_) {
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        WorldBorder worldborder = this.world.getWorldBorder();
        double d0 = this.mc.gameSettings.renderDistanceChunks * 16;
        if (p_renderWorldBorder_1_.posX >= worldborder.maxX() - d0 || p_renderWorldBorder_1_.posX <= worldborder.minX() + d0 || p_renderWorldBorder_1_.posZ >= worldborder.maxZ() - d0 || p_renderWorldBorder_1_.posZ <= worldborder.minZ() + d0) {
            double d1 = 1.0 - worldborder.getClosestDistance(p_renderWorldBorder_1_) / d0;
            d1 = Math.pow(d1, 4.0);
            double d2 = p_renderWorldBorder_1_.lastTickPosX + (p_renderWorldBorder_1_.posX - p_renderWorldBorder_1_.lastTickPosX) * (double)p_renderWorldBorder_2_;
            double d3 = p_renderWorldBorder_1_.lastTickPosY + (p_renderWorldBorder_1_.posY - p_renderWorldBorder_1_.lastTickPosY) * (double)p_renderWorldBorder_2_;
            double d4 = p_renderWorldBorder_1_.lastTickPosZ + (p_renderWorldBorder_1_.posZ - p_renderWorldBorder_1_.lastTickPosZ) * (double)p_renderWorldBorder_2_;
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            this.renderEngine.bindTexture(FORCEFIELD_TEXTURES);
            GlStateManager.depthMask(false);
            GlStateManager.pushMatrix();
            int i = worldborder.getStatus().getID();
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            GlStateManager.color(f, f1, f2, (float)d1);
            GlStateManager.doPolygonOffset(-3.0f, -3.0f);
            GlStateManager.enablePolygonOffset();
            GlStateManager.alphaFunc(516, 0.1f);
            GlStateManager.enableAlpha();
            GlStateManager.disableCull();
            float f3 = (float)(Minecraft.getSystemTime() % 3000L) / 3000.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 128.0f;
            vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
            vertexbuffer.setTranslation(-d2, -d3, -d4);
            double d5 = Math.max((double)MathHelper.floor(d4 - d0), worldborder.minZ());
            double d6 = Math.min((double)MathHelper.ceil(d4 + d0), worldborder.maxZ());
            if (d2 > worldborder.maxX() - d0) {
                float f7 = 0.0f;
                double d7 = d5;
                while (d7 < d6) {
                    double d8 = Math.min(1.0, d6 - d7);
                    float f8 = (float)d8 * 0.5f;
                    vertexbuffer.pos(worldborder.maxX(), 256.0, d7).tex(f3 + f7, f3 + 0.0f).endVertex();
                    vertexbuffer.pos(worldborder.maxX(), 256.0, d7 + d8).tex(f3 + f8 + f7, f3 + 0.0f).endVertex();
                    vertexbuffer.pos(worldborder.maxX(), 0.0, d7 + d8).tex(f3 + f8 + f7, f3 + 128.0f).endVertex();
                    vertexbuffer.pos(worldborder.maxX(), 0.0, d7).tex(f3 + f7, f3 + 128.0f).endVertex();
                    d7 += 1.0;
                    f7 += 0.5f;
                }
            }
            if (d2 < worldborder.minX() + d0) {
                float f9 = 0.0f;
                double d9 = d5;
                while (d9 < d6) {
                    double d12 = Math.min(1.0, d6 - d9);
                    float f12 = (float)d12 * 0.5f;
                    vertexbuffer.pos(worldborder.minX(), 256.0, d9).tex(f3 + f9, f3 + 0.0f).endVertex();
                    vertexbuffer.pos(worldborder.minX(), 256.0, d9 + d12).tex(f3 + f12 + f9, f3 + 0.0f).endVertex();
                    vertexbuffer.pos(worldborder.minX(), 0.0, d9 + d12).tex(f3 + f12 + f9, f3 + 128.0f).endVertex();
                    vertexbuffer.pos(worldborder.minX(), 0.0, d9).tex(f3 + f9, f3 + 128.0f).endVertex();
                    d9 += 1.0;
                    f9 += 0.5f;
                }
            }
            d5 = Math.max((double)MathHelper.floor(d2 - d0), worldborder.minX());
            d6 = Math.min((double)MathHelper.ceil(d2 + d0), worldborder.maxX());
            if (d4 > worldborder.maxZ() - d0) {
                float f10 = 0.0f;
                double d10 = d5;
                while (d10 < d6) {
                    double d13 = Math.min(1.0, d6 - d10);
                    float f13 = (float)d13 * 0.5f;
                    vertexbuffer.pos(d10, 256.0, worldborder.maxZ()).tex(f3 + f10, f3 + 0.0f).endVertex();
                    vertexbuffer.pos(d10 + d13, 256.0, worldborder.maxZ()).tex(f3 + f13 + f10, f3 + 0.0f).endVertex();
                    vertexbuffer.pos(d10 + d13, 0.0, worldborder.maxZ()).tex(f3 + f13 + f10, f3 + 128.0f).endVertex();
                    vertexbuffer.pos(d10, 0.0, worldborder.maxZ()).tex(f3 + f10, f3 + 128.0f).endVertex();
                    d10 += 1.0;
                    f10 += 0.5f;
                }
            }
            if (d4 < worldborder.minZ() + d0) {
                float f11 = 0.0f;
                double d11 = d5;
                while (d11 < d6) {
                    double d14 = Math.min(1.0, d6 - d11);
                    float f14 = (float)d14 * 0.5f;
                    vertexbuffer.pos(d11, 256.0, worldborder.minZ()).tex(f3 + f11, f3 + 0.0f).endVertex();
                    vertexbuffer.pos(d11 + d14, 256.0, worldborder.minZ()).tex(f3 + f14 + f11, f3 + 0.0f).endVertex();
                    vertexbuffer.pos(d11 + d14, 0.0, worldborder.minZ()).tex(f3 + f14 + f11, f3 + 128.0f).endVertex();
                    vertexbuffer.pos(d11, 0.0, worldborder.minZ()).tex(f3 + f11, f3 + 128.0f).endVertex();
                    d11 += 1.0;
                    f11 += 0.5f;
                }
            }
            tessellator.draw();
            vertexbuffer.setTranslation(0.0, 0.0, 0.0);
            GlStateManager.enableCull();
            GlStateManager.disableAlpha();
            GlStateManager.doPolygonOffset(0.0f, 0.0f);
            GlStateManager.disablePolygonOffset();
            GlStateManager.enableAlpha();
            GlStateManager.disableBlend();
            GlStateManager.popMatrix();
            GlStateManager.depthMask(true);
        }
    }

    private void preRenderDamagedBlocks() {
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.DST_COLOR, GlStateManager.DestFactor.SRC_COLOR, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.enableBlend();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 0.5f);
        GlStateManager.doPolygonOffset(-3.0f, -3.0f);
        GlStateManager.enablePolygonOffset();
        GlStateManager.alphaFunc(516, 0.1f);
        GlStateManager.enableAlpha();
        GlStateManager.pushMatrix();
    }

    private void postRenderDamagedBlocks() {
        GlStateManager.disableAlpha();
        GlStateManager.doPolygonOffset(0.0f, 0.0f);
        GlStateManager.disablePolygonOffset();
        GlStateManager.enableAlpha();
        GlStateManager.depthMask(true);
        GlStateManager.popMatrix();
    }

    public void drawBlockDamageTexture(Tessellator p_drawBlockDamageTexture_1_, VertexBuffer p_drawBlockDamageTexture_2_, Entity p_drawBlockDamageTexture_3_, float p_drawBlockDamageTexture_4_) {
        double d0 = p_drawBlockDamageTexture_3_.lastTickPosX + (p_drawBlockDamageTexture_3_.posX - p_drawBlockDamageTexture_3_.lastTickPosX) * (double)p_drawBlockDamageTexture_4_;
        double d1 = p_drawBlockDamageTexture_3_.lastTickPosY + (p_drawBlockDamageTexture_3_.posY - p_drawBlockDamageTexture_3_.lastTickPosY) * (double)p_drawBlockDamageTexture_4_;
        double d2 = p_drawBlockDamageTexture_3_.lastTickPosZ + (p_drawBlockDamageTexture_3_.posZ - p_drawBlockDamageTexture_3_.lastTickPosZ) * (double)p_drawBlockDamageTexture_4_;
        if (!this.damagedBlocks.isEmpty()) {
            this.renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
            this.preRenderDamagedBlocks();
            p_drawBlockDamageTexture_2_.begin(7, DefaultVertexFormats.BLOCK);
            p_drawBlockDamageTexture_2_.setTranslation(-d0, -d1, -d2);
            p_drawBlockDamageTexture_2_.noColor();
            Iterator<DestroyBlockProgress> iterator = this.damagedBlocks.values().iterator();
            while (iterator.hasNext()) {
                boolean hasBreak;
                DestroyBlockProgress destroyblockprogress = iterator.next();
                BlockPos blockpos = destroyblockprogress.getPosition();
                double d3 = (double)blockpos.getX() - d0;
                double d4 = (double)blockpos.getY() - d1;
                double d5 = (double)blockpos.getZ() - d2;
                Block block = this.world.getBlockState(blockpos).getBlock();
                TileEntity te = this.world.getTileEntity(blockpos);
                boolean bl = hasBreak = block instanceof BlockChest || block instanceof BlockEnderChest || block instanceof BlockSign || block instanceof BlockSkull;
                if (!hasBreak) {
                    boolean bl2 = hasBreak = te != null && te.canRenderBreaking();
                }
                if (hasBreak) continue;
                if (d3 * d3 + d4 * d4 + d5 * d5 > 1024.0) {
                    iterator.remove();
                    continue;
                }
                IBlockState iblockstate = this.world.getBlockState(blockpos);
                if (iblockstate.getMaterial() == Material.AIR) continue;
                int i = destroyblockprogress.getPartialBlockDamage();
                TextureAtlasSprite textureatlassprite = this.destroyBlockIcons[i];
                BlockRendererDispatcher blockrendererdispatcher = this.mc.getBlockRendererDispatcher();
                blockrendererdispatcher.renderBlockDamage(iblockstate, blockpos, textureatlassprite, this.world);
            }
            p_drawBlockDamageTexture_1_.draw();
            p_drawBlockDamageTexture_2_.setTranslation(0.0, 0.0, 0.0);
            this.postRenderDamagedBlocks();
        }
    }

    public void drawSelectionBox(EntityPlayer p_drawSelectionBox_1_, RayTraceResult p_drawSelectionBox_2_, int p_drawSelectionBox_3_, float p_drawSelectionBox_4_) {
        if (p_drawSelectionBox_3_ == 0 && p_drawSelectionBox_2_.typeOfHit == RayTraceResult.Type.BLOCK) {
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            GlStateManager.glLineWidth(2.0f);
            GlStateManager.disableTexture2D();
            GlStateManager.depthMask(false);
            BlockPos blockpos = p_drawSelectionBox_2_.getBlockPos();
            IBlockState iblockstate = this.world.getBlockState(blockpos);
            if (iblockstate.getMaterial() != Material.AIR && this.world.getWorldBorder().contains(blockpos)) {
                double d0 = p_drawSelectionBox_1_.lastTickPosX + (p_drawSelectionBox_1_.posX - p_drawSelectionBox_1_.lastTickPosX) * (double)p_drawSelectionBox_4_;
                double d1 = p_drawSelectionBox_1_.lastTickPosY + (p_drawSelectionBox_1_.posY - p_drawSelectionBox_1_.lastTickPosY) * (double)p_drawSelectionBox_4_;
                double d2 = p_drawSelectionBox_1_.lastTickPosZ + (p_drawSelectionBox_1_.posZ - p_drawSelectionBox_1_.lastTickPosZ) * (double)p_drawSelectionBox_4_;
                RenderGlobal.drawSelectionBoundingBox(iblockstate.getSelectedBoundingBox(this.world, blockpos).expandXyz(0.002f).offset(-d0, -d1, -d2), 0.0f, 0.0f, 0.0f, 0.4f);
            }
            GlStateManager.depthMask(true);
            GlStateManager.enableTexture2D();
            GlStateManager.disableBlend();
        }
    }

    public static void drawSelectionBoundingBox(AxisAlignedBB p_drawSelectionBoundingBox_0_, float p_drawSelectionBoundingBox_1_, float p_drawSelectionBoundingBox_2_, float p_drawSelectionBoundingBox_3_, float p_drawSelectionBoundingBox_4_) {
        RenderGlobal.drawBoundingBox(p_drawSelectionBoundingBox_0_.minX, p_drawSelectionBoundingBox_0_.minY, p_drawSelectionBoundingBox_0_.minZ, p_drawSelectionBoundingBox_0_.maxX, p_drawSelectionBoundingBox_0_.maxY, p_drawSelectionBoundingBox_0_.maxZ, p_drawSelectionBoundingBox_1_, p_drawSelectionBoundingBox_2_, p_drawSelectionBoundingBox_3_, p_drawSelectionBoundingBox_4_);
    }

    public static void drawBoundingBox(double p_drawBoundingBox_0_, double p_drawBoundingBox_2_, double p_drawBoundingBox_4_, double p_drawBoundingBox_6_, double p_drawBoundingBox_8_, double p_drawBoundingBox_10_, float p_drawBoundingBox_12_, float p_drawBoundingBox_13_, float p_drawBoundingBox_14_, float p_drawBoundingBox_15_) {
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        vertexbuffer.begin(3, DefaultVertexFormats.POSITION_COLOR);
        RenderGlobal.drawBoundingBox(vertexbuffer, p_drawBoundingBox_0_, p_drawBoundingBox_2_, p_drawBoundingBox_4_, p_drawBoundingBox_6_, p_drawBoundingBox_8_, p_drawBoundingBox_10_, p_drawBoundingBox_12_, p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_);
        tessellator.draw();
    }

    public static void drawBoundingBox(VertexBuffer p_drawBoundingBox_0_, double p_drawBoundingBox_1_, double p_drawBoundingBox_3_, double p_drawBoundingBox_5_, double p_drawBoundingBox_7_, double p_drawBoundingBox_9_, double p_drawBoundingBox_11_, float p_drawBoundingBox_13_, float p_drawBoundingBox_14_, float p_drawBoundingBox_15_, float p_drawBoundingBox_16_) {
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_1_, p_drawBoundingBox_3_, p_drawBoundingBox_5_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, 0.0f).endVertex();
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_1_, p_drawBoundingBox_3_, p_drawBoundingBox_5_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, p_drawBoundingBox_16_).endVertex();
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_7_, p_drawBoundingBox_3_, p_drawBoundingBox_5_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, p_drawBoundingBox_16_).endVertex();
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_7_, p_drawBoundingBox_3_, p_drawBoundingBox_11_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, p_drawBoundingBox_16_).endVertex();
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_1_, p_drawBoundingBox_3_, p_drawBoundingBox_11_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, p_drawBoundingBox_16_).endVertex();
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_1_, p_drawBoundingBox_3_, p_drawBoundingBox_5_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, p_drawBoundingBox_16_).endVertex();
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_1_, p_drawBoundingBox_9_, p_drawBoundingBox_5_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, p_drawBoundingBox_16_).endVertex();
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_7_, p_drawBoundingBox_9_, p_drawBoundingBox_5_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, p_drawBoundingBox_16_).endVertex();
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_7_, p_drawBoundingBox_9_, p_drawBoundingBox_11_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, p_drawBoundingBox_16_).endVertex();
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_1_, p_drawBoundingBox_9_, p_drawBoundingBox_11_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, p_drawBoundingBox_16_).endVertex();
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_1_, p_drawBoundingBox_9_, p_drawBoundingBox_5_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, p_drawBoundingBox_16_).endVertex();
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_1_, p_drawBoundingBox_9_, p_drawBoundingBox_11_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, 0.0f).endVertex();
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_1_, p_drawBoundingBox_3_, p_drawBoundingBox_11_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, p_drawBoundingBox_16_).endVertex();
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_7_, p_drawBoundingBox_9_, p_drawBoundingBox_11_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, 0.0f).endVertex();
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_7_, p_drawBoundingBox_3_, p_drawBoundingBox_11_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, p_drawBoundingBox_16_).endVertex();
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_7_, p_drawBoundingBox_9_, p_drawBoundingBox_5_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, 0.0f).endVertex();
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_7_, p_drawBoundingBox_3_, p_drawBoundingBox_5_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, p_drawBoundingBox_16_).endVertex();
        p_drawBoundingBox_0_.pos(p_drawBoundingBox_7_, p_drawBoundingBox_3_, p_drawBoundingBox_5_).color(p_drawBoundingBox_13_, p_drawBoundingBox_14_, p_drawBoundingBox_15_, 0.0f).endVertex();
    }

    public static void renderFilledBox(AxisAlignedBB p_renderFilledBox_0_, float p_renderFilledBox_1_, float p_renderFilledBox_2_, float p_renderFilledBox_3_, float p_renderFilledBox_4_) {
        RenderGlobal.renderFilledBox(p_renderFilledBox_0_.minX, p_renderFilledBox_0_.minY, p_renderFilledBox_0_.minZ, p_renderFilledBox_0_.maxX, p_renderFilledBox_0_.maxY, p_renderFilledBox_0_.maxZ, p_renderFilledBox_1_, p_renderFilledBox_2_, p_renderFilledBox_3_, p_renderFilledBox_4_);
    }

    public static void renderFilledBox(double p_renderFilledBox_0_, double p_renderFilledBox_2_, double p_renderFilledBox_4_, double p_renderFilledBox_6_, double p_renderFilledBox_8_, double p_renderFilledBox_10_, float p_renderFilledBox_12_, float p_renderFilledBox_13_, float p_renderFilledBox_14_, float p_renderFilledBox_15_) {
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        vertexbuffer.begin(5, DefaultVertexFormats.POSITION_COLOR);
        RenderGlobal.addChainedFilledBoxVertices(vertexbuffer, p_renderFilledBox_0_, p_renderFilledBox_2_, p_renderFilledBox_4_, p_renderFilledBox_6_, p_renderFilledBox_8_, p_renderFilledBox_10_, p_renderFilledBox_12_, p_renderFilledBox_13_, p_renderFilledBox_14_, p_renderFilledBox_15_);
        tessellator.draw();
    }

    public static void addChainedFilledBoxVertices(VertexBuffer p_addChainedFilledBoxVertices_0_, double p_addChainedFilledBoxVertices_1_, double p_addChainedFilledBoxVertices_3_, double p_addChainedFilledBoxVertices_5_, double p_addChainedFilledBoxVertices_7_, double p_addChainedFilledBoxVertices_9_, double p_addChainedFilledBoxVertices_11_, float p_addChainedFilledBoxVertices_13_, float p_addChainedFilledBoxVertices_14_, float p_addChainedFilledBoxVertices_15_, float p_addChainedFilledBoxVertices_16_) {
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_1_, p_addChainedFilledBoxVertices_3_, p_addChainedFilledBoxVertices_5_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_1_, p_addChainedFilledBoxVertices_3_, p_addChainedFilledBoxVertices_5_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_1_, p_addChainedFilledBoxVertices_3_, p_addChainedFilledBoxVertices_5_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_1_, p_addChainedFilledBoxVertices_3_, p_addChainedFilledBoxVertices_11_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_1_, p_addChainedFilledBoxVertices_9_, p_addChainedFilledBoxVertices_5_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_1_, p_addChainedFilledBoxVertices_9_, p_addChainedFilledBoxVertices_11_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_1_, p_addChainedFilledBoxVertices_9_, p_addChainedFilledBoxVertices_11_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_1_, p_addChainedFilledBoxVertices_3_, p_addChainedFilledBoxVertices_11_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_7_, p_addChainedFilledBoxVertices_9_, p_addChainedFilledBoxVertices_11_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_7_, p_addChainedFilledBoxVertices_3_, p_addChainedFilledBoxVertices_11_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_7_, p_addChainedFilledBoxVertices_3_, p_addChainedFilledBoxVertices_11_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_7_, p_addChainedFilledBoxVertices_3_, p_addChainedFilledBoxVertices_5_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_7_, p_addChainedFilledBoxVertices_9_, p_addChainedFilledBoxVertices_11_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_7_, p_addChainedFilledBoxVertices_9_, p_addChainedFilledBoxVertices_5_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_7_, p_addChainedFilledBoxVertices_9_, p_addChainedFilledBoxVertices_5_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_7_, p_addChainedFilledBoxVertices_3_, p_addChainedFilledBoxVertices_5_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_1_, p_addChainedFilledBoxVertices_9_, p_addChainedFilledBoxVertices_5_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_1_, p_addChainedFilledBoxVertices_3_, p_addChainedFilledBoxVertices_5_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_1_, p_addChainedFilledBoxVertices_3_, p_addChainedFilledBoxVertices_5_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_7_, p_addChainedFilledBoxVertices_3_, p_addChainedFilledBoxVertices_5_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_1_, p_addChainedFilledBoxVertices_3_, p_addChainedFilledBoxVertices_11_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_7_, p_addChainedFilledBoxVertices_3_, p_addChainedFilledBoxVertices_11_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_7_, p_addChainedFilledBoxVertices_3_, p_addChainedFilledBoxVertices_11_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_1_, p_addChainedFilledBoxVertices_9_, p_addChainedFilledBoxVertices_5_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_1_, p_addChainedFilledBoxVertices_9_, p_addChainedFilledBoxVertices_5_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_1_, p_addChainedFilledBoxVertices_9_, p_addChainedFilledBoxVertices_11_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_7_, p_addChainedFilledBoxVertices_9_, p_addChainedFilledBoxVertices_5_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_7_, p_addChainedFilledBoxVertices_9_, p_addChainedFilledBoxVertices_11_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_7_, p_addChainedFilledBoxVertices_9_, p_addChainedFilledBoxVertices_11_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
        p_addChainedFilledBoxVertices_0_.pos(p_addChainedFilledBoxVertices_7_, p_addChainedFilledBoxVertices_9_, p_addChainedFilledBoxVertices_11_).color(p_addChainedFilledBoxVertices_13_, p_addChainedFilledBoxVertices_14_, p_addChainedFilledBoxVertices_15_, p_addChainedFilledBoxVertices_16_).endVertex();
    }

    private void markBlocksForUpdate(int p_markBlocksForUpdate_1_, int p_markBlocksForUpdate_2_, int p_markBlocksForUpdate_3_, int p_markBlocksForUpdate_4_, int p_markBlocksForUpdate_5_, int p_markBlocksForUpdate_6_, boolean p_markBlocksForUpdate_7_) {
        this.viewFrustum.markBlocksForUpdate(p_markBlocksForUpdate_1_, p_markBlocksForUpdate_2_, p_markBlocksForUpdate_3_, p_markBlocksForUpdate_4_, p_markBlocksForUpdate_5_, p_markBlocksForUpdate_6_, p_markBlocksForUpdate_7_);
    }

    @Override
    public void notifyBlockUpdate(World p_notifyBlockUpdate_1_, BlockPos p_notifyBlockUpdate_2_, IBlockState p_notifyBlockUpdate_3_, IBlockState p_notifyBlockUpdate_4_, int p_notifyBlockUpdate_5_) {
        int i = p_notifyBlockUpdate_2_.getX();
        int j = p_notifyBlockUpdate_2_.getY();
        int k = p_notifyBlockUpdate_2_.getZ();
        this.markBlocksForUpdate(i - 1, j - 1, k - 1, i + 1, j + 1, k + 1, (p_notifyBlockUpdate_5_ & 8) != 0);
    }

    @Override
    public void notifyLightSet(BlockPos p_notifyLightSet_1_) {
        this.setLightUpdates.add(p_notifyLightSet_1_.toImmutable());
    }

    @Override
    public void markBlockRangeForRenderUpdate(int p_markBlockRangeForRenderUpdate_1_, int p_markBlockRangeForRenderUpdate_2_, int p_markBlockRangeForRenderUpdate_3_, int p_markBlockRangeForRenderUpdate_4_, int p_markBlockRangeForRenderUpdate_5_, int p_markBlockRangeForRenderUpdate_6_) {
        this.markBlocksForUpdate(p_markBlockRangeForRenderUpdate_1_ - 1, p_markBlockRangeForRenderUpdate_2_ - 1, p_markBlockRangeForRenderUpdate_3_ - 1, p_markBlockRangeForRenderUpdate_4_ + 1, p_markBlockRangeForRenderUpdate_5_ + 1, p_markBlockRangeForRenderUpdate_6_ + 1, false);
    }

    @Override
    public void playRecord(SoundEvent p_playRecord_1_, BlockPos p_playRecord_2_) {
        ISound isound = this.mapSoundPositions.get(p_playRecord_2_);
        if (isound != null) {
            this.mc.getSoundHandler().stopSound(isound);
            this.mapSoundPositions.remove(p_playRecord_2_);
        }
        if (p_playRecord_1_ != null) {
            ItemRecord itemrecord = ItemRecord.getBySound(p_playRecord_1_);
            if (itemrecord != null) {
                this.mc.ingameGUI.setRecordPlayingMessage(itemrecord.getRecordNameLocal());
            }
            PositionedSoundRecord positionedsoundrecord = PositionedSoundRecord.getRecordSoundRecord(p_playRecord_1_, p_playRecord_2_.getX(), p_playRecord_2_.getY(), p_playRecord_2_.getZ());
            this.mapSoundPositions.put(p_playRecord_2_, positionedsoundrecord);
            this.mc.getSoundHandler().playSound(positionedsoundrecord);
        }
    }

    @Override
    public void playSoundToAllNearExcept(EntityPlayer p_playSoundToAllNearExcept_1_, SoundEvent p_playSoundToAllNearExcept_2_, SoundCategory p_playSoundToAllNearExcept_3_, double p_playSoundToAllNearExcept_4_, double p_playSoundToAllNearExcept_6_, double p_playSoundToAllNearExcept_8_, float p_playSoundToAllNearExcept_10_, float p_playSoundToAllNearExcept_11_) {
    }

    @Override
    public void spawnParticle(int p_spawnParticle_1_, boolean p_spawnParticle_2_, double p_spawnParticle_3_, double p_spawnParticle_5_, double p_spawnParticle_7_, double p_spawnParticle_9_, double p_spawnParticle_11_, double p_spawnParticle_13_, int ... p_spawnParticle_15_) {
        this.spawnParticle(p_spawnParticle_1_, p_spawnParticle_2_, false, p_spawnParticle_3_, p_spawnParticle_5_, p_spawnParticle_7_, p_spawnParticle_9_, p_spawnParticle_11_, p_spawnParticle_13_, p_spawnParticle_15_);
    }

    @Override
    public void spawnParticle(int p_spawnParticle_1_, boolean p_spawnParticle_2_, boolean p_spawnParticle_3_, final double p_spawnParticle_4_, final double p_spawnParticle_6_, final double p_spawnParticle_8_, double p_spawnParticle_10_, double p_spawnParticle_12_, double p_spawnParticle_14_, int ... p_spawnParticle_16_) {
        try {
            this.spawnParticle0(p_spawnParticle_1_, p_spawnParticle_2_, p_spawnParticle_3_, p_spawnParticle_4_, p_spawnParticle_6_, p_spawnParticle_8_, p_spawnParticle_10_, p_spawnParticle_12_, p_spawnParticle_14_, p_spawnParticle_16_);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Exception while adding particle");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Particle being added");
            crashreportcategory.addCrashSection("ID", p_spawnParticle_1_);
            if (p_spawnParticle_16_ != null) {
                crashreportcategory.addCrashSection("Parameters", p_spawnParticle_16_);
            }
            crashreportcategory.setDetail("Position", new ICrashReportDetail<String>(){

                @Override
                public String call() throws Exception {
                    return CrashReportCategory.getCoordinateInfo(p_spawnParticle_4_, p_spawnParticle_6_, p_spawnParticle_8_);
                }
            });
            throw new ReportedException(crashreport);
        }
    }

    private void spawnParticle(EnumParticleTypes p_spawnParticle_1_, double p_spawnParticle_2_, double p_spawnParticle_4_, double p_spawnParticle_6_, double p_spawnParticle_8_, double p_spawnParticle_10_, double p_spawnParticle_12_, int ... p_spawnParticle_14_) {
        this.spawnParticle(p_spawnParticle_1_.getParticleID(), p_spawnParticle_1_.getShouldIgnoreRange(), p_spawnParticle_2_, p_spawnParticle_4_, p_spawnParticle_6_, p_spawnParticle_8_, p_spawnParticle_10_, p_spawnParticle_12_, p_spawnParticle_14_);
    }

    @Nullable
    private Particle spawnEntityFX(int p_spawnEntityFX_1_, boolean p_spawnEntityFX_2_, double p_spawnEntityFX_3_, double p_spawnEntityFX_5_, double p_spawnEntityFX_7_, double p_spawnEntityFX_9_, double p_spawnEntityFX_11_, double p_spawnEntityFX_13_, int ... p_spawnEntityFX_15_) {
        return this.spawnParticle0(p_spawnEntityFX_1_, p_spawnEntityFX_2_, false, p_spawnEntityFX_3_, p_spawnEntityFX_5_, p_spawnEntityFX_7_, p_spawnEntityFX_9_, p_spawnEntityFX_11_, p_spawnEntityFX_13_, p_spawnEntityFX_15_);
    }

    @Nullable
    private Particle spawnParticle0(int p_spawnParticle0_1_, boolean p_spawnParticle0_2_, boolean p_spawnParticle0_3_, double p_spawnParticle0_4_, double p_spawnParticle0_6_, double p_spawnParticle0_8_, double p_spawnParticle0_10_, double p_spawnParticle0_12_, double p_spawnParticle0_14_, int ... p_spawnParticle0_16_) {
        Entity entity = this.mc.getRenderViewEntity();
        if (this.mc != null && entity != null && this.mc.effectRenderer != null) {
            int i = this.calculateParticleLevel(p_spawnParticle0_3_);
            double d0 = entity.posX - p_spawnParticle0_4_;
            double d1 = entity.posY - p_spawnParticle0_6_;
            double d2 = entity.posZ - p_spawnParticle0_8_;
            return p_spawnParticle0_2_ ? this.mc.effectRenderer.spawnEffectParticle(p_spawnParticle0_1_, p_spawnParticle0_4_, p_spawnParticle0_6_, p_spawnParticle0_8_, p_spawnParticle0_10_, p_spawnParticle0_12_, p_spawnParticle0_14_, p_spawnParticle0_16_) : (d0 * d0 + d1 * d1 + d2 * d2 > 1024.0 ? null : (i > 1 ? null : this.mc.effectRenderer.spawnEffectParticle(p_spawnParticle0_1_, p_spawnParticle0_4_, p_spawnParticle0_6_, p_spawnParticle0_8_, p_spawnParticle0_10_, p_spawnParticle0_12_, p_spawnParticle0_14_, p_spawnParticle0_16_)));
        }
        return null;
    }

    private int calculateParticleLevel(boolean p_calculateParticleLevel_1_) {
        int i = this.mc.gameSettings.particleSetting;
        if (p_calculateParticleLevel_1_ && i == 2 && this.world.rand.nextInt(10) == 0) {
            i = 1;
        }
        if (i == 1 && this.world.rand.nextInt(3) == 0) {
            i = 2;
        }
        return i;
    }

    @Override
    public void onEntityAdded(Entity p_onEntityAdded_1_) {
    }

    @Override
    public void onEntityRemoved(Entity p_onEntityRemoved_1_) {
    }

    public void deleteAllDisplayLists() {
    }

    @Override
    public void broadcastSound(int p_broadcastSound_1_, BlockPos p_broadcastSound_2_, int p_broadcastSound_3_) {
        switch (p_broadcastSound_1_) {
            case 1023: 
            case 1028: {
                Entity entity = this.mc.getRenderViewEntity();
                if (entity == null) break;
                double d0 = (double)p_broadcastSound_2_.getX() - entity.posX;
                double d1 = (double)p_broadcastSound_2_.getY() - entity.posY;
                double d2 = (double)p_broadcastSound_2_.getZ() - entity.posZ;
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                double d4 = entity.posX;
                double d5 = entity.posY;
                double d6 = entity.posZ;
                if (d3 > 0.0) {
                    d4 += d0 / d3 * 2.0;
                    d5 += d1 / d3 * 2.0;
                    d6 += d2 / d3 * 2.0;
                }
                if (p_broadcastSound_1_ == 1023) {
                    this.world.playSound(d4, d5, d6, SoundEvents.ENTITY_WITHER_SPAWN, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
                    break;
                }
                this.world.playSound(d4, d5, d6, SoundEvents.ENTITY_ENDERDRAGON_DEATH, SoundCategory.HOSTILE, 5.0f, 1.0f, false);
            }
        }
    }

    @Override
    public void playEvent(EntityPlayer p_playEvent_1_, int p_playEvent_2_, BlockPos p_playEvent_3_, int p_playEvent_4_) {
        Random random = this.world.rand;
        switch (p_playEvent_2_) {
            case 1000: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_DISPENSER_DISPENSE, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1001: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_DISPENSER_FAIL, SoundCategory.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 1002: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_DISPENSER_LAUNCH, SoundCategory.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 1003: {
                this.world.playSound(p_playEvent_3_, SoundEvents.ENTITY_ENDEREYE_LAUNCH, SoundCategory.NEUTRAL, 1.0f, 1.2f, false);
                break;
            }
            case 1004: {
                this.world.playSound(p_playEvent_3_, SoundEvents.ENTITY_FIREWORK_SHOOT, SoundCategory.NEUTRAL, 1.0f, 1.2f, false);
                break;
            }
            case 1005: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_IRON_DOOR_OPEN, SoundCategory.BLOCKS, 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1006: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_WOODEN_DOOR_OPEN, SoundCategory.BLOCKS, 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1007: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_WOODEN_TRAPDOOR_OPEN, SoundCategory.BLOCKS, 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1008: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_FENCE_GATE_OPEN, SoundCategory.BLOCKS, 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1009: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f, false);
                break;
            }
            case 1010: {
                if (Item.getItemById(p_playEvent_4_) instanceof ItemRecord) {
                    this.world.playRecord(p_playEvent_3_, ((ItemRecord)Item.getItemById(p_playEvent_4_)).getSound());
                    break;
                }
                this.world.playRecord(p_playEvent_3_, null);
                break;
            }
            case 1011: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_IRON_DOOR_CLOSE, SoundCategory.BLOCKS, 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1012: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_WOODEN_DOOR_CLOSE, SoundCategory.BLOCKS, 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1013: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_WOODEN_TRAPDOOR_CLOSE, SoundCategory.BLOCKS, 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1014: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_FENCE_GATE_CLOSE, SoundCategory.BLOCKS, 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1015: {
                this.world.playSound(p_playEvent_3_, SoundEvents.ENTITY_GHAST_WARN, SoundCategory.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1016: {
                this.world.playSound(p_playEvent_3_, SoundEvents.ENTITY_GHAST_SHOOT, SoundCategory.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1017: {
                this.world.playSound(p_playEvent_3_, SoundEvents.ENTITY_ENDERDRAGON_SHOOT, SoundCategory.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1018: {
                this.world.playSound(p_playEvent_3_, SoundEvents.ENTITY_BLAZE_SHOOT, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1019: {
                this.world.playSound(p_playEvent_3_, SoundEvents.ENTITY_ZOMBIE_ATTACK_DOOR_WOOD, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1020: {
                this.world.playSound(p_playEvent_3_, SoundEvents.ENTITY_ZOMBIE_ATTACK_IRON_DOOR, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1021: {
                this.world.playSound(p_playEvent_3_, SoundEvents.ENTITY_ZOMBIE_BREAK_DOOR_WOOD, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1022: {
                this.world.playSound(p_playEvent_3_, SoundEvents.ENTITY_WITHER_BREAK_BLOCK, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1024: {
                this.world.playSound(p_playEvent_3_, SoundEvents.ENTITY_WITHER_SHOOT, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1025: {
                this.world.playSound(p_playEvent_3_, SoundEvents.ENTITY_BAT_TAKEOFF, SoundCategory.NEUTRAL, 0.05f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1026: {
                this.world.playSound(p_playEvent_3_, SoundEvents.ENTITY_ZOMBIE_INFECT, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1027: {
                this.world.playSound(p_playEvent_3_, SoundEvents.ENTITY_ZOMBIE_VILLAGER_CONVERTED, SoundCategory.NEUTRAL, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1029: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_ANVIL_DESTROY, SoundCategory.BLOCKS, 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1030: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_ANVIL_USE, SoundCategory.BLOCKS, 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1031: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_ANVIL_LAND, SoundCategory.BLOCKS, 0.3f, this.world.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1032: {
                this.mc.getSoundHandler().playSound(PositionedSoundRecord.getMasterRecord(SoundEvents.BLOCK_PORTAL_TRAVEL, random.nextFloat() * 0.4f + 0.8f));
                break;
            }
            case 1033: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_CHORUS_FLOWER_GROW, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1034: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_CHORUS_FLOWER_DEATH, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1035: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_BREWING_STAND_BREW, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1036: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_IRON_TRAPDOOR_CLOSE, SoundCategory.BLOCKS, 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1037: {
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_IRON_TRAPDOOR_OPEN, SoundCategory.BLOCKS, 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2000: {
                int l = p_playEvent_4_ % 3 - 1;
                int i = p_playEvent_4_ / 3 % 3 - 1;
                double d8 = (double)p_playEvent_3_.getX() + (double)l * 0.6 + 0.5;
                double d10 = (double)p_playEvent_3_.getY() + 0.5;
                double d12 = (double)p_playEvent_3_.getZ() + (double)i * 0.6 + 0.5;
                for (int j1 = 0; j1 < 10; ++j1) {
                    double d13 = random.nextDouble() * 0.2 + 0.01;
                    double d16 = d8 + (double)l * 0.01 + (random.nextDouble() - 0.5) * (double)i * 0.5;
                    double d19 = d10 + (random.nextDouble() - 0.5) * 0.5;
                    double d22 = d12 + (double)i * 0.01 + (random.nextDouble() - 0.5) * (double)l * 0.5;
                    double d24 = (double)l * d13 + random.nextGaussian() * 0.01;
                    double d26 = -0.03 + random.nextGaussian() * 0.01;
                    double d27 = (double)i * d13 + random.nextGaussian() * 0.01;
                    this.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, d16, d19, d22, d24, d26, d27, new int[0]);
                }
                return;
            }
            case 2001: {
                Block block = Block.getBlockById(p_playEvent_4_ & 0xFFF);
                if (block.getDefaultState().getMaterial() != Material.AIR) {
                    SoundType soundtype = block.getSoundType(Block.getStateById(p_playEvent_4_), this.world, p_playEvent_3_, null);
                    this.world.playSound(p_playEvent_3_, soundtype.getBreakSound(), SoundCategory.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f, false);
                }
                this.mc.effectRenderer.addBlockDestroyEffects(p_playEvent_3_, block.getStateFromMeta(p_playEvent_4_ >> 12 & 0xFF));
                break;
            }
            case 2002: 
            case 2007: {
                double d6 = p_playEvent_3_.getX();
                double d7 = p_playEvent_3_.getY();
                double d9 = p_playEvent_3_.getZ();
                for (int i1 = 0; i1 < 8; ++i1) {
                    this.spawnParticle(EnumParticleTypes.ITEM_CRACK, d6, d7, d9, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15, Item.getIdFromItem(Items.SPLASH_POTION));
                }
                float f5 = (float)(p_playEvent_4_ >> 16 & 0xFF) / 255.0f;
                float f = (float)(p_playEvent_4_ >> 8 & 0xFF) / 255.0f;
                float f1 = (float)(p_playEvent_4_ >> 0 & 0xFF) / 255.0f;
                EnumParticleTypes enumparticletypes = p_playEvent_2_ == 2007 ? EnumParticleTypes.SPELL_INSTANT : EnumParticleTypes.SPELL;
                for (int l1 = 0; l1 < 100; ++l1) {
                    double d15 = random.nextDouble() * 4.0;
                    double d18 = random.nextDouble() * Math.PI * 2.0;
                    double d21 = Math.cos(d18) * d15;
                    double d23 = 0.01 + random.nextDouble() * 0.5;
                    double d25 = Math.sin(d18) * d15;
                    Particle particle1 = this.spawnEntityFX(enumparticletypes.getParticleID(), enumparticletypes.getShouldIgnoreRange(), d6 + d21 * 0.1, d7 + 0.3, d9 + d25 * 0.1, d21, d23, d25, new int[0]);
                    if (particle1 == null) continue;
                    float f4 = 0.75f + random.nextFloat() * 0.25f;
                    particle1.setRBGColorF(f5 * f4, f * f4, f1 * f4);
                    particle1.multiplyVelocity((float)d15);
                }
                this.world.playSound(p_playEvent_3_, SoundEvents.ENTITY_SPLASH_POTION_BREAK, SoundCategory.NEUTRAL, 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2003: {
                double d0 = (double)p_playEvent_3_.getX() + 0.5;
                double d1 = p_playEvent_3_.getY();
                double d2 = (double)p_playEvent_3_.getZ() + 0.5;
                for (int j = 0; j < 8; ++j) {
                    this.spawnParticle(EnumParticleTypes.ITEM_CRACK, d0, d1, d2, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15, Item.getIdFromItem(Items.ENDER_EYE));
                }
                for (double d11 = 0.0; d11 < Math.PI * 2; d11 += 0.15707963267948966) {
                    this.spawnParticle(EnumParticleTypes.PORTAL, d0 + Math.cos(d11) * 5.0, d1 - 0.4, d2 + Math.sin(d11) * 5.0, Math.cos(d11) * -5.0, 0.0, Math.sin(d11) * -5.0, new int[0]);
                    this.spawnParticle(EnumParticleTypes.PORTAL, d0 + Math.cos(d11) * 5.0, d1 - 0.4, d2 + Math.sin(d11) * 5.0, Math.cos(d11) * -7.0, 0.0, Math.sin(d11) * -7.0, new int[0]);
                }
                return;
            }
            case 2004: {
                for (int k1 = 0; k1 < 20; ++k1) {
                    double d14 = (double)p_playEvent_3_.getX() + 0.5 + ((double)this.world.rand.nextFloat() - 0.5) * 2.0;
                    double d17 = (double)p_playEvent_3_.getY() + 0.5 + ((double)this.world.rand.nextFloat() - 0.5) * 2.0;
                    double d20 = (double)p_playEvent_3_.getZ() + 0.5 + ((double)this.world.rand.nextFloat() - 0.5) * 2.0;
                    this.world.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, d14, d17, d20, 0.0, 0.0, 0.0, new int[0]);
                    this.world.spawnParticle(EnumParticleTypes.FLAME, d14, d17, d20, 0.0, 0.0, 0.0, new int[0]);
                }
                return;
            }
            case 2005: {
                ItemDye.spawnBonemealParticles(this.world, p_playEvent_3_, p_playEvent_4_);
                break;
            }
            case 2006: {
                for (int k = 0; k < 200; ++k) {
                    float f2 = random.nextFloat() * 4.0f;
                    float f3 = random.nextFloat() * ((float)Math.PI * 2);
                    double d3 = MathHelper.cos(f3) * f2;
                    double d4 = 0.01 + random.nextDouble() * 0.5;
                    double d5 = MathHelper.sin(f3) * f2;
                    Particle particle = this.spawnEntityFX(EnumParticleTypes.DRAGON_BREATH.getParticleID(), false, (double)p_playEvent_3_.getX() + d3 * 0.1, (double)p_playEvent_3_.getY() + 0.3, (double)p_playEvent_3_.getZ() + d5 * 0.1, d3, d4, d5, new int[0]);
                    if (particle == null) continue;
                    particle.multiplyVelocity(f2);
                }
                this.world.playSound(p_playEvent_3_, SoundEvents.ENTITY_ENDERDRAGON_FIREBALL_EPLD, SoundCategory.HOSTILE, 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 3000: {
                this.world.spawnParticle(EnumParticleTypes.EXPLOSION_HUGE, true, (double)p_playEvent_3_.getX() + 0.5, (double)p_playEvent_3_.getY() + 0.5, (double)p_playEvent_3_.getZ() + 0.5, 0.0, 0.0, 0.0, new int[0]);
                this.world.playSound(p_playEvent_3_, SoundEvents.BLOCK_END_GATEWAY_SPAWN, SoundCategory.BLOCKS, 10.0f, (1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f) * 0.7f, false);
                break;
            }
            case 3001: {
                this.world.playSound(p_playEvent_3_, SoundEvents.ENTITY_ENDERDRAGON_GROWL, SoundCategory.HOSTILE, 64.0f, 0.8f + this.world.rand.nextFloat() * 0.3f, false);
            }
        }
    }

    @Override
    public void sendBlockBreakProgress(int p_sendBlockBreakProgress_1_, BlockPos p_sendBlockBreakProgress_2_, int p_sendBlockBreakProgress_3_) {
        if (p_sendBlockBreakProgress_3_ >= 0 && p_sendBlockBreakProgress_3_ < 10) {
            DestroyBlockProgress destroyblockprogress = this.damagedBlocks.get(p_sendBlockBreakProgress_1_);
            if (destroyblockprogress == null || destroyblockprogress.getPosition().getX() != p_sendBlockBreakProgress_2_.getX() || destroyblockprogress.getPosition().getY() != p_sendBlockBreakProgress_2_.getY() || destroyblockprogress.getPosition().getZ() != p_sendBlockBreakProgress_2_.getZ()) {
                destroyblockprogress = new DestroyBlockProgress(p_sendBlockBreakProgress_1_, p_sendBlockBreakProgress_2_);
                this.damagedBlocks.put(p_sendBlockBreakProgress_1_, destroyblockprogress);
            }
            destroyblockprogress.setPartialBlockDamage(p_sendBlockBreakProgress_3_);
            destroyblockprogress.setCloudUpdateTick(this.cloudTickCounter);
        } else {
            this.damagedBlocks.remove(p_sendBlockBreakProgress_1_);
        }
    }

    public boolean hasNoChunkUpdates() {
        return this.chunksToUpdate.isEmpty() && this.renderDispatcher.hasChunkUpdates();
    }

    public void setDisplayListEntitiesDirty() {
        this.displayListEntitiesDirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTileEntities(Collection<TileEntity> p_updateTileEntities_1_, Collection<TileEntity> p_updateTileEntities_2_) {
        Set<TileEntity> set = this.setTileEntities;
        synchronized (set) {
            this.setTileEntities.removeAll(p_updateTileEntities_1_);
            this.setTileEntities.addAll(p_updateTileEntities_2_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    class ContainerLocalRenderInformation {
        final RenderChunk renderChunk;
        final EnumFacing facing;
        byte setFacing;
        final int counter;

        private ContainerLocalRenderInformation(RenderChunk p_i46248_2_, EnumFacing p_i46248_3_, int p_i46248_4_) {
            this.renderChunk = p_i46248_2_;
            this.facing = p_i46248_3_;
            this.counter = p_i46248_4_;
        }

        public void setDirection(byte p_setDirection_1_, EnumFacing p_setDirection_2_) {
            this.setFacing = (byte)(this.setFacing | p_setDirection_1_ | 1 << p_setDirection_2_.ordinal());
        }

        public boolean hasDirection(EnumFacing p_hasDirection_1_) {
            return (this.setFacing & 1 << p_hasDirection_1_.ordinal()) > 0;
        }
    }
}

