/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class ThreadDownloadImageData
extends SimpleTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final AtomicInteger TEXTURE_DOWNLOADER_THREAD_ID = new AtomicInteger(0);
    @Nullable
    private final File cacheFile;
    private final String imageUrl;
    @Nullable
    private final IImageBuffer imageBuffer;
    @Nullable
    private BufferedImage bufferedImage;
    @Nullable
    private Thread imageThread;
    private boolean textureUploaded;

    public ThreadDownloadImageData(File p_i1049_1_, String p_i1049_2_, ResourceLocation p_i1049_3_, IImageBuffer p_i1049_4_) {
        super(p_i1049_3_);
        this.cacheFile = p_i1049_1_;
        this.imageUrl = p_i1049_2_;
        this.imageBuffer = p_i1049_4_;
    }

    private void checkTextureUploaded() {
        if (this.textureUploaded) {
            return;
        }
        if (this.bufferedImage != null) {
            if (this.textureLocation != null) {
                this.deleteGlTexture();
            }
            TextureUtil.uploadTextureImage(super.getGlTextureId(), this.bufferedImage);
            this.textureUploaded = true;
        }
    }

    @Override
    public int getGlTextureId() {
        this.checkTextureUploaded();
        return super.getGlTextureId();
    }

    public void setBufferedImage(BufferedImage p_setBufferedImage_1_) {
        this.bufferedImage = p_setBufferedImage_1_;
        if (this.imageBuffer != null) {
            this.imageBuffer.skinAvailable();
        }
    }

    @Override
    public void loadTexture(IResourceManager p_loadTexture_1_) throws IOException {
        if (this.bufferedImage == null && this.textureLocation != null) {
            super.loadTexture(p_loadTexture_1_);
        }
        if (this.imageThread == null) {
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                LOGGER.debug("Loading http texture from local cache ({})", new Object[]{this.cacheFile});
                try {
                    this.bufferedImage = ImageIO.read(this.cacheFile);
                    if (this.imageBuffer != null) {
                        this.setBufferedImage(this.imageBuffer.parseUserSkin(this.bufferedImage));
                    }
                }
                catch (IOException lvt_2_1_) {
                    LOGGER.error("Couldn't load skin {}", new Object[]{this.cacheFile, lvt_2_1_});
                    this.loadTextureFromServer();
                }
            } else {
                this.loadTextureFromServer();
            }
        }
    }

    protected void loadTextureFromServer() {
        this.imageThread = new Thread("Texture Downloader #" + TEXTURE_DOWNLOADER_THREAD_ID.incrementAndGet()){

            @Override
            public void run() {
                HttpURLConnection lvt_1_1_ = null;
                LOGGER.debug("Downloading http texture from {} to {}", new Object[]{ThreadDownloadImageData.this.imageUrl, ThreadDownloadImageData.this.cacheFile});
                try {
                    BufferedImage lvt_2_2_;
                    lvt_1_1_ = (HttpURLConnection)new URL(ThreadDownloadImageData.this.imageUrl).openConnection(Minecraft.getMinecraft().getProxy());
                    lvt_1_1_.setDoInput(true);
                    lvt_1_1_.setDoOutput(false);
                    lvt_1_1_.connect();
                    if (lvt_1_1_.getResponseCode() / 100 != 2) {
                        return;
                    }
                    if (ThreadDownloadImageData.this.cacheFile != null) {
                        FileUtils.copyInputStreamToFile((InputStream)lvt_1_1_.getInputStream(), (File)ThreadDownloadImageData.this.cacheFile);
                        BufferedImage lvt_2_1_ = ImageIO.read(ThreadDownloadImageData.this.cacheFile);
                    } else {
                        lvt_2_2_ = TextureUtil.readBufferedImage(lvt_1_1_.getInputStream());
                    }
                    if (ThreadDownloadImageData.this.imageBuffer != null) {
                        lvt_2_2_ = ThreadDownloadImageData.this.imageBuffer.parseUserSkin(lvt_2_2_);
                    }
                    ThreadDownloadImageData.this.setBufferedImage(lvt_2_2_);
                }
                catch (Exception lvt_2_3_) {
                    LOGGER.error("Couldn't download http texture", (Throwable)lvt_2_3_);
                }
                finally {
                    if (lvt_1_1_ != null) {
                        lvt_1_1_.disconnect();
                    }
                }
            }
        };
        this.imageThread.setDaemon(true);
        this.imageThread.start();
    }
}

