/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.chunk.IRenderChunkFactory;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ViewFrustum {
    protected final RenderGlobal renderGlobal;
    protected final World world;
    protected int countChunksY;
    protected int countChunksX;
    protected int countChunksZ;
    public RenderChunk[] renderChunks;

    public ViewFrustum(World p_i46246_1_, int p_i46246_2_, RenderGlobal p_i46246_3_, IRenderChunkFactory p_i46246_4_) {
        this.renderGlobal = p_i46246_3_;
        this.world = p_i46246_1_;
        this.setCountChunksXYZ(p_i46246_2_);
        this.createRenderChunks(p_i46246_4_);
    }

    protected void createRenderChunks(IRenderChunkFactory p_createRenderChunks_1_) {
        int lvt_2_1_ = this.countChunksX * this.countChunksY * this.countChunksZ;
        this.renderChunks = new RenderChunk[lvt_2_1_];
        int lvt_3_1_ = 0;
        for (int lvt_4_1_ = 0; lvt_4_1_ < this.countChunksX; ++lvt_4_1_) {
            for (int lvt_5_1_ = 0; lvt_5_1_ < this.countChunksY; ++lvt_5_1_) {
                for (int lvt_6_1_ = 0; lvt_6_1_ < this.countChunksZ; ++lvt_6_1_) {
                    int lvt_7_1_ = (lvt_6_1_ * this.countChunksY + lvt_5_1_) * this.countChunksX + lvt_4_1_;
                    this.renderChunks[lvt_7_1_] = p_createRenderChunks_1_.create(this.world, this.renderGlobal, lvt_3_1_++);
                    this.renderChunks[lvt_7_1_].setPosition(lvt_4_1_ * 16, lvt_5_1_ * 16, lvt_6_1_ * 16);
                }
            }
        }
    }

    public void deleteGlResources() {
        for (RenderChunk lvt_4_1_ : this.renderChunks) {
            lvt_4_1_.deleteGlResources();
        }
    }

    protected void setCountChunksXYZ(int p_setCountChunksXYZ_1_) {
        int lvt_2_1_;
        this.countChunksX = lvt_2_1_ = p_setCountChunksXYZ_1_ * 2 + 1;
        this.countChunksY = 16;
        this.countChunksZ = lvt_2_1_;
    }

    public void updateChunkPositions(double p_updateChunkPositions_1_, double p_updateChunkPositions_3_) {
        int lvt_5_1_ = MathHelper.floor(p_updateChunkPositions_1_) - 8;
        int lvt_6_1_ = MathHelper.floor(p_updateChunkPositions_3_) - 8;
        int lvt_7_1_ = this.countChunksX * 16;
        for (int lvt_8_1_ = 0; lvt_8_1_ < this.countChunksX; ++lvt_8_1_) {
            int lvt_9_1_ = this.getBaseCoordinate(lvt_5_1_, lvt_7_1_, lvt_8_1_);
            for (int lvt_10_1_ = 0; lvt_10_1_ < this.countChunksZ; ++lvt_10_1_) {
                int lvt_11_1_ = this.getBaseCoordinate(lvt_6_1_, lvt_7_1_, lvt_10_1_);
                for (int lvt_12_1_ = 0; lvt_12_1_ < this.countChunksY; ++lvt_12_1_) {
                    int lvt_13_1_ = lvt_12_1_ * 16;
                    RenderChunk lvt_14_1_ = this.renderChunks[(lvt_10_1_ * this.countChunksY + lvt_12_1_) * this.countChunksX + lvt_8_1_];
                    lvt_14_1_.setPosition(lvt_9_1_, lvt_13_1_, lvt_11_1_);
                }
            }
        }
    }

    private int getBaseCoordinate(int p_getBaseCoordinate_1_, int p_getBaseCoordinate_2_, int p_getBaseCoordinate_3_) {
        int lvt_4_1_ = p_getBaseCoordinate_3_ * 16;
        int lvt_5_1_ = lvt_4_1_ - p_getBaseCoordinate_1_ + p_getBaseCoordinate_2_ / 2;
        if (lvt_5_1_ < 0) {
            lvt_5_1_ -= p_getBaseCoordinate_2_ - 1;
        }
        return lvt_4_1_ - lvt_5_1_ / p_getBaseCoordinate_2_ * p_getBaseCoordinate_2_;
    }

    public void markBlocksForUpdate(int p_markBlocksForUpdate_1_, int p_markBlocksForUpdate_2_, int p_markBlocksForUpdate_3_, int p_markBlocksForUpdate_4_, int p_markBlocksForUpdate_5_, int p_markBlocksForUpdate_6_, boolean p_markBlocksForUpdate_7_) {
        int lvt_8_1_ = MathHelper.intFloorDiv(p_markBlocksForUpdate_1_, 16);
        int lvt_9_1_ = MathHelper.intFloorDiv(p_markBlocksForUpdate_2_, 16);
        int lvt_10_1_ = MathHelper.intFloorDiv(p_markBlocksForUpdate_3_, 16);
        int lvt_11_1_ = MathHelper.intFloorDiv(p_markBlocksForUpdate_4_, 16);
        int lvt_12_1_ = MathHelper.intFloorDiv(p_markBlocksForUpdate_5_, 16);
        int lvt_13_1_ = MathHelper.intFloorDiv(p_markBlocksForUpdate_6_, 16);
        for (int lvt_14_1_ = lvt_8_1_; lvt_14_1_ <= lvt_11_1_; ++lvt_14_1_) {
            int lvt_15_1_ = lvt_14_1_ % this.countChunksX;
            if (lvt_15_1_ < 0) {
                lvt_15_1_ += this.countChunksX;
            }
            for (int lvt_16_1_ = lvt_9_1_; lvt_16_1_ <= lvt_12_1_; ++lvt_16_1_) {
                int lvt_17_1_ = lvt_16_1_ % this.countChunksY;
                if (lvt_17_1_ < 0) {
                    lvt_17_1_ += this.countChunksY;
                }
                for (int lvt_18_1_ = lvt_10_1_; lvt_18_1_ <= lvt_13_1_; ++lvt_18_1_) {
                    int lvt_19_1_ = lvt_18_1_ % this.countChunksZ;
                    if (lvt_19_1_ < 0) {
                        lvt_19_1_ += this.countChunksZ;
                    }
                    int lvt_20_1_ = (lvt_19_1_ * this.countChunksY + lvt_17_1_) * this.countChunksX + lvt_15_1_;
                    RenderChunk lvt_21_1_ = this.renderChunks[lvt_20_1_];
                    lvt_21_1_.setNeedsUpdate(p_markBlocksForUpdate_7_);
                }
            }
        }
    }

    @Nullable
    protected RenderChunk getRenderChunk(BlockPos p_getRenderChunk_1_) {
        int lvt_2_1_ = MathHelper.intFloorDiv(p_getRenderChunk_1_.getX(), 16);
        int lvt_3_1_ = MathHelper.intFloorDiv(p_getRenderChunk_1_.getY(), 16);
        int lvt_4_1_ = MathHelper.intFloorDiv(p_getRenderChunk_1_.getZ(), 16);
        if (lvt_3_1_ < 0 || lvt_3_1_ >= this.countChunksY) {
            return null;
        }
        if ((lvt_2_1_ %= this.countChunksX) < 0) {
            lvt_2_1_ += this.countChunksX;
        }
        if ((lvt_4_1_ %= this.countChunksZ) < 0) {
            lvt_4_1_ += this.countChunksZ;
        }
        int lvt_5_1_ = (lvt_4_1_ * this.countChunksY + lvt_3_1_) * this.countChunksX + lvt_2_1_;
        return this.renderChunks[lvt_5_1_];
    }
}

