/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockFaceUV {
    public float[] uvs;
    public final int rotation;

    public BlockFaceUV(float[] p_i46228_1_, int p_i46228_2_) {
        this.uvs = p_i46228_1_;
        this.rotation = p_i46228_2_;
    }

    public float getVertexU(int p_getVertexU_1_) {
        if (this.uvs == null) {
            throw new NullPointerException("uvs");
        }
        int lvt_2_1_ = this.getVertexRotated(p_getVertexU_1_);
        return lvt_2_1_ == 0 || lvt_2_1_ == 1 ? this.uvs[0] : this.uvs[2];
    }

    public float getVertexV(int p_getVertexV_1_) {
        if (this.uvs == null) {
            throw new NullPointerException("uvs");
        }
        int lvt_2_1_ = this.getVertexRotated(p_getVertexV_1_);
        return lvt_2_1_ == 0 || lvt_2_1_ == 3 ? this.uvs[1] : this.uvs[3];
    }

    private int getVertexRotated(int p_getVertexRotated_1_) {
        return (p_getVertexRotated_1_ + this.rotation / 90) % 4;
    }

    public int getVertexRotatedRev(int p_getVertexRotatedRev_1_) {
        return (p_getVertexRotatedRev_1_ + (4 - this.rotation / 90)) % 4;
    }

    public void setUvs(float[] p_setUvs_1_) {
        if (this.uvs == null) {
            this.uvs = p_setUvs_1_;
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class Deserializer
    implements JsonDeserializer<BlockFaceUV> {
        Deserializer() {
        }

        public BlockFaceUV deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject lvt_4_1_ = p_deserialize_1_.getAsJsonObject();
            float[] lvt_5_1_ = this.parseUV(lvt_4_1_);
            int lvt_6_1_ = this.parseRotation(lvt_4_1_);
            return new BlockFaceUV(lvt_5_1_, lvt_6_1_);
        }

        protected int parseRotation(JsonObject p_parseRotation_1_) {
            int lvt_2_1_ = JsonUtils.getInt(p_parseRotation_1_, "rotation", 0);
            if (lvt_2_1_ < 0 || lvt_2_1_ % 90 != 0 || lvt_2_1_ / 90 > 3) {
                throw new JsonParseException("Invalid rotation " + lvt_2_1_ + " found, only 0/90/180/270 allowed");
            }
            return lvt_2_1_;
        }

        @Nullable
        private float[] parseUV(JsonObject p_parseUV_1_) {
            if (!p_parseUV_1_.has("uv")) {
                return null;
            }
            JsonArray lvt_2_1_ = JsonUtils.getJsonArray(p_parseUV_1_, "uv");
            if (lvt_2_1_.size() != 4) {
                throw new JsonParseException("Expected 4 uv values, found: " + lvt_2_1_.size());
            }
            float[] lvt_3_1_ = new float[4];
            for (int lvt_4_1_ = 0; lvt_4_1_ < lvt_3_1_.length; ++lvt_4_1_) {
                lvt_3_1_[lvt_4_1_] = JsonUtils.getFloat(lvt_2_1_.get(lvt_4_1_), "uv[" + lvt_4_1_ + "]");
            }
            return lvt_3_1_;
        }

        public /* synthetic */ Object deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
        }
    }
}

