/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import net.minecraft.client.renderer.EnumFaceDirection;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

@SideOnly(value=Side.CLIENT)
public class FaceBakery {
    private static final float SCALE_ROTATION_22_5 = 1.0f / (float)Math.cos(0.3926991f) - 1.0f;
    private static final float SCALE_ROTATION_GENERAL = 1.0f / (float)Math.cos(0.7853981633974483) - 1.0f;
    private static final Rotation[] UV_ROTATIONS = new Rotation[ModelRotation.values().length * EnumFacing.values().length];
    private static final Rotation UV_ROTATION_0 = new Rotation(){

        @Override
        BlockFaceUV makeRotatedUV(float p_makeRotatedUV_1_, float p_makeRotatedUV_2_, float p_makeRotatedUV_3_, float p_makeRotatedUV_4_) {
            return new BlockFaceUV(new float[]{p_makeRotatedUV_1_, p_makeRotatedUV_2_, p_makeRotatedUV_3_, p_makeRotatedUV_4_}, 0);
        }
    };
    private static final Rotation UV_ROTATION_270 = new Rotation(){

        @Override
        BlockFaceUV makeRotatedUV(float p_makeRotatedUV_1_, float p_makeRotatedUV_2_, float p_makeRotatedUV_3_, float p_makeRotatedUV_4_) {
            return new BlockFaceUV(new float[]{p_makeRotatedUV_4_, 16.0f - p_makeRotatedUV_1_, p_makeRotatedUV_2_, 16.0f - p_makeRotatedUV_3_}, 270);
        }
    };
    private static final Rotation UV_ROTATION_INVERSE = new Rotation(){

        @Override
        BlockFaceUV makeRotatedUV(float p_makeRotatedUV_1_, float p_makeRotatedUV_2_, float p_makeRotatedUV_3_, float p_makeRotatedUV_4_) {
            return new BlockFaceUV(new float[]{16.0f - p_makeRotatedUV_1_, 16.0f - p_makeRotatedUV_2_, 16.0f - p_makeRotatedUV_3_, 16.0f - p_makeRotatedUV_4_}, 0);
        }
    };
    private static final Rotation UV_ROTATION_90 = new Rotation(){

        @Override
        BlockFaceUV makeRotatedUV(float p_makeRotatedUV_1_, float p_makeRotatedUV_2_, float p_makeRotatedUV_3_, float p_makeRotatedUV_4_) {
            return new BlockFaceUV(new float[]{16.0f - p_makeRotatedUV_2_, p_makeRotatedUV_3_, 16.0f - p_makeRotatedUV_4_, p_makeRotatedUV_1_}, 90);
        }
    };

    public BakedQuad makeBakedQuad(Vector3f p_makeBakedQuad_1_, Vector3f p_makeBakedQuad_2_, BlockPartFace p_makeBakedQuad_3_, TextureAtlasSprite p_makeBakedQuad_4_, EnumFacing p_makeBakedQuad_5_, ModelRotation p_makeBakedQuad_6_, BlockPartRotation p_makeBakedQuad_7_, boolean p_makeBakedQuad_8_, boolean p_makeBakedQuad_9_) {
        return this.makeBakedQuad(p_makeBakedQuad_1_, p_makeBakedQuad_2_, p_makeBakedQuad_3_, p_makeBakedQuad_4_, p_makeBakedQuad_5_, (ITransformation)p_makeBakedQuad_6_, p_makeBakedQuad_7_, p_makeBakedQuad_8_, p_makeBakedQuad_9_);
    }

    public BakedQuad makeBakedQuad(Vector3f p_makeBakedQuad_1_, Vector3f p_makeBakedQuad_2_, BlockPartFace p_makeBakedQuad_3_, TextureAtlasSprite p_makeBakedQuad_4_, EnumFacing p_makeBakedQuad_5_, ITransformation p_makeBakedQuad_6_, BlockPartRotation p_makeBakedQuad_7_, boolean p_makeBakedQuad_8_, boolean p_makeBakedQuad_9_) {
        BlockFaceUV blockfaceuv = p_makeBakedQuad_3_.blockFaceUV;
        if (p_makeBakedQuad_8_) {
            blockfaceuv = ForgeHooksClient.applyUVLock(p_makeBakedQuad_3_.blockFaceUV, p_makeBakedQuad_5_, p_makeBakedQuad_6_);
        }
        int[] aint = this.makeQuadVertexData(blockfaceuv, p_makeBakedQuad_4_, p_makeBakedQuad_5_, this.getPositionsDiv16(p_makeBakedQuad_1_, p_makeBakedQuad_2_), p_makeBakedQuad_6_, p_makeBakedQuad_7_, false);
        EnumFacing enumfacing = FaceBakery.getFacingFromVertexData(aint);
        if (p_makeBakedQuad_7_ == null) {
            this.applyFacing(aint, enumfacing);
        }
        ForgeHooksClient.fillNormal(aint, enumfacing);
        return new BakedQuad(aint, p_makeBakedQuad_3_.tintIndex, enumfacing, p_makeBakedQuad_4_, p_makeBakedQuad_9_, DefaultVertexFormats.ITEM);
    }

    private BlockFaceUV applyUVLock(BlockFaceUV p_applyUVLock_1_, EnumFacing p_applyUVLock_2_, ModelRotation p_applyUVLock_3_) {
        return UV_ROTATIONS[FaceBakery.getIndex(p_applyUVLock_3_, p_applyUVLock_2_)].rotateUV(p_applyUVLock_1_);
    }

    private int[] makeQuadVertexData(BlockFaceUV p_makeQuadVertexData_1_, TextureAtlasSprite p_makeQuadVertexData_2_, EnumFacing p_makeQuadVertexData_3_, float[] p_makeQuadVertexData_4_, ModelRotation p_makeQuadVertexData_5_, BlockPartRotation p_makeQuadVertexData_6_, boolean p_makeQuadVertexData_7_) {
        return this.makeQuadVertexData(p_makeQuadVertexData_1_, p_makeQuadVertexData_2_, p_makeQuadVertexData_3_, p_makeQuadVertexData_4_, (ITransformation)p_makeQuadVertexData_5_, p_makeQuadVertexData_6_, p_makeQuadVertexData_7_);
    }

    private int[] makeQuadVertexData(BlockFaceUV p_makeQuadVertexData_1_, TextureAtlasSprite p_makeQuadVertexData_2_, EnumFacing p_makeQuadVertexData_3_, float[] p_makeQuadVertexData_4_, ITransformation p_makeQuadVertexData_5_, BlockPartRotation p_makeQuadVertexData_6_, boolean p_makeQuadVertexData_7_) {
        int[] aint = new int[28];
        for (int i = 0; i < 4; ++i) {
            this.fillVertexData(aint, i, p_makeQuadVertexData_3_, p_makeQuadVertexData_1_, p_makeQuadVertexData_4_, p_makeQuadVertexData_2_, p_makeQuadVertexData_5_, p_makeQuadVertexData_6_, p_makeQuadVertexData_7_);
        }
        return aint;
    }

    private int getFaceShadeColor(EnumFacing p_getFaceShadeColor_1_) {
        float f = this.getFaceBrightness(p_getFaceShadeColor_1_);
        int i = MathHelper.clamp((int)(f * 255.0f), 0, 255);
        return 0xFF000000 | i << 16 | i << 8 | i;
    }

    private float getFaceBrightness(EnumFacing p_getFaceBrightness_1_) {
        switch (p_getFaceBrightness_1_) {
            case DOWN: {
                return 0.5f;
            }
            case UP: {
                return 1.0f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
            case WEST: 
            case EAST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }

    private float[] getPositionsDiv16(Vector3f p_getPositionsDiv16_1_, Vector3f p_getPositionsDiv16_2_) {
        float[] afloat = new float[EnumFacing.values().length];
        afloat[EnumFaceDirection.Constants.WEST_INDEX] = p_getPositionsDiv16_1_.x / 16.0f;
        afloat[EnumFaceDirection.Constants.DOWN_INDEX] = p_getPositionsDiv16_1_.y / 16.0f;
        afloat[EnumFaceDirection.Constants.NORTH_INDEX] = p_getPositionsDiv16_1_.z / 16.0f;
        afloat[EnumFaceDirection.Constants.EAST_INDEX] = p_getPositionsDiv16_2_.x / 16.0f;
        afloat[EnumFaceDirection.Constants.UP_INDEX] = p_getPositionsDiv16_2_.y / 16.0f;
        afloat[EnumFaceDirection.Constants.SOUTH_INDEX] = p_getPositionsDiv16_2_.z / 16.0f;
        return afloat;
    }

    private void fillVertexData(int[] p_fillVertexData_1_, int p_fillVertexData_2_, EnumFacing p_fillVertexData_3_, BlockFaceUV p_fillVertexData_4_, float[] p_fillVertexData_5_, TextureAtlasSprite p_fillVertexData_6_, ModelRotation p_fillVertexData_7_, BlockPartRotation p_fillVertexData_8_, boolean p_fillVertexData_9_) {
        this.fillVertexData(p_fillVertexData_1_, p_fillVertexData_2_, p_fillVertexData_3_, p_fillVertexData_4_, p_fillVertexData_5_, p_fillVertexData_6_, (ITransformation)p_fillVertexData_7_, p_fillVertexData_8_, p_fillVertexData_9_);
    }

    private void fillVertexData(int[] p_fillVertexData_1_, int p_fillVertexData_2_, EnumFacing p_fillVertexData_3_, BlockFaceUV p_fillVertexData_4_, float[] p_fillVertexData_5_, TextureAtlasSprite p_fillVertexData_6_, ITransformation p_fillVertexData_7_, BlockPartRotation p_fillVertexData_8_, boolean p_fillVertexData_9_) {
        EnumFacing enumfacing = p_fillVertexData_7_.rotate(p_fillVertexData_3_);
        int i = p_fillVertexData_9_ ? this.getFaceShadeColor(enumfacing) : -1;
        EnumFaceDirection.VertexInformation enumfacedirection$vertexinformation = EnumFaceDirection.getFacing(p_fillVertexData_3_).getVertexInformation(p_fillVertexData_2_);
        Vector3f vector3f = new Vector3f(p_fillVertexData_5_[enumfacedirection$vertexinformation.xIndex], p_fillVertexData_5_[enumfacedirection$vertexinformation.yIndex], p_fillVertexData_5_[enumfacedirection$vertexinformation.zIndex]);
        this.rotatePart(vector3f, p_fillVertexData_8_);
        int j = this.rotateVertex(vector3f, p_fillVertexData_3_, p_fillVertexData_2_, p_fillVertexData_7_);
        this.storeVertexData(p_fillVertexData_1_, j, p_fillVertexData_2_, vector3f, i, p_fillVertexData_6_, p_fillVertexData_4_);
    }

    private void storeVertexData(int[] p_storeVertexData_1_, int p_storeVertexData_2_, int p_storeVertexData_3_, Vector3f p_storeVertexData_4_, int p_storeVertexData_5_, TextureAtlasSprite p_storeVertexData_6_, BlockFaceUV p_storeVertexData_7_) {
        int i = p_storeVertexData_2_ * 7;
        p_storeVertexData_1_[i] = Float.floatToRawIntBits(p_storeVertexData_4_.x);
        p_storeVertexData_1_[i + 1] = Float.floatToRawIntBits(p_storeVertexData_4_.y);
        p_storeVertexData_1_[i + 2] = Float.floatToRawIntBits(p_storeVertexData_4_.z);
        p_storeVertexData_1_[i + 3] = p_storeVertexData_5_;
        p_storeVertexData_1_[i + 4] = Float.floatToRawIntBits(p_storeVertexData_6_.getInterpolatedU((double)p_storeVertexData_7_.getVertexU(p_storeVertexData_3_) * 0.999 + (double)p_storeVertexData_7_.getVertexU((p_storeVertexData_3_ + 2) % 4) * 0.001));
        p_storeVertexData_1_[i + 4 + 1] = Float.floatToRawIntBits(p_storeVertexData_6_.getInterpolatedV((double)p_storeVertexData_7_.getVertexV(p_storeVertexData_3_) * 0.999 + (double)p_storeVertexData_7_.getVertexV((p_storeVertexData_3_ + 2) % 4) * 0.001));
    }

    private void rotatePart(Vector3f p_rotatePart_1_, BlockPartRotation p_rotatePart_2_) {
        if (p_rotatePart_2_ != null) {
            Matrix4f matrix4f = this.getMatrixIdentity();
            Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
            switch (p_rotatePart_2_.axis) {
                case X: {
                    Matrix4f.rotate((float)(p_rotatePart_2_.angle * ((float)Math.PI / 180)), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)matrix4f, (Matrix4f)matrix4f);
                    vector3f.set(0.0f, 1.0f, 1.0f);
                    break;
                }
                case Y: {
                    Matrix4f.rotate((float)(p_rotatePart_2_.angle * ((float)Math.PI / 180)), (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f), (Matrix4f)matrix4f, (Matrix4f)matrix4f);
                    vector3f.set(1.0f, 0.0f, 1.0f);
                    break;
                }
                case Z: {
                    Matrix4f.rotate((float)(p_rotatePart_2_.angle * ((float)Math.PI / 180)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)matrix4f, (Matrix4f)matrix4f);
                    vector3f.set(1.0f, 1.0f, 0.0f);
                }
            }
            if (p_rotatePart_2_.rescale) {
                if (Math.abs(p_rotatePart_2_.angle) == 22.5f) {
                    vector3f.scale(SCALE_ROTATION_22_5);
                } else {
                    vector3f.scale(SCALE_ROTATION_GENERAL);
                }
                Vector3f.add((Vector3f)vector3f, (Vector3f)new Vector3f(1.0f, 1.0f, 1.0f), (Vector3f)vector3f);
            } else {
                vector3f.set(1.0f, 1.0f, 1.0f);
            }
            this.rotateScale(p_rotatePart_1_, new Vector3f((ReadableVector3f)p_rotatePart_2_.origin), matrix4f, vector3f);
        }
    }

    public int rotateVertex(Vector3f p_rotateVertex_1_, EnumFacing p_rotateVertex_2_, int p_rotateVertex_3_, ModelRotation p_rotateVertex_4_) {
        return this.rotateVertex(p_rotateVertex_1_, p_rotateVertex_2_, p_rotateVertex_3_, (ITransformation)p_rotateVertex_4_);
    }

    public int rotateVertex(Vector3f p_rotateVertex_1_, EnumFacing p_rotateVertex_2_, int p_rotateVertex_3_, ITransformation p_rotateVertex_4_) {
        if (p_rotateVertex_4_ == ModelRotation.X0_Y0) {
            return p_rotateVertex_3_;
        }
        ForgeHooksClient.transform(p_rotateVertex_1_, p_rotateVertex_4_.getMatrix());
        return p_rotateVertex_4_.rotate(p_rotateVertex_2_, p_rotateVertex_3_);
    }

    private void rotateScale(Vector3f p_rotateScale_1_, Vector3f p_rotateScale_2_, Matrix4f p_rotateScale_3_, Vector3f p_rotateScale_4_) {
        Vector4f vector4f = new Vector4f(p_rotateScale_1_.x - p_rotateScale_2_.x, p_rotateScale_1_.y - p_rotateScale_2_.y, p_rotateScale_1_.z - p_rotateScale_2_.z, 1.0f);
        Matrix4f.transform((Matrix4f)p_rotateScale_3_, (Vector4f)vector4f, (Vector4f)vector4f);
        vector4f.x *= p_rotateScale_4_.x;
        vector4f.y *= p_rotateScale_4_.y;
        vector4f.z *= p_rotateScale_4_.z;
        p_rotateScale_1_.set(vector4f.x + p_rotateScale_2_.x, vector4f.y + p_rotateScale_2_.y, vector4f.z + p_rotateScale_2_.z);
    }

    private Matrix4f getMatrixIdentity() {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        return matrix4f;
    }

    public static EnumFacing getFacingFromVertexData(int[] p_getFacingFromVertexData_0_) {
        Vector3f vector3f = new Vector3f(Float.intBitsToFloat(p_getFacingFromVertexData_0_[0]), Float.intBitsToFloat(p_getFacingFromVertexData_0_[1]), Float.intBitsToFloat(p_getFacingFromVertexData_0_[2]));
        Vector3f vector3f1 = new Vector3f(Float.intBitsToFloat(p_getFacingFromVertexData_0_[7]), Float.intBitsToFloat(p_getFacingFromVertexData_0_[8]), Float.intBitsToFloat(p_getFacingFromVertexData_0_[9]));
        Vector3f vector3f2 = new Vector3f(Float.intBitsToFloat(p_getFacingFromVertexData_0_[14]), Float.intBitsToFloat(p_getFacingFromVertexData_0_[15]), Float.intBitsToFloat(p_getFacingFromVertexData_0_[16]));
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        Vector3f vector3f5 = new Vector3f();
        Vector3f.sub((Vector3f)vector3f, (Vector3f)vector3f1, (Vector3f)vector3f3);
        Vector3f.sub((Vector3f)vector3f2, (Vector3f)vector3f1, (Vector3f)vector3f4);
        Vector3f.cross((Vector3f)vector3f4, (Vector3f)vector3f3, (Vector3f)vector3f5);
        float f = (float)Math.sqrt(vector3f5.x * vector3f5.x + vector3f5.y * vector3f5.y + vector3f5.z * vector3f5.z);
        vector3f5.x /= f;
        vector3f5.y /= f;
        vector3f5.z /= f;
        EnumFacing enumfacing = null;
        float f1 = 0.0f;
        for (EnumFacing enumfacing1 : EnumFacing.values()) {
            Vec3i vec3i = enumfacing1.getDirectionVec();
            Vector3f vector3f6 = new Vector3f((float)vec3i.getX(), (float)vec3i.getY(), (float)vec3i.getZ());
            float f2 = Vector3f.dot((Vector3f)vector3f5, (Vector3f)vector3f6);
            if (!(f2 >= 0.0f) || !(f2 > f1)) continue;
            f1 = f2;
            enumfacing = enumfacing1;
        }
        if (enumfacing == null) {
            return EnumFacing.UP;
        }
        return enumfacing;
    }

    private void applyFacing(int[] p_applyFacing_1_, EnumFacing p_applyFacing_2_) {
        int[] aint = new int[p_applyFacing_1_.length];
        System.arraycopy(p_applyFacing_1_, 0, aint, 0, p_applyFacing_1_.length);
        float[] afloat = new float[EnumFacing.values().length];
        afloat[EnumFaceDirection.Constants.WEST_INDEX] = 999.0f;
        afloat[EnumFaceDirection.Constants.DOWN_INDEX] = 999.0f;
        afloat[EnumFaceDirection.Constants.NORTH_INDEX] = 999.0f;
        afloat[EnumFaceDirection.Constants.EAST_INDEX] = -999.0f;
        afloat[EnumFaceDirection.Constants.UP_INDEX] = -999.0f;
        afloat[EnumFaceDirection.Constants.SOUTH_INDEX] = -999.0f;
        for (int i = 0; i < 4; ++i) {
            int j = 7 * i;
            float f = Float.intBitsToFloat(aint[j]);
            float f1 = Float.intBitsToFloat(aint[j + 1]);
            float f2 = Float.intBitsToFloat(aint[j + 2]);
            if (f < afloat[EnumFaceDirection.Constants.WEST_INDEX]) {
                afloat[EnumFaceDirection.Constants.WEST_INDEX] = f;
            }
            if (f1 < afloat[EnumFaceDirection.Constants.DOWN_INDEX]) {
                afloat[EnumFaceDirection.Constants.DOWN_INDEX] = f1;
            }
            if (f2 < afloat[EnumFaceDirection.Constants.NORTH_INDEX]) {
                afloat[EnumFaceDirection.Constants.NORTH_INDEX] = f2;
            }
            if (f > afloat[EnumFaceDirection.Constants.EAST_INDEX]) {
                afloat[EnumFaceDirection.Constants.EAST_INDEX] = f;
            }
            if (f1 > afloat[EnumFaceDirection.Constants.UP_INDEX]) {
                afloat[EnumFaceDirection.Constants.UP_INDEX] = f1;
            }
            if (!(f2 > afloat[EnumFaceDirection.Constants.SOUTH_INDEX])) continue;
            afloat[EnumFaceDirection.Constants.SOUTH_INDEX] = f2;
        }
        EnumFaceDirection enumfacedirection = EnumFaceDirection.getFacing(p_applyFacing_2_);
        for (int i1 = 0; i1 < 4; ++i1) {
            int j1 = 7 * i1;
            EnumFaceDirection.VertexInformation enumfacedirection$vertexinformation = enumfacedirection.getVertexInformation(i1);
            float f8 = afloat[enumfacedirection$vertexinformation.xIndex];
            float f3 = afloat[enumfacedirection$vertexinformation.yIndex];
            float f4 = afloat[enumfacedirection$vertexinformation.zIndex];
            p_applyFacing_1_[j1] = Float.floatToRawIntBits(f8);
            p_applyFacing_1_[j1 + 1] = Float.floatToRawIntBits(f3);
            p_applyFacing_1_[j1 + 2] = Float.floatToRawIntBits(f4);
            for (int k = 0; k < 4; ++k) {
                int l = 7 * k;
                float f5 = Float.intBitsToFloat(aint[l]);
                float f6 = Float.intBitsToFloat(aint[l + 1]);
                float f7 = Float.intBitsToFloat(aint[l + 2]);
                if (!MathHelper.epsilonEquals(f8, f5) || !MathHelper.epsilonEquals(f3, f6) || !MathHelper.epsilonEquals(f4, f7)) continue;
                p_applyFacing_1_[j1 + 4] = aint[l + 4];
                p_applyFacing_1_[j1 + 4 + 1] = aint[l + 4 + 1];
            }
        }
    }

    private static void addUvRotation(ModelRotation p_addUvRotation_0_, EnumFacing p_addUvRotation_1_, Rotation p_addUvRotation_2_) {
        FaceBakery.UV_ROTATIONS[FaceBakery.getIndex((ModelRotation)p_addUvRotation_0_, (EnumFacing)p_addUvRotation_1_)] = p_addUvRotation_2_;
    }

    private static int getIndex(ModelRotation p_getIndex_0_, EnumFacing p_getIndex_1_) {
        return ModelRotation.values().length * p_getIndex_1_.ordinal() + p_getIndex_0_.ordinal();
    }

    static {
        FaceBakery.addUvRotation(ModelRotation.X0_Y0, EnumFacing.DOWN, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y0, EnumFacing.EAST, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y0, EnumFacing.NORTH, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y0, EnumFacing.SOUTH, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y0, EnumFacing.UP, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y0, EnumFacing.WEST, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y90, EnumFacing.EAST, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y90, EnumFacing.NORTH, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y90, EnumFacing.SOUTH, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y90, EnumFacing.WEST, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y180, EnumFacing.EAST, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y180, EnumFacing.NORTH, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y180, EnumFacing.SOUTH, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y180, EnumFacing.WEST, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y270, EnumFacing.EAST, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y270, EnumFacing.NORTH, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y270, EnumFacing.SOUTH, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y270, EnumFacing.WEST, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X90_Y0, EnumFacing.DOWN, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X90_Y0, EnumFacing.SOUTH, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X90_Y90, EnumFacing.DOWN, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X90_Y180, EnumFacing.DOWN, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X90_Y180, EnumFacing.NORTH, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X90_Y270, EnumFacing.DOWN, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X180_Y0, EnumFacing.DOWN, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X180_Y0, EnumFacing.UP, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X270_Y0, EnumFacing.SOUTH, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X270_Y0, EnumFacing.UP, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X270_Y90, EnumFacing.UP, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X270_Y180, EnumFacing.NORTH, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X270_Y180, EnumFacing.UP, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X270_Y270, EnumFacing.UP, UV_ROTATION_0);
        FaceBakery.addUvRotation(ModelRotation.X0_Y270, EnumFacing.UP, UV_ROTATION_270);
        FaceBakery.addUvRotation(ModelRotation.X0_Y90, EnumFacing.DOWN, UV_ROTATION_270);
        FaceBakery.addUvRotation(ModelRotation.X90_Y0, EnumFacing.WEST, UV_ROTATION_270);
        FaceBakery.addUvRotation(ModelRotation.X90_Y90, EnumFacing.WEST, UV_ROTATION_270);
        FaceBakery.addUvRotation(ModelRotation.X90_Y180, EnumFacing.WEST, UV_ROTATION_270);
        FaceBakery.addUvRotation(ModelRotation.X90_Y270, EnumFacing.NORTH, UV_ROTATION_270);
        FaceBakery.addUvRotation(ModelRotation.X90_Y270, EnumFacing.SOUTH, UV_ROTATION_270);
        FaceBakery.addUvRotation(ModelRotation.X90_Y270, EnumFacing.WEST, UV_ROTATION_270);
        FaceBakery.addUvRotation(ModelRotation.X180_Y90, EnumFacing.UP, UV_ROTATION_270);
        FaceBakery.addUvRotation(ModelRotation.X180_Y270, EnumFacing.DOWN, UV_ROTATION_270);
        FaceBakery.addUvRotation(ModelRotation.X270_Y0, EnumFacing.EAST, UV_ROTATION_270);
        FaceBakery.addUvRotation(ModelRotation.X270_Y90, EnumFacing.EAST, UV_ROTATION_270);
        FaceBakery.addUvRotation(ModelRotation.X270_Y90, EnumFacing.NORTH, UV_ROTATION_270);
        FaceBakery.addUvRotation(ModelRotation.X270_Y90, EnumFacing.SOUTH, UV_ROTATION_270);
        FaceBakery.addUvRotation(ModelRotation.X270_Y180, EnumFacing.EAST, UV_ROTATION_270);
        FaceBakery.addUvRotation(ModelRotation.X270_Y270, EnumFacing.EAST, UV_ROTATION_270);
        FaceBakery.addUvRotation(ModelRotation.X0_Y180, EnumFacing.DOWN, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X0_Y180, EnumFacing.UP, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X90_Y0, EnumFacing.NORTH, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X90_Y0, EnumFacing.UP, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X90_Y90, EnumFacing.UP, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X90_Y180, EnumFacing.SOUTH, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X90_Y180, EnumFacing.UP, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X90_Y270, EnumFacing.UP, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y0, EnumFacing.EAST, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y0, EnumFacing.NORTH, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y0, EnumFacing.SOUTH, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y0, EnumFacing.WEST, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y90, EnumFacing.EAST, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y90, EnumFacing.NORTH, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y90, EnumFacing.SOUTH, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y90, EnumFacing.WEST, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y180, EnumFacing.DOWN, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y180, EnumFacing.EAST, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y180, EnumFacing.NORTH, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y180, EnumFacing.SOUTH, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y180, EnumFacing.UP, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y180, EnumFacing.WEST, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y270, EnumFacing.EAST, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y270, EnumFacing.NORTH, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y270, EnumFacing.SOUTH, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X180_Y270, EnumFacing.WEST, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X270_Y0, EnumFacing.DOWN, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X270_Y0, EnumFacing.NORTH, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X270_Y90, EnumFacing.DOWN, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X270_Y180, EnumFacing.DOWN, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X270_Y180, EnumFacing.SOUTH, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X270_Y270, EnumFacing.DOWN, UV_ROTATION_INVERSE);
        FaceBakery.addUvRotation(ModelRotation.X0_Y90, EnumFacing.UP, UV_ROTATION_90);
        FaceBakery.addUvRotation(ModelRotation.X0_Y270, EnumFacing.DOWN, UV_ROTATION_90);
        FaceBakery.addUvRotation(ModelRotation.X90_Y0, EnumFacing.EAST, UV_ROTATION_90);
        FaceBakery.addUvRotation(ModelRotation.X90_Y90, EnumFacing.EAST, UV_ROTATION_90);
        FaceBakery.addUvRotation(ModelRotation.X90_Y90, EnumFacing.NORTH, UV_ROTATION_90);
        FaceBakery.addUvRotation(ModelRotation.X90_Y90, EnumFacing.SOUTH, UV_ROTATION_90);
        FaceBakery.addUvRotation(ModelRotation.X90_Y180, EnumFacing.EAST, UV_ROTATION_90);
        FaceBakery.addUvRotation(ModelRotation.X90_Y270, EnumFacing.EAST, UV_ROTATION_90);
        FaceBakery.addUvRotation(ModelRotation.X270_Y0, EnumFacing.WEST, UV_ROTATION_90);
        FaceBakery.addUvRotation(ModelRotation.X180_Y90, EnumFacing.DOWN, UV_ROTATION_90);
        FaceBakery.addUvRotation(ModelRotation.X180_Y270, EnumFacing.UP, UV_ROTATION_90);
        FaceBakery.addUvRotation(ModelRotation.X270_Y90, EnumFacing.WEST, UV_ROTATION_90);
        FaceBakery.addUvRotation(ModelRotation.X270_Y180, EnumFacing.WEST, UV_ROTATION_90);
        FaceBakery.addUvRotation(ModelRotation.X270_Y270, EnumFacing.NORTH, UV_ROTATION_90);
        FaceBakery.addUvRotation(ModelRotation.X270_Y270, EnumFacing.SOUTH, UV_ROTATION_90);
        FaceBakery.addUvRotation(ModelRotation.X270_Y270, EnumFacing.WEST, UV_ROTATION_90);
    }

    @SideOnly(value=Side.CLIENT)
    static abstract class Rotation {
        private Rotation() {
        }

        public BlockFaceUV rotateUV(BlockFaceUV p_rotateUV_1_) {
            float f = p_rotateUV_1_.getVertexU(p_rotateUV_1_.getVertexRotatedRev(0));
            float f1 = p_rotateUV_1_.getVertexV(p_rotateUV_1_.getVertexRotatedRev(0));
            float f2 = p_rotateUV_1_.getVertexU(p_rotateUV_1_.getVertexRotatedRev(2));
            float f3 = p_rotateUV_1_.getVertexV(p_rotateUV_1_.getVertexRotatedRev(2));
            return this.makeRotatedUV(f, f1, f2, f3);
        }

        abstract BlockFaceUV makeRotatedUV(float var1, float var2, float var3, float var4);
    }
}

