/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Quaternion;

@SideOnly(value=Side.CLIENT)
public class ItemCameraTransforms {
    public static final ItemCameraTransforms DEFAULT = new ItemCameraTransforms();
    public static float offsetTranslateX;
    public static float offsetTranslateY;
    public static float offsetTranslateZ;
    public static float offsetRotationX;
    public static float offsetRotationY;
    public static float offsetRotationZ;
    public static float offsetScaleX;
    public static float offsetScaleY;
    public static float offsetScaleZ;
    public final ItemTransformVec3f thirdperson_left;
    public final ItemTransformVec3f thirdperson_right;
    public final ItemTransformVec3f firstperson_left;
    public final ItemTransformVec3f firstperson_right;
    public final ItemTransformVec3f head;
    public final ItemTransformVec3f gui;
    public final ItemTransformVec3f ground;
    public final ItemTransformVec3f fixed;

    private ItemCameraTransforms() {
        this(ItemTransformVec3f.DEFAULT, ItemTransformVec3f.DEFAULT, ItemTransformVec3f.DEFAULT, ItemTransformVec3f.DEFAULT, ItemTransformVec3f.DEFAULT, ItemTransformVec3f.DEFAULT, ItemTransformVec3f.DEFAULT, ItemTransformVec3f.DEFAULT);
    }

    @Deprecated
    public ItemCameraTransforms(ItemCameraTransforms p_i46443_1_) {
        this.thirdperson_left = p_i46443_1_.thirdperson_left;
        this.thirdperson_right = p_i46443_1_.thirdperson_right;
        this.firstperson_left = p_i46443_1_.firstperson_left;
        this.firstperson_right = p_i46443_1_.firstperson_right;
        this.head = p_i46443_1_.head;
        this.gui = p_i46443_1_.gui;
        this.ground = p_i46443_1_.ground;
        this.fixed = p_i46443_1_.fixed;
    }

    @Deprecated
    public ItemCameraTransforms(ItemTransformVec3f p_i46569_1_, ItemTransformVec3f p_i46569_2_, ItemTransformVec3f p_i46569_3_, ItemTransformVec3f p_i46569_4_, ItemTransformVec3f p_i46569_5_, ItemTransformVec3f p_i46569_6_, ItemTransformVec3f p_i46569_7_, ItemTransformVec3f p_i46569_8_) {
        this.thirdperson_left = p_i46569_1_;
        this.thirdperson_right = p_i46569_2_;
        this.firstperson_left = p_i46569_3_;
        this.firstperson_right = p_i46569_4_;
        this.head = p_i46569_5_;
        this.gui = p_i46569_6_;
        this.ground = p_i46569_7_;
        this.fixed = p_i46569_8_;
    }

    public void applyTransform(TransformType p_applyTransform_1_) {
        ItemCameraTransforms.applyTransformSide(this.getTransform(p_applyTransform_1_), false);
    }

    public static void applyTransformSide(ItemTransformVec3f p_applyTransformSide_0_, boolean p_applyTransformSide_1_) {
        if (p_applyTransformSide_0_ != ItemTransformVec3f.DEFAULT) {
            int i = p_applyTransformSide_1_ ? -1 : 1;
            GlStateManager.translate((float)i * (offsetTranslateX + p_applyTransformSide_0_.translation.x), offsetTranslateY + p_applyTransformSide_0_.translation.y, offsetTranslateZ + p_applyTransformSide_0_.translation.z);
            float f = offsetRotationX + p_applyTransformSide_0_.rotation.x;
            float f1 = offsetRotationY + p_applyTransformSide_0_.rotation.y;
            float f2 = offsetRotationZ + p_applyTransformSide_0_.rotation.z;
            if (p_applyTransformSide_1_) {
                f1 = -f1;
                f2 = -f2;
            }
            GlStateManager.rotate(ItemCameraTransforms.makeQuaternion(f, f1, f2));
            GlStateManager.scale(offsetScaleX + p_applyTransformSide_0_.scale.x, offsetScaleY + p_applyTransformSide_0_.scale.y, offsetScaleZ + p_applyTransformSide_0_.scale.z);
        }
    }

    private static Quaternion makeQuaternion(float p_makeQuaternion_0_, float p_makeQuaternion_1_, float p_makeQuaternion_2_) {
        float f = p_makeQuaternion_0_ * ((float)Math.PI / 180);
        float f1 = p_makeQuaternion_1_ * ((float)Math.PI / 180);
        float f2 = p_makeQuaternion_2_ * ((float)Math.PI / 180);
        float f3 = MathHelper.sin(0.5f * f);
        float f4 = MathHelper.cos(0.5f * f);
        float f5 = MathHelper.sin(0.5f * f1);
        float f6 = MathHelper.cos(0.5f * f1);
        float f7 = MathHelper.sin(0.5f * f2);
        float f8 = MathHelper.cos(0.5f * f2);
        return new Quaternion(f3 * f6 * f8 + f4 * f5 * f7, f4 * f5 * f8 - f3 * f6 * f7, f3 * f5 * f8 + f4 * f6 * f7, f4 * f6 * f8 - f3 * f5 * f7);
    }

    @Deprecated
    public ItemTransformVec3f getTransform(TransformType p_getTransform_1_) {
        switch (p_getTransform_1_) {
            case THIRD_PERSON_LEFT_HAND: {
                return this.thirdperson_left;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                return this.thirdperson_right;
            }
            case FIRST_PERSON_LEFT_HAND: {
                return this.firstperson_left;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                return this.firstperson_right;
            }
            case HEAD: {
                return this.head;
            }
            case GUI: {
                return this.gui;
            }
            case GROUND: {
                return this.ground;
            }
            case FIXED: {
                return this.fixed;
            }
        }
        return ItemTransformVec3f.DEFAULT;
    }

    public boolean hasCustomTransform(TransformType p_hasCustomTransform_1_) {
        return this.getTransform(p_hasCustomTransform_1_) != ItemTransformVec3f.DEFAULT;
    }

    @SideOnly(value=Side.CLIENT)
    public static enum TransformType implements IModelPart
    {
        NONE,
        THIRD_PERSON_LEFT_HAND,
        THIRD_PERSON_RIGHT_HAND,
        FIRST_PERSON_LEFT_HAND,
        FIRST_PERSON_RIGHT_HAND,
        HEAD,
        GUI,
        GROUND,
        FIXED;

    }

    @SideOnly(value=Side.CLIENT)
    static class Deserializer
    implements JsonDeserializer<ItemCameraTransforms> {
        Deserializer() {
        }

        public ItemCameraTransforms deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = p_deserialize_1_.getAsJsonObject();
            ItemTransformVec3f itemtransformvec3f = this.getTransform(p_deserialize_3_, jsonobject, "thirdperson_righthand");
            ItemTransformVec3f itemtransformvec3f1 = this.getTransform(p_deserialize_3_, jsonobject, "thirdperson_lefthand");
            if (itemtransformvec3f1 == ItemTransformVec3f.DEFAULT) {
                itemtransformvec3f1 = itemtransformvec3f;
            }
            ItemTransformVec3f itemtransformvec3f2 = this.getTransform(p_deserialize_3_, jsonobject, "firstperson_righthand");
            ItemTransformVec3f itemtransformvec3f3 = this.getTransform(p_deserialize_3_, jsonobject, "firstperson_lefthand");
            if (itemtransformvec3f3 == ItemTransformVec3f.DEFAULT) {
                itemtransformvec3f3 = itemtransformvec3f2;
            }
            ItemTransformVec3f itemtransformvec3f4 = this.getTransform(p_deserialize_3_, jsonobject, "head");
            ItemTransformVec3f itemtransformvec3f5 = this.getTransform(p_deserialize_3_, jsonobject, "gui");
            ItemTransformVec3f itemtransformvec3f6 = this.getTransform(p_deserialize_3_, jsonobject, "ground");
            ItemTransformVec3f itemtransformvec3f7 = this.getTransform(p_deserialize_3_, jsonobject, "fixed");
            return new ItemCameraTransforms(itemtransformvec3f1, itemtransformvec3f, itemtransformvec3f3, itemtransformvec3f2, itemtransformvec3f4, itemtransformvec3f5, itemtransformvec3f6, itemtransformvec3f7);
        }

        private ItemTransformVec3f getTransform(JsonDeserializationContext p_getTransform_1_, JsonObject p_getTransform_2_, String p_getTransform_3_) {
            return p_getTransform_2_.has(p_getTransform_3_) ? (ItemTransformVec3f)p_getTransform_1_.deserialize(p_getTransform_2_.get(p_getTransform_3_), ItemTransformVec3f.class) : ItemTransformVec3f.DEFAULT;
        }
    }
}

