/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class ItemModelGenerator {
    public static final List<String> LAYERS = Lists.newArrayList((Object[])new String[]{"layer0", "layer1", "layer2", "layer3", "layer4"});

    @Nullable
    public ModelBlock makeItemModel(TextureMap p_makeItemModel_1_, ModelBlock p_makeItemModel_2_) {
        String lvt_6_1_;
        HashMap lvt_3_1_ = Maps.newHashMap();
        ArrayList lvt_4_1_ = Lists.newArrayList();
        for (int lvt_5_1_ = 0; lvt_5_1_ < LAYERS.size() && p_makeItemModel_2_.isTexturePresent(lvt_6_1_ = LAYERS.get(lvt_5_1_)); ++lvt_5_1_) {
            String lvt_7_1_ = p_makeItemModel_2_.resolveTextureName(lvt_6_1_);
            lvt_3_1_.put(lvt_6_1_, lvt_7_1_);
            TextureAtlasSprite lvt_8_1_ = p_makeItemModel_1_.getAtlasSprite(new ResourceLocation(lvt_7_1_).toString());
            lvt_4_1_.addAll(this.getBlockParts(lvt_5_1_, lvt_6_1_, lvt_8_1_));
        }
        if (lvt_4_1_.isEmpty()) {
            return null;
        }
        lvt_3_1_.put("particle", p_makeItemModel_2_.isTexturePresent("particle") ? p_makeItemModel_2_.resolveTextureName("particle") : (String)lvt_3_1_.get("layer0"));
        return new ModelBlock(null, lvt_4_1_, lvt_3_1_, false, false, p_makeItemModel_2_.getAllTransforms(), p_makeItemModel_2_.getOverrides());
    }

    private List<BlockPart> getBlockParts(int p_getBlockParts_1_, String p_getBlockParts_2_, TextureAtlasSprite p_getBlockParts_3_) {
        HashMap lvt_4_1_ = Maps.newHashMap();
        lvt_4_1_.put(EnumFacing.SOUTH, new BlockPartFace(null, p_getBlockParts_1_, p_getBlockParts_2_, new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0)));
        lvt_4_1_.put(EnumFacing.NORTH, new BlockPartFace(null, p_getBlockParts_1_, p_getBlockParts_2_, new BlockFaceUV(new float[]{16.0f, 0.0f, 0.0f, 16.0f}, 0)));
        ArrayList lvt_5_1_ = Lists.newArrayList();
        lvt_5_1_.add(new BlockPart(new Vector3f(0.0f, 0.0f, 7.5f), new Vector3f(16.0f, 16.0f, 8.5f), lvt_4_1_, null, true));
        lvt_5_1_.addAll(this.getBlockParts(p_getBlockParts_3_, p_getBlockParts_2_, p_getBlockParts_1_));
        return lvt_5_1_;
    }

    private List<BlockPart> getBlockParts(TextureAtlasSprite p_getBlockParts_1_, String p_getBlockParts_2_, int p_getBlockParts_3_) {
        float lvt_4_1_ = p_getBlockParts_1_.getIconWidth();
        float lvt_5_1_ = p_getBlockParts_1_.getIconHeight();
        ArrayList lvt_6_1_ = Lists.newArrayList();
        for (Span lvt_8_1_ : this.getSpans(p_getBlockParts_1_)) {
            float lvt_9_1_ = 0.0f;
            float lvt_10_1_ = 0.0f;
            float lvt_11_1_ = 0.0f;
            float lvt_12_1_ = 0.0f;
            float lvt_13_1_ = 0.0f;
            float lvt_14_1_ = 0.0f;
            float lvt_15_1_ = 0.0f;
            float lvt_16_1_ = 0.0f;
            float lvt_17_1_ = 0.0f;
            float lvt_18_1_ = 0.0f;
            float lvt_19_1_ = lvt_8_1_.getMin();
            float lvt_20_1_ = lvt_8_1_.getMax();
            float lvt_21_1_ = lvt_8_1_.getAnchor();
            SpanFacing lvt_22_1_ = lvt_8_1_.getFacing();
            switch (lvt_22_1_) {
                case UP: {
                    lvt_9_1_ = lvt_13_1_ = lvt_19_1_;
                    lvt_11_1_ = lvt_14_1_ = lvt_20_1_ + 1.0f;
                    lvt_10_1_ = lvt_15_1_ = lvt_21_1_;
                    lvt_12_1_ = lvt_16_1_ = lvt_21_1_;
                    lvt_17_1_ = 16.0f / lvt_4_1_;
                    lvt_18_1_ = 16.0f / (lvt_5_1_ - 1.0f);
                    break;
                }
                case DOWN: {
                    lvt_15_1_ = lvt_16_1_ = lvt_21_1_;
                    lvt_9_1_ = lvt_13_1_ = lvt_19_1_;
                    lvt_11_1_ = lvt_14_1_ = lvt_20_1_ + 1.0f;
                    lvt_10_1_ = lvt_21_1_ + 1.0f;
                    lvt_12_1_ = lvt_21_1_ + 1.0f;
                    lvt_17_1_ = 16.0f / lvt_4_1_;
                    lvt_18_1_ = 16.0f / (lvt_5_1_ - 1.0f);
                    break;
                }
                case LEFT: {
                    lvt_9_1_ = lvt_13_1_ = lvt_21_1_;
                    lvt_11_1_ = lvt_14_1_ = lvt_21_1_;
                    lvt_10_1_ = lvt_16_1_ = lvt_19_1_;
                    lvt_12_1_ = lvt_15_1_ = lvt_20_1_ + 1.0f;
                    lvt_17_1_ = 16.0f / (lvt_4_1_ - 1.0f);
                    lvt_18_1_ = 16.0f / lvt_5_1_;
                    break;
                }
                case RIGHT: {
                    lvt_13_1_ = lvt_14_1_ = lvt_21_1_;
                    lvt_9_1_ = lvt_21_1_ + 1.0f;
                    lvt_11_1_ = lvt_21_1_ + 1.0f;
                    lvt_10_1_ = lvt_16_1_ = lvt_19_1_;
                    lvt_12_1_ = lvt_15_1_ = lvt_20_1_ + 1.0f;
                    lvt_17_1_ = 16.0f / (lvt_4_1_ - 1.0f);
                    lvt_18_1_ = 16.0f / lvt_5_1_;
                }
            }
            float lvt_23_1_ = 16.0f / lvt_4_1_;
            float lvt_24_1_ = 16.0f / lvt_5_1_;
            lvt_9_1_ *= lvt_23_1_;
            lvt_11_1_ *= lvt_23_1_;
            lvt_10_1_ *= lvt_24_1_;
            lvt_12_1_ *= lvt_24_1_;
            lvt_10_1_ = 16.0f - lvt_10_1_;
            lvt_12_1_ = 16.0f - lvt_12_1_;
            HashMap lvt_25_1_ = Maps.newHashMap();
            lvt_25_1_.put(lvt_22_1_.getFacing(), new BlockPartFace(null, p_getBlockParts_3_, p_getBlockParts_2_, new BlockFaceUV(new float[]{lvt_13_1_ *= lvt_17_1_, lvt_15_1_ *= lvt_18_1_, lvt_14_1_ *= lvt_17_1_, lvt_16_1_ *= lvt_18_1_}, 0)));
            switch (lvt_22_1_) {
                case UP: {
                    lvt_6_1_.add(new BlockPart(new Vector3f(lvt_9_1_, lvt_10_1_, 7.5f), new Vector3f(lvt_11_1_, lvt_10_1_, 8.5f), lvt_25_1_, null, true));
                    break;
                }
                case DOWN: {
                    lvt_6_1_.add(new BlockPart(new Vector3f(lvt_9_1_, lvt_12_1_, 7.5f), new Vector3f(lvt_11_1_, lvt_12_1_, 8.5f), lvt_25_1_, null, true));
                    break;
                }
                case LEFT: {
                    lvt_6_1_.add(new BlockPart(new Vector3f(lvt_9_1_, lvt_10_1_, 7.5f), new Vector3f(lvt_9_1_, lvt_12_1_, 8.5f), lvt_25_1_, null, true));
                    break;
                }
                case RIGHT: {
                    lvt_6_1_.add(new BlockPart(new Vector3f(lvt_11_1_, lvt_10_1_, 7.5f), new Vector3f(lvt_11_1_, lvt_12_1_, 8.5f), lvt_25_1_, null, true));
                }
            }
        }
        return lvt_6_1_;
    }

    private List<Span> getSpans(TextureAtlasSprite p_getSpans_1_) {
        int lvt_2_1_ = p_getSpans_1_.getIconWidth();
        int lvt_3_1_ = p_getSpans_1_.getIconHeight();
        ArrayList lvt_4_1_ = Lists.newArrayList();
        for (int lvt_5_1_ = 0; lvt_5_1_ < p_getSpans_1_.getFrameCount(); ++lvt_5_1_) {
            int[] lvt_6_1_ = p_getSpans_1_.getFrameTextureData(lvt_5_1_)[0];
            for (int lvt_7_1_ = 0; lvt_7_1_ < lvt_3_1_; ++lvt_7_1_) {
                for (int lvt_8_1_ = 0; lvt_8_1_ < lvt_2_1_; ++lvt_8_1_) {
                    boolean lvt_9_1_ = !this.isTransparent(lvt_6_1_, lvt_8_1_, lvt_7_1_, lvt_2_1_, lvt_3_1_);
                    this.checkTransition(SpanFacing.UP, lvt_4_1_, lvt_6_1_, lvt_8_1_, lvt_7_1_, lvt_2_1_, lvt_3_1_, lvt_9_1_);
                    this.checkTransition(SpanFacing.DOWN, lvt_4_1_, lvt_6_1_, lvt_8_1_, lvt_7_1_, lvt_2_1_, lvt_3_1_, lvt_9_1_);
                    this.checkTransition(SpanFacing.LEFT, lvt_4_1_, lvt_6_1_, lvt_8_1_, lvt_7_1_, lvt_2_1_, lvt_3_1_, lvt_9_1_);
                    this.checkTransition(SpanFacing.RIGHT, lvt_4_1_, lvt_6_1_, lvt_8_1_, lvt_7_1_, lvt_2_1_, lvt_3_1_, lvt_9_1_);
                }
            }
        }
        return lvt_4_1_;
    }

    private void checkTransition(SpanFacing p_checkTransition_1_, List<Span> p_checkTransition_2_, int[] p_checkTransition_3_, int p_checkTransition_4_, int p_checkTransition_5_, int p_checkTransition_6_, int p_checkTransition_7_, boolean p_checkTransition_8_) {
        boolean lvt_9_1_;
        boolean bl = lvt_9_1_ = this.isTransparent(p_checkTransition_3_, p_checkTransition_4_ + p_checkTransition_1_.getXOffset(), p_checkTransition_5_ + p_checkTransition_1_.getYOffset(), p_checkTransition_6_, p_checkTransition_7_) && p_checkTransition_8_;
        if (lvt_9_1_) {
            this.createOrExpandSpan(p_checkTransition_2_, p_checkTransition_1_, p_checkTransition_4_, p_checkTransition_5_);
        }
    }

    private void createOrExpandSpan(List<Span> p_createOrExpandSpan_1_, SpanFacing p_createOrExpandSpan_2_, int p_createOrExpandSpan_3_, int p_createOrExpandSpan_4_) {
        int lvt_7_2_;
        Span lvt_5_1_ = null;
        for (Span lvt_7_1_ : p_createOrExpandSpan_1_) {
            int lvt_8_1_;
            if (lvt_7_1_.getFacing() != p_createOrExpandSpan_2_) continue;
            int n = lvt_8_1_ = p_createOrExpandSpan_2_.isHorizontal() ? p_createOrExpandSpan_4_ : p_createOrExpandSpan_3_;
            if (lvt_7_1_.getAnchor() != lvt_8_1_) continue;
            lvt_5_1_ = lvt_7_1_;
            break;
        }
        int lvt_6_1_ = p_createOrExpandSpan_2_.isHorizontal() ? p_createOrExpandSpan_4_ : p_createOrExpandSpan_3_;
        int n = lvt_7_2_ = p_createOrExpandSpan_2_.isHorizontal() ? p_createOrExpandSpan_3_ : p_createOrExpandSpan_4_;
        if (lvt_5_1_ == null) {
            p_createOrExpandSpan_1_.add(new Span(p_createOrExpandSpan_2_, lvt_7_2_, lvt_6_1_));
        } else {
            lvt_5_1_.expand(lvt_7_2_);
        }
    }

    private boolean isTransparent(int[] p_isTransparent_1_, int p_isTransparent_2_, int p_isTransparent_3_, int p_isTransparent_4_, int p_isTransparent_5_) {
        if (p_isTransparent_2_ < 0 || p_isTransparent_3_ < 0 || p_isTransparent_2_ >= p_isTransparent_4_ || p_isTransparent_3_ >= p_isTransparent_5_) {
            return true;
        }
        return (p_isTransparent_1_[p_isTransparent_3_ * p_isTransparent_4_ + p_isTransparent_2_] >> 24 & 0xFF) == 0;
    }

    @SideOnly(value=Side.CLIENT)
    static class Span {
        private final SpanFacing spanFacing;
        private int min;
        private int max;
        private final int anchor;

        public Span(SpanFacing p_i46216_1_, int p_i46216_2_, int p_i46216_3_) {
            this.spanFacing = p_i46216_1_;
            this.min = p_i46216_2_;
            this.max = p_i46216_2_;
            this.anchor = p_i46216_3_;
        }

        public void expand(int p_expand_1_) {
            if (p_expand_1_ < this.min) {
                this.min = p_expand_1_;
            } else if (p_expand_1_ > this.max) {
                this.max = p_expand_1_;
            }
        }

        public SpanFacing getFacing() {
            return this.spanFacing;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public int getAnchor() {
            return this.anchor;
        }
    }

    @SideOnly(value=Side.CLIENT)
    static enum SpanFacing {
        UP(EnumFacing.UP, 0, -1),
        DOWN(EnumFacing.DOWN, 0, 1),
        LEFT(EnumFacing.EAST, -1, 0),
        RIGHT(EnumFacing.WEST, 1, 0);

        private final EnumFacing facing;
        private final int xOffset;
        private final int yOffset;

        private SpanFacing(EnumFacing p_i46215_3_, int p_i46215_4_, int p_i46215_5_) {
            this.facing = p_i46215_3_;
            this.xOffset = p_i46215_4_;
            this.yOffset = p_i46215_5_;
        }

        public EnumFacing getFacing() {
            return this.facing;
        }

        public int getXOffset() {
            return this.xOffset;
        }

        public int getYOffset() {
            return this.yOffset;
        }

        private boolean isHorizontal() {
            return this == DOWN || this == UP;
        }
    }
}

