/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ItemOverride {
    private final ResourceLocation location;
    private final Map<ResourceLocation, Float> mapResourceValues;

    public ItemOverride(ResourceLocation p_i46571_1_, Map<ResourceLocation, Float> p_i46571_2_) {
        this.location = p_i46571_1_;
        this.mapResourceValues = p_i46571_2_;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    boolean matchesItemStack(ItemStack p_matchesItemStack_1_, World p_matchesItemStack_2_, EntityLivingBase p_matchesItemStack_3_) {
        Item lvt_4_1_ = p_matchesItemStack_1_.getItem();
        for (Map.Entry<ResourceLocation, Float> lvt_6_1_ : this.mapResourceValues.entrySet()) {
            IItemPropertyGetter lvt_7_1_ = lvt_4_1_.getPropertyGetter(lvt_6_1_.getKey());
            if (lvt_7_1_ != null && !(lvt_7_1_.apply(p_matchesItemStack_1_, p_matchesItemStack_2_, p_matchesItemStack_3_) < lvt_6_1_.getValue().floatValue())) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    static class Deserializer
    implements JsonDeserializer<ItemOverride> {
        Deserializer() {
        }

        public ItemOverride deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject lvt_4_1_ = p_deserialize_1_.getAsJsonObject();
            ResourceLocation lvt_5_1_ = new ResourceLocation(JsonUtils.getString(lvt_4_1_, "model"));
            Map<ResourceLocation, Float> lvt_6_1_ = this.makeMapResourceValues(lvt_4_1_);
            return new ItemOverride(lvt_5_1_, lvt_6_1_);
        }

        protected Map<ResourceLocation, Float> makeMapResourceValues(JsonObject p_makeMapResourceValues_1_) {
            LinkedHashMap lvt_2_1_ = Maps.newLinkedHashMap();
            JsonObject lvt_3_1_ = JsonUtils.getJsonObject(p_makeMapResourceValues_1_, "predicate");
            for (Map.Entry lvt_5_1_ : lvt_3_1_.entrySet()) {
                lvt_2_1_.put(new ResourceLocation((String)lvt_5_1_.getKey()), Float.valueOf(JsonUtils.getFloat((JsonElement)lvt_5_1_.getValue(), (String)lvt_5_1_.getKey())));
            }
            return lvt_2_1_;
        }

        public /* synthetic */ Object deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
        }
    }
}

