/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ItemOverrideList {
    public static final ItemOverrideList NONE = new ItemOverrideList();
    private final List<ItemOverride> overrides = Lists.newArrayList();

    private ItemOverrideList() {
    }

    public ItemOverrideList(List<ItemOverride> p_i46570_1_) {
        for (int i = p_i46570_1_.size() - 1; i >= 0; --i) {
            this.overrides.add(p_i46570_1_.get(i));
        }
    }

    @Nullable
    @Deprecated
    public ResourceLocation applyOverride(ItemStack p_applyOverride_1_, World p_applyOverride_2_, EntityLivingBase p_applyOverride_3_) {
        if (!this.overrides.isEmpty()) {
            for (ItemOverride itemoverride : this.overrides) {
                if (!itemoverride.matchesItemStack(p_applyOverride_1_, p_applyOverride_2_, p_applyOverride_3_)) continue;
                return itemoverride.getLocation();
            }
        }
        return null;
    }

    public IBakedModel handleItemState(IBakedModel p_handleItemState_1_, ItemStack p_handleItemState_2_, World p_handleItemState_3_, EntityLivingBase p_handleItemState_4_) {
        ResourceLocation location;
        if (!p_handleItemState_2_.isEmpty() && p_handleItemState_2_.getItem().hasCustomProperties() && (location = this.applyOverride(p_handleItemState_2_, p_handleItemState_3_, p_handleItemState_4_)) != null) {
            return Minecraft.getMinecraft().getRenderItem().getItemModelMesher().getModelManager().getModel(ModelLoader.getInventoryVariant(location.toString()));
        }
        return p_handleItemState_1_;
    }

    public ImmutableList<ItemOverride> getOverrides() {
        return ImmutableList.copyOf(this.overrides);
    }
}

