/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class ModelBlock {
    private static final Logger LOGGER = LogManager.getLogger();
    @VisibleForTesting
    static final Gson SERIALIZER = new GsonBuilder().registerTypeAdapter(ModelBlock.class, (Object)new Deserializer()).registerTypeAdapter(BlockPart.class, (Object)new BlockPart.Deserializer()).registerTypeAdapter(BlockPartFace.class, (Object)new BlockPartFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransformVec3f.class, (Object)new ItemTransformVec3f.Deserializer()).registerTypeAdapter(ItemCameraTransforms.class, (Object)new ItemCameraTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverride.Deserializer()).create();
    private final List<BlockPart> elements;
    private final boolean gui3d;
    public final boolean ambientOcclusion;
    private final ItemCameraTransforms cameraTransforms;
    private final List<ItemOverride> overrides;
    public String name = "";
    @VisibleForTesting
    public final Map<String, String> textures;
    @VisibleForTesting
    public ModelBlock parent;
    @VisibleForTesting
    protected ResourceLocation parentLocation;

    public static ModelBlock deserialize(Reader p_deserialize_0_) {
        return JsonUtils.gsonDeserialize(SERIALIZER, p_deserialize_0_, ModelBlock.class, false);
    }

    public static ModelBlock deserialize(String p_deserialize_0_) {
        return ModelBlock.deserialize(new StringReader(p_deserialize_0_));
    }

    public ModelBlock(ResourceLocation p_i46573_1_, List<BlockPart> p_i46573_2_, Map<String, String> p_i46573_3_, boolean p_i46573_4_, boolean p_i46573_5_, ItemCameraTransforms p_i46573_6_, List<ItemOverride> p_i46573_7_) {
        this.elements = p_i46573_2_;
        this.ambientOcclusion = p_i46573_4_;
        this.gui3d = p_i46573_5_;
        this.textures = p_i46573_3_;
        this.parentLocation = p_i46573_1_;
        this.cameraTransforms = p_i46573_6_;
        this.overrides = p_i46573_7_;
    }

    public List<BlockPart> getElements() {
        if (this.elements.isEmpty() && this.hasParent()) {
            return this.parent.getElements();
        }
        return this.elements;
    }

    private boolean hasParent() {
        return this.parent != null;
    }

    public boolean isAmbientOcclusion() {
        if (this.hasParent()) {
            return this.parent.isAmbientOcclusion();
        }
        return this.ambientOcclusion;
    }

    public boolean isGui3d() {
        return this.gui3d;
    }

    public boolean isResolved() {
        return this.parentLocation == null || this.parent != null && this.parent.isResolved();
    }

    public void getParentFromMap(Map<ResourceLocation, ModelBlock> p_getParentFromMap_1_) {
        if (this.parentLocation != null) {
            this.parent = p_getParentFromMap_1_.get(this.parentLocation);
        }
    }

    public Collection<ResourceLocation> getOverrideLocations() {
        HashSet lvt_1_1_ = Sets.newHashSet();
        for (ItemOverride lvt_3_1_ : this.overrides) {
            lvt_1_1_.add(lvt_3_1_.getLocation());
        }
        return lvt_1_1_;
    }

    public List<ItemOverride> getOverrides() {
        return this.overrides;
    }

    public ItemOverrideList createOverrides() {
        if (this.overrides.isEmpty()) {
            return ItemOverrideList.NONE;
        }
        return new ItemOverrideList(this.overrides);
    }

    public boolean isTexturePresent(String p_isTexturePresent_1_) {
        return !"missingno".equals(this.resolveTextureName(p_isTexturePresent_1_));
    }

    public String resolveTextureName(String p_resolveTextureName_1_) {
        if (!this.startsWithHash(p_resolveTextureName_1_)) {
            p_resolveTextureName_1_ = '#' + p_resolveTextureName_1_;
        }
        return this.resolveTextureName(p_resolveTextureName_1_, new Bookkeep(this));
    }

    private String resolveTextureName(String p_resolveTextureName_1_, Bookkeep p_resolveTextureName_2_) {
        if (this.startsWithHash(p_resolveTextureName_1_)) {
            if (this == p_resolveTextureName_2_.modelExt) {
                LOGGER.warn("Unable to resolve texture due to upward reference: {} in {}", new Object[]{p_resolveTextureName_1_, this.name});
                return "missingno";
            }
            String lvt_3_1_ = this.textures.get(p_resolveTextureName_1_.substring(1));
            if (lvt_3_1_ == null && this.hasParent()) {
                lvt_3_1_ = this.parent.resolveTextureName(p_resolveTextureName_1_, p_resolveTextureName_2_);
            }
            p_resolveTextureName_2_.modelExt = this;
            if (lvt_3_1_ != null && this.startsWithHash(lvt_3_1_)) {
                lvt_3_1_ = p_resolveTextureName_2_.model.resolveTextureName(lvt_3_1_, p_resolveTextureName_2_);
            }
            if (lvt_3_1_ == null || this.startsWithHash(lvt_3_1_)) {
                return "missingno";
            }
            return lvt_3_1_;
        }
        return p_resolveTextureName_1_;
    }

    private boolean startsWithHash(String p_startsWithHash_1_) {
        return p_startsWithHash_1_.charAt(0) == '#';
    }

    @Nullable
    public ResourceLocation getParentLocation() {
        return this.parentLocation;
    }

    public ModelBlock getRootModel() {
        return this.hasParent() ? this.parent.getRootModel() : this;
    }

    public ItemCameraTransforms getAllTransforms() {
        ItemTransformVec3f lvt_1_1_ = this.getTransform(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
        ItemTransformVec3f lvt_2_1_ = this.getTransform(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        ItemTransformVec3f lvt_3_1_ = this.getTransform(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND);
        ItemTransformVec3f lvt_4_1_ = this.getTransform(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
        ItemTransformVec3f lvt_5_1_ = this.getTransform(ItemCameraTransforms.TransformType.HEAD);
        ItemTransformVec3f lvt_6_1_ = this.getTransform(ItemCameraTransforms.TransformType.GUI);
        ItemTransformVec3f lvt_7_1_ = this.getTransform(ItemCameraTransforms.TransformType.GROUND);
        ItemTransformVec3f lvt_8_1_ = this.getTransform(ItemCameraTransforms.TransformType.FIXED);
        return new ItemCameraTransforms(lvt_1_1_, lvt_2_1_, lvt_3_1_, lvt_4_1_, lvt_5_1_, lvt_6_1_, lvt_7_1_, lvt_8_1_);
    }

    private ItemTransformVec3f getTransform(ItemCameraTransforms.TransformType p_getTransform_1_) {
        if (this.parent != null && !this.cameraTransforms.hasCustomTransform(p_getTransform_1_)) {
            return this.parent.getTransform(p_getTransform_1_);
        }
        return this.cameraTransforms.getTransform(p_getTransform_1_);
    }

    public static void checkModelHierarchy(Map<ResourceLocation, ModelBlock> p_checkModelHierarchy_0_) {
        for (ModelBlock lvt_2_1_ : p_checkModelHierarchy_0_.values()) {
            try {
                ModelBlock lvt_3_1_ = lvt_2_1_.parent;
                ModelBlock lvt_4_1_ = lvt_3_1_.parent;
                while (lvt_3_1_ != lvt_4_1_) {
                    lvt_3_1_ = lvt_3_1_.parent;
                    lvt_4_1_ = lvt_4_1_.parent.parent;
                }
                throw new LoopException();
            }
            catch (NullPointerException nullPointerException) {
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LoopException
    extends RuntimeException {
    }

    @SideOnly(value=Side.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<ModelBlock> {
        public ModelBlock deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject lvt_4_1_ = p_deserialize_1_.getAsJsonObject();
            List<BlockPart> lvt_5_1_ = this.getModelElements(p_deserialize_3_, lvt_4_1_);
            String lvt_6_1_ = this.getParent(lvt_4_1_);
            Map<String, String> lvt_7_1_ = this.getTextures(lvt_4_1_);
            boolean lvt_8_1_ = this.getAmbientOcclusionEnabled(lvt_4_1_);
            ItemCameraTransforms lvt_9_1_ = ItemCameraTransforms.DEFAULT;
            if (lvt_4_1_.has("display")) {
                JsonObject lvt_10_1_ = JsonUtils.getJsonObject(lvt_4_1_, "display");
                lvt_9_1_ = (ItemCameraTransforms)p_deserialize_3_.deserialize((JsonElement)lvt_10_1_, ItemCameraTransforms.class);
            }
            List<ItemOverride> lvt_10_2_ = this.getItemOverrides(p_deserialize_3_, lvt_4_1_);
            ResourceLocation lvt_11_1_ = lvt_6_1_.isEmpty() ? null : new ResourceLocation(lvt_6_1_);
            return new ModelBlock(lvt_11_1_, lvt_5_1_, lvt_7_1_, lvt_8_1_, true, lvt_9_1_, lvt_10_2_);
        }

        protected List<ItemOverride> getItemOverrides(JsonDeserializationContext p_getItemOverrides_1_, JsonObject p_getItemOverrides_2_) {
            ArrayList lvt_3_1_ = Lists.newArrayList();
            if (p_getItemOverrides_2_.has("overrides")) {
                JsonArray lvt_4_1_ = JsonUtils.getJsonArray(p_getItemOverrides_2_, "overrides");
                for (JsonElement lvt_6_1_ : lvt_4_1_) {
                    lvt_3_1_.add((ItemOverride)p_getItemOverrides_1_.deserialize(lvt_6_1_, ItemOverride.class));
                }
            }
            return lvt_3_1_;
        }

        private Map<String, String> getTextures(JsonObject p_getTextures_1_) {
            HashMap lvt_2_1_ = Maps.newHashMap();
            if (p_getTextures_1_.has("textures")) {
                JsonObject lvt_3_1_ = p_getTextures_1_.getAsJsonObject("textures");
                for (Map.Entry lvt_5_1_ : lvt_3_1_.entrySet()) {
                    lvt_2_1_.put(lvt_5_1_.getKey(), ((JsonElement)lvt_5_1_.getValue()).getAsString());
                }
            }
            return lvt_2_1_;
        }

        private String getParent(JsonObject p_getParent_1_) {
            return JsonUtils.getString(p_getParent_1_, "parent", "");
        }

        protected boolean getAmbientOcclusionEnabled(JsonObject p_getAmbientOcclusionEnabled_1_) {
            return JsonUtils.getBoolean(p_getAmbientOcclusionEnabled_1_, "ambientocclusion", true);
        }

        protected List<BlockPart> getModelElements(JsonDeserializationContext p_getModelElements_1_, JsonObject p_getModelElements_2_) {
            ArrayList lvt_3_1_ = Lists.newArrayList();
            if (p_getModelElements_2_.has("elements")) {
                for (JsonElement lvt_5_1_ : JsonUtils.getJsonArray(p_getModelElements_2_, "elements")) {
                    lvt_3_1_.add((BlockPart)p_getModelElements_1_.deserialize(lvt_5_1_, BlockPart.class));
                }
            }
            return lvt_3_1_;
        }

        public /* synthetic */ Object deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    static final class Bookkeep {
        public final ModelBlock model;
        public ModelBlock modelExt;

        private Bookkeep(ModelBlock p_i46223_1_) {
            this.model = p_i46223_1_;
        }
    }
}

