/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelManager
implements IResourceManagerReloadListener {
    private IRegistry<ModelResourceLocation, IBakedModel> modelRegistry;
    private final TextureMap texMap;
    private final BlockModelShapes modelProvider;
    private IBakedModel defaultModel;

    public ModelManager(TextureMap p_i46082_1_) {
        this.texMap = p_i46082_1_;
        this.modelProvider = new BlockModelShapes(this);
    }

    @Override
    public void onResourceManagerReload(IResourceManager p_onResourceManagerReload_1_) {
        ModelLoader modelbakery = new ModelLoader(p_onResourceManagerReload_1_, this.texMap, this.modelProvider);
        this.modelRegistry = modelbakery.setupModelRegistry();
        this.defaultModel = this.modelRegistry.getObject(ModelBakery.MODEL_MISSING);
        ForgeHooksClient.onModelBake(this, this.modelRegistry, modelbakery);
        this.modelProvider.reloadModels();
    }

    public IBakedModel getModel(ModelResourceLocation p_getModel_1_) {
        if (p_getModel_1_ == null) {
            return this.defaultModel;
        }
        IBakedModel ibakedmodel = this.modelRegistry.getObject(p_getModel_1_);
        return ibakedmodel == null ? this.defaultModel : ibakedmodel;
    }

    public IBakedModel getMissingModel() {
        return this.defaultModel;
    }

    public TextureMap getTextureMap() {
        return this.texMap;
    }

    public BlockModelShapes getBlockModelShapes() {
        return this.modelProvider;
    }
}

