/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MultipartBakedModel
implements IBakedModel {
    private final Map<Predicate<IBlockState>, IBakedModel> selectors;
    protected final boolean ambientOcclusion;
    protected final boolean gui3D;
    protected final TextureAtlasSprite particleTexture;
    protected final ItemCameraTransforms cameraTransforms;
    protected final ItemOverrideList overrides;

    public MultipartBakedModel(Map<Predicate<IBlockState>, IBakedModel> p_i46536_1_) {
        this.selectors = p_i46536_1_;
        IBakedModel lvt_2_1_ = p_i46536_1_.values().iterator().next();
        this.ambientOcclusion = lvt_2_1_.isAmbientOcclusion();
        this.gui3D = lvt_2_1_.isGui3d();
        this.particleTexture = lvt_2_1_.getParticleTexture();
        this.cameraTransforms = lvt_2_1_.getItemCameraTransforms();
        this.overrides = lvt_2_1_.getOverrides();
    }

    @Override
    public List<BakedQuad> getQuads(IBlockState p_getQuads_1_, EnumFacing p_getQuads_2_, long p_getQuads_3_) {
        ArrayList lvt_5_1_ = Lists.newArrayList();
        if (p_getQuads_1_ != null) {
            for (Map.Entry<Predicate<IBlockState>, IBakedModel> lvt_7_1_ : this.selectors.entrySet()) {
                if (!lvt_7_1_.getKey().apply((Object)p_getQuads_1_)) continue;
                lvt_5_1_.addAll(lvt_7_1_.getValue().getQuads(p_getQuads_1_, p_getQuads_2_, p_getQuads_3_++));
            }
        }
        return lvt_5_1_;
    }

    @Override
    public boolean isAmbientOcclusion() {
        return this.ambientOcclusion;
    }

    @Override
    public boolean isGui3d() {
        return this.gui3D;
    }

    @Override
    public boolean isBuiltInRenderer() {
        return false;
    }

    @Override
    public TextureAtlasSprite getParticleTexture() {
        return this.particleTexture;
    }

    @Override
    public ItemCameraTransforms getItemCameraTransforms() {
        return this.cameraTransforms;
    }

    @Override
    public ItemOverrideList getOverrides() {
        return this.overrides;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Builder {
        private final Map<Predicate<IBlockState>, IBakedModel> builderSelectors = Maps.newLinkedHashMap();

        public void putModel(Predicate<IBlockState> p_putModel_1_, IBakedModel p_putModel_2_) {
            this.builderSelectors.put(p_putModel_1_, p_putModel_2_);
        }

        public IBakedModel makeMultipartModel() {
            return new MultipartBakedModel(this.builderSelectors);
        }
    }
}

