/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BakedQuadRetextured;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SimpleBakedModel
implements IBakedModel {
    protected final List<BakedQuad> generalQuads;
    protected final Map<EnumFacing, List<BakedQuad>> faceQuads;
    protected final boolean ambientOcclusion;
    protected final boolean gui3d;
    protected final TextureAtlasSprite texture;
    protected final ItemCameraTransforms cameraTransforms;
    protected final ItemOverrideList itemOverrideList;

    public SimpleBakedModel(List<BakedQuad> p_i46535_1_, Map<EnumFacing, List<BakedQuad>> p_i46535_2_, boolean p_i46535_3_, boolean p_i46535_4_, TextureAtlasSprite p_i46535_5_, ItemCameraTransforms p_i46535_6_, ItemOverrideList p_i46535_7_) {
        this.generalQuads = p_i46535_1_;
        this.faceQuads = p_i46535_2_;
        this.ambientOcclusion = p_i46535_3_;
        this.gui3d = p_i46535_4_;
        this.texture = p_i46535_5_;
        this.cameraTransforms = p_i46535_6_;
        this.itemOverrideList = p_i46535_7_;
    }

    @Override
    public List<BakedQuad> getQuads(IBlockState p_getQuads_1_, EnumFacing p_getQuads_2_, long p_getQuads_3_) {
        return p_getQuads_2_ == null ? this.generalQuads : this.faceQuads.get(p_getQuads_2_);
    }

    @Override
    public boolean isAmbientOcclusion() {
        return this.ambientOcclusion;
    }

    @Override
    public boolean isGui3d() {
        return this.gui3d;
    }

    @Override
    public boolean isBuiltInRenderer() {
        return false;
    }

    @Override
    public TextureAtlasSprite getParticleTexture() {
        return this.texture;
    }

    @Override
    public ItemCameraTransforms getItemCameraTransforms() {
        return this.cameraTransforms;
    }

    @Override
    public ItemOverrideList getOverrides() {
        return this.itemOverrideList;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Builder {
        private final List<BakedQuad> builderGeneralQuads = Lists.newArrayList();
        private final Map<EnumFacing, List<BakedQuad>> builderFaceQuads = Maps.newEnumMap(EnumFacing.class);
        private final ItemOverrideList builderItemOverrideList;
        private final boolean builderAmbientOcclusion;
        private TextureAtlasSprite builderTexture;
        private final boolean builderGui3d;
        private final ItemCameraTransforms builderCameraTransforms;

        public Builder(ModelBlock p_i46988_1_, ItemOverrideList p_i46988_2_) {
            this(p_i46988_1_.isAmbientOcclusion(), p_i46988_1_.isGui3d(), p_i46988_1_.getAllTransforms(), p_i46988_2_);
        }

        public Builder(IBlockState p_i46989_1_, IBakedModel p_i46989_2_, TextureAtlasSprite p_i46989_3_, BlockPos p_i46989_4_) {
            this(p_i46989_2_.isAmbientOcclusion(), p_i46989_2_.isGui3d(), p_i46989_2_.getItemCameraTransforms(), p_i46989_2_.getOverrides());
            this.builderTexture = p_i46989_2_.getParticleTexture();
            long lvt_5_1_ = MathHelper.getPositionRandom(p_i46989_4_);
            for (EnumFacing lvt_10_1_ : EnumFacing.values()) {
                this.addFaceQuads(p_i46989_1_, p_i46989_2_, p_i46989_3_, lvt_10_1_, lvt_5_1_);
            }
            this.addGeneralQuads(p_i46989_1_, p_i46989_2_, p_i46989_3_, lvt_5_1_);
        }

        private Builder(boolean p_i46990_1_, boolean p_i46990_2_, ItemCameraTransforms p_i46990_3_, ItemOverrideList p_i46990_4_) {
            for (EnumFacing lvt_8_1_ : EnumFacing.values()) {
                this.builderFaceQuads.put(lvt_8_1_, Lists.newArrayList());
            }
            this.builderItemOverrideList = p_i46990_4_;
            this.builderAmbientOcclusion = p_i46990_1_;
            this.builderGui3d = p_i46990_2_;
            this.builderCameraTransforms = p_i46990_3_;
        }

        private void addFaceQuads(IBlockState p_addFaceQuads_1_, IBakedModel p_addFaceQuads_2_, TextureAtlasSprite p_addFaceQuads_3_, EnumFacing p_addFaceQuads_4_, long p_addFaceQuads_5_) {
            for (BakedQuad lvt_8_1_ : p_addFaceQuads_2_.getQuads(p_addFaceQuads_1_, p_addFaceQuads_4_, p_addFaceQuads_5_)) {
                this.addFaceQuad(p_addFaceQuads_4_, new BakedQuadRetextured(lvt_8_1_, p_addFaceQuads_3_));
            }
        }

        private void addGeneralQuads(IBlockState p_addGeneralQuads_1_, IBakedModel p_addGeneralQuads_2_, TextureAtlasSprite p_addGeneralQuads_3_, long p_addGeneralQuads_4_) {
            for (BakedQuad lvt_7_1_ : p_addGeneralQuads_2_.getQuads(p_addGeneralQuads_1_, null, p_addGeneralQuads_4_)) {
                this.addGeneralQuad(new BakedQuadRetextured(lvt_7_1_, p_addGeneralQuads_3_));
            }
        }

        public Builder addFaceQuad(EnumFacing p_addFaceQuad_1_, BakedQuad p_addFaceQuad_2_) {
            this.builderFaceQuads.get(p_addFaceQuad_1_).add(p_addFaceQuad_2_);
            return this;
        }

        public Builder addGeneralQuad(BakedQuad p_addGeneralQuad_1_) {
            this.builderGeneralQuads.add(p_addGeneralQuad_1_);
            return this;
        }

        public Builder setTexture(TextureAtlasSprite p_setTexture_1_) {
            this.builderTexture = p_setTexture_1_;
            return this;
        }

        public IBakedModel makeBakedModel() {
            if (this.builderTexture == null) {
                throw new RuntimeException("Missing particle!");
            }
            return new SimpleBakedModel(this.builderGeneralQuads, this.builderFaceQuads, this.builderAmbientOcclusion, this.builderGui3d, this.builderTexture, this.builderCameraTransforms, this.builderItemOverrideList);
        }
    }
}

