/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ISmartVariant;
import net.minecraftforge.client.model.ModelProcessingHelper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Variant
implements ISmartVariant {
    private final ResourceLocation modelLocation;
    private final ModelRotation rotation;
    private final boolean uvLock;
    private final int weight;

    public Variant(ResourceLocation p_i46567_1_, ModelRotation p_i46567_2_, boolean p_i46567_3_, int p_i46567_4_) {
        this.modelLocation = p_i46567_1_;
        this.rotation = p_i46567_2_;
        this.uvLock = p_i46567_3_;
        this.weight = p_i46567_4_;
    }

    public ResourceLocation getModelLocation() {
        return this.modelLocation;
    }

    @Deprecated
    public ModelRotation getRotation() {
        return this.rotation;
    }

    public IModelState getState() {
        return this.rotation;
    }

    public boolean isUvLock() {
        return this.uvLock;
    }

    public int getWeight() {
        return this.weight;
    }

    public String toString() {
        return "Variant{modelLocation=" + this.modelLocation + ", rotation=" + this.rotation + ", uvLock=" + this.uvLock + ", weight=" + this.weight + '}';
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof Variant)) {
            return false;
        }
        Variant variant = (Variant)p_equals_1_;
        return this.modelLocation.equals(variant.modelLocation) && this.rotation == variant.rotation && this.uvLock == variant.uvLock && this.weight == variant.weight;
    }

    public int hashCode() {
        int i = this.modelLocation.hashCode();
        i = 31 * i + this.rotation.hashCode();
        i = 31 * i + Boolean.valueOf(this.uvLock).hashCode();
        i = 31 * i + this.weight;
        return i;
    }

    @Override
    public IModel process(IModel p_process_1_) {
        return ModelProcessingHelper.uvlock(p_process_1_, this.isUvLock());
    }

    @SideOnly(value=Side.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<Variant> {
        public Variant deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = p_deserialize_1_.getAsJsonObject();
            String s = this.getStringModel(jsonobject);
            ModelRotation modelrotation = this.parseModelRotation(jsonobject);
            boolean flag = this.parseUvLock(jsonobject);
            int i = this.parseWeight(jsonobject);
            return new Variant(this.getResourceLocationBlock(s), modelrotation, flag, i);
        }

        private ResourceLocation getResourceLocationBlock(String p_getResourceLocationBlock_1_) {
            ResourceLocation resourcelocation = new ResourceLocation(p_getResourceLocationBlock_1_);
            resourcelocation = new ResourceLocation(resourcelocation.getResourceDomain(), "block/" + resourcelocation.getResourcePath());
            return resourcelocation;
        }

        private boolean parseUvLock(JsonObject p_parseUvLock_1_) {
            return JsonUtils.getBoolean(p_parseUvLock_1_, "uvlock", false);
        }

        protected ModelRotation parseModelRotation(JsonObject p_parseModelRotation_1_) {
            int j;
            int i = JsonUtils.getInt(p_parseModelRotation_1_, "x", 0);
            ModelRotation modelrotation = ModelRotation.getModelRotation(i, j = JsonUtils.getInt(p_parseModelRotation_1_, "y", 0));
            if (modelrotation == null) {
                throw new JsonParseException("Invalid BlockModelRotation x: " + i + ", y: " + j);
            }
            return modelrotation;
        }

        protected String getStringModel(JsonObject p_getStringModel_1_) {
            return JsonUtils.getString(p_getStringModel_1_, "model");
        }

        protected int parseWeight(JsonObject p_parseWeight_1_) {
            int i = JsonUtils.getInt(p_parseWeight_1_, "weight", 1);
            if (i < 1) {
                throw new JsonParseException("Invalid weight " + i + " found, expected integer >= 1");
            }
            return i;
        }
    }
}

