/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class VariantList {
    private final List<Variant> variantList;

    public VariantList(List<Variant> p_i46568_1_) {
        this.variantList = p_i46568_1_;
    }

    public List<Variant> getVariantList() {
        return this.variantList;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ instanceof VariantList) {
            VariantList lvt_2_1_ = (VariantList)p_equals_1_;
            return this.variantList.equals(lvt_2_1_.variantList);
        }
        return false;
    }

    public int hashCode() {
        return this.variantList.hashCode();
    }

    @SideOnly(value=Side.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<VariantList> {
        public VariantList deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            ArrayList lvt_4_1_ = Lists.newArrayList();
            if (p_deserialize_1_.isJsonArray()) {
                JsonArray lvt_5_1_ = p_deserialize_1_.getAsJsonArray();
                if (lvt_5_1_.size() == 0) {
                    throw new JsonParseException("Empty variant array");
                }
                for (JsonElement lvt_7_1_ : lvt_5_1_) {
                    lvt_4_1_.add((Variant)p_deserialize_3_.deserialize(lvt_7_1_, Variant.class));
                }
            } else {
                lvt_4_1_.add((Variant)p_deserialize_3_.deserialize(p_deserialize_1_, Variant.class));
            }
            return new VariantList(lvt_4_1_);
        }

        public /* synthetic */ Object deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
        }
    }
}

