/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WeightedBakedModel
implements IBakedModel {
    private final int totalWeight;
    private final List<WeightedModel> models;
    private final IBakedModel baseModel;

    public WeightedBakedModel(List<WeightedModel> p_i46073_1_) {
        this.models = p_i46073_1_;
        this.totalWeight = WeightedRandom.getTotalWeight(p_i46073_1_);
        this.baseModel = p_i46073_1_.get((int)0).model;
    }

    private IBakedModel getRandomModel(long p_getRandomModel_1_) {
        return WeightedRandom.getRandomItem(this.models, (int)(Math.abs((int)((int)p_getRandomModel_1_ >> 16)) % this.totalWeight)).model;
    }

    @Override
    public List<BakedQuad> getQuads(IBlockState p_getQuads_1_, EnumFacing p_getQuads_2_, long p_getQuads_3_) {
        return this.getRandomModel(p_getQuads_3_).getQuads(p_getQuads_1_, p_getQuads_2_, p_getQuads_3_);
    }

    @Override
    public boolean isAmbientOcclusion() {
        return this.baseModel.isAmbientOcclusion();
    }

    @Override
    public boolean isGui3d() {
        return this.baseModel.isGui3d();
    }

    @Override
    public boolean isBuiltInRenderer() {
        return this.baseModel.isBuiltInRenderer();
    }

    @Override
    public TextureAtlasSprite getParticleTexture() {
        return this.baseModel.getParticleTexture();
    }

    @Override
    public ItemCameraTransforms getItemCameraTransforms() {
        return this.baseModel.getItemCameraTransforms();
    }

    @Override
    public ItemOverrideList getOverrides() {
        return this.baseModel.getOverrides();
    }

    @SideOnly(value=Side.CLIENT)
    static class WeightedModel
    extends WeightedRandom.Item
    implements Comparable<WeightedModel> {
        protected final IBakedModel model;

        public WeightedModel(IBakedModel p_i46763_1_, int p_i46763_2_) {
            super(p_i46763_2_);
            this.model = p_i46763_1_;
        }

        @Override
        public int compareTo(WeightedModel p_compareTo_1_) {
            return ComparisonChain.start().compare(p_compareTo_1_.itemWeight, this.itemWeight).result();
        }

        public String toString() {
            return "MyWeighedRandomItem{weight=" + this.itemWeight + ", model=" + this.model + '}';
        }

        @Override
        public /* synthetic */ int compareTo(Object p_compareTo_1_) {
            return this.compareTo((WeightedModel)p_compareTo_1_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Builder {
        private final List<WeightedModel> listItems = Lists.newArrayList();

        public Builder add(IBakedModel p_add_1_, int p_add_2_) {
            this.listItems.add(new WeightedModel(p_add_1_, p_add_2_));
            return this;
        }

        public WeightedBakedModel build() {
            Collections.sort(this.listItems);
            return new WeightedBakedModel(this.listItems);
        }

        public IBakedModel first() {
            return this.listItems.get((int)0).model;
        }
    }
}

