/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model.multipart;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.multipart.ICondition;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ConditionPropertyValue
implements ICondition {
    private static final Splitter SPLITTER = Splitter.on((char)'|').omitEmptyStrings();
    private final String key;
    private final String value;

    public ConditionPropertyValue(String p_i46565_1_, String p_i46565_2_) {
        this.key = p_i46565_1_;
        this.value = p_i46565_2_;
    }

    @Override
    public Predicate<IBlockState> getPredicate(BlockStateContainer p_getPredicate_1_) {
        Predicate lvt_6_2_;
        List lvt_5_1_;
        boolean lvt_4_1_;
        final IProperty<?> lvt_2_1_ = p_getPredicate_1_.getProperty(this.key);
        if (lvt_2_1_ == null) {
            throw new RuntimeException(this.toString() + ": Definition: " + p_getPredicate_1_ + " has no property: " + this.key);
        }
        String lvt_3_1_ = this.value;
        boolean bl = lvt_4_1_ = !lvt_3_1_.isEmpty() && lvt_3_1_.charAt(0) == '!';
        if (lvt_4_1_) {
            lvt_3_1_ = lvt_3_1_.substring(1);
        }
        if ((lvt_5_1_ = SPLITTER.splitToList((CharSequence)lvt_3_1_)).isEmpty()) {
            throw new RuntimeException(this.toString() + ": has an empty value: " + this.value);
        }
        if (lvt_5_1_.size() == 1) {
            Predicate<IBlockState> lvt_6_1_ = this.makePredicate(lvt_2_1_, lvt_3_1_);
        } else {
            lvt_6_2_ = Predicates.or((Iterable)Iterables.transform((Iterable)lvt_5_1_, (Function)new Function<String, Predicate<IBlockState>>(){

                @Nullable
                public Predicate<IBlockState> apply(String p_apply_1_) {
                    return ConditionPropertyValue.this.makePredicate(lvt_2_1_, p_apply_1_);
                }

                @Nullable
                public /* synthetic */ Object apply(Object p_apply_1_) {
                    return this.apply((String)p_apply_1_);
                }
            }));
        }
        return lvt_4_1_ ? Predicates.not((Predicate)lvt_6_2_) : lvt_6_2_;
    }

    private Predicate<IBlockState> makePredicate(final IProperty<?> p_makePredicate_1_, String p_makePredicate_2_) {
        final Optional<?> lvt_3_1_ = p_makePredicate_1_.parseValue(p_makePredicate_2_);
        if (!lvt_3_1_.isPresent()) {
            throw new RuntimeException(this.toString() + ": has an unknown value: " + this.value);
        }
        return new Predicate<IBlockState>(){

            public boolean apply(IBlockState p_apply_1_) {
                return p_apply_1_ != null && p_apply_1_.getValue(p_makePredicate_1_).equals(lvt_3_1_.get());
            }

            public /* synthetic */ boolean apply(Object p_apply_1_) {
                return this.apply((IBlockState)p_apply_1_);
            }
        };
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("key", (Object)this.key).add("value", (Object)this.value).toString();
    }
}

