/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model.multipart;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.VariantList;
import net.minecraft.client.renderer.block.model.multipart.ConditionAnd;
import net.minecraft.client.renderer.block.model.multipart.ConditionOr;
import net.minecraft.client.renderer.block.model.multipart.ConditionPropertyValue;
import net.minecraft.client.renderer.block.model.multipart.ICondition;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Selector {
    private final ICondition condition;
    private final VariantList variantList;

    public Selector(ICondition p_i46562_1_, VariantList p_i46562_2_) {
        if (p_i46562_1_ == null) {
            throw new IllegalArgumentException("Missing condition for selector");
        }
        if (p_i46562_2_ == null) {
            throw new IllegalArgumentException("Missing variant for selector");
        }
        this.condition = p_i46562_1_;
        this.variantList = p_i46562_2_;
    }

    public VariantList getVariantList() {
        return this.variantList;
    }

    public Predicate<IBlockState> getPredicate(BlockStateContainer p_getPredicate_1_) {
        return this.condition.getPredicate(p_getPredicate_1_);
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ instanceof Selector) {
            Selector lvt_2_1_ = (Selector)p_equals_1_;
            if (this.condition.equals(lvt_2_1_.condition)) {
                return this.variantList.equals(lvt_2_1_.variantList);
            }
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.condition.hashCode() + this.variantList.hashCode();
    }

    @SideOnly(value=Side.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<Selector> {
        private static final Function<JsonElement, ICondition> FUNCTION_OR_AND = new Function<JsonElement, ICondition>(){

            @Nullable
            public ICondition apply(JsonElement p_apply_1_) {
                return p_apply_1_ == null ? null : Deserializer.getOrAndCondition(p_apply_1_.getAsJsonObject());
            }

            @Nullable
            public /* synthetic */ Object apply(Object p_apply_1_) {
                return this.apply((JsonElement)p_apply_1_);
            }
        };
        private static final Function<Map.Entry<String, JsonElement>, ICondition> FUNCTION_PROPERTY_VALUE = new Function<Map.Entry<String, JsonElement>, ICondition>(){

            @Nullable
            public ICondition apply(Map.Entry<String, JsonElement> p_apply_1_) {
                return p_apply_1_ == null ? null : Deserializer.makePropertyValue(p_apply_1_);
            }

            @Nullable
            public /* synthetic */ Object apply(Object p_apply_1_) {
                return this.apply((Map.Entry)p_apply_1_);
            }
        };

        public Selector deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject lvt_4_1_ = p_deserialize_1_.getAsJsonObject();
            return new Selector(this.getWhenCondition(lvt_4_1_), (VariantList)p_deserialize_3_.deserialize(lvt_4_1_.get("apply"), VariantList.class));
        }

        private ICondition getWhenCondition(JsonObject p_getWhenCondition_1_) {
            if (p_getWhenCondition_1_.has("when")) {
                return Deserializer.getOrAndCondition(JsonUtils.getJsonObject(p_getWhenCondition_1_, "when"));
            }
            return ICondition.TRUE;
        }

        @VisibleForTesting
        static ICondition getOrAndCondition(JsonObject p_getOrAndCondition_0_) {
            Set lvt_1_1_ = p_getOrAndCondition_0_.entrySet();
            if (lvt_1_1_.isEmpty()) {
                throw new JsonParseException("No elements found in selector");
            }
            if (lvt_1_1_.size() == 1) {
                if (p_getOrAndCondition_0_.has("OR")) {
                    return new ConditionOr(Iterables.transform((Iterable)JsonUtils.getJsonArray(p_getOrAndCondition_0_, "OR"), FUNCTION_OR_AND));
                }
                if (p_getOrAndCondition_0_.has("AND")) {
                    return new ConditionAnd(Iterables.transform((Iterable)JsonUtils.getJsonArray(p_getOrAndCondition_0_, "AND"), FUNCTION_OR_AND));
                }
                return Deserializer.makePropertyValue((Map.Entry)lvt_1_1_.iterator().next());
            }
            return new ConditionAnd(Iterables.transform((Iterable)lvt_1_1_, FUNCTION_PROPERTY_VALUE));
        }

        private static ConditionPropertyValue makePropertyValue(Map.Entry<String, JsonElement> p_makePropertyValue_0_) {
            return new ConditionPropertyValue(p_makePropertyValue_0_.getKey(), p_makePropertyValue_0_.getValue().getAsString());
        }

        public /* synthetic */ Object deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
        }
    }
}

