/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.statemap;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockStateMapper {
    private final Map<Block, IStateMapper> blockStateMap = Maps.newIdentityHashMap();
    private final Set<Block> setBuiltInBlocks = Sets.newIdentityHashSet();

    public void registerBlockStateMapper(Block p_registerBlockStateMapper_1_, IStateMapper p_registerBlockStateMapper_2_) {
        this.blockStateMap.put(p_registerBlockStateMapper_1_, p_registerBlockStateMapper_2_);
    }

    public void registerBuiltInBlocks(Block ... p_registerBuiltInBlocks_1_) {
        Collections.addAll(this.setBuiltInBlocks, p_registerBuiltInBlocks_1_);
    }

    public Map<IBlockState, ModelResourceLocation> putAllStateModelLocations() {
        IdentityHashMap lvt_1_1_ = Maps.newIdentityHashMap();
        for (Block lvt_3_1_ : Block.REGISTRY) {
            lvt_1_1_.putAll(this.getVariants(lvt_3_1_));
        }
        return lvt_1_1_;
    }

    public Set<ResourceLocation> getBlockstateLocations(Block p_getBlockstateLocations_1_) {
        if (this.setBuiltInBlocks.contains(p_getBlockstateLocations_1_)) {
            return Collections.emptySet();
        }
        IStateMapper lvt_2_1_ = this.blockStateMap.get(p_getBlockstateLocations_1_);
        if (lvt_2_1_ == null) {
            return Collections.singleton(Block.REGISTRY.getNameForObject(p_getBlockstateLocations_1_));
        }
        HashSet lvt_3_1_ = Sets.newHashSet();
        for (ModelResourceLocation lvt_5_1_ : lvt_2_1_.putStateModelLocations(p_getBlockstateLocations_1_).values()) {
            lvt_3_1_.add(new ResourceLocation(lvt_5_1_.getResourceDomain(), lvt_5_1_.getResourcePath()));
        }
        return lvt_3_1_;
    }

    public Map<IBlockState, ModelResourceLocation> getVariants(Block p_getVariants_1_) {
        if (this.setBuiltInBlocks.contains(p_getVariants_1_)) {
            return Collections.emptyMap();
        }
        return ((IStateMapper)Objects.firstNonNull((Object)this.blockStateMap.get(p_getVariants_1_), (Object)new DefaultStateMapper())).putStateModelLocations(p_getVariants_1_);
    }
}

