/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.statemap;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class StateMap
extends StateMapperBase {
    private final IProperty<?> name;
    private final String suffix;
    private final List<IProperty<?>> ignored;

    private StateMap(IProperty<?> p_i46210_1_, String p_i46210_2_, List<IProperty<?>> p_i46210_3_) {
        this.name = p_i46210_1_;
        this.suffix = p_i46210_2_;
        this.ignored = p_i46210_3_;
    }

    @Override
    protected ModelResourceLocation getModelResourceLocation(IBlockState p_getModelResourceLocation_1_) {
        LinkedHashMap map = Maps.newLinkedHashMap(p_getModelResourceLocation_1_.getProperties());
        String s = this.name == null ? Block.REGISTRY.getNameForObject(p_getModelResourceLocation_1_.getBlock()).toString() : String.format("%s:%s", Block.REGISTRY.getNameForObject(p_getModelResourceLocation_1_.getBlock()).getResourceDomain(), this.removeName(this.name, map));
        if (this.suffix != null) {
            s = s + this.suffix;
        }
        for (IProperty<?> iproperty : this.ignored) {
            map.remove(iproperty);
        }
        return new ModelResourceLocation(s, this.getPropertyString(map));
    }

    private <T extends Comparable<T>> String removeName(IProperty<T> p_removeName_1_, Map<IProperty<?>, Comparable<?>> p_removeName_2_) {
        return p_removeName_1_.getName(p_removeName_2_.remove(this.name));
    }

    @SideOnly(value=Side.CLIENT)
    public static class Builder {
        private IProperty<?> name;
        private String suffix;
        private final List<IProperty<?>> ignored = Lists.newArrayList();

        public Builder withName(IProperty<?> p_withName_1_) {
            this.name = p_withName_1_;
            return this;
        }

        public Builder withSuffix(String p_withSuffix_1_) {
            this.suffix = p_withSuffix_1_;
            return this;
        }

        public Builder ignore(IProperty<?> ... p_ignore_1_) {
            Collections.addAll(this.ignored, p_ignore_1_);
            return this;
        }

        public StateMap build() {
            return new StateMap(this.name, this.suffix, this.ignored);
        }
    }
}

