/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.statemap;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class StateMapperBase
implements IStateMapper {
    protected Map<IBlockState, ModelResourceLocation> mapStateModelLocations = Maps.newLinkedHashMap();

    public String getPropertyString(Map<IProperty<?>, Comparable<?>> p_getPropertyString_1_) {
        StringBuilder lvt_2_1_ = new StringBuilder();
        for (Map.Entry<IProperty<?>, Comparable<?>> lvt_4_1_ : p_getPropertyString_1_.entrySet()) {
            if (lvt_2_1_.length() != 0) {
                lvt_2_1_.append(",");
            }
            IProperty<?> lvt_5_1_ = lvt_4_1_.getKey();
            lvt_2_1_.append(lvt_5_1_.getName());
            lvt_2_1_.append("=");
            lvt_2_1_.append(this.getPropertyName(lvt_5_1_, lvt_4_1_.getValue()));
        }
        if (lvt_2_1_.length() == 0) {
            lvt_2_1_.append("normal");
        }
        return lvt_2_1_.toString();
    }

    private <T extends Comparable<T>> String getPropertyName(IProperty<T> p_getPropertyName_1_, Comparable<?> p_getPropertyName_2_) {
        return p_getPropertyName_1_.getName(p_getPropertyName_2_);
    }

    @Override
    public Map<IBlockState, ModelResourceLocation> putStateModelLocations(Block p_putStateModelLocations_1_) {
        for (IBlockState lvt_3_1_ : p_putStateModelLocations_1_.getBlockState().getValidStates()) {
            this.mapStateModelLocations.put(lvt_3_1_, this.getModelResourceLocation(lvt_3_1_));
        }
        return this.mapStateModelLocations;
    }

    protected abstract ModelResourceLocation getModelResourceLocation(IBlockState var1);
}

