/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.chunk.ChunkCompileTaskGenerator;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class ChunkRenderWorker
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ChunkRenderDispatcher chunkRenderDispatcher;
    private final RegionRenderCacheBuilder regionRenderCacheBuilder;
    private boolean shouldRun = true;

    public ChunkRenderWorker(ChunkRenderDispatcher p_i46201_1_) {
        this(p_i46201_1_, null);
    }

    public ChunkRenderWorker(ChunkRenderDispatcher p_i46202_1_, RegionRenderCacheBuilder p_i46202_2_) {
        this.chunkRenderDispatcher = p_i46202_1_;
        this.regionRenderCacheBuilder = p_i46202_2_;
    }

    @Override
    public void run() {
        while (this.shouldRun) {
            try {
                this.processTask(this.chunkRenderDispatcher.getNextChunkUpdate());
            }
            catch (InterruptedException lvt_1_1_) {
                LOGGER.debug("Stopping chunk worker due to interrupt");
                return;
            }
            catch (Throwable lvt_1_2_) {
                CrashReport lvt_2_1_ = CrashReport.makeCrashReport(lvt_1_2_, "Batching chunks");
                Minecraft.getMinecraft().crashed(Minecraft.getMinecraft().addGraphicsAndWorldToCrashReport(lvt_2_1_));
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTask(final ChunkCompileTaskGenerator p_processTask_1_) throws InterruptedException {
        p_processTask_1_.getLock().lock();
        try {
            if (p_processTask_1_.getStatus() != ChunkCompileTaskGenerator.Status.PENDING) {
                if (!p_processTask_1_.isFinished()) {
                    LOGGER.warn("Chunk render task was {} when I expected it to be pending; ignoring task", new Object[]{p_processTask_1_.getStatus()});
                }
                return;
            }
            BlockPos lvt_2_1_ = new BlockPos(Minecraft.getMinecraft().player);
            BlockPos lvt_3_1_ = p_processTask_1_.getRenderChunk().getPosition();
            int lvt_4_1_ = 16;
            int lvt_5_1_ = 8;
            int lvt_6_1_ = 24;
            if (lvt_3_1_.add(8, 8, 8).distanceSq(lvt_2_1_) > 576.0) {
                World lvt_7_1_ = p_processTask_1_.getRenderChunk().getWorld();
                BlockPos.MutableBlockPos lvt_8_1_ = new BlockPos.MutableBlockPos(lvt_3_1_);
                if (!(this.isChunkExisting(lvt_8_1_.setPos(lvt_3_1_).move(EnumFacing.WEST, 16), lvt_7_1_) && this.isChunkExisting(lvt_8_1_.setPos(lvt_3_1_).move(EnumFacing.NORTH, 16), lvt_7_1_) && this.isChunkExisting(lvt_8_1_.setPos(lvt_3_1_).move(EnumFacing.EAST, 16), lvt_7_1_) && this.isChunkExisting(lvt_8_1_.setPos(lvt_3_1_).move(EnumFacing.SOUTH, 16), lvt_7_1_))) {
                    return;
                }
            }
            p_processTask_1_.setStatus(ChunkCompileTaskGenerator.Status.COMPILING);
        }
        finally {
            p_processTask_1_.getLock().unlock();
        }
        Entity lvt_2_2_ = Minecraft.getMinecraft().getRenderViewEntity();
        if (lvt_2_2_ == null) {
            p_processTask_1_.finish();
            return;
        }
        p_processTask_1_.setRegionRenderCacheBuilder(this.getRegionRenderCacheBuilder());
        float lvt_3_2_ = (float)lvt_2_2_.posX;
        float lvt_4_2_ = (float)lvt_2_2_.posY + lvt_2_2_.getEyeHeight();
        float lvt_5_2_ = (float)lvt_2_2_.posZ;
        ChunkCompileTaskGenerator.Type lvt_6_2_ = p_processTask_1_.getType();
        if (lvt_6_2_ == ChunkCompileTaskGenerator.Type.REBUILD_CHUNK) {
            p_processTask_1_.getRenderChunk().rebuildChunk(lvt_3_2_, lvt_4_2_, lvt_5_2_, p_processTask_1_);
        } else if (lvt_6_2_ == ChunkCompileTaskGenerator.Type.RESORT_TRANSPARENCY) {
            p_processTask_1_.getRenderChunk().resortTransparency(lvt_3_2_, lvt_4_2_, lvt_5_2_, p_processTask_1_);
        }
        p_processTask_1_.getLock().lock();
        try {
            if (p_processTask_1_.getStatus() != ChunkCompileTaskGenerator.Status.COMPILING) {
                if (!p_processTask_1_.isFinished()) {
                    LOGGER.warn("Chunk render task was {} when I expected it to be compiling; aborting task", new Object[]{p_processTask_1_.getStatus()});
                }
                this.freeRenderBuilder(p_processTask_1_);
                return;
            }
            p_processTask_1_.setStatus(ChunkCompileTaskGenerator.Status.UPLOADING);
        }
        finally {
            p_processTask_1_.getLock().unlock();
        }
        final CompiledChunk lvt_7_2_ = p_processTask_1_.getCompiledChunk();
        ArrayList lvt_8_2_ = Lists.newArrayList();
        if (lvt_6_2_ == ChunkCompileTaskGenerator.Type.REBUILD_CHUNK) {
            for (BlockRenderLayer lvt_12_1_ : BlockRenderLayer.values()) {
                if (!lvt_7_2_.isLayerStarted(lvt_12_1_)) continue;
                lvt_8_2_.add(this.chunkRenderDispatcher.uploadChunk(lvt_12_1_, p_processTask_1_.getRegionRenderCacheBuilder().getWorldRendererByLayer(lvt_12_1_), p_processTask_1_.getRenderChunk(), lvt_7_2_, p_processTask_1_.getDistanceSq()));
            }
        } else if (lvt_6_2_ == ChunkCompileTaskGenerator.Type.RESORT_TRANSPARENCY) {
            lvt_8_2_.add(this.chunkRenderDispatcher.uploadChunk(BlockRenderLayer.TRANSLUCENT, p_processTask_1_.getRegionRenderCacheBuilder().getWorldRendererByLayer(BlockRenderLayer.TRANSLUCENT), p_processTask_1_.getRenderChunk(), lvt_7_2_, p_processTask_1_.getDistanceSq()));
        }
        final ListenableFuture lvt_9_1_ = Futures.allAsList((Iterable)lvt_8_2_);
        p_processTask_1_.addFinishRunnable(new Runnable(){

            @Override
            public void run() {
                lvt_9_1_.cancel(false);
            }
        });
        Futures.addCallback((ListenableFuture)lvt_9_1_, (FutureCallback)new FutureCallback<List<Object>>(){

            public void onSuccess(List<Object> p_onSuccess_1_) {
                ChunkRenderWorker.this.freeRenderBuilder(p_processTask_1_);
                p_processTask_1_.getLock().lock();
                try {
                    if (p_processTask_1_.getStatus() != ChunkCompileTaskGenerator.Status.UPLOADING) {
                        if (!p_processTask_1_.isFinished()) {
                            LOGGER.warn("Chunk render task was {} when I expected it to be uploading; aborting task", new Object[]{p_processTask_1_.getStatus()});
                        }
                        return;
                    }
                    p_processTask_1_.setStatus(ChunkCompileTaskGenerator.Status.DONE);
                }
                finally {
                    p_processTask_1_.getLock().unlock();
                }
                p_processTask_1_.getRenderChunk().setCompiledChunk(lvt_7_2_);
            }

            public void onFailure(Throwable p_onFailure_1_) {
                ChunkRenderWorker.this.freeRenderBuilder(p_processTask_1_);
                if (!(p_onFailure_1_ instanceof CancellationException) && !(p_onFailure_1_ instanceof InterruptedException)) {
                    Minecraft.getMinecraft().crashed(CrashReport.makeCrashReport(p_onFailure_1_, "Rendering chunk"));
                }
            }

            public /* synthetic */ void onSuccess(Object p_onSuccess_1_) {
                this.onSuccess((List)p_onSuccess_1_);
            }
        });
    }

    private boolean isChunkExisting(BlockPos p_isChunkExisting_1_, World p_isChunkExisting_2_) {
        return !p_isChunkExisting_2_.getChunkFromChunkCoords(p_isChunkExisting_1_.getX() >> 4, p_isChunkExisting_1_.getZ() >> 4).isEmpty();
    }

    private RegionRenderCacheBuilder getRegionRenderCacheBuilder() throws InterruptedException {
        return this.regionRenderCacheBuilder != null ? this.regionRenderCacheBuilder : this.chunkRenderDispatcher.allocateRenderBuilder();
    }

    private void freeRenderBuilder(ChunkCompileTaskGenerator p_freeRenderBuilder_1_) {
        if (this.regionRenderCacheBuilder == null) {
            this.chunkRenderDispatcher.freeRenderBuilder(p_freeRenderBuilder_1_.getRegionRenderCacheBuilder());
        }
    }

    public void notifyToStop() {
        this.shouldRun = false;
    }
}

