/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.chunk.SetVisibility;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CompiledChunk {
    public static final CompiledChunk DUMMY = new CompiledChunk(){

        @Override
        protected void setLayerUsed(BlockRenderLayer p_setLayerUsed_1_) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLayerStarted(BlockRenderLayer p_setLayerStarted_1_) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isVisible(EnumFacing p_isVisible_1_, EnumFacing p_isVisible_2_) {
            return false;
        }
    };
    private final boolean[] layersUsed = new boolean[BlockRenderLayer.values().length];
    private final boolean[] layersStarted = new boolean[BlockRenderLayer.values().length];
    private boolean empty = true;
    private final List<TileEntity> tileEntities = Lists.newArrayList();
    private SetVisibility setVisibility = new SetVisibility();
    private VertexBuffer.State state;

    public boolean isEmpty() {
        return this.empty;
    }

    protected void setLayerUsed(BlockRenderLayer p_setLayerUsed_1_) {
        this.empty = false;
        this.layersUsed[p_setLayerUsed_1_.ordinal()] = true;
    }

    public boolean isLayerEmpty(BlockRenderLayer p_isLayerEmpty_1_) {
        return !this.layersUsed[p_isLayerEmpty_1_.ordinal()];
    }

    public void setLayerStarted(BlockRenderLayer p_setLayerStarted_1_) {
        this.layersStarted[p_setLayerStarted_1_.ordinal()] = true;
    }

    public boolean isLayerStarted(BlockRenderLayer p_isLayerStarted_1_) {
        return this.layersStarted[p_isLayerStarted_1_.ordinal()];
    }

    public List<TileEntity> getTileEntities() {
        return this.tileEntities;
    }

    public void addTileEntity(TileEntity p_addTileEntity_1_) {
        this.tileEntities.add(p_addTileEntity_1_);
    }

    public boolean isVisible(EnumFacing p_isVisible_1_, EnumFacing p_isVisible_2_) {
        return this.setVisibility.isVisible(p_isVisible_1_, p_isVisible_2_);
    }

    public void setVisibility(SetVisibility p_setVisibility_1_) {
        this.setVisibility = p_setVisibility_1_;
    }

    public VertexBuffer.State getState() {
        return this.state;
    }

    public void setState(VertexBuffer.State p_setState_1_) {
        this.state = p_setState_1_;
    }
}

