/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Sets;
import java.nio.FloatBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.chunk.ChunkCompileTaskGenerator;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderChunk {
    private World world;
    private final RenderGlobal renderGlobal;
    public static int renderChunksUpdated;
    public CompiledChunk compiledChunk = CompiledChunk.DUMMY;
    private final ReentrantLock lockCompileTask = new ReentrantLock();
    private final ReentrantLock lockCompiledChunk = new ReentrantLock();
    private ChunkCompileTaskGenerator compileTask;
    private final Set<TileEntity> setTileEntities = Sets.newHashSet();
    private final int index;
    private final FloatBuffer modelviewMatrix = GLAllocation.createDirectFloatBuffer(16);
    private final net.minecraft.client.renderer.vertex.VertexBuffer[] vertexBuffers = new net.minecraft.client.renderer.vertex.VertexBuffer[BlockRenderLayer.values().length];
    public AxisAlignedBB boundingBox;
    private int frameIndex = -1;
    private boolean needsUpdate = true;
    private final BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos(-1, -1, -1);
    private final BlockPos.MutableBlockPos[] mapEnumFacing = new BlockPos.MutableBlockPos[6];
    private boolean needsUpdateCustom;
    private ChunkCache region;

    public RenderChunk(World p_i47120_1_, RenderGlobal p_i47120_2_, int p_i47120_3_) {
        for (int i = 0; i < this.mapEnumFacing.length; ++i) {
            this.mapEnumFacing[i] = new BlockPos.MutableBlockPos();
        }
        this.world = p_i47120_1_;
        this.renderGlobal = p_i47120_2_;
        this.index = p_i47120_3_;
        if (OpenGlHelper.useVbo()) {
            for (int j = 0; j < BlockRenderLayer.values().length; ++j) {
                this.vertexBuffers[j] = new net.minecraft.client.renderer.vertex.VertexBuffer(DefaultVertexFormats.BLOCK);
            }
        }
    }

    public boolean setFrameIndex(int p_setFrameIndex_1_) {
        if (this.frameIndex == p_setFrameIndex_1_) {
            return false;
        }
        this.frameIndex = p_setFrameIndex_1_;
        return true;
    }

    public net.minecraft.client.renderer.vertex.VertexBuffer getVertexBufferByLayer(int p_getVertexBufferByLayer_1_) {
        return this.vertexBuffers[p_getVertexBufferByLayer_1_];
    }

    public void setPosition(int p_setPosition_1_, int p_setPosition_2_, int p_setPosition_3_) {
        if (p_setPosition_1_ != this.position.getX() || p_setPosition_2_ != this.position.getY() || p_setPosition_3_ != this.position.getZ()) {
            this.stopCompileTask();
            this.position.setPos(p_setPosition_1_, p_setPosition_2_, p_setPosition_3_);
            this.boundingBox = new AxisAlignedBB(p_setPosition_1_, p_setPosition_2_, p_setPosition_3_, p_setPosition_1_ + 16, p_setPosition_2_ + 16, p_setPosition_3_ + 16);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                this.mapEnumFacing[enumfacing.ordinal()].setPos(this.position).move(enumfacing, 16);
            }
            this.initModelviewMatrix();
        }
    }

    public void resortTransparency(float p_resortTransparency_1_, float p_resortTransparency_2_, float p_resortTransparency_3_, ChunkCompileTaskGenerator p_resortTransparency_4_) {
        CompiledChunk compiledchunk = p_resortTransparency_4_.getCompiledChunk();
        if (compiledchunk.getState() != null && !compiledchunk.isLayerEmpty(BlockRenderLayer.TRANSLUCENT)) {
            this.preRenderBlocks(p_resortTransparency_4_.getRegionRenderCacheBuilder().getWorldRendererByLayer(BlockRenderLayer.TRANSLUCENT), this.position);
            p_resortTransparency_4_.getRegionRenderCacheBuilder().getWorldRendererByLayer(BlockRenderLayer.TRANSLUCENT).setVertexState(compiledchunk.getState());
            this.postRenderBlocks(BlockRenderLayer.TRANSLUCENT, p_resortTransparency_1_, p_resortTransparency_2_, p_resortTransparency_3_, p_resortTransparency_4_.getRegionRenderCacheBuilder().getWorldRendererByLayer(BlockRenderLayer.TRANSLUCENT), compiledchunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildChunk(float p_rebuildChunk_1_, float p_rebuildChunk_2_, float p_rebuildChunk_3_, ChunkCompileTaskGenerator p_rebuildChunk_4_) {
        CompiledChunk compiledchunk = new CompiledChunk();
        boolean i = true;
        BlockPos.MutableBlockPos blockpos = this.position;
        BlockPos blockpos1 = ((BlockPos)blockpos).add(15, 15, 15);
        p_rebuildChunk_4_.getLock().lock();
        try {
            if (p_rebuildChunk_4_.getStatus() != ChunkCompileTaskGenerator.Status.COMPILING) {
                return;
            }
            p_rebuildChunk_4_.setCompiledChunk(compiledchunk);
        }
        finally {
            p_rebuildChunk_4_.getLock().unlock();
        }
        VisGraph lvt_9_1_ = new VisGraph();
        HashSet lvt_10_1_ = Sets.newHashSet();
        if (!this.region.extendedLevelsInChunkCache()) {
            ++renderChunksUpdated;
            boolean[] aboolean = new boolean[BlockRenderLayer.values().length];
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.getMinecraft().getBlockRendererDispatcher();
            for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.getAllInBoxMutable(blockpos, blockpos1)) {
                TileEntitySpecialRenderer<TileEntity> tileentityspecialrenderer;
                TileEntity tileentity;
                IBlockState iblockstate = this.region.getBlockState(blockpos$mutableblockpos);
                Block block = iblockstate.getBlock();
                if (iblockstate.isOpaqueCube()) {
                    lvt_9_1_.setOpaqueCube(blockpos$mutableblockpos);
                }
                if (block.hasTileEntity(iblockstate) && (tileentity = this.region.getTileEntity(blockpos$mutableblockpos, Chunk.EnumCreateEntityType.CHECK)) != null && (tileentityspecialrenderer = TileEntityRendererDispatcher.instance.getSpecialRenderer(tileentity)) != null) {
                    compiledchunk.addTileEntity(tileentity);
                    if (tileentityspecialrenderer.isGlobalRenderer(tileentity)) {
                        lvt_10_1_.add(tileentity);
                    }
                }
                for (BlockRenderLayer blockrenderlayer1 : BlockRenderLayer.values()) {
                    if (!block.canRenderInLayer(iblockstate, blockrenderlayer1)) continue;
                    ForgeHooksClient.setRenderLayer(blockrenderlayer1);
                    int j = blockrenderlayer1.ordinal();
                    if (block.getDefaultState().getRenderType() == EnumBlockRenderType.INVISIBLE) continue;
                    VertexBuffer vertexbuffer = p_rebuildChunk_4_.getRegionRenderCacheBuilder().getWorldRendererByLayerId(j);
                    if (!compiledchunk.isLayerStarted(blockrenderlayer1)) {
                        compiledchunk.setLayerStarted(blockrenderlayer1);
                        this.preRenderBlocks(vertexbuffer, blockpos);
                    }
                    int n = j;
                    aboolean[n] = aboolean[n] | blockrendererdispatcher.renderBlock(iblockstate, blockpos$mutableblockpos, this.region, vertexbuffer);
                }
                ForgeHooksClient.setRenderLayer(null);
            }
            for (BlockRenderLayer blockrenderlayer : BlockRenderLayer.values()) {
                if (aboolean[blockrenderlayer.ordinal()]) {
                    compiledchunk.setLayerUsed(blockrenderlayer);
                }
                if (!compiledchunk.isLayerStarted(blockrenderlayer)) continue;
                this.postRenderBlocks(blockrenderlayer, p_rebuildChunk_1_, p_rebuildChunk_2_, p_rebuildChunk_3_, p_rebuildChunk_4_.getRegionRenderCacheBuilder().getWorldRendererByLayer(blockrenderlayer), compiledchunk);
            }
        }
        compiledchunk.setVisibility(lvt_9_1_.computeVisibility());
        this.lockCompileTask.lock();
        try {
            HashSet set = Sets.newHashSet((Iterable)lvt_10_1_);
            HashSet set1 = Sets.newHashSet(this.setTileEntities);
            set.removeAll(this.setTileEntities);
            set1.removeAll(lvt_10_1_);
            this.setTileEntities.clear();
            this.setTileEntities.addAll(lvt_10_1_);
            this.renderGlobal.updateTileEntities(set1, set);
        }
        finally {
            this.lockCompileTask.unlock();
        }
    }

    protected void finishCompileTask() {
        this.lockCompileTask.lock();
        try {
            if (this.compileTask != null && this.compileTask.getStatus() != ChunkCompileTaskGenerator.Status.DONE) {
                this.compileTask.finish();
                this.compileTask = null;
            }
        }
        finally {
            this.lockCompileTask.unlock();
        }
    }

    public ReentrantLock getLockCompileTask() {
        return this.lockCompileTask;
    }

    public ChunkCompileTaskGenerator makeCompileTaskChunk() {
        ChunkCompileTaskGenerator chunkcompiletaskgenerator;
        this.lockCompileTask.lock();
        try {
            this.finishCompileTask();
            this.compileTask = new ChunkCompileTaskGenerator(this, ChunkCompileTaskGenerator.Type.REBUILD_CHUNK, this.getDistanceSq());
            this.resetChunkCache();
            chunkcompiletaskgenerator = this.compileTask;
        }
        finally {
            this.lockCompileTask.unlock();
        }
        return chunkcompiletaskgenerator;
    }

    private void resetChunkCache() {
        boolean i = true;
        ChunkCache cache = this.createRegionRenderCache(this.world, this.position.add(-1, -1, -1), this.position.add(16, 16, 16), 1);
        MinecraftForgeClient.onRebuildChunk(this.world, this.position, cache);
        this.region = cache;
    }

    @Nullable
    public ChunkCompileTaskGenerator makeCompileTaskTransparency() {
        ChunkCompileTaskGenerator chunkcompiletaskgenerator;
        this.lockCompileTask.lock();
        try {
            if (this.compileTask == null || this.compileTask.getStatus() != ChunkCompileTaskGenerator.Status.PENDING) {
                ChunkCompileTaskGenerator chunkcompiletaskgenerator2;
                if (this.compileTask != null && this.compileTask.getStatus() != ChunkCompileTaskGenerator.Status.DONE) {
                    this.compileTask.finish();
                    this.compileTask = null;
                }
                this.compileTask = new ChunkCompileTaskGenerator(this, ChunkCompileTaskGenerator.Type.RESORT_TRANSPARENCY, this.getDistanceSq());
                this.compileTask.setCompiledChunk(this.compiledChunk);
                ChunkCompileTaskGenerator chunkCompileTaskGenerator = chunkcompiletaskgenerator2 = this.compileTask;
                return chunkCompileTaskGenerator;
            }
            chunkcompiletaskgenerator = null;
        }
        finally {
            this.lockCompileTask.unlock();
        }
        return chunkcompiletaskgenerator;
    }

    protected double getDistanceSq() {
        EntityPlayerSP entityplayersp = Minecraft.getMinecraft().player;
        double d0 = this.boundingBox.minX + 8.0 - entityplayersp.posX;
        double d1 = this.boundingBox.minY + 8.0 - entityplayersp.posY;
        double d2 = this.boundingBox.minZ + 8.0 - entityplayersp.posZ;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    private void preRenderBlocks(VertexBuffer p_preRenderBlocks_1_, BlockPos p_preRenderBlocks_2_) {
        p_preRenderBlocks_1_.begin(7, DefaultVertexFormats.BLOCK);
        p_preRenderBlocks_1_.setTranslation(-p_preRenderBlocks_2_.getX(), -p_preRenderBlocks_2_.getY(), -p_preRenderBlocks_2_.getZ());
    }

    private void postRenderBlocks(BlockRenderLayer p_postRenderBlocks_1_, float p_postRenderBlocks_2_, float p_postRenderBlocks_3_, float p_postRenderBlocks_4_, VertexBuffer p_postRenderBlocks_5_, CompiledChunk p_postRenderBlocks_6_) {
        if (p_postRenderBlocks_1_ == BlockRenderLayer.TRANSLUCENT && !p_postRenderBlocks_6_.isLayerEmpty(p_postRenderBlocks_1_)) {
            p_postRenderBlocks_5_.sortVertexData(p_postRenderBlocks_2_, p_postRenderBlocks_3_, p_postRenderBlocks_4_);
            p_postRenderBlocks_6_.setState(p_postRenderBlocks_5_.getVertexState());
        }
        p_postRenderBlocks_5_.finishDrawing();
    }

    private void initModelviewMatrix() {
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        float f = 1.000001f;
        GlStateManager.translate(-8.0f, -8.0f, -8.0f);
        GlStateManager.scale(1.000001f, 1.000001f, 1.000001f);
        GlStateManager.translate(8.0f, 8.0f, 8.0f);
        GlStateManager.getFloat(2982, this.modelviewMatrix);
        GlStateManager.popMatrix();
    }

    public void multModelviewMatrix() {
        GlStateManager.multMatrix(this.modelviewMatrix);
    }

    public CompiledChunk getCompiledChunk() {
        return this.compiledChunk;
    }

    public void setCompiledChunk(CompiledChunk p_setCompiledChunk_1_) {
        this.lockCompiledChunk.lock();
        try {
            this.compiledChunk = p_setCompiledChunk_1_;
        }
        finally {
            this.lockCompiledChunk.unlock();
        }
    }

    public void stopCompileTask() {
        this.finishCompileTask();
        this.compiledChunk = CompiledChunk.DUMMY;
    }

    public void deleteGlResources() {
        this.stopCompileTask();
        this.world = null;
        for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
            if (this.vertexBuffers[i] == null) continue;
            this.vertexBuffers[i].deleteGlBuffers();
        }
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public void setNeedsUpdate(boolean p_setNeedsUpdate_1_) {
        if (this.needsUpdate) {
            p_setNeedsUpdate_1_ |= this.needsUpdateCustom;
        }
        this.needsUpdate = true;
        this.needsUpdateCustom = p_setNeedsUpdate_1_;
    }

    public void clearNeedsUpdate() {
        this.needsUpdate = false;
        this.needsUpdateCustom = false;
    }

    public boolean isNeedsUpdate() {
        return this.needsUpdate;
    }

    public boolean isNeedsUpdateCustom() {
        return this.needsUpdate && this.needsUpdateCustom;
    }

    protected ChunkCache createRegionRenderCache(World p_createRegionRenderCache_1_, BlockPos p_createRegionRenderCache_2_, BlockPos p_createRegionRenderCache_3_, int p_createRegionRenderCache_4_) {
        return new ChunkCache(p_createRegionRenderCache_1_, p_createRegionRenderCache_2_, p_createRegionRenderCache_3_, p_createRegionRenderCache_4_);
    }

    public BlockPos getBlockPosOffset16(EnumFacing p_getBlockPosOffset16_1_) {
        return this.mapEnumFacing[p_getBlockPosOffset16_1_.ordinal()];
    }

    public World getWorld() {
        return this.world;
    }
}

