/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.renderer.chunk.SetVisibility;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IntegerCache;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class VisGraph {
    private static final int DX = (int)Math.pow(16.0, 0.0);
    private static final int DZ = (int)Math.pow(16.0, 1.0);
    private static final int DY = (int)Math.pow(16.0, 2.0);
    private final BitSet bitSet = new BitSet(4096);
    private static final int[] INDEX_OF_EDGES = new int[1352];
    private int empty = 4096;

    public void setOpaqueCube(BlockPos p_setOpaqueCube_1_) {
        this.bitSet.set(VisGraph.getIndex(p_setOpaqueCube_1_), true);
        --this.empty;
    }

    private static int getIndex(BlockPos p_getIndex_0_) {
        return VisGraph.getIndex(p_getIndex_0_.getX() & 0xF, p_getIndex_0_.getY() & 0xF, p_getIndex_0_.getZ() & 0xF);
    }

    private static int getIndex(int p_getIndex_0_, int p_getIndex_1_, int p_getIndex_2_) {
        return p_getIndex_0_ << 0 | p_getIndex_1_ << 8 | p_getIndex_2_ << 4;
    }

    public SetVisibility computeVisibility() {
        SetVisibility lvt_1_1_ = new SetVisibility();
        if (4096 - this.empty < 256) {
            lvt_1_1_.setAllVisible(true);
        } else if (this.empty == 0) {
            lvt_1_1_.setAllVisible(false);
        } else {
            for (int lvt_5_1_ : INDEX_OF_EDGES) {
                if (this.bitSet.get(lvt_5_1_)) continue;
                lvt_1_1_.setManyVisible(this.floodFill(lvt_5_1_));
            }
        }
        return lvt_1_1_;
    }

    public Set<EnumFacing> getVisibleFacings(BlockPos p_getVisibleFacings_1_) {
        return this.floodFill(VisGraph.getIndex(p_getVisibleFacings_1_));
    }

    private Set<EnumFacing> floodFill(int p_floodFill_1_) {
        EnumSet<EnumFacing> lvt_2_1_ = EnumSet.noneOf(EnumFacing.class);
        ArrayDeque lvt_3_1_ = Queues.newArrayDeque();
        lvt_3_1_.add(IntegerCache.getInteger(p_floodFill_1_));
        this.bitSet.set(p_floodFill_1_, true);
        while (!lvt_3_1_.isEmpty()) {
            int lvt_4_1_ = (Integer)lvt_3_1_.poll();
            this.addEdges(lvt_4_1_, lvt_2_1_);
            for (EnumFacing lvt_8_1_ : EnumFacing.values()) {
                int lvt_9_1_ = this.getNeighborIndexAtFace(lvt_4_1_, lvt_8_1_);
                if (lvt_9_1_ < 0 || this.bitSet.get(lvt_9_1_)) continue;
                this.bitSet.set(lvt_9_1_, true);
                lvt_3_1_.add(IntegerCache.getInteger(lvt_9_1_));
            }
        }
        return lvt_2_1_;
    }

    private void addEdges(int p_addEdges_1_, Set<EnumFacing> p_addEdges_2_) {
        int lvt_3_1_ = p_addEdges_1_ >> 0 & 0xF;
        if (lvt_3_1_ == 0) {
            p_addEdges_2_.add(EnumFacing.WEST);
        } else if (lvt_3_1_ == 15) {
            p_addEdges_2_.add(EnumFacing.EAST);
        }
        int lvt_4_1_ = p_addEdges_1_ >> 8 & 0xF;
        if (lvt_4_1_ == 0) {
            p_addEdges_2_.add(EnumFacing.DOWN);
        } else if (lvt_4_1_ == 15) {
            p_addEdges_2_.add(EnumFacing.UP);
        }
        int lvt_5_1_ = p_addEdges_1_ >> 4 & 0xF;
        if (lvt_5_1_ == 0) {
            p_addEdges_2_.add(EnumFacing.NORTH);
        } else if (lvt_5_1_ == 15) {
            p_addEdges_2_.add(EnumFacing.SOUTH);
        }
    }

    private int getNeighborIndexAtFace(int p_getNeighborIndexAtFace_1_, EnumFacing p_getNeighborIndexAtFace_2_) {
        switch (p_getNeighborIndexAtFace_2_) {
            case DOWN: {
                if ((p_getNeighborIndexAtFace_1_ >> 8 & 0xF) == 0) {
                    return -1;
                }
                return p_getNeighborIndexAtFace_1_ - DY;
            }
            case UP: {
                if ((p_getNeighborIndexAtFace_1_ >> 8 & 0xF) == 15) {
                    return -1;
                }
                return p_getNeighborIndexAtFace_1_ + DY;
            }
            case NORTH: {
                if ((p_getNeighborIndexAtFace_1_ >> 4 & 0xF) == 0) {
                    return -1;
                }
                return p_getNeighborIndexAtFace_1_ - DZ;
            }
            case SOUTH: {
                if ((p_getNeighborIndexAtFace_1_ >> 4 & 0xF) == 15) {
                    return -1;
                }
                return p_getNeighborIndexAtFace_1_ + DZ;
            }
            case WEST: {
                if ((p_getNeighborIndexAtFace_1_ >> 0 & 0xF) == 0) {
                    return -1;
                }
                return p_getNeighborIndexAtFace_1_ - DX;
            }
            case EAST: {
                if ((p_getNeighborIndexAtFace_1_ >> 0 & 0xF) == 15) {
                    return -1;
                }
                return p_getNeighborIndexAtFace_1_ + DX;
            }
        }
        return -1;
    }

    static {
        boolean lvt_0_1_ = false;
        int lvt_1_1_ = 15;
        int lvt_2_1_ = 0;
        for (int lvt_3_1_ = 0; lvt_3_1_ < 16; ++lvt_3_1_) {
            for (int lvt_4_1_ = 0; lvt_4_1_ < 16; ++lvt_4_1_) {
                for (int lvt_5_1_ = 0; lvt_5_1_ < 16; ++lvt_5_1_) {
                    if (lvt_3_1_ != 0 && lvt_3_1_ != 15 && lvt_4_1_ != 0 && lvt_4_1_ != 15 && lvt_5_1_ != 0 && lvt_5_1_ != 15) continue;
                    VisGraph.INDEX_OF_EDGES[lvt_2_1_++] = VisGraph.getIndex(lvt_3_1_, lvt_4_1_, lvt_5_1_);
                }
            }
        }
    }
}

