/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.color;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockColors {
    private final Map<RegistryDelegate<Block>, IBlockColor> blockColorMap = Maps.newHashMap();

    public static BlockColors init() {
        final BlockColors blockcolors = new BlockColors();
        blockcolors.registerBlockColorHandler(new IBlockColor(){

            @Override
            public int colorMultiplier(IBlockState p_colorMultiplier_1_, IBlockAccess p_colorMultiplier_2_, BlockPos p_colorMultiplier_3_, int p_colorMultiplier_4_) {
                BlockDoublePlant.EnumPlantType blockdoubleplant$enumplanttype = p_colorMultiplier_1_.getValue(BlockDoublePlant.VARIANT);
                return p_colorMultiplier_2_ != null && p_colorMultiplier_3_ != null && (blockdoubleplant$enumplanttype == BlockDoublePlant.EnumPlantType.GRASS || blockdoubleplant$enumplanttype == BlockDoublePlant.EnumPlantType.FERN) ? BiomeColorHelper.getGrassColorAtPos(p_colorMultiplier_2_, p_colorMultiplier_1_.getValue(BlockDoublePlant.HALF) == BlockDoublePlant.EnumBlockHalf.UPPER ? p_colorMultiplier_3_.down() : p_colorMultiplier_3_) : -1;
            }
        }, Blocks.DOUBLE_PLANT);
        blockcolors.registerBlockColorHandler(new IBlockColor(){

            @Override
            public int colorMultiplier(IBlockState p_colorMultiplier_1_, IBlockAccess p_colorMultiplier_2_, BlockPos p_colorMultiplier_3_, int p_colorMultiplier_4_) {
                if (p_colorMultiplier_2_ != null && p_colorMultiplier_3_ != null) {
                    TileEntity tileentity = p_colorMultiplier_2_.getTileEntity(p_colorMultiplier_3_);
                    if (tileentity instanceof TileEntityFlowerPot) {
                        Item item = ((TileEntityFlowerPot)tileentity).getFlowerPotItem();
                        IBlockState iblockstate = Block.getBlockFromItem(item).getDefaultState();
                        return blockcolors.colorMultiplier(iblockstate, p_colorMultiplier_2_, p_colorMultiplier_3_, p_colorMultiplier_4_);
                    }
                    return -1;
                }
                return -1;
            }
        }, Blocks.FLOWER_POT);
        blockcolors.registerBlockColorHandler(new IBlockColor(){

            @Override
            public int colorMultiplier(IBlockState p_colorMultiplier_1_, IBlockAccess p_colorMultiplier_2_, BlockPos p_colorMultiplier_3_, int p_colorMultiplier_4_) {
                return p_colorMultiplier_2_ != null && p_colorMultiplier_3_ != null ? BiomeColorHelper.getGrassColorAtPos(p_colorMultiplier_2_, p_colorMultiplier_3_) : ColorizerGrass.getGrassColor(0.5, 1.0);
            }
        }, Blocks.GRASS);
        blockcolors.registerBlockColorHandler(new IBlockColor(){

            @Override
            public int colorMultiplier(IBlockState p_colorMultiplier_1_, IBlockAccess p_colorMultiplier_2_, BlockPos p_colorMultiplier_3_, int p_colorMultiplier_4_) {
                BlockPlanks.EnumType blockplanks$enumtype = p_colorMultiplier_1_.getValue(BlockOldLeaf.VARIANT);
                return blockplanks$enumtype == BlockPlanks.EnumType.SPRUCE ? ColorizerFoliage.getFoliageColorPine() : (blockplanks$enumtype == BlockPlanks.EnumType.BIRCH ? ColorizerFoliage.getFoliageColorBirch() : (p_colorMultiplier_2_ != null && p_colorMultiplier_3_ != null ? BiomeColorHelper.getFoliageColorAtPos(p_colorMultiplier_2_, p_colorMultiplier_3_) : ColorizerFoliage.getFoliageColorBasic()));
            }
        }, Blocks.LEAVES);
        blockcolors.registerBlockColorHandler(new IBlockColor(){

            @Override
            public int colorMultiplier(IBlockState p_colorMultiplier_1_, IBlockAccess p_colorMultiplier_2_, BlockPos p_colorMultiplier_3_, int p_colorMultiplier_4_) {
                return p_colorMultiplier_2_ != null && p_colorMultiplier_3_ != null ? BiomeColorHelper.getFoliageColorAtPos(p_colorMultiplier_2_, p_colorMultiplier_3_) : ColorizerFoliage.getFoliageColorBasic();
            }
        }, Blocks.LEAVES2);
        blockcolors.registerBlockColorHandler(new IBlockColor(){

            @Override
            public int colorMultiplier(IBlockState p_colorMultiplier_1_, IBlockAccess p_colorMultiplier_2_, BlockPos p_colorMultiplier_3_, int p_colorMultiplier_4_) {
                return p_colorMultiplier_2_ != null && p_colorMultiplier_3_ != null ? BiomeColorHelper.getWaterColorAtPos(p_colorMultiplier_2_, p_colorMultiplier_3_) : -1;
            }
        }, Blocks.WATER, Blocks.FLOWING_WATER);
        blockcolors.registerBlockColorHandler(new IBlockColor(){

            @Override
            public int colorMultiplier(IBlockState p_colorMultiplier_1_, IBlockAccess p_colorMultiplier_2_, BlockPos p_colorMultiplier_3_, int p_colorMultiplier_4_) {
                return BlockRedstoneWire.colorMultiplier(p_colorMultiplier_1_.getValue(BlockRedstoneWire.POWER));
            }
        }, Blocks.REDSTONE_WIRE);
        blockcolors.registerBlockColorHandler(new IBlockColor(){

            @Override
            public int colorMultiplier(IBlockState p_colorMultiplier_1_, IBlockAccess p_colorMultiplier_2_, BlockPos p_colorMultiplier_3_, int p_colorMultiplier_4_) {
                return p_colorMultiplier_2_ != null && p_colorMultiplier_3_ != null ? BiomeColorHelper.getGrassColorAtPos(p_colorMultiplier_2_, p_colorMultiplier_3_) : -1;
            }
        }, Blocks.REEDS);
        blockcolors.registerBlockColorHandler(new IBlockColor(){

            @Override
            public int colorMultiplier(IBlockState p_colorMultiplier_1_, IBlockAccess p_colorMultiplier_2_, BlockPos p_colorMultiplier_3_, int p_colorMultiplier_4_) {
                int i = p_colorMultiplier_1_.getValue(BlockStem.AGE);
                int j = i * 32;
                int k = 255 - i * 8;
                int l = i * 4;
                return j << 16 | k << 8 | l;
            }
        }, Blocks.MELON_STEM, Blocks.PUMPKIN_STEM);
        blockcolors.registerBlockColorHandler(new IBlockColor(){

            @Override
            public int colorMultiplier(IBlockState p_colorMultiplier_1_, IBlockAccess p_colorMultiplier_2_, BlockPos p_colorMultiplier_3_, int p_colorMultiplier_4_) {
                return p_colorMultiplier_2_ != null && p_colorMultiplier_3_ != null ? BiomeColorHelper.getGrassColorAtPos(p_colorMultiplier_2_, p_colorMultiplier_3_) : (p_colorMultiplier_1_.getValue(BlockTallGrass.TYPE) == BlockTallGrass.EnumType.DEAD_BUSH ? 0xFFFFFF : ColorizerGrass.getGrassColor(0.5, 1.0));
            }
        }, Blocks.TALLGRASS);
        blockcolors.registerBlockColorHandler(new IBlockColor(){

            @Override
            public int colorMultiplier(IBlockState p_colorMultiplier_1_, IBlockAccess p_colorMultiplier_2_, BlockPos p_colorMultiplier_3_, int p_colorMultiplier_4_) {
                return p_colorMultiplier_2_ != null && p_colorMultiplier_3_ != null ? BiomeColorHelper.getFoliageColorAtPos(p_colorMultiplier_2_, p_colorMultiplier_3_) : ColorizerFoliage.getFoliageColorBasic();
            }
        }, Blocks.VINE);
        blockcolors.registerBlockColorHandler(new IBlockColor(){

            @Override
            public int colorMultiplier(IBlockState p_colorMultiplier_1_, IBlockAccess p_colorMultiplier_2_, BlockPos p_colorMultiplier_3_, int p_colorMultiplier_4_) {
                return p_colorMultiplier_2_ != null && p_colorMultiplier_3_ != null ? 2129968 : 7455580;
            }
        }, Blocks.WATERLILY);
        return blockcolors;
    }

    public int getColor(IBlockState p_getColor_1_) {
        IBlockColor iblockcolor = this.blockColorMap.get(p_getColor_1_.getBlock().delegate);
        if (iblockcolor != null) {
            return iblockcolor.colorMultiplier(p_getColor_1_, null, null, 0);
        }
        MapColor mapcolor = p_getColor_1_.getMapColor();
        return mapcolor != null ? mapcolor.colorValue : -1;
    }

    public int colorMultiplier(IBlockState p_colorMultiplier_1_, IBlockAccess p_colorMultiplier_2_, BlockPos p_colorMultiplier_3_, int p_colorMultiplier_4_) {
        IBlockColor iblockcolor = this.blockColorMap.get(p_colorMultiplier_1_.getBlock().delegate);
        return iblockcolor == null ? -1 : iblockcolor.colorMultiplier(p_colorMultiplier_1_, p_colorMultiplier_2_, p_colorMultiplier_3_, p_colorMultiplier_4_);
    }

    public void registerBlockColorHandler(IBlockColor p_registerBlockColorHandler_1_, Block ... p_registerBlockColorHandler_2_) {
        for (Block block : p_registerBlockColorHandler_2_) {
            if (block == null) {
                throw new IllegalArgumentException("Block registered to block color handler cannot be null!");
            }
            if (block.getRegistryName() == null) {
                throw new IllegalArgumentException("Block must be registered before assigning color handler.");
            }
            this.blockColorMap.put(block.delegate, p_registerBlockColorHandler_1_);
        }
    }
}

