/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.color;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFireworkCharge;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.potion.PotionUtils;
import net.minecraft.world.ColorizerGrass;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ItemColors {
    private final Map<RegistryDelegate<Item>, IItemColor> itemColorMap = Maps.newHashMap();

    public static ItemColors init(final BlockColors p_init_0_) {
        ItemColors itemcolors = new ItemColors();
        itemcolors.registerItemColorHandler(new IItemColor(){

            @Override
            public int getColorFromItemstack(ItemStack p_getColorFromItemstack_1_, int p_getColorFromItemstack_2_) {
                return p_getColorFromItemstack_2_ > 0 ? -1 : ((ItemArmor)p_getColorFromItemstack_1_.getItem()).getColor(p_getColorFromItemstack_1_);
            }
        }, Items.LEATHER_HELMET, Items.LEATHER_CHESTPLATE, Items.LEATHER_LEGGINGS, Items.LEATHER_BOOTS);
        itemcolors.registerItemColorHandler(new IItemColor(){

            @Override
            public int getColorFromItemstack(ItemStack p_getColorFromItemstack_1_, int p_getColorFromItemstack_2_) {
                BlockDoublePlant.EnumPlantType blockdoubleplant$enumplanttype = BlockDoublePlant.EnumPlantType.byMetadata(p_getColorFromItemstack_1_.getMetadata());
                return blockdoubleplant$enumplanttype != BlockDoublePlant.EnumPlantType.GRASS && blockdoubleplant$enumplanttype != BlockDoublePlant.EnumPlantType.FERN ? -1 : ColorizerGrass.getGrassColor(0.5, 1.0);
            }
        }, Blocks.DOUBLE_PLANT);
        itemcolors.registerItemColorHandler(new IItemColor(){

            @Override
            public int getColorFromItemstack(ItemStack p_getColorFromItemstack_1_, int p_getColorFromItemstack_2_) {
                if (p_getColorFromItemstack_2_ != 1) {
                    return -1;
                }
                NBTBase nbtbase = ItemFireworkCharge.getExplosionTag(p_getColorFromItemstack_1_, "Colors");
                if (!(nbtbase instanceof NBTTagIntArray)) {
                    return 0x8A8A8A;
                }
                int[] aint = ((NBTTagIntArray)nbtbase).getIntArray();
                if (aint.length == 1) {
                    return aint[0];
                }
                int i = 0;
                int j = 0;
                int k = 0;
                for (int l : aint) {
                    i += (l & 0xFF0000) >> 16;
                    j += (l & 0xFF00) >> 8;
                    k += (l & 0xFF) >> 0;
                }
                return (i /= aint.length) << 16 | (j /= aint.length) << 8 | (k /= aint.length);
            }
        }, Items.FIREWORK_CHARGE);
        itemcolors.registerItemColorHandler(new IItemColor(){

            @Override
            public int getColorFromItemstack(ItemStack p_getColorFromItemstack_1_, int p_getColorFromItemstack_2_) {
                return p_getColorFromItemstack_2_ > 0 ? -1 : PotionUtils.getColor(p_getColorFromItemstack_1_);
            }
        }, Items.POTIONITEM, Items.SPLASH_POTION, Items.LINGERING_POTION);
        itemcolors.registerItemColorHandler(new IItemColor(){

            @Override
            public int getColorFromItemstack(ItemStack p_getColorFromItemstack_1_, int p_getColorFromItemstack_2_) {
                EntityList.EntityEggInfo entitylist$entityegginfo = EntityList.ENTITY_EGGS.get(ItemMonsterPlacer.getNamedIdFrom(p_getColorFromItemstack_1_));
                return entitylist$entityegginfo == null ? -1 : (p_getColorFromItemstack_2_ == 0 ? entitylist$entityegginfo.primaryColor : entitylist$entityegginfo.secondaryColor);
            }
        }, Items.SPAWN_EGG);
        itemcolors.registerItemColorHandler(new IItemColor(){

            @Override
            public int getColorFromItemstack(ItemStack p_getColorFromItemstack_1_, int p_getColorFromItemstack_2_) {
                IBlockState iblockstate = ((ItemBlock)p_getColorFromItemstack_1_.getItem()).getBlock().getStateFromMeta(p_getColorFromItemstack_1_.getMetadata());
                return p_init_0_.colorMultiplier(iblockstate, null, null, p_getColorFromItemstack_2_);
            }
        }, Blocks.GRASS, Blocks.TALLGRASS, Blocks.VINE, Blocks.LEAVES, Blocks.LEAVES2, Blocks.WATERLILY);
        itemcolors.registerItemColorHandler(new IItemColor(){

            @Override
            public int getColorFromItemstack(ItemStack p_getColorFromItemstack_1_, int p_getColorFromItemstack_2_) {
                return p_getColorFromItemstack_2_ == 0 ? PotionUtils.getColor(p_getColorFromItemstack_1_) : -1;
            }
        }, Items.TIPPED_ARROW);
        itemcolors.registerItemColorHandler(new IItemColor(){

            @Override
            public int getColorFromItemstack(ItemStack p_getColorFromItemstack_1_, int p_getColorFromItemstack_2_) {
                return p_getColorFromItemstack_2_ == 0 ? -1 : ItemMap.getColor(p_getColorFromItemstack_1_);
            }
        }, Items.FILLED_MAP);
        return itemcolors;
    }

    public int getColorFromItemstack(ItemStack p_getColorFromItemstack_1_, int p_getColorFromItemstack_2_) {
        IItemColor iitemcolor = this.itemColorMap.get(p_getColorFromItemstack_1_.getItem().delegate);
        return iitemcolor == null ? -1 : iitemcolor.getColorFromItemstack(p_getColorFromItemstack_1_, p_getColorFromItemstack_2_);
    }

    public void registerItemColorHandler(IItemColor p_registerItemColorHandler_1_, Block ... p_registerItemColorHandler_2_) {
        for (Block block : p_registerItemColorHandler_2_) {
            if (block == null) {
                throw new IllegalArgumentException("Block registered to item color handler cannot be null!");
            }
            if (block.getRegistryName() == null) {
                throw new IllegalArgumentException("Block must be registered before assigning color handler.");
            }
            this.itemColorMap.put(Item.getItemFromBlock((Block)block).delegate, p_registerItemColorHandler_1_);
        }
    }

    public void registerItemColorHandler(IItemColor p_registerItemColorHandler_1_, Item ... p_registerItemColorHandler_2_) {
        for (Item item : p_registerItemColorHandler_2_) {
            if (item == null) {
                throw new IllegalArgumentException("Item registered to item color handler cannot be null!");
            }
            if (item.getRegistryName() == null) {
                throw new IllegalArgumentException("Item must be registered before assigning color handler.");
            }
            this.itemColorMap.put(item.delegate, p_registerItemColorHandler_1_);
        }
    }
}

