/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.debug.DebugRendererChunkBorder;
import net.minecraft.client.renderer.debug.DebugRendererCollisionBox;
import net.minecraft.client.renderer.debug.DebugRendererHeightMap;
import net.minecraft.client.renderer.debug.DebugRendererNeighborsUpdate;
import net.minecraft.client.renderer.debug.DebugRendererPathfinding;
import net.minecraft.client.renderer.debug.DebugRendererWater;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DebugRenderer {
    public final IDebugRenderer debugRendererPathfinding;
    public final IDebugRenderer debugRendererWater;
    public final IDebugRenderer debugRendererChunkBorder;
    public final IDebugRenderer debugRendererHeightMap;
    public final IDebugRenderer collisionBoxRenderer;
    public final IDebugRenderer field_191557_f;
    private boolean chunkBordersEnabled;
    private boolean pathfindingEnabled;
    private boolean waterEnabled;
    private boolean heightmapEnabled;
    private boolean renderCollision;
    private boolean field_191558_l;

    public DebugRenderer(Minecraft p_i46557_1_) {
        this.debugRendererPathfinding = new DebugRendererPathfinding(p_i46557_1_);
        this.debugRendererWater = new DebugRendererWater(p_i46557_1_);
        this.debugRendererChunkBorder = new DebugRendererChunkBorder(p_i46557_1_);
        this.debugRendererHeightMap = new DebugRendererHeightMap(p_i46557_1_);
        this.collisionBoxRenderer = new DebugRendererCollisionBox(p_i46557_1_);
        this.field_191557_f = new DebugRendererNeighborsUpdate(p_i46557_1_);
    }

    public boolean shouldRender() {
        return this.chunkBordersEnabled || this.pathfindingEnabled || this.waterEnabled || this.heightmapEnabled || this.renderCollision || this.field_191558_l;
    }

    public boolean toggleDebugScreen() {
        this.chunkBordersEnabled = !this.chunkBordersEnabled;
        return this.chunkBordersEnabled;
    }

    public void renderDebug(float p_renderDebug_1_, long p_renderDebug_2_) {
        if (this.pathfindingEnabled) {
            this.debugRendererPathfinding.render(p_renderDebug_1_, p_renderDebug_2_);
        }
        if (this.chunkBordersEnabled && !Minecraft.getMinecraft().isReducedDebug()) {
            this.debugRendererChunkBorder.render(p_renderDebug_1_, p_renderDebug_2_);
        }
        if (this.waterEnabled) {
            this.debugRendererWater.render(p_renderDebug_1_, p_renderDebug_2_);
        }
        if (this.heightmapEnabled) {
            this.debugRendererHeightMap.render(p_renderDebug_1_, p_renderDebug_2_);
        }
        if (this.renderCollision) {
            this.collisionBoxRenderer.render(p_renderDebug_1_, p_renderDebug_2_);
        }
        if (this.field_191558_l) {
            this.field_191557_f.render(p_renderDebug_1_, p_renderDebug_2_);
        }
    }

    public static void func_191556_a(String p_191556_0_, int p_191556_1_, int p_191556_2_, int p_191556_3_, float p_191556_4_, int p_191556_5_) {
        DebugRenderer.renderDebugText(p_191556_0_, (double)p_191556_1_ + 0.5, (double)p_191556_2_ + 0.5, (double)p_191556_3_ + 0.5, p_191556_4_, p_191556_5_);
    }

    public static void renderDebugText(String p_renderDebugText_0_, double p_renderDebugText_1_, double p_renderDebugText_3_, double p_renderDebugText_5_, float p_renderDebugText_7_, int p_renderDebugText_8_) {
        Minecraft lvt_9_1_ = Minecraft.getMinecraft();
        if (lvt_9_1_.player == null || lvt_9_1_.getRenderManager() == null || lvt_9_1_.getRenderManager().options == null) {
            return;
        }
        FontRenderer lvt_10_1_ = lvt_9_1_.fontRendererObj;
        EntityPlayerSP lvt_11_1_ = lvt_9_1_.player;
        double lvt_12_1_ = lvt_11_1_.lastTickPosX + (lvt_11_1_.posX - lvt_11_1_.lastTickPosX) * (double)p_renderDebugText_7_;
        double lvt_14_1_ = lvt_11_1_.lastTickPosY + (lvt_11_1_.posY - lvt_11_1_.lastTickPosY) * (double)p_renderDebugText_7_;
        double lvt_16_1_ = lvt_11_1_.lastTickPosZ + (lvt_11_1_.posZ - lvt_11_1_.lastTickPosZ) * (double)p_renderDebugText_7_;
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)(p_renderDebugText_1_ - lvt_12_1_), (float)(p_renderDebugText_3_ - lvt_14_1_) + 0.07f, (float)(p_renderDebugText_5_ - lvt_16_1_));
        GlStateManager.glNormal3f(0.0f, 1.0f, 0.0f);
        GlStateManager.scale(0.02f, -0.02f, 0.02f);
        RenderManager lvt_18_1_ = lvt_9_1_.getRenderManager();
        GlStateManager.rotate(-lvt_18_1_.playerViewY, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate((float)(lvt_18_1_.options.thirdPersonView == 2 ? 1 : -1) * lvt_18_1_.playerViewX, 1.0f, 0.0f, 0.0f);
        GlStateManager.disableLighting();
        GlStateManager.enableTexture2D();
        GlStateManager.enableDepth();
        GlStateManager.depthMask(true);
        GlStateManager.scale(-1.0f, 1.0f, 1.0f);
        lvt_10_1_.drawString(p_renderDebugText_0_, -lvt_10_1_.getStringWidth(p_renderDebugText_0_) / 2, 0, p_renderDebugText_8_);
        GlStateManager.enableLighting();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.popMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public static interface IDebugRenderer {
        public void render(float var1, long var2);
    }
}

