/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DebugRendererCollisionBox
implements DebugRenderer.IDebugRenderer {
    private final Minecraft mc;
    private EntityPlayer player;
    private double renderPosX;
    private double renderPosY;
    private double renderPosZ;

    public DebugRendererCollisionBox(Minecraft p_i47215_1_) {
        this.mc = p_i47215_1_;
    }

    @Override
    public void render(float p_render_1_, long p_render_2_) {
        this.player = this.mc.player;
        this.renderPosX = this.player.lastTickPosX + (this.player.posX - this.player.lastTickPosX) * (double)p_render_1_;
        this.renderPosY = this.player.lastTickPosY + (this.player.posY - this.player.lastTickPosY) * (double)p_render_1_;
        this.renderPosZ = this.player.lastTickPosZ + (this.player.posZ - this.player.lastTickPosZ) * (double)p_render_1_;
        World lvt_4_1_ = this.mc.player.world;
        List<AxisAlignedBB> lvt_5_1_ = lvt_4_1_.getCollisionBoxes(this.player, this.player.getEntityBoundingBox().expand(4.0, 4.0, 4.0));
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.glLineWidth(2.0f);
        GlStateManager.disableTexture2D();
        GlStateManager.depthMask(false);
        for (AxisAlignedBB lvt_7_1_ : lvt_5_1_) {
            RenderGlobal.drawSelectionBoundingBox(lvt_7_1_.expandXyz(0.002).offset(-this.renderPosX, -this.renderPosY, -this.renderPosZ), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        GlStateManager.depthMask(true);
        GlStateManager.enableTexture2D();
        GlStateManager.disableBlend();
    }
}

