/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DebugRendererHeightMap
implements DebugRenderer.IDebugRenderer {
    private final Minecraft minecraft;

    public DebugRendererHeightMap(Minecraft p_i47133_1_) {
        this.minecraft = p_i47133_1_;
    }

    @Override
    public void render(float p_render_1_, long p_render_2_) {
        EntityPlayerSP lvt_4_1_ = this.minecraft.player;
        WorldClient lvt_5_1_ = this.minecraft.world;
        double lvt_6_1_ = lvt_4_1_.lastTickPosX + (lvt_4_1_.posX - lvt_4_1_.lastTickPosX) * (double)p_render_1_;
        double lvt_8_1_ = lvt_4_1_.lastTickPosY + (lvt_4_1_.posY - lvt_4_1_.lastTickPosY) * (double)p_render_1_;
        double lvt_10_1_ = lvt_4_1_.lastTickPosZ + (lvt_4_1_.posZ - lvt_4_1_.lastTickPosZ) * (double)p_render_1_;
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.disableTexture2D();
        BlockPos lvt_12_1_ = new BlockPos(lvt_4_1_.posX, 0.0, lvt_4_1_.posZ);
        Iterable<BlockPos> lvt_13_1_ = BlockPos.getAllInBox(lvt_12_1_.add(-40, 0, -40), lvt_12_1_.add(40, 0, 40));
        Tessellator lvt_14_1_ = Tessellator.getInstance();
        VertexBuffer lvt_15_1_ = lvt_14_1_.getBuffer();
        lvt_15_1_.begin(5, DefaultVertexFormats.POSITION_COLOR);
        for (BlockPos lvt_17_1_ : lvt_13_1_) {
            int lvt_18_1_;
            if (lvt_5_1_.getBlockState(lvt_17_1_.add(0, lvt_18_1_ = lvt_5_1_.getHeight(lvt_17_1_.getX(), lvt_17_1_.getZ()), 0).down()) == Blocks.AIR.getDefaultState()) {
                RenderGlobal.addChainedFilledBoxVertices(lvt_15_1_, (double)((float)lvt_17_1_.getX() + 0.25f) - lvt_6_1_, (double)lvt_18_1_ - lvt_8_1_, (double)((float)lvt_17_1_.getZ() + 0.25f) - lvt_10_1_, (double)((float)lvt_17_1_.getX() + 0.75f) - lvt_6_1_, (double)lvt_18_1_ + 0.09375 - lvt_8_1_, (double)((float)lvt_17_1_.getZ() + 0.75f) - lvt_10_1_, 0.0f, 0.0f, 1.0f, 0.5f);
                continue;
            }
            RenderGlobal.addChainedFilledBoxVertices(lvt_15_1_, (double)((float)lvt_17_1_.getX() + 0.25f) - lvt_6_1_, (double)lvt_18_1_ - lvt_8_1_, (double)((float)lvt_17_1_.getZ() + 0.25f) - lvt_10_1_, (double)((float)lvt_17_1_.getX() + 0.75f) - lvt_6_1_, (double)lvt_18_1_ + 0.09375 - lvt_8_1_, (double)((float)lvt_17_1_.getZ() + 0.75f) - lvt_10_1_, 0.0f, 1.0f, 0.0f, 0.5f);
        }
        lvt_14_1_.draw();
        GlStateManager.enableTexture2D();
        GlStateManager.popMatrix();
    }
}

