/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DebugRendererPathfinding
implements DebugRenderer.IDebugRenderer {
    private final Minecraft minecraft;
    private final Map<Integer, Path> pathMap = Maps.newHashMap();
    private final Map<Integer, Float> pathMaxDistance = Maps.newHashMap();
    private final Map<Integer, Long> creationMap = Maps.newHashMap();
    private EntityPlayer player;
    private double xo;
    private double yo;
    private double zo;

    public DebugRendererPathfinding(Minecraft p_i46556_1_) {
        this.minecraft = p_i46556_1_;
    }

    public void addPath(int p_addPath_1_, Path p_addPath_2_, float p_addPath_3_) {
        this.pathMap.put(p_addPath_1_, p_addPath_2_);
        this.creationMap.put(p_addPath_1_, System.currentTimeMillis());
        this.pathMaxDistance.put(p_addPath_1_, Float.valueOf(p_addPath_3_));
    }

    @Override
    public void render(float p_render_1_, long p_render_2_) {
        if (this.pathMap.size() == 0) {
            return;
        }
        long lvt_4_1_ = System.currentTimeMillis();
        this.player = this.minecraft.player;
        this.xo = this.player.lastTickPosX + (this.player.posX - this.player.lastTickPosX) * (double)p_render_1_;
        this.yo = this.player.lastTickPosY + (this.player.posY - this.player.lastTickPosY) * (double)p_render_1_;
        this.zo = this.player.lastTickPosZ + (this.player.posZ - this.player.lastTickPosZ) * (double)p_render_1_;
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.color(0.0f, 1.0f, 0.0f, 0.75f);
        GlStateManager.disableTexture2D();
        GlStateManager.glLineWidth(6.0f);
        for (Integer lvt_7_1_ : this.pathMap.keySet()) {
            Path lvt_8_1_ = this.pathMap.get(lvt_7_1_);
            float lvt_9_1_ = this.pathMaxDistance.get(lvt_7_1_).floatValue();
            this.renderPathLine(p_render_1_, lvt_8_1_);
            PathPoint lvt_10_1_ = lvt_8_1_.getTarget();
            if (this.addDistanceToPlayer(lvt_10_1_) > 40.0f) continue;
            RenderGlobal.renderFilledBox(new AxisAlignedBB((float)lvt_10_1_.xCoord + 0.25f, (float)lvt_10_1_.yCoord + 0.25f, (double)lvt_10_1_.zCoord + 0.25, (float)lvt_10_1_.xCoord + 0.75f, (float)lvt_10_1_.yCoord + 0.75f, (float)lvt_10_1_.zCoord + 0.75f).offset(-this.xo, -this.yo, -this.zo), 0.0f, 1.0f, 0.0f, 0.5f);
            for (int lvt_11_1_ = 0; lvt_11_1_ < lvt_8_1_.getCurrentPathLength(); ++lvt_11_1_) {
                PathPoint lvt_12_1_ = lvt_8_1_.getPathPointFromIndex(lvt_11_1_);
                if (this.addDistanceToPlayer(lvt_12_1_) > 40.0f) continue;
                float lvt_13_1_ = lvt_11_1_ == lvt_8_1_.getCurrentPathIndex() ? 1.0f : 0.0f;
                float lvt_14_1_ = lvt_11_1_ == lvt_8_1_.getCurrentPathIndex() ? 0.0f : 1.0f;
                RenderGlobal.renderFilledBox(new AxisAlignedBB((float)lvt_12_1_.xCoord + 0.5f - lvt_9_1_, (float)lvt_12_1_.yCoord + 0.01f * (float)lvt_11_1_, (float)lvt_12_1_.zCoord + 0.5f - lvt_9_1_, (float)lvt_12_1_.xCoord + 0.5f + lvt_9_1_, (float)lvt_12_1_.yCoord + 0.25f + 0.01f * (float)lvt_11_1_, (float)lvt_12_1_.zCoord + 0.5f + lvt_9_1_).offset(-this.xo, -this.yo, -this.zo), lvt_13_1_, 0.0f, lvt_14_1_, 0.5f);
            }
        }
        for (Integer lvt_7_2_ : this.pathMap.keySet()) {
            Path lvt_8_2_ = this.pathMap.get(lvt_7_2_);
            for (PathPoint lvt_12_2_ : lvt_8_2_.getClosedSet()) {
                if (this.addDistanceToPlayer(lvt_12_2_) > 40.0f) continue;
                DebugRenderer.renderDebugText(String.format("%s", new Object[]{lvt_12_2_.nodeType}), (double)lvt_12_2_.xCoord + 0.5, (double)lvt_12_2_.yCoord + 0.75, (double)lvt_12_2_.zCoord + 0.5, p_render_1_, -65536);
                DebugRenderer.renderDebugText(String.format("%.2f", Float.valueOf(lvt_12_2_.costMalus)), (double)lvt_12_2_.xCoord + 0.5, (double)lvt_12_2_.yCoord + 0.25, (double)lvt_12_2_.zCoord + 0.5, p_render_1_, -65536);
            }
            for (PathPoint lvt_12_3_ : lvt_8_2_.getOpenSet()) {
                if (this.addDistanceToPlayer(lvt_12_3_) > 40.0f) continue;
                DebugRenderer.renderDebugText(String.format("%s", new Object[]{lvt_12_3_.nodeType}), (double)lvt_12_3_.xCoord + 0.5, (double)lvt_12_3_.yCoord + 0.75, (double)lvt_12_3_.zCoord + 0.5, p_render_1_, -16776961);
                DebugRenderer.renderDebugText(String.format("%.2f", Float.valueOf(lvt_12_3_.costMalus)), (double)lvt_12_3_.xCoord + 0.5, (double)lvt_12_3_.yCoord + 0.25, (double)lvt_12_3_.zCoord + 0.5, p_render_1_, -16776961);
            }
            for (int lvt_9_2_ = 0; lvt_9_2_ < lvt_8_2_.getCurrentPathLength(); ++lvt_9_2_) {
                PathPoint lvt_10_2_ = lvt_8_2_.getPathPointFromIndex(lvt_9_2_);
                if (this.addDistanceToPlayer(lvt_10_2_) > 40.0f) continue;
                DebugRenderer.renderDebugText(String.format("%s", new Object[]{lvt_10_2_.nodeType}), (double)lvt_10_2_.xCoord + 0.5, (double)lvt_10_2_.yCoord + 0.75, (double)lvt_10_2_.zCoord + 0.5, p_render_1_, -1);
                DebugRenderer.renderDebugText(String.format("%.2f", Float.valueOf(lvt_10_2_.costMalus)), (double)lvt_10_2_.xCoord + 0.5, (double)lvt_10_2_.yCoord + 0.25, (double)lvt_10_2_.zCoord + 0.5, p_render_1_, -1);
            }
        }
        for (Integer lvt_9_3_ : this.creationMap.keySet().toArray(new Integer[0])) {
            if (lvt_4_1_ - this.creationMap.get(lvt_9_3_) <= 20000L) continue;
            this.pathMap.remove(lvt_9_3_);
            this.creationMap.remove(lvt_9_3_);
        }
        GlStateManager.enableTexture2D();
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    public void renderPathLine(float p_renderPathLine_1_, Path p_renderPathLine_2_) {
        Tessellator lvt_3_1_ = Tessellator.getInstance();
        VertexBuffer lvt_4_1_ = lvt_3_1_.getBuffer();
        lvt_4_1_.begin(3, DefaultVertexFormats.POSITION_COLOR);
        for (int lvt_5_1_ = 0; lvt_5_1_ < p_renderPathLine_2_.getCurrentPathLength(); ++lvt_5_1_) {
            PathPoint lvt_6_1_ = p_renderPathLine_2_.getPathPointFromIndex(lvt_5_1_);
            if (this.addDistanceToPlayer(lvt_6_1_) > 40.0f) continue;
            float lvt_7_1_ = (float)lvt_5_1_ / (float)p_renderPathLine_2_.getCurrentPathLength() * 0.33f;
            int lvt_8_1_ = lvt_5_1_ == 0 ? 0 : MathHelper.hsvToRGB(lvt_7_1_, 0.9f, 0.9f);
            int lvt_9_1_ = lvt_8_1_ >> 16 & 0xFF;
            int lvt_10_1_ = lvt_8_1_ >> 8 & 0xFF;
            int lvt_11_1_ = lvt_8_1_ & 0xFF;
            lvt_4_1_.pos((double)lvt_6_1_.xCoord - this.xo + 0.5, (double)lvt_6_1_.yCoord - this.yo + 0.5, (double)lvt_6_1_.zCoord - this.zo + 0.5).color(lvt_9_1_, lvt_10_1_, lvt_11_1_, 255).endVertex();
        }
        lvt_3_1_.draw();
    }

    private float addDistanceToPlayer(PathPoint p_addDistanceToPlayer_1_) {
        return (float)(Math.abs((double)p_addDistanceToPlayer_1_.xCoord - this.player.posX) + Math.abs((double)p_addDistanceToPlayer_1_.yCoord - this.player.posY) + Math.abs((double)p_addDistanceToPlayer_1_.zCoord - this.player.posZ));
    }
}

