/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DebugRendererWater
implements DebugRenderer.IDebugRenderer {
    private final Minecraft minecraft;
    private EntityPlayer player;
    private double xo;
    private double yo;
    private double zo;

    public DebugRendererWater(Minecraft p_i46555_1_) {
        this.minecraft = p_i46555_1_;
    }

    @Override
    public void render(float p_render_1_, long p_render_2_) {
        this.player = this.minecraft.player;
        this.xo = this.player.lastTickPosX + (this.player.posX - this.player.lastTickPosX) * (double)p_render_1_;
        this.yo = this.player.lastTickPosY + (this.player.posY - this.player.lastTickPosY) * (double)p_render_1_;
        this.zo = this.player.lastTickPosZ + (this.player.posZ - this.player.lastTickPosZ) * (double)p_render_1_;
        BlockPos lvt_4_1_ = this.minecraft.player.getPosition();
        World lvt_5_1_ = this.minecraft.player.world;
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.color(0.0f, 1.0f, 0.0f, 0.75f);
        GlStateManager.disableTexture2D();
        GlStateManager.glLineWidth(6.0f);
        Iterable<BlockPos> lvt_6_1_ = BlockPos.getAllInBox(lvt_4_1_.add(-10, -10, -10), lvt_4_1_.add(10, 10, 10));
        for (BlockPos lvt_8_1_ : lvt_6_1_) {
            IBlockState lvt_9_1_ = lvt_5_1_.getBlockState(lvt_8_1_);
            if (lvt_9_1_.getBlock() != Blocks.WATER && lvt_9_1_.getBlock() != Blocks.FLOWING_WATER) continue;
            double lvt_10_1_ = BlockLiquid.getLiquidHeight(lvt_9_1_, lvt_5_1_, lvt_8_1_);
            RenderGlobal.renderFilledBox(new AxisAlignedBB((float)lvt_8_1_.getX() + 0.01f, (float)lvt_8_1_.getY() + 0.01f, (float)lvt_8_1_.getZ() + 0.01f, (float)lvt_8_1_.getX() + 0.99f, lvt_10_1_, (float)lvt_8_1_.getZ() + 0.99f).offset(-this.xo, -this.yo, -this.zo), 1.0f, 1.0f, 1.0f, 0.2f);
        }
        lvt_6_1_ = BlockPos.getAllInBox(lvt_4_1_.add(-10, -10, -10), lvt_4_1_.add(10, 10, 10));
        for (BlockPos lvt_8_2_ : lvt_6_1_) {
            IBlockState lvt_9_2_ = lvt_5_1_.getBlockState(lvt_8_2_);
            if (lvt_9_2_.getBlock() != Blocks.WATER && lvt_9_2_.getBlock() != Blocks.FLOWING_WATER) continue;
            Integer lvt_10_2_ = lvt_9_2_.getValue(BlockLiquid.LEVEL);
            double lvt_11_1_ = lvt_10_2_ > 7 ? 0.9 : 1.0 - 0.11 * (double)lvt_10_2_.intValue();
            String lvt_13_1_ = lvt_9_2_.getBlock() == Blocks.FLOWING_WATER ? "f" : "s";
            DebugRenderer.renderDebugText(lvt_13_1_ + " " + lvt_10_2_, (double)lvt_8_2_.getX() + 0.5, (double)lvt_8_2_.getY() + lvt_11_1_, (double)lvt_8_2_.getZ() + 0.5, p_render_1_, -16777216);
        }
        GlStateManager.enableTexture2D();
        GlStateManager.disableBlend();
    }
}

