/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class Render<T extends Entity> {
    private static final ResourceLocation SHADOW_TEXTURES = new ResourceLocation("textures/misc/shadow.png");
    protected final RenderManager renderManager;
    protected float shadowSize;
    protected float shadowOpaque = 1.0f;
    protected boolean renderOutlines;

    protected Render(RenderManager p_i46179_1_) {
        this.renderManager = p_i46179_1_;
    }

    public void setRenderOutlines(boolean p_setRenderOutlines_1_) {
        this.renderOutlines = p_setRenderOutlines_1_;
    }

    public boolean shouldRender(T p_shouldRender_1_, ICamera p_shouldRender_2_, double p_shouldRender_3_, double p_shouldRender_5_, double p_shouldRender_7_) {
        AxisAlignedBB lvt_9_1_ = ((Entity)p_shouldRender_1_).getRenderBoundingBox().expandXyz(0.5);
        if (lvt_9_1_.hasNaN() || lvt_9_1_.getAverageEdgeLength() == 0.0) {
            lvt_9_1_ = new AxisAlignedBB(((Entity)p_shouldRender_1_).posX - 2.0, ((Entity)p_shouldRender_1_).posY - 2.0, ((Entity)p_shouldRender_1_).posZ - 2.0, ((Entity)p_shouldRender_1_).posX + 2.0, ((Entity)p_shouldRender_1_).posY + 2.0, ((Entity)p_shouldRender_1_).posZ + 2.0);
        }
        return ((Entity)p_shouldRender_1_).isInRangeToRender3d(p_shouldRender_3_, p_shouldRender_5_, p_shouldRender_7_) && (((Entity)p_shouldRender_1_).ignoreFrustumCheck || p_shouldRender_2_.isBoundingBoxInFrustum(lvt_9_1_));
    }

    public void doRender(T p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        if (!this.renderOutlines) {
            this.renderName(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_);
        }
    }

    protected int getTeamColor(T p_getTeamColor_1_) {
        String lvt_4_1_;
        int lvt_2_1_ = 0xFFFFFF;
        ScorePlayerTeam lvt_3_1_ = (ScorePlayerTeam)((Entity)p_getTeamColor_1_).getTeam();
        if (lvt_3_1_ != null && (lvt_4_1_ = FontRenderer.getFormatFromString(lvt_3_1_.getColorPrefix())).length() >= 2) {
            lvt_2_1_ = this.getFontRendererFromRenderManager().getColorCode(lvt_4_1_.charAt(1));
        }
        return lvt_2_1_;
    }

    protected void renderName(T p_renderName_1_, double p_renderName_2_, double p_renderName_4_, double p_renderName_6_) {
        if (!this.canRenderName(p_renderName_1_)) {
            return;
        }
        this.renderLivingLabel(p_renderName_1_, ((Entity)p_renderName_1_).getDisplayName().getFormattedText(), p_renderName_2_, p_renderName_4_, p_renderName_6_, 64);
    }

    protected boolean canRenderName(T p_canRenderName_1_) {
        return ((Entity)p_canRenderName_1_).getAlwaysRenderNameTagForRender() && ((Entity)p_canRenderName_1_).hasCustomName();
    }

    protected void renderEntityName(T p_renderEntityName_1_, double p_renderEntityName_2_, double p_renderEntityName_4_, double p_renderEntityName_6_, String p_renderEntityName_8_, double p_renderEntityName_9_) {
        this.renderLivingLabel(p_renderEntityName_1_, p_renderEntityName_8_, p_renderEntityName_2_, p_renderEntityName_4_, p_renderEntityName_6_, 64);
    }

    @Nullable
    protected abstract ResourceLocation getEntityTexture(T var1);

    protected boolean bindEntityTexture(T p_bindEntityTexture_1_) {
        ResourceLocation lvt_2_1_ = this.getEntityTexture(p_bindEntityTexture_1_);
        if (lvt_2_1_ == null) {
            return false;
        }
        this.bindTexture(lvt_2_1_);
        return true;
    }

    public void bindTexture(ResourceLocation p_bindTexture_1_) {
        this.renderManager.renderEngine.bindTexture(p_bindTexture_1_);
    }

    private void renderEntityOnFire(Entity p_renderEntityOnFire_1_, double p_renderEntityOnFire_2_, double p_renderEntityOnFire_4_, double p_renderEntityOnFire_6_, float p_renderEntityOnFire_8_) {
        GlStateManager.disableLighting();
        TextureMap lvt_9_1_ = Minecraft.getMinecraft().getTextureMapBlocks();
        TextureAtlasSprite lvt_10_1_ = lvt_9_1_.getAtlasSprite("minecraft:blocks/fire_layer_0");
        TextureAtlasSprite lvt_11_1_ = lvt_9_1_.getAtlasSprite("minecraft:blocks/fire_layer_1");
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)p_renderEntityOnFire_2_, (float)p_renderEntityOnFire_4_, (float)p_renderEntityOnFire_6_);
        float lvt_12_1_ = p_renderEntityOnFire_1_.width * 1.4f;
        GlStateManager.scale(lvt_12_1_, lvt_12_1_, lvt_12_1_);
        Tessellator lvt_13_1_ = Tessellator.getInstance();
        VertexBuffer lvt_14_1_ = lvt_13_1_.getBuffer();
        float lvt_15_1_ = 0.5f;
        float lvt_16_1_ = 0.0f;
        float lvt_17_1_ = p_renderEntityOnFire_1_.height / lvt_12_1_;
        float lvt_18_1_ = (float)(p_renderEntityOnFire_1_.posY - p_renderEntityOnFire_1_.getEntityBoundingBox().minY);
        GlStateManager.rotate(-this.renderManager.playerViewY, 0.0f, 1.0f, 0.0f);
        GlStateManager.translate(0.0f, 0.0f, -0.3f + (float)((int)lvt_17_1_) * 0.02f);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        float lvt_19_1_ = 0.0f;
        int lvt_20_1_ = 0;
        lvt_14_1_.begin(7, DefaultVertexFormats.POSITION_TEX);
        while (lvt_17_1_ > 0.0f) {
            TextureAtlasSprite lvt_21_1_ = lvt_20_1_ % 2 == 0 ? lvt_10_1_ : lvt_11_1_;
            this.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
            float lvt_22_1_ = lvt_21_1_.getMinU();
            float lvt_23_1_ = lvt_21_1_.getMinV();
            float lvt_24_1_ = lvt_21_1_.getMaxU();
            float lvt_25_1_ = lvt_21_1_.getMaxV();
            if (lvt_20_1_ / 2 % 2 == 0) {
                float lvt_26_1_ = lvt_24_1_;
                lvt_24_1_ = lvt_22_1_;
                lvt_22_1_ = lvt_26_1_;
            }
            lvt_14_1_.pos(lvt_15_1_ - 0.0f, 0.0f - lvt_18_1_, lvt_19_1_).tex(lvt_24_1_, lvt_25_1_).endVertex();
            lvt_14_1_.pos(-lvt_15_1_ - 0.0f, 0.0f - lvt_18_1_, lvt_19_1_).tex(lvt_22_1_, lvt_25_1_).endVertex();
            lvt_14_1_.pos(-lvt_15_1_ - 0.0f, 1.4f - lvt_18_1_, lvt_19_1_).tex(lvt_22_1_, lvt_23_1_).endVertex();
            lvt_14_1_.pos(lvt_15_1_ - 0.0f, 1.4f - lvt_18_1_, lvt_19_1_).tex(lvt_24_1_, lvt_23_1_).endVertex();
            lvt_17_1_ -= 0.45f;
            lvt_18_1_ -= 0.45f;
            lvt_15_1_ *= 0.9f;
            lvt_19_1_ += 0.03f;
            ++lvt_20_1_;
        }
        lvt_13_1_.draw();
        GlStateManager.popMatrix();
        GlStateManager.enableLighting();
    }

    private void renderShadow(Entity p_renderShadow_1_, double p_renderShadow_2_, double p_renderShadow_4_, double p_renderShadow_6_, float p_renderShadow_8_, float p_renderShadow_9_) {
        GlStateManager.enableBlend();
        GlStateManager.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.renderManager.renderEngine.bindTexture(SHADOW_TEXTURES);
        World lvt_10_1_ = this.getWorldFromRenderManager();
        GlStateManager.depthMask(false);
        float lvt_11_1_ = this.shadowSize;
        if (p_renderShadow_1_ instanceof EntityLiving) {
            EntityLiving lvt_12_1_ = (EntityLiving)p_renderShadow_1_;
            lvt_11_1_ *= lvt_12_1_.getRenderSizeModifier();
            if (lvt_12_1_.isChild()) {
                lvt_11_1_ *= 0.5f;
            }
        }
        double lvt_12_2_ = p_renderShadow_1_.lastTickPosX + (p_renderShadow_1_.posX - p_renderShadow_1_.lastTickPosX) * (double)p_renderShadow_9_;
        double lvt_14_1_ = p_renderShadow_1_.lastTickPosY + (p_renderShadow_1_.posY - p_renderShadow_1_.lastTickPosY) * (double)p_renderShadow_9_;
        double lvt_16_1_ = p_renderShadow_1_.lastTickPosZ + (p_renderShadow_1_.posZ - p_renderShadow_1_.lastTickPosZ) * (double)p_renderShadow_9_;
        int lvt_18_1_ = MathHelper.floor(lvt_12_2_ - (double)lvt_11_1_);
        int lvt_19_1_ = MathHelper.floor(lvt_12_2_ + (double)lvt_11_1_);
        int lvt_20_1_ = MathHelper.floor(lvt_14_1_ - (double)lvt_11_1_);
        int lvt_21_1_ = MathHelper.floor(lvt_14_1_);
        int lvt_22_1_ = MathHelper.floor(lvt_16_1_ - (double)lvt_11_1_);
        int lvt_23_1_ = MathHelper.floor(lvt_16_1_ + (double)lvt_11_1_);
        double lvt_24_1_ = p_renderShadow_2_ - lvt_12_2_;
        double lvt_26_1_ = p_renderShadow_4_ - lvt_14_1_;
        double lvt_28_1_ = p_renderShadow_6_ - lvt_16_1_;
        Tessellator lvt_30_1_ = Tessellator.getInstance();
        VertexBuffer lvt_31_1_ = lvt_30_1_.getBuffer();
        lvt_31_1_.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
        for (BlockPos blockPos : BlockPos.getAllInBoxMutable(new BlockPos(lvt_18_1_, lvt_20_1_, lvt_22_1_), new BlockPos(lvt_19_1_, lvt_21_1_, lvt_23_1_))) {
            IBlockState lvt_34_1_ = lvt_10_1_.getBlockState(blockPos.down());
            if (lvt_34_1_.getRenderType() == EnumBlockRenderType.INVISIBLE || lvt_10_1_.getLightFromNeighbors(blockPos) <= 3) continue;
            this.renderShadowSingle(lvt_34_1_, p_renderShadow_2_, p_renderShadow_4_, p_renderShadow_6_, blockPos, p_renderShadow_8_, lvt_11_1_, lvt_24_1_, lvt_26_1_, lvt_28_1_);
        }
        lvt_30_1_.draw();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableBlend();
        GlStateManager.depthMask(true);
    }

    private World getWorldFromRenderManager() {
        return this.renderManager.world;
    }

    private void renderShadowSingle(IBlockState p_renderShadowSingle_1_, double p_renderShadowSingle_2_, double p_renderShadowSingle_4_, double p_renderShadowSingle_6_, BlockPos p_renderShadowSingle_8_, float p_renderShadowSingle_9_, float p_renderShadowSingle_10_, double p_renderShadowSingle_11_, double p_renderShadowSingle_13_, double p_renderShadowSingle_15_) {
        if (!p_renderShadowSingle_1_.isFullCube()) {
            return;
        }
        Tessellator lvt_17_1_ = Tessellator.getInstance();
        VertexBuffer lvt_18_1_ = lvt_17_1_.getBuffer();
        double lvt_19_1_ = ((double)p_renderShadowSingle_9_ - (p_renderShadowSingle_4_ - ((double)p_renderShadowSingle_8_.getY() + p_renderShadowSingle_13_)) / 2.0) * 0.5 * (double)this.getWorldFromRenderManager().getLightBrightness(p_renderShadowSingle_8_);
        if (lvt_19_1_ < 0.0) {
            return;
        }
        if (lvt_19_1_ > 1.0) {
            lvt_19_1_ = 1.0;
        }
        AxisAlignedBB lvt_21_1_ = p_renderShadowSingle_1_.getBoundingBox(this.getWorldFromRenderManager(), p_renderShadowSingle_8_);
        double lvt_22_1_ = (double)p_renderShadowSingle_8_.getX() + lvt_21_1_.minX + p_renderShadowSingle_11_;
        double lvt_24_1_ = (double)p_renderShadowSingle_8_.getX() + lvt_21_1_.maxX + p_renderShadowSingle_11_;
        double lvt_26_1_ = (double)p_renderShadowSingle_8_.getY() + lvt_21_1_.minY + p_renderShadowSingle_13_ + 0.015625;
        double lvt_28_1_ = (double)p_renderShadowSingle_8_.getZ() + lvt_21_1_.minZ + p_renderShadowSingle_15_;
        double lvt_30_1_ = (double)p_renderShadowSingle_8_.getZ() + lvt_21_1_.maxZ + p_renderShadowSingle_15_;
        float lvt_32_1_ = (float)((p_renderShadowSingle_2_ - lvt_22_1_) / 2.0 / (double)p_renderShadowSingle_10_ + 0.5);
        float lvt_33_1_ = (float)((p_renderShadowSingle_2_ - lvt_24_1_) / 2.0 / (double)p_renderShadowSingle_10_ + 0.5);
        float lvt_34_1_ = (float)((p_renderShadowSingle_6_ - lvt_28_1_) / 2.0 / (double)p_renderShadowSingle_10_ + 0.5);
        float lvt_35_1_ = (float)((p_renderShadowSingle_6_ - lvt_30_1_) / 2.0 / (double)p_renderShadowSingle_10_ + 0.5);
        lvt_18_1_.pos(lvt_22_1_, lvt_26_1_, lvt_28_1_).tex(lvt_32_1_, lvt_34_1_).color(1.0f, 1.0f, 1.0f, (float)lvt_19_1_).endVertex();
        lvt_18_1_.pos(lvt_22_1_, lvt_26_1_, lvt_30_1_).tex(lvt_32_1_, lvt_35_1_).color(1.0f, 1.0f, 1.0f, (float)lvt_19_1_).endVertex();
        lvt_18_1_.pos(lvt_24_1_, lvt_26_1_, lvt_30_1_).tex(lvt_33_1_, lvt_35_1_).color(1.0f, 1.0f, 1.0f, (float)lvt_19_1_).endVertex();
        lvt_18_1_.pos(lvt_24_1_, lvt_26_1_, lvt_28_1_).tex(lvt_33_1_, lvt_34_1_).color(1.0f, 1.0f, 1.0f, (float)lvt_19_1_).endVertex();
    }

    public static void renderOffsetAABB(AxisAlignedBB p_renderOffsetAABB_0_, double p_renderOffsetAABB_1_, double p_renderOffsetAABB_3_, double p_renderOffsetAABB_5_) {
        GlStateManager.disableTexture2D();
        Tessellator lvt_7_1_ = Tessellator.getInstance();
        VertexBuffer lvt_8_1_ = lvt_7_1_.getBuffer();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        lvt_8_1_.setTranslation(p_renderOffsetAABB_1_, p_renderOffsetAABB_3_, p_renderOffsetAABB_5_);
        lvt_8_1_.begin(7, DefaultVertexFormats.POSITION_NORMAL);
        lvt_8_1_.pos(p_renderOffsetAABB_0_.minX, p_renderOffsetAABB_0_.maxY, p_renderOffsetAABB_0_.minZ).normal(0.0f, 0.0f, -1.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.maxX, p_renderOffsetAABB_0_.maxY, p_renderOffsetAABB_0_.minZ).normal(0.0f, 0.0f, -1.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.maxX, p_renderOffsetAABB_0_.minY, p_renderOffsetAABB_0_.minZ).normal(0.0f, 0.0f, -1.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.minX, p_renderOffsetAABB_0_.minY, p_renderOffsetAABB_0_.minZ).normal(0.0f, 0.0f, -1.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.minX, p_renderOffsetAABB_0_.minY, p_renderOffsetAABB_0_.maxZ).normal(0.0f, 0.0f, 1.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.maxX, p_renderOffsetAABB_0_.minY, p_renderOffsetAABB_0_.maxZ).normal(0.0f, 0.0f, 1.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.maxX, p_renderOffsetAABB_0_.maxY, p_renderOffsetAABB_0_.maxZ).normal(0.0f, 0.0f, 1.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.minX, p_renderOffsetAABB_0_.maxY, p_renderOffsetAABB_0_.maxZ).normal(0.0f, 0.0f, 1.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.minX, p_renderOffsetAABB_0_.minY, p_renderOffsetAABB_0_.minZ).normal(0.0f, -1.0f, 0.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.maxX, p_renderOffsetAABB_0_.minY, p_renderOffsetAABB_0_.minZ).normal(0.0f, -1.0f, 0.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.maxX, p_renderOffsetAABB_0_.minY, p_renderOffsetAABB_0_.maxZ).normal(0.0f, -1.0f, 0.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.minX, p_renderOffsetAABB_0_.minY, p_renderOffsetAABB_0_.maxZ).normal(0.0f, -1.0f, 0.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.minX, p_renderOffsetAABB_0_.maxY, p_renderOffsetAABB_0_.maxZ).normal(0.0f, 1.0f, 0.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.maxX, p_renderOffsetAABB_0_.maxY, p_renderOffsetAABB_0_.maxZ).normal(0.0f, 1.0f, 0.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.maxX, p_renderOffsetAABB_0_.maxY, p_renderOffsetAABB_0_.minZ).normal(0.0f, 1.0f, 0.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.minX, p_renderOffsetAABB_0_.maxY, p_renderOffsetAABB_0_.minZ).normal(0.0f, 1.0f, 0.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.minX, p_renderOffsetAABB_0_.minY, p_renderOffsetAABB_0_.maxZ).normal(-1.0f, 0.0f, 0.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.minX, p_renderOffsetAABB_0_.maxY, p_renderOffsetAABB_0_.maxZ).normal(-1.0f, 0.0f, 0.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.minX, p_renderOffsetAABB_0_.maxY, p_renderOffsetAABB_0_.minZ).normal(-1.0f, 0.0f, 0.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.minX, p_renderOffsetAABB_0_.minY, p_renderOffsetAABB_0_.minZ).normal(-1.0f, 0.0f, 0.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.maxX, p_renderOffsetAABB_0_.minY, p_renderOffsetAABB_0_.minZ).normal(1.0f, 0.0f, 0.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.maxX, p_renderOffsetAABB_0_.maxY, p_renderOffsetAABB_0_.minZ).normal(1.0f, 0.0f, 0.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.maxX, p_renderOffsetAABB_0_.maxY, p_renderOffsetAABB_0_.maxZ).normal(1.0f, 0.0f, 0.0f).endVertex();
        lvt_8_1_.pos(p_renderOffsetAABB_0_.maxX, p_renderOffsetAABB_0_.minY, p_renderOffsetAABB_0_.maxZ).normal(1.0f, 0.0f, 0.0f).endVertex();
        lvt_7_1_.draw();
        lvt_8_1_.setTranslation(0.0, 0.0, 0.0);
        GlStateManager.enableTexture2D();
    }

    public void doRenderShadowAndFire(Entity p_doRenderShadowAndFire_1_, double p_doRenderShadowAndFire_2_, double p_doRenderShadowAndFire_4_, double p_doRenderShadowAndFire_6_, float p_doRenderShadowAndFire_8_, float p_doRenderShadowAndFire_9_) {
        double lvt_10_1_;
        float lvt_12_1_;
        if (this.renderManager.options == null) {
            return;
        }
        if (this.renderManager.options.entityShadows && this.shadowSize > 0.0f && !p_doRenderShadowAndFire_1_.isInvisible() && this.renderManager.isRenderShadow() && (lvt_12_1_ = (float)((1.0 - (lvt_10_1_ = this.renderManager.getDistanceToCamera(p_doRenderShadowAndFire_1_.posX, p_doRenderShadowAndFire_1_.posY, p_doRenderShadowAndFire_1_.posZ)) / 256.0) * (double)this.shadowOpaque)) > 0.0f) {
            this.renderShadow(p_doRenderShadowAndFire_1_, p_doRenderShadowAndFire_2_, p_doRenderShadowAndFire_4_, p_doRenderShadowAndFire_6_, lvt_12_1_, p_doRenderShadowAndFire_9_);
        }
        if (!(!p_doRenderShadowAndFire_1_.canRenderOnFire() || p_doRenderShadowAndFire_1_ instanceof EntityPlayer && ((EntityPlayer)p_doRenderShadowAndFire_1_).isSpectator())) {
            this.renderEntityOnFire(p_doRenderShadowAndFire_1_, p_doRenderShadowAndFire_2_, p_doRenderShadowAndFire_4_, p_doRenderShadowAndFire_6_, p_doRenderShadowAndFire_9_);
        }
    }

    public FontRenderer getFontRendererFromRenderManager() {
        return this.renderManager.getFontRenderer();
    }

    protected void renderLivingLabel(T p_renderLivingLabel_1_, String p_renderLivingLabel_2_, double p_renderLivingLabel_3_, double p_renderLivingLabel_5_, double p_renderLivingLabel_7_, int p_renderLivingLabel_9_) {
        double lvt_10_1_ = ((Entity)p_renderLivingLabel_1_).getDistanceSqToEntity(this.renderManager.renderViewEntity);
        if (lvt_10_1_ > (double)(p_renderLivingLabel_9_ * p_renderLivingLabel_9_)) {
            return;
        }
        boolean lvt_12_1_ = ((Entity)p_renderLivingLabel_1_).isSneaking();
        float lvt_13_1_ = this.renderManager.playerViewY;
        float lvt_14_1_ = this.renderManager.playerViewX;
        boolean lvt_15_1_ = this.renderManager.options.thirdPersonView == 2;
        float lvt_16_1_ = ((Entity)p_renderLivingLabel_1_).height + 0.5f - (lvt_12_1_ ? 0.25f : 0.0f);
        int lvt_17_1_ = "deadmau5".equals(p_renderLivingLabel_2_) ? -10 : 0;
        EntityRenderer.drawNameplate(this.getFontRendererFromRenderManager(), p_renderLivingLabel_2_, (float)p_renderLivingLabel_3_, (float)p_renderLivingLabel_5_ + lvt_16_1_, (float)p_renderLivingLabel_7_, lvt_17_1_, lvt_13_1_, lvt_14_1_, lvt_15_1_, lvt_12_1_);
    }

    public RenderManager getRenderManager() {
        return this.renderManager;
    }

    public boolean isMultipass() {
        return false;
    }

    public void renderMultipass(T p_renderMultipass_1_, double p_renderMultipass_2_, double p_renderMultipass_4_, double p_renderMultipass_6_, float p_renderMultipass_8_, float p_renderMultipass_9_) {
    }
}

