/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.model.ModelHorse;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntityZombieHorse;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderAbstractHorse
extends RenderLiving<AbstractHorse> {
    private static final Map<Class<?>, ResourceLocation> MAP = Maps.newHashMap();
    private final float scale;

    public RenderAbstractHorse(RenderManager p_i47212_1_) {
        this(p_i47212_1_, 1.0f);
    }

    public RenderAbstractHorse(RenderManager p_i47213_1_, float p_i47213_2_) {
        super(p_i47213_1_, new ModelHorse(), 0.75f);
        this.scale = p_i47213_2_;
    }

    @Override
    protected void preRenderCallback(AbstractHorse p_preRenderCallback_1_, float p_preRenderCallback_2_) {
        GlStateManager.scale(this.scale, this.scale, this.scale);
        super.preRenderCallback(p_preRenderCallback_1_, p_preRenderCallback_2_);
    }

    @Override
    protected ResourceLocation getEntityTexture(AbstractHorse p_getEntityTexture_1_) {
        return MAP.get(p_getEntityTexture_1_.getClass());
    }

    static {
        MAP.put(EntityDonkey.class, new ResourceLocation("textures/entity/horse/donkey.png"));
        MAP.put(EntityMule.class, new ResourceLocation("textures/entity/horse/mule.png"));
        MAP.put(EntityZombieHorse.class, new ResourceLocation("textures/entity/horse/horse_zombie.png"));
        MAP.put(EntitySkeletonHorse.class, new ResourceLocation("textures/entity/horse/horse_skeleton.png"));
    }
}

