/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelArmorStand;
import net.minecraft.client.model.ModelArmorStandArmor;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderArmorStand
extends RenderLivingBase<EntityArmorStand> {
    public static final ResourceLocation TEXTURE_ARMOR_STAND = new ResourceLocation("textures/entity/armorstand/wood.png");

    public RenderArmorStand(RenderManager p_i46195_1_) {
        super(p_i46195_1_, new ModelArmorStand(), 0.0f);
        LayerBipedArmor lvt_2_1_ = new LayerBipedArmor(this){

            @Override
            protected void initArmor() {
                this.modelLeggings = new ModelArmorStandArmor(0.5f);
                this.modelArmor = new ModelArmorStandArmor(1.0f);
            }
        };
        this.addLayer(lvt_2_1_);
        this.addLayer(new LayerHeldItem(this));
        this.addLayer(new LayerElytra(this));
        this.addLayer(new LayerCustomHead(this.getMainModel().bipedHead));
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityArmorStand p_getEntityTexture_1_) {
        return TEXTURE_ARMOR_STAND;
    }

    @Override
    public ModelArmorStand getMainModel() {
        return (ModelArmorStand)super.getMainModel();
    }

    @Override
    protected void applyRotations(EntityArmorStand p_applyRotations_1_, float p_applyRotations_2_, float p_applyRotations_3_, float p_applyRotations_4_) {
        GlStateManager.rotate(180.0f - p_applyRotations_3_, 0.0f, 1.0f, 0.0f);
        float lvt_5_1_ = (float)(p_applyRotations_1_.world.getTotalWorldTime() - p_applyRotations_1_.punchCooldown) + p_applyRotations_4_;
        if (lvt_5_1_ < 5.0f) {
            GlStateManager.rotate(MathHelper.sin(lvt_5_1_ / 1.5f * (float)Math.PI) * 3.0f, 0.0f, 1.0f, 0.0f);
        }
    }

    @Override
    protected boolean canRenderName(EntityArmorStand p_canRenderName_1_) {
        return p_canRenderName_1_.getAlwaysRenderNameTag();
    }

    @Override
    public void doRender(EntityArmorStand p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        if (p_doRender_1_.hasMarker()) {
            this.renderMarker = true;
        }
        super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
        if (p_doRender_1_.hasMarker()) {
            this.renderMarker = false;
        }
    }

    @Override
    protected /* synthetic */ boolean canRenderName(EntityLivingBase p_canRenderName_1_) {
        return this.canRenderName((EntityArmorStand)p_canRenderName_1_);
    }

    @Override
    public /* synthetic */ ModelBase getMainModel() {
        return this.getMainModel();
    }
}

