/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.IMultipassModel;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBoat;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBoat
extends Render<EntityBoat> {
    private static final ResourceLocation[] BOAT_TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/boat/boat_oak.png"), new ResourceLocation("textures/entity/boat/boat_spruce.png"), new ResourceLocation("textures/entity/boat/boat_birch.png"), new ResourceLocation("textures/entity/boat/boat_jungle.png"), new ResourceLocation("textures/entity/boat/boat_acacia.png"), new ResourceLocation("textures/entity/boat/boat_darkoak.png")};
    protected ModelBase modelBoat = new ModelBoat();

    public RenderBoat(RenderManager p_i46190_1_) {
        super(p_i46190_1_);
        this.shadowSize = 0.5f;
    }

    @Override
    public void doRender(EntityBoat p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        GlStateManager.pushMatrix();
        this.setupTranslation(p_doRender_2_, p_doRender_4_, p_doRender_6_);
        this.setupRotation(p_doRender_1_, p_doRender_8_, p_doRender_9_);
        this.bindEntityTexture(p_doRender_1_);
        if (this.renderOutlines) {
            GlStateManager.enableColorMaterial();
            GlStateManager.enableOutlineMode(this.getTeamColor(p_doRender_1_));
        }
        this.modelBoat.render(p_doRender_1_, p_doRender_9_, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        if (this.renderOutlines) {
            GlStateManager.disableOutlineMode();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.popMatrix();
        super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
    }

    public void setupRotation(EntityBoat p_setupRotation_1_, float p_setupRotation_2_, float p_setupRotation_3_) {
        GlStateManager.rotate(180.0f - p_setupRotation_2_, 0.0f, 1.0f, 0.0f);
        float lvt_4_1_ = (float)p_setupRotation_1_.getTimeSinceHit() - p_setupRotation_3_;
        float lvt_5_1_ = p_setupRotation_1_.getDamageTaken() - p_setupRotation_3_;
        if (lvt_5_1_ < 0.0f) {
            lvt_5_1_ = 0.0f;
        }
        if (lvt_4_1_ > 0.0f) {
            GlStateManager.rotate(MathHelper.sin(lvt_4_1_) * lvt_4_1_ * lvt_5_1_ / 10.0f * (float)p_setupRotation_1_.getForwardDirection(), 1.0f, 0.0f, 0.0f);
        }
        GlStateManager.scale(-1.0f, -1.0f, 1.0f);
    }

    public void setupTranslation(double p_setupTranslation_1_, double p_setupTranslation_3_, double p_setupTranslation_5_) {
        GlStateManager.translate((float)p_setupTranslation_1_, (float)p_setupTranslation_3_ + 0.375f, (float)p_setupTranslation_5_);
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityBoat p_getEntityTexture_1_) {
        return BOAT_TEXTURES[p_getEntityTexture_1_.getBoatType().ordinal()];
    }

    @Override
    public boolean isMultipass() {
        return true;
    }

    @Override
    public void renderMultipass(EntityBoat p_renderMultipass_1_, double p_renderMultipass_2_, double p_renderMultipass_4_, double p_renderMultipass_6_, float p_renderMultipass_8_, float p_renderMultipass_9_) {
        GlStateManager.pushMatrix();
        this.setupTranslation(p_renderMultipass_2_, p_renderMultipass_4_, p_renderMultipass_6_);
        this.setupRotation(p_renderMultipass_1_, p_renderMultipass_8_, p_renderMultipass_9_);
        this.bindEntityTexture(p_renderMultipass_1_);
        ((IMultipassModel)((Object)this.modelBoat)).renderMultipass(p_renderMultipass_1_, p_renderMultipass_9_, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.popMatrix();
    }
}

