/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelCreeper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerCreeperCharge;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderCreeper
extends RenderLiving<EntityCreeper> {
    private static final ResourceLocation CREEPER_TEXTURES = new ResourceLocation("textures/entity/creeper/creeper.png");

    public RenderCreeper(RenderManager p_i46186_1_) {
        super(p_i46186_1_, new ModelCreeper(), 0.5f);
        this.addLayer(new LayerCreeperCharge(this));
    }

    @Override
    protected void preRenderCallback(EntityCreeper p_preRenderCallback_1_, float p_preRenderCallback_2_) {
        float lvt_3_1_ = p_preRenderCallback_1_.getCreeperFlashIntensity(p_preRenderCallback_2_);
        float lvt_4_1_ = 1.0f + MathHelper.sin(lvt_3_1_ * 100.0f) * lvt_3_1_ * 0.01f;
        lvt_3_1_ = MathHelper.clamp(lvt_3_1_, 0.0f, 1.0f);
        lvt_3_1_ *= lvt_3_1_;
        lvt_3_1_ *= lvt_3_1_;
        float lvt_5_1_ = (1.0f + lvt_3_1_ * 0.4f) * lvt_4_1_;
        float lvt_6_1_ = (1.0f + lvt_3_1_ * 0.1f) / lvt_4_1_;
        GlStateManager.scale(lvt_5_1_, lvt_6_1_, lvt_5_1_);
    }

    @Override
    protected int getColorMultiplier(EntityCreeper p_getColorMultiplier_1_, float p_getColorMultiplier_2_, float p_getColorMultiplier_3_) {
        float lvt_4_1_ = p_getColorMultiplier_1_.getCreeperFlashIntensity(p_getColorMultiplier_3_);
        if ((int)(lvt_4_1_ * 10.0f) % 2 == 0) {
            return 0;
        }
        int lvt_5_1_ = (int)(lvt_4_1_ * 0.2f * 255.0f);
        lvt_5_1_ = MathHelper.clamp(lvt_5_1_, 0, 255);
        return lvt_5_1_ << 24 | 0x30FFFFFF;
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityCreeper p_getEntityTexture_1_) {
        return CREEPER_TEXTURES;
    }
}

