/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelDragon;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerEnderDragonDeath;
import net.minecraft.client.renderer.entity.layers.LayerEnderDragonEyes;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderDragon
extends RenderLiving<EntityDragon> {
    public static final ResourceLocation ENDERCRYSTAL_BEAM_TEXTURES = new ResourceLocation("textures/entity/endercrystal/endercrystal_beam.png");
    private static final ResourceLocation DRAGON_EXPLODING_TEXTURES = new ResourceLocation("textures/entity/enderdragon/dragon_exploding.png");
    private static final ResourceLocation DRAGON_TEXTURES = new ResourceLocation("textures/entity/enderdragon/dragon.png");

    public RenderDragon(RenderManager p_i46183_1_) {
        super(p_i46183_1_, new ModelDragon(0.0f), 0.5f);
        this.addLayer(new LayerEnderDragonEyes(this));
        this.addLayer(new LayerEnderDragonDeath());
    }

    @Override
    protected void applyRotations(EntityDragon p_applyRotations_1_, float p_applyRotations_2_, float p_applyRotations_3_, float p_applyRotations_4_) {
        float lvt_5_1_ = (float)p_applyRotations_1_.getMovementOffsets(7, p_applyRotations_4_)[0];
        float lvt_6_1_ = (float)(p_applyRotations_1_.getMovementOffsets(5, p_applyRotations_4_)[1] - p_applyRotations_1_.getMovementOffsets(10, p_applyRotations_4_)[1]);
        GlStateManager.rotate(-lvt_5_1_, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate(lvt_6_1_ * 10.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.translate(0.0f, 0.0f, 1.0f);
        if (p_applyRotations_1_.deathTime > 0) {
            float lvt_7_1_ = ((float)p_applyRotations_1_.deathTime + p_applyRotations_4_ - 1.0f) / 20.0f * 1.6f;
            if ((lvt_7_1_ = MathHelper.sqrt(lvt_7_1_)) > 1.0f) {
                lvt_7_1_ = 1.0f;
            }
            GlStateManager.rotate(lvt_7_1_ * this.getDeathMaxRotation(p_applyRotations_1_), 0.0f, 0.0f, 1.0f);
        }
    }

    @Override
    protected void renderModel(EntityDragon p_renderModel_1_, float p_renderModel_2_, float p_renderModel_3_, float p_renderModel_4_, float p_renderModel_5_, float p_renderModel_6_, float p_renderModel_7_) {
        if (p_renderModel_1_.deathTicks > 0) {
            float lvt_8_1_ = (float)p_renderModel_1_.deathTicks / 200.0f;
            GlStateManager.depthFunc(515);
            GlStateManager.enableAlpha();
            GlStateManager.alphaFunc(516, lvt_8_1_);
            this.bindTexture(DRAGON_EXPLODING_TEXTURES);
            this.mainModel.render(p_renderModel_1_, p_renderModel_2_, p_renderModel_3_, p_renderModel_4_, p_renderModel_5_, p_renderModel_6_, p_renderModel_7_);
            GlStateManager.alphaFunc(516, 0.1f);
            GlStateManager.depthFunc(514);
        }
        this.bindEntityTexture(p_renderModel_1_);
        this.mainModel.render(p_renderModel_1_, p_renderModel_2_, p_renderModel_3_, p_renderModel_4_, p_renderModel_5_, p_renderModel_6_, p_renderModel_7_);
        if (p_renderModel_1_.hurtTime > 0) {
            GlStateManager.depthFunc(514);
            GlStateManager.disableTexture2D();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.color(1.0f, 0.0f, 0.0f, 0.5f);
            this.mainModel.render(p_renderModel_1_, p_renderModel_2_, p_renderModel_3_, p_renderModel_4_, p_renderModel_5_, p_renderModel_6_, p_renderModel_7_);
            GlStateManager.enableTexture2D();
            GlStateManager.disableBlend();
            GlStateManager.depthFunc(515);
        }
    }

    @Override
    public void doRender(EntityDragon p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
        if (p_doRender_1_.healingEnderCrystal != null) {
            this.bindTexture(ENDERCRYSTAL_BEAM_TEXTURES);
            float lvt_10_1_ = MathHelper.sin(((float)p_doRender_1_.healingEnderCrystal.ticksExisted + p_doRender_9_) * 0.2f) / 2.0f + 0.5f;
            lvt_10_1_ = (lvt_10_1_ * lvt_10_1_ + lvt_10_1_) * 0.2f;
            RenderDragon.renderCrystalBeams(p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_9_, p_doRender_1_.posX + (p_doRender_1_.prevPosX - p_doRender_1_.posX) * (double)(1.0f - p_doRender_9_), p_doRender_1_.posY + (p_doRender_1_.prevPosY - p_doRender_1_.posY) * (double)(1.0f - p_doRender_9_), p_doRender_1_.posZ + (p_doRender_1_.prevPosZ - p_doRender_1_.posZ) * (double)(1.0f - p_doRender_9_), p_doRender_1_.ticksExisted, p_doRender_1_.healingEnderCrystal.posX, (double)lvt_10_1_ + p_doRender_1_.healingEnderCrystal.posY, p_doRender_1_.healingEnderCrystal.posZ);
        }
    }

    public static void renderCrystalBeams(double p_renderCrystalBeams_0_, double p_renderCrystalBeams_2_, double p_renderCrystalBeams_4_, float p_renderCrystalBeams_6_, double p_renderCrystalBeams_7_, double p_renderCrystalBeams_9_, double p_renderCrystalBeams_11_, int p_renderCrystalBeams_13_, double p_renderCrystalBeams_14_, double p_renderCrystalBeams_16_, double p_renderCrystalBeams_18_) {
        float lvt_20_1_ = (float)(p_renderCrystalBeams_14_ - p_renderCrystalBeams_7_);
        float lvt_21_1_ = (float)(p_renderCrystalBeams_16_ - 1.0 - p_renderCrystalBeams_9_);
        float lvt_22_1_ = (float)(p_renderCrystalBeams_18_ - p_renderCrystalBeams_11_);
        float lvt_23_1_ = MathHelper.sqrt(lvt_20_1_ * lvt_20_1_ + lvt_22_1_ * lvt_22_1_);
        float lvt_24_1_ = MathHelper.sqrt(lvt_20_1_ * lvt_20_1_ + lvt_21_1_ * lvt_21_1_ + lvt_22_1_ * lvt_22_1_);
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)p_renderCrystalBeams_0_, (float)p_renderCrystalBeams_2_ + 2.0f, (float)p_renderCrystalBeams_4_);
        GlStateManager.rotate((float)(-Math.atan2(lvt_22_1_, lvt_20_1_)) * 57.295776f - 90.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate((float)(-Math.atan2(lvt_23_1_, lvt_21_1_)) * 57.295776f - 90.0f, 1.0f, 0.0f, 0.0f);
        Tessellator lvt_25_1_ = Tessellator.getInstance();
        VertexBuffer lvt_26_1_ = lvt_25_1_.getBuffer();
        RenderHelper.disableStandardItemLighting();
        GlStateManager.disableCull();
        GlStateManager.shadeModel(7425);
        float lvt_27_1_ = 0.0f - ((float)p_renderCrystalBeams_13_ + p_renderCrystalBeams_6_) * 0.01f;
        float lvt_28_1_ = MathHelper.sqrt(lvt_20_1_ * lvt_20_1_ + lvt_21_1_ * lvt_21_1_ + lvt_22_1_ * lvt_22_1_) / 32.0f - ((float)p_renderCrystalBeams_13_ + p_renderCrystalBeams_6_) * 0.01f;
        lvt_26_1_.begin(5, DefaultVertexFormats.POSITION_TEX_COLOR);
        int lvt_29_1_ = 8;
        for (int lvt_30_1_ = 0; lvt_30_1_ <= 8; ++lvt_30_1_) {
            float lvt_31_1_ = MathHelper.sin((float)(lvt_30_1_ % 8) * ((float)Math.PI * 2) / 8.0f) * 0.75f;
            float lvt_32_1_ = MathHelper.cos((float)(lvt_30_1_ % 8) * ((float)Math.PI * 2) / 8.0f) * 0.75f;
            float lvt_33_1_ = (float)(lvt_30_1_ % 8) / 8.0f;
            lvt_26_1_.pos(lvt_31_1_ * 0.2f, lvt_32_1_ * 0.2f, 0.0).tex(lvt_33_1_, lvt_27_1_).color(0, 0, 0, 255).endVertex();
            lvt_26_1_.pos(lvt_31_1_, lvt_32_1_, lvt_24_1_).tex(lvt_33_1_, lvt_28_1_).color(255, 255, 255, 255).endVertex();
        }
        lvt_25_1_.draw();
        GlStateManager.enableCull();
        GlStateManager.shadeModel(7424);
        RenderHelper.enableStandardItemLighting();
        GlStateManager.popMatrix();
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityDragon p_getEntityTexture_1_) {
        return DRAGON_TEXTURES;
    }
}

