/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import java.util.Random;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderEntityItem
extends Render<EntityItem> {
    private final RenderItem itemRenderer;
    private final Random random = new Random();

    public RenderEntityItem(RenderManager p_i46167_1_, RenderItem p_i46167_2_) {
        super(p_i46167_1_);
        this.itemRenderer = p_i46167_2_;
        this.shadowSize = 0.15f;
        this.shadowOpaque = 0.75f;
    }

    private int transformModelCount(EntityItem p_transformModelCount_1_, double p_transformModelCount_2_, double p_transformModelCount_4_, double p_transformModelCount_6_, float p_transformModelCount_8_, IBakedModel p_transformModelCount_9_) {
        ItemStack itemstack = p_transformModelCount_1_.getEntityItem();
        Item item = itemstack.getItem();
        if (item == null) {
            return 0;
        }
        boolean flag = p_transformModelCount_9_.isGui3d();
        int i = this.getModelCount(itemstack);
        float f = 0.25f;
        float f1 = this.shouldBob() ? MathHelper.sin(((float)p_transformModelCount_1_.getAge() + p_transformModelCount_8_) / 10.0f + p_transformModelCount_1_.hoverStart) * 0.1f + 0.1f : 0.0f;
        float f2 = p_transformModelCount_9_.getItemCameraTransforms().getTransform((ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND).scale.y;
        GlStateManager.translate((float)p_transformModelCount_2_, (float)p_transformModelCount_4_ + f1 + 0.25f * f2, (float)p_transformModelCount_6_);
        if (flag || this.renderManager.options != null) {
            float f3 = (((float)p_transformModelCount_1_.getAge() + p_transformModelCount_8_) / 20.0f + p_transformModelCount_1_.hoverStart) * 57.295776f;
            GlStateManager.rotate(f3, 0.0f, 1.0f, 0.0f);
        }
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        return i;
    }

    protected int getModelCount(ItemStack p_getModelCount_1_) {
        int i = 1;
        if (p_getModelCount_1_.getCount() > 48) {
            i = 5;
        } else if (p_getModelCount_1_.getCount() > 32) {
            i = 4;
        } else if (p_getModelCount_1_.getCount() > 16) {
            i = 3;
        } else if (p_getModelCount_1_.getCount() > 1) {
            i = 2;
        }
        return i;
    }

    @Override
    public void doRender(EntityItem p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        ItemStack itemstack = p_doRender_1_.getEntityItem();
        int i = itemstack.isEmpty() ? 187 : Item.getIdFromItem(itemstack.getItem()) + itemstack.getMetadata();
        this.random.setSeed(i);
        boolean flag = false;
        if (this.bindEntityTexture(p_doRender_1_)) {
            this.renderManager.renderEngine.getTexture(this.getEntityTexture(p_doRender_1_)).setBlurMipmap(false, false);
            flag = true;
        }
        GlStateManager.enableRescaleNormal();
        GlStateManager.alphaFunc(516, 0.1f);
        GlStateManager.enableBlend();
        RenderHelper.enableStandardItemLighting();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.pushMatrix();
        IBakedModel ibakedmodel = this.itemRenderer.getItemModelWithOverrides(itemstack, p_doRender_1_.world, null);
        int j = this.transformModelCount(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_9_, ibakedmodel);
        boolean flag1 = ibakedmodel.isGui3d();
        if (!flag1) {
            float f3 = -0.0f * (float)(j - 1) * 0.5f;
            float f4 = -0.0f * (float)(j - 1) * 0.5f;
            float f5 = -0.09375f * (float)(j - 1) * 0.5f;
            GlStateManager.translate(f3, f4, f5);
        }
        if (this.renderOutlines) {
            GlStateManager.enableColorMaterial();
            GlStateManager.enableOutlineMode(this.getTeamColor(p_doRender_1_));
        }
        for (int k = 0; k < j; ++k) {
            if (flag1) {
                GlStateManager.pushMatrix();
                if (k > 0) {
                    float f7 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f9 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f6 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    GlStateManager.translate(this.shouldSpreadItems() ? f7 : 0.0f, this.shouldSpreadItems() ? f9 : 0.0f, f6);
                }
                ibakedmodel = ForgeHooksClient.handleCameraTransforms(ibakedmodel, ItemCameraTransforms.TransformType.GROUND, false);
                this.itemRenderer.renderItem(itemstack, ibakedmodel);
                GlStateManager.popMatrix();
                continue;
            }
            GlStateManager.pushMatrix();
            if (k > 0) {
                float f8 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                float f10 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                GlStateManager.translate(f8, f10, 0.0f);
            }
            ibakedmodel = ForgeHooksClient.handleCameraTransforms(ibakedmodel, ItemCameraTransforms.TransformType.GROUND, false);
            this.itemRenderer.renderItem(itemstack, ibakedmodel);
            GlStateManager.popMatrix();
            GlStateManager.translate(0.0f, 0.0f, 0.09375f);
        }
        if (this.renderOutlines) {
            GlStateManager.disableOutlineMode();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.popMatrix();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableBlend();
        this.bindEntityTexture(p_doRender_1_);
        if (flag) {
            this.renderManager.renderEngine.getTexture(this.getEntityTexture(p_doRender_1_)).restoreLastBlurMipmap();
        }
        super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityItem p_getEntityTexture_1_) {
        return TextureMap.LOCATION_BLOCKS_TEXTURE;
    }

    public boolean shouldSpreadItems() {
        return true;
    }

    public boolean shouldBob() {
        return true;
    }
}

