/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderFallingBlock
extends Render<EntityFallingBlock> {
    public RenderFallingBlock(RenderManager p_i46177_1_) {
        super(p_i46177_1_);
        this.shadowSize = 0.5f;
    }

    @Override
    public void doRender(EntityFallingBlock p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        if (p_doRender_1_.getBlock() == null) {
            return;
        }
        IBlockState lvt_10_1_ = p_doRender_1_.getBlock();
        if (lvt_10_1_.getRenderType() != EnumBlockRenderType.MODEL) {
            return;
        }
        World lvt_11_1_ = p_doRender_1_.getWorldObj();
        if (lvt_10_1_ == lvt_11_1_.getBlockState(new BlockPos(p_doRender_1_)) || lvt_10_1_.getRenderType() == EnumBlockRenderType.INVISIBLE) {
            return;
        }
        this.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        GlStateManager.pushMatrix();
        GlStateManager.disableLighting();
        Tessellator lvt_12_1_ = Tessellator.getInstance();
        VertexBuffer lvt_13_1_ = lvt_12_1_.getBuffer();
        if (this.renderOutlines) {
            GlStateManager.enableColorMaterial();
            GlStateManager.enableOutlineMode(this.getTeamColor(p_doRender_1_));
        }
        lvt_13_1_.begin(7, DefaultVertexFormats.BLOCK);
        BlockPos lvt_14_1_ = new BlockPos(p_doRender_1_.posX, p_doRender_1_.getEntityBoundingBox().maxY, p_doRender_1_.posZ);
        GlStateManager.translate((float)(p_doRender_2_ - (double)lvt_14_1_.getX() - 0.5), (float)(p_doRender_4_ - (double)lvt_14_1_.getY()), (float)(p_doRender_6_ - (double)lvt_14_1_.getZ() - 0.5));
        BlockRendererDispatcher lvt_15_1_ = Minecraft.getMinecraft().getBlockRendererDispatcher();
        lvt_15_1_.getBlockModelRenderer().renderModel(lvt_11_1_, lvt_15_1_.getModelForState(lvt_10_1_), lvt_10_1_, lvt_14_1_, lvt_13_1_, false, MathHelper.getPositionRandom(p_doRender_1_.getOrigin()));
        lvt_12_1_.draw();
        if (this.renderOutlines) {
            GlStateManager.disableOutlineMode();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
        super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityFallingBlock p_getEntityTexture_1_) {
        return TextureMap.LOCATION_BLOCKS_TEXTURE;
    }
}

