/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderFireball
extends Render<EntityFireball> {
    private final float scale;

    public RenderFireball(RenderManager p_i46176_1_, float p_i46176_2_) {
        super(p_i46176_1_);
        this.scale = p_i46176_2_;
    }

    @Override
    public void doRender(EntityFireball p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        GlStateManager.pushMatrix();
        this.bindEntityTexture(p_doRender_1_);
        GlStateManager.translate((float)p_doRender_2_, (float)p_doRender_4_, (float)p_doRender_6_);
        GlStateManager.enableRescaleNormal();
        GlStateManager.scale(this.scale, this.scale, this.scale);
        TextureAtlasSprite lvt_10_1_ = Minecraft.getMinecraft().getRenderItem().getItemModelMesher().getParticleIcon(Items.FIRE_CHARGE);
        Tessellator lvt_11_1_ = Tessellator.getInstance();
        VertexBuffer lvt_12_1_ = lvt_11_1_.getBuffer();
        float lvt_13_1_ = lvt_10_1_.getMinU();
        float lvt_14_1_ = lvt_10_1_.getMaxU();
        float lvt_15_1_ = lvt_10_1_.getMinV();
        float lvt_16_1_ = lvt_10_1_.getMaxV();
        float lvt_17_1_ = 1.0f;
        float lvt_18_1_ = 0.5f;
        float lvt_19_1_ = 0.25f;
        GlStateManager.rotate(180.0f - this.renderManager.playerViewY, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate((float)(this.renderManager.options.thirdPersonView == 2 ? -1 : 1) * -this.renderManager.playerViewX, 1.0f, 0.0f, 0.0f);
        if (this.renderOutlines) {
            GlStateManager.enableColorMaterial();
            GlStateManager.enableOutlineMode(this.getTeamColor(p_doRender_1_));
        }
        lvt_12_1_.begin(7, DefaultVertexFormats.POSITION_TEX_NORMAL);
        lvt_12_1_.pos(-0.5, -0.25, 0.0).tex(lvt_13_1_, lvt_16_1_).normal(0.0f, 1.0f, 0.0f).endVertex();
        lvt_12_1_.pos(0.5, -0.25, 0.0).tex(lvt_14_1_, lvt_16_1_).normal(0.0f, 1.0f, 0.0f).endVertex();
        lvt_12_1_.pos(0.5, 0.75, 0.0).tex(lvt_14_1_, lvt_15_1_).normal(0.0f, 1.0f, 0.0f).endVertex();
        lvt_12_1_.pos(-0.5, 0.75, 0.0).tex(lvt_13_1_, lvt_15_1_).normal(0.0f, 1.0f, 0.0f).endVertex();
        lvt_11_1_.draw();
        if (this.renderOutlines) {
            GlStateManager.disableOutlineMode();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
        super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityFireball p_getEntityTexture_1_) {
        return TextureMap.LOCATION_BLOCKS_TEXTURE;
    }
}

