/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderFish
extends Render<EntityFishHook> {
    private static final ResourceLocation FISH_PARTICLES = new ResourceLocation("textures/particle/particles.png");

    public RenderFish(RenderManager p_i46175_1_) {
        super(p_i46175_1_);
    }

    @Override
    public void doRender(EntityFishHook p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        double lvt_41_2_;
        double lvt_39_2_;
        double lvt_37_2_;
        double lvt_35_2_;
        EntityPlayer lvt_10_1_ = p_doRender_1_.getAngler();
        if (lvt_10_1_ == null || this.renderOutlines) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)p_doRender_2_, (float)p_doRender_4_, (float)p_doRender_6_);
        GlStateManager.enableRescaleNormal();
        GlStateManager.scale(0.5f, 0.5f, 0.5f);
        this.bindEntityTexture(p_doRender_1_);
        Tessellator lvt_11_1_ = Tessellator.getInstance();
        VertexBuffer lvt_12_1_ = lvt_11_1_.getBuffer();
        boolean lvt_13_1_ = true;
        int lvt_14_1_ = 2;
        float lvt_15_1_ = 0.0625f;
        float lvt_16_1_ = 0.125f;
        float lvt_17_1_ = 0.125f;
        float lvt_18_1_ = 0.1875f;
        float lvt_19_1_ = 1.0f;
        float lvt_20_1_ = 0.5f;
        float lvt_21_1_ = 0.5f;
        GlStateManager.rotate(180.0f - this.renderManager.playerViewY, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate((float)(this.renderManager.options.thirdPersonView == 2 ? -1 : 1) * -this.renderManager.playerViewX, 1.0f, 0.0f, 0.0f);
        if (this.renderOutlines) {
            GlStateManager.enableColorMaterial();
            GlStateManager.enableOutlineMode(this.getTeamColor(p_doRender_1_));
        }
        lvt_12_1_.begin(7, DefaultVertexFormats.POSITION_TEX_NORMAL);
        lvt_12_1_.pos(-0.5, -0.5, 0.0).tex(0.0625, 0.1875).normal(0.0f, 1.0f, 0.0f).endVertex();
        lvt_12_1_.pos(0.5, -0.5, 0.0).tex(0.125, 0.1875).normal(0.0f, 1.0f, 0.0f).endVertex();
        lvt_12_1_.pos(0.5, 0.5, 0.0).tex(0.125, 0.125).normal(0.0f, 1.0f, 0.0f).endVertex();
        lvt_12_1_.pos(-0.5, 0.5, 0.0).tex(0.0625, 0.125).normal(0.0f, 1.0f, 0.0f).endVertex();
        lvt_11_1_.draw();
        if (this.renderOutlines) {
            GlStateManager.disableOutlineMode();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
        int lvt_22_1_ = lvt_10_1_.getPrimaryHand() == EnumHandSide.RIGHT ? 1 : -1;
        ItemStack lvt_23_1_ = lvt_10_1_.getHeldItemMainhand();
        if (lvt_23_1_.getItem() != Items.FISHING_ROD) {
            lvt_22_1_ = -lvt_22_1_;
        }
        float lvt_24_1_ = lvt_10_1_.getSwingProgress(p_doRender_9_);
        float lvt_25_1_ = MathHelper.sin(MathHelper.sqrt(lvt_24_1_) * (float)Math.PI);
        float lvt_26_1_ = (lvt_10_1_.prevRenderYawOffset + (lvt_10_1_.renderYawOffset - lvt_10_1_.prevRenderYawOffset) * p_doRender_9_) * ((float)Math.PI / 180);
        double lvt_27_1_ = MathHelper.sin(lvt_26_1_);
        double lvt_29_1_ = MathHelper.cos(lvt_26_1_);
        double lvt_31_1_ = (double)lvt_22_1_ * 0.35;
        double lvt_33_1_ = 0.8;
        if (this.renderManager.options != null && this.renderManager.options.thirdPersonView > 0 || lvt_10_1_ != Minecraft.getMinecraft().player) {
            double lvt_35_1_ = lvt_10_1_.prevPosX + (lvt_10_1_.posX - lvt_10_1_.prevPosX) * (double)p_doRender_9_ - lvt_29_1_ * lvt_31_1_ - lvt_27_1_ * 0.8;
            double lvt_37_1_ = lvt_10_1_.prevPosY + (double)lvt_10_1_.getEyeHeight() + (lvt_10_1_.posY - lvt_10_1_.prevPosY) * (double)p_doRender_9_ - 0.45;
            double lvt_39_1_ = lvt_10_1_.prevPosZ + (lvt_10_1_.posZ - lvt_10_1_.prevPosZ) * (double)p_doRender_9_ - lvt_27_1_ * lvt_31_1_ + lvt_29_1_ * 0.8;
            double lvt_41_1_ = lvt_10_1_.isSneaking() ? -0.1875 : 0.0;
        } else {
            float lvt_43_1_ = this.renderManager.options.fovSetting;
            Vec3d lvt_44_1_ = new Vec3d((double)lvt_22_1_ * -0.36 * (double)(lvt_43_1_ /= 100.0f), -0.045 * (double)lvt_43_1_, 0.4);
            lvt_44_1_ = lvt_44_1_.rotatePitch(-(lvt_10_1_.prevRotationPitch + (lvt_10_1_.rotationPitch - lvt_10_1_.prevRotationPitch) * p_doRender_9_) * ((float)Math.PI / 180));
            lvt_44_1_ = lvt_44_1_.rotateYaw(-(lvt_10_1_.prevRotationYaw + (lvt_10_1_.rotationYaw - lvt_10_1_.prevRotationYaw) * p_doRender_9_) * ((float)Math.PI / 180));
            lvt_44_1_ = lvt_44_1_.rotateYaw(lvt_25_1_ * 0.5f);
            lvt_44_1_ = lvt_44_1_.rotatePitch(-lvt_25_1_ * 0.7f);
            lvt_35_2_ = lvt_10_1_.prevPosX + (lvt_10_1_.posX - lvt_10_1_.prevPosX) * (double)p_doRender_9_ + lvt_44_1_.xCoord;
            lvt_37_2_ = lvt_10_1_.prevPosY + (lvt_10_1_.posY - lvt_10_1_.prevPosY) * (double)p_doRender_9_ + lvt_44_1_.yCoord;
            lvt_39_2_ = lvt_10_1_.prevPosZ + (lvt_10_1_.posZ - lvt_10_1_.prevPosZ) * (double)p_doRender_9_ + lvt_44_1_.zCoord;
            lvt_41_2_ = lvt_10_1_.getEyeHeight();
        }
        double lvt_43_2_ = p_doRender_1_.prevPosX + (p_doRender_1_.posX - p_doRender_1_.prevPosX) * (double)p_doRender_9_;
        double lvt_45_1_ = p_doRender_1_.prevPosY + (p_doRender_1_.posY - p_doRender_1_.prevPosY) * (double)p_doRender_9_ + 0.25;
        double lvt_47_1_ = p_doRender_1_.prevPosZ + (p_doRender_1_.posZ - p_doRender_1_.prevPosZ) * (double)p_doRender_9_;
        double lvt_49_1_ = (float)(lvt_35_2_ - lvt_43_2_);
        double lvt_51_1_ = (double)((float)(lvt_37_2_ - lvt_45_1_)) + lvt_41_2_;
        double lvt_53_1_ = (float)(lvt_39_2_ - lvt_47_1_);
        GlStateManager.disableTexture2D();
        GlStateManager.disableLighting();
        lvt_12_1_.begin(3, DefaultVertexFormats.POSITION_COLOR);
        int lvt_55_1_ = 16;
        for (int lvt_56_1_ = 0; lvt_56_1_ <= 16; ++lvt_56_1_) {
            float lvt_57_1_ = (float)lvt_56_1_ / 16.0f;
            lvt_12_1_.pos(p_doRender_2_ + lvt_49_1_ * (double)lvt_57_1_, p_doRender_4_ + lvt_51_1_ * (double)(lvt_57_1_ * lvt_57_1_ + lvt_57_1_) * 0.5 + 0.25, p_doRender_6_ + lvt_53_1_ * (double)lvt_57_1_).color(0, 0, 0, 255).endVertex();
        }
        lvt_11_1_.draw();
        GlStateManager.enableLighting();
        GlStateManager.enableTexture2D();
        super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityFishHook p_getEntityTexture_1_) {
        return FISH_PARTICLES;
    }
}

