/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelGuardian;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderGuardian
extends RenderLiving<EntityGuardian> {
    private static final ResourceLocation GUARDIAN_TEXTURE = new ResourceLocation("textures/entity/guardian.png");
    private static final ResourceLocation GUARDIAN_BEAM_TEXTURE = new ResourceLocation("textures/entity/guardian_beam.png");

    public RenderGuardian(RenderManager p_i46171_1_) {
        super(p_i46171_1_, new ModelGuardian(), 0.5f);
    }

    @Override
    public boolean shouldRender(EntityGuardian p_shouldRender_1_, ICamera p_shouldRender_2_, double p_shouldRender_3_, double p_shouldRender_5_, double p_shouldRender_7_) {
        EntityLivingBase lvt_9_1_;
        if (super.shouldRender(p_shouldRender_1_, p_shouldRender_2_, p_shouldRender_3_, p_shouldRender_5_, p_shouldRender_7_)) {
            return true;
        }
        if (p_shouldRender_1_.hasTargetedEntity() && (lvt_9_1_ = p_shouldRender_1_.getTargetedEntity()) != null) {
            Vec3d lvt_10_1_ = this.getPosition(lvt_9_1_, (double)lvt_9_1_.height * 0.5, 1.0f);
            Vec3d lvt_11_1_ = this.getPosition(p_shouldRender_1_, p_shouldRender_1_.getEyeHeight(), 1.0f);
            if (p_shouldRender_2_.isBoundingBoxInFrustum(new AxisAlignedBB(lvt_11_1_.xCoord, lvt_11_1_.yCoord, lvt_11_1_.zCoord, lvt_10_1_.xCoord, lvt_10_1_.yCoord, lvt_10_1_.zCoord))) {
                return true;
            }
        }
        return false;
    }

    private Vec3d getPosition(EntityLivingBase p_getPosition_1_, double p_getPosition_2_, float p_getPosition_4_) {
        double lvt_5_1_ = p_getPosition_1_.lastTickPosX + (p_getPosition_1_.posX - p_getPosition_1_.lastTickPosX) * (double)p_getPosition_4_;
        double lvt_7_1_ = p_getPosition_2_ + p_getPosition_1_.lastTickPosY + (p_getPosition_1_.posY - p_getPosition_1_.lastTickPosY) * (double)p_getPosition_4_;
        double lvt_9_1_ = p_getPosition_1_.lastTickPosZ + (p_getPosition_1_.posZ - p_getPosition_1_.lastTickPosZ) * (double)p_getPosition_4_;
        return new Vec3d(lvt_5_1_, lvt_7_1_, lvt_9_1_);
    }

    @Override
    public void doRender(EntityGuardian p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
        EntityLivingBase lvt_10_1_ = p_doRender_1_.getTargetedEntity();
        if (lvt_10_1_ != null) {
            float lvt_11_1_ = p_doRender_1_.getAttackAnimationScale(p_doRender_9_);
            Tessellator lvt_12_1_ = Tessellator.getInstance();
            VertexBuffer lvt_13_1_ = lvt_12_1_.getBuffer();
            this.bindTexture(GUARDIAN_BEAM_TEXTURE);
            GlStateManager.glTexParameteri(3553, 10242, 10497);
            GlStateManager.glTexParameteri(3553, 10243, 10497);
            GlStateManager.disableLighting();
            GlStateManager.disableCull();
            GlStateManager.disableBlend();
            GlStateManager.depthMask(true);
            float lvt_14_1_ = 240.0f;
            OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, 240.0f, 240.0f);
            GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            float lvt_15_1_ = (float)p_doRender_1_.world.getTotalWorldTime() + p_doRender_9_;
            float lvt_16_1_ = lvt_15_1_ * 0.5f % 1.0f;
            float lvt_17_1_ = p_doRender_1_.getEyeHeight();
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)p_doRender_2_, (float)p_doRender_4_ + lvt_17_1_, (float)p_doRender_6_);
            Vec3d lvt_18_1_ = this.getPosition(lvt_10_1_, (double)lvt_10_1_.height * 0.5, p_doRender_9_);
            Vec3d lvt_19_1_ = this.getPosition(p_doRender_1_, lvt_17_1_, p_doRender_9_);
            Vec3d lvt_20_1_ = lvt_18_1_.subtract(lvt_19_1_);
            double lvt_21_1_ = lvt_20_1_.lengthVector() + 1.0;
            lvt_20_1_ = lvt_20_1_.normalize();
            float lvt_23_1_ = (float)Math.acos(lvt_20_1_.yCoord);
            float lvt_24_1_ = (float)Math.atan2(lvt_20_1_.zCoord, lvt_20_1_.xCoord);
            GlStateManager.rotate((1.5707964f + -lvt_24_1_) * 57.295776f, 0.0f, 1.0f, 0.0f);
            GlStateManager.rotate(lvt_23_1_ * 57.295776f, 1.0f, 0.0f, 0.0f);
            boolean lvt_25_1_ = true;
            double lvt_26_1_ = (double)lvt_15_1_ * 0.05 * -1.5;
            lvt_13_1_.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
            float lvt_28_1_ = lvt_11_1_ * lvt_11_1_;
            int lvt_29_1_ = 64 + (int)(lvt_28_1_ * 191.0f);
            int lvt_30_1_ = 32 + (int)(lvt_28_1_ * 191.0f);
            int lvt_31_1_ = 128 - (int)(lvt_28_1_ * 64.0f);
            double lvt_32_1_ = 0.2;
            double lvt_34_1_ = 0.282;
            double lvt_36_1_ = 0.0 + Math.cos(lvt_26_1_ + 2.356194490192345) * 0.282;
            double lvt_38_1_ = 0.0 + Math.sin(lvt_26_1_ + 2.356194490192345) * 0.282;
            double lvt_40_1_ = 0.0 + Math.cos(lvt_26_1_ + 0.7853981633974483) * 0.282;
            double lvt_42_1_ = 0.0 + Math.sin(lvt_26_1_ + 0.7853981633974483) * 0.282;
            double lvt_44_1_ = 0.0 + Math.cos(lvt_26_1_ + 3.9269908169872414) * 0.282;
            double lvt_46_1_ = 0.0 + Math.sin(lvt_26_1_ + 3.9269908169872414) * 0.282;
            double lvt_48_1_ = 0.0 + Math.cos(lvt_26_1_ + 5.497787143782138) * 0.282;
            double lvt_50_1_ = 0.0 + Math.sin(lvt_26_1_ + 5.497787143782138) * 0.282;
            double lvt_52_1_ = 0.0 + Math.cos(lvt_26_1_ + Math.PI) * 0.2;
            double lvt_54_1_ = 0.0 + Math.sin(lvt_26_1_ + Math.PI) * 0.2;
            double lvt_56_1_ = 0.0 + Math.cos(lvt_26_1_ + 0.0) * 0.2;
            double lvt_58_1_ = 0.0 + Math.sin(lvt_26_1_ + 0.0) * 0.2;
            double lvt_60_1_ = 0.0 + Math.cos(lvt_26_1_ + 1.5707963267948966) * 0.2;
            double lvt_62_1_ = 0.0 + Math.sin(lvt_26_1_ + 1.5707963267948966) * 0.2;
            double lvt_64_1_ = 0.0 + Math.cos(lvt_26_1_ + 4.71238898038469) * 0.2;
            double lvt_66_1_ = 0.0 + Math.sin(lvt_26_1_ + 4.71238898038469) * 0.2;
            double lvt_68_1_ = lvt_21_1_;
            double lvt_70_1_ = 0.0;
            double lvt_72_1_ = 0.4999;
            double lvt_74_1_ = -1.0f + lvt_16_1_;
            double lvt_76_1_ = lvt_21_1_ * 2.5 + lvt_74_1_;
            lvt_13_1_.pos(lvt_52_1_, lvt_68_1_, lvt_54_1_).tex(0.4999, lvt_76_1_).color(lvt_29_1_, lvt_30_1_, lvt_31_1_, 255).endVertex();
            lvt_13_1_.pos(lvt_52_1_, 0.0, lvt_54_1_).tex(0.4999, lvt_74_1_).color(lvt_29_1_, lvt_30_1_, lvt_31_1_, 255).endVertex();
            lvt_13_1_.pos(lvt_56_1_, 0.0, lvt_58_1_).tex(0.0, lvt_74_1_).color(lvt_29_1_, lvt_30_1_, lvt_31_1_, 255).endVertex();
            lvt_13_1_.pos(lvt_56_1_, lvt_68_1_, lvt_58_1_).tex(0.0, lvt_76_1_).color(lvt_29_1_, lvt_30_1_, lvt_31_1_, 255).endVertex();
            lvt_13_1_.pos(lvt_60_1_, lvt_68_1_, lvt_62_1_).tex(0.4999, lvt_76_1_).color(lvt_29_1_, lvt_30_1_, lvt_31_1_, 255).endVertex();
            lvt_13_1_.pos(lvt_60_1_, 0.0, lvt_62_1_).tex(0.4999, lvt_74_1_).color(lvt_29_1_, lvt_30_1_, lvt_31_1_, 255).endVertex();
            lvt_13_1_.pos(lvt_64_1_, 0.0, lvt_66_1_).tex(0.0, lvt_74_1_).color(lvt_29_1_, lvt_30_1_, lvt_31_1_, 255).endVertex();
            lvt_13_1_.pos(lvt_64_1_, lvt_68_1_, lvt_66_1_).tex(0.0, lvt_76_1_).color(lvt_29_1_, lvt_30_1_, lvt_31_1_, 255).endVertex();
            double lvt_78_1_ = 0.0;
            if (p_doRender_1_.ticksExisted % 2 == 0) {
                lvt_78_1_ = 0.5;
            }
            lvt_13_1_.pos(lvt_36_1_, lvt_68_1_, lvt_38_1_).tex(0.5, lvt_78_1_ + 0.5).color(lvt_29_1_, lvt_30_1_, lvt_31_1_, 255).endVertex();
            lvt_13_1_.pos(lvt_40_1_, lvt_68_1_, lvt_42_1_).tex(1.0, lvt_78_1_ + 0.5).color(lvt_29_1_, lvt_30_1_, lvt_31_1_, 255).endVertex();
            lvt_13_1_.pos(lvt_48_1_, lvt_68_1_, lvt_50_1_).tex(1.0, lvt_78_1_).color(lvt_29_1_, lvt_30_1_, lvt_31_1_, 255).endVertex();
            lvt_13_1_.pos(lvt_44_1_, lvt_68_1_, lvt_46_1_).tex(0.5, lvt_78_1_).color(lvt_29_1_, lvt_30_1_, lvt_31_1_, 255).endVertex();
            lvt_12_1_.draw();
            GlStateManager.popMatrix();
        }
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityGuardian p_getEntityTexture_1_) {
        return GUARDIAN_TEXTURE;
    }
}

