/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelIronGolem;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerIronGolemFlower;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderIronGolem
extends RenderLiving<EntityIronGolem> {
    private static final ResourceLocation IRON_GOLEM_TEXTURES = new ResourceLocation("textures/entity/iron_golem.png");

    public RenderIronGolem(RenderManager p_i46133_1_) {
        super(p_i46133_1_, new ModelIronGolem(), 0.5f);
        this.addLayer(new LayerIronGolemFlower(this));
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityIronGolem p_getEntityTexture_1_) {
        return IRON_GOLEM_TEXTURES;
    }

    @Override
    protected void applyRotations(EntityIronGolem p_applyRotations_1_, float p_applyRotations_2_, float p_applyRotations_3_, float p_applyRotations_4_) {
        super.applyRotations(p_applyRotations_1_, p_applyRotations_2_, p_applyRotations_3_, p_applyRotations_4_);
        if ((double)p_applyRotations_1_.limbSwingAmount < 0.01) {
            return;
        }
        float lvt_5_1_ = 13.0f;
        float lvt_6_1_ = p_applyRotations_1_.limbSwing - p_applyRotations_1_.limbSwingAmount * (1.0f - p_applyRotations_4_) + 6.0f;
        float lvt_7_1_ = (Math.abs(lvt_6_1_ % 13.0f - 6.5f) - 3.25f) / 3.25f;
        GlStateManager.rotate(6.5f * lvt_7_1_, 0.0f, 0.0f, 1.0f);
    }
}

