/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class RenderLiving<T extends EntityLiving>
extends RenderLivingBase<T> {
    public RenderLiving(RenderManager p_i46153_1_, ModelBase p_i46153_2_, float p_i46153_3_) {
        super(p_i46153_1_, p_i46153_2_, p_i46153_3_);
    }

    @Override
    protected boolean canRenderName(T p_canRenderName_1_) {
        return super.canRenderName(p_canRenderName_1_) && (((EntityLivingBase)p_canRenderName_1_).getAlwaysRenderNameTagForRender() || ((Entity)p_canRenderName_1_).hasCustomName() && p_canRenderName_1_ == this.renderManager.pointedEntity);
    }

    @Override
    public boolean shouldRender(T p_shouldRender_1_, ICamera p_shouldRender_2_, double p_shouldRender_3_, double p_shouldRender_5_, double p_shouldRender_7_) {
        if (super.shouldRender(p_shouldRender_1_, p_shouldRender_2_, p_shouldRender_3_, p_shouldRender_5_, p_shouldRender_7_)) {
            return true;
        }
        if (((EntityLiving)p_shouldRender_1_).getLeashed() && ((EntityLiving)p_shouldRender_1_).getLeashedToEntity() != null) {
            Entity lvt_9_1_ = ((EntityLiving)p_shouldRender_1_).getLeashedToEntity();
            return p_shouldRender_2_.isBoundingBoxInFrustum(lvt_9_1_.getRenderBoundingBox());
        }
        return false;
    }

    @Override
    public void doRender(T p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
        if (!this.renderOutlines) {
            this.renderLeash(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
        }
    }

    public void setLightmap(T p_setLightmap_1_, float p_setLightmap_2_) {
        int lvt_3_1_ = ((Entity)p_setLightmap_1_).getBrightnessForRender(p_setLightmap_2_);
        int lvt_4_1_ = lvt_3_1_ % 65536;
        int lvt_5_1_ = lvt_3_1_ / 65536;
        OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, lvt_4_1_, lvt_5_1_);
    }

    private double interpolateValue(double p_interpolateValue_1_, double p_interpolateValue_3_, double p_interpolateValue_5_) {
        return p_interpolateValue_1_ + (p_interpolateValue_3_ - p_interpolateValue_1_) * p_interpolateValue_5_;
    }

    protected void renderLeash(T p_renderLeash_1_, double p_renderLeash_2_, double p_renderLeash_4_, double p_renderLeash_6_, float p_renderLeash_8_, float p_renderLeash_9_) {
        Entity lvt_10_1_ = ((EntityLiving)p_renderLeash_1_).getLeashedToEntity();
        if (lvt_10_1_ == null) {
            return;
        }
        p_renderLeash_4_ -= (1.6 - (double)((EntityLiving)p_renderLeash_1_).height) * 0.5;
        Tessellator lvt_11_1_ = Tessellator.getInstance();
        VertexBuffer lvt_12_1_ = lvt_11_1_.getBuffer();
        double lvt_13_1_ = this.interpolateValue(lvt_10_1_.prevRotationYaw, lvt_10_1_.rotationYaw, p_renderLeash_9_ * 0.5f) * 0.01745329238474369;
        double lvt_15_1_ = this.interpolateValue(lvt_10_1_.prevRotationPitch, lvt_10_1_.rotationPitch, p_renderLeash_9_ * 0.5f) * 0.01745329238474369;
        double lvt_17_1_ = Math.cos(lvt_13_1_);
        double lvt_19_1_ = Math.sin(lvt_13_1_);
        double lvt_21_1_ = Math.sin(lvt_15_1_);
        if (lvt_10_1_ instanceof EntityHanging) {
            lvt_17_1_ = 0.0;
            lvt_19_1_ = 0.0;
            lvt_21_1_ = -1.0;
        }
        double lvt_23_1_ = Math.cos(lvt_15_1_);
        double lvt_25_1_ = this.interpolateValue(lvt_10_1_.prevPosX, lvt_10_1_.posX, p_renderLeash_9_) - lvt_17_1_ * 0.7 - lvt_19_1_ * 0.5 * lvt_23_1_;
        double lvt_27_1_ = this.interpolateValue(lvt_10_1_.prevPosY + (double)lvt_10_1_.getEyeHeight() * 0.7, lvt_10_1_.posY + (double)lvt_10_1_.getEyeHeight() * 0.7, p_renderLeash_9_) - lvt_21_1_ * 0.5 - 0.25;
        double lvt_29_1_ = this.interpolateValue(lvt_10_1_.prevPosZ, lvt_10_1_.posZ, p_renderLeash_9_) - lvt_19_1_ * 0.7 + lvt_17_1_ * 0.5 * lvt_23_1_;
        double lvt_31_1_ = this.interpolateValue(((EntityLiving)p_renderLeash_1_).prevRenderYawOffset, ((EntityLiving)p_renderLeash_1_).renderYawOffset, p_renderLeash_9_) * 0.01745329238474369 + 1.5707963267948966;
        lvt_17_1_ = Math.cos(lvt_31_1_) * (double)((EntityLiving)p_renderLeash_1_).width * 0.4;
        lvt_19_1_ = Math.sin(lvt_31_1_) * (double)((EntityLiving)p_renderLeash_1_).width * 0.4;
        double lvt_33_1_ = this.interpolateValue(((EntityLiving)p_renderLeash_1_).prevPosX, ((EntityLiving)p_renderLeash_1_).posX, p_renderLeash_9_) + lvt_17_1_;
        double lvt_35_1_ = this.interpolateValue(((EntityLiving)p_renderLeash_1_).prevPosY, ((EntityLiving)p_renderLeash_1_).posY, p_renderLeash_9_);
        double lvt_37_1_ = this.interpolateValue(((EntityLiving)p_renderLeash_1_).prevPosZ, ((EntityLiving)p_renderLeash_1_).posZ, p_renderLeash_9_) + lvt_19_1_;
        p_renderLeash_2_ += lvt_17_1_;
        p_renderLeash_6_ += lvt_19_1_;
        double lvt_39_1_ = (float)(lvt_25_1_ - lvt_33_1_);
        double lvt_41_1_ = (float)(lvt_27_1_ - lvt_35_1_);
        double lvt_43_1_ = (float)(lvt_29_1_ - lvt_37_1_);
        GlStateManager.disableTexture2D();
        GlStateManager.disableLighting();
        GlStateManager.disableCull();
        int lvt_45_1_ = 24;
        double lvt_46_1_ = 0.025;
        lvt_12_1_.begin(5, DefaultVertexFormats.POSITION_COLOR);
        for (int lvt_48_1_ = 0; lvt_48_1_ <= 24; ++lvt_48_1_) {
            float lvt_49_1_ = 0.5f;
            float lvt_50_1_ = 0.4f;
            float lvt_51_1_ = 0.3f;
            if (lvt_48_1_ % 2 == 0) {
                lvt_49_1_ *= 0.7f;
                lvt_50_1_ *= 0.7f;
                lvt_51_1_ *= 0.7f;
            }
            float lvt_52_1_ = (float)lvt_48_1_ / 24.0f;
            lvt_12_1_.pos(p_renderLeash_2_ + lvt_39_1_ * (double)lvt_52_1_ + 0.0, p_renderLeash_4_ + lvt_41_1_ * (double)(lvt_52_1_ * lvt_52_1_ + lvt_52_1_) * 0.5 + (double)((24.0f - (float)lvt_48_1_) / 18.0f + 0.125f), p_renderLeash_6_ + lvt_43_1_ * (double)lvt_52_1_).color(lvt_49_1_, lvt_50_1_, lvt_51_1_, 1.0f).endVertex();
            lvt_12_1_.pos(p_renderLeash_2_ + lvt_39_1_ * (double)lvt_52_1_ + 0.025, p_renderLeash_4_ + lvt_41_1_ * (double)(lvt_52_1_ * lvt_52_1_ + lvt_52_1_) * 0.5 + (double)((24.0f - (float)lvt_48_1_) / 18.0f + 0.125f) + 0.025, p_renderLeash_6_ + lvt_43_1_ * (double)lvt_52_1_).color(lvt_49_1_, lvt_50_1_, lvt_51_1_, 1.0f).endVertex();
        }
        lvt_11_1_.draw();
        lvt_12_1_.begin(5, DefaultVertexFormats.POSITION_COLOR);
        for (int lvt_48_2_ = 0; lvt_48_2_ <= 24; ++lvt_48_2_) {
            float lvt_49_2_ = 0.5f;
            float lvt_50_2_ = 0.4f;
            float lvt_51_2_ = 0.3f;
            if (lvt_48_2_ % 2 == 0) {
                lvt_49_2_ *= 0.7f;
                lvt_50_2_ *= 0.7f;
                lvt_51_2_ *= 0.7f;
            }
            float lvt_52_2_ = (float)lvt_48_2_ / 24.0f;
            lvt_12_1_.pos(p_renderLeash_2_ + lvt_39_1_ * (double)lvt_52_2_ + 0.0, p_renderLeash_4_ + lvt_41_1_ * (double)(lvt_52_2_ * lvt_52_2_ + lvt_52_2_) * 0.5 + (double)((24.0f - (float)lvt_48_2_) / 18.0f + 0.125f) + 0.025, p_renderLeash_6_ + lvt_43_1_ * (double)lvt_52_2_).color(lvt_49_2_, lvt_50_2_, lvt_51_2_, 1.0f).endVertex();
            lvt_12_1_.pos(p_renderLeash_2_ + lvt_39_1_ * (double)lvt_52_2_ + 0.025, p_renderLeash_4_ + lvt_41_1_ * (double)(lvt_52_2_ * lvt_52_2_ + lvt_52_2_) * 0.5 + (double)((24.0f - (float)lvt_48_2_) / 18.0f + 0.125f), p_renderLeash_6_ + lvt_43_1_ * (double)lvt_52_2_ + 0.025).color(lvt_49_2_, lvt_50_2_, lvt_51_2_, 1.0f).endVertex();
        }
        lvt_11_1_.draw();
        GlStateManager.enableLighting();
        GlStateManager.enableTexture2D();
        GlStateManager.enableCull();
    }

    @Override
    protected /* synthetic */ boolean canRenderName(EntityLivingBase p_canRenderName_1_) {
        return this.canRenderName((T)((EntityLiving)p_canRenderName_1_));
    }
}

