/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderAbstractHorse;
import net.minecraft.client.renderer.entity.RenderAreaEffectCloud;
import net.minecraft.client.renderer.entity.RenderArmorStand;
import net.minecraft.client.renderer.entity.RenderBat;
import net.minecraft.client.renderer.entity.RenderBlaze;
import net.minecraft.client.renderer.entity.RenderBoat;
import net.minecraft.client.renderer.entity.RenderCaveSpider;
import net.minecraft.client.renderer.entity.RenderChicken;
import net.minecraft.client.renderer.entity.RenderCow;
import net.minecraft.client.renderer.entity.RenderCreeper;
import net.minecraft.client.renderer.entity.RenderDragon;
import net.minecraft.client.renderer.entity.RenderDragonFireball;
import net.minecraft.client.renderer.entity.RenderElderGuardian;
import net.minecraft.client.renderer.entity.RenderEnderman;
import net.minecraft.client.renderer.entity.RenderEndermite;
import net.minecraft.client.renderer.entity.RenderEntity;
import net.minecraft.client.renderer.entity.RenderEntityItem;
import net.minecraft.client.renderer.entity.RenderEvoker;
import net.minecraft.client.renderer.entity.RenderEvokerFangs;
import net.minecraft.client.renderer.entity.RenderFallingBlock;
import net.minecraft.client.renderer.entity.RenderFireball;
import net.minecraft.client.renderer.entity.RenderFish;
import net.minecraft.client.renderer.entity.RenderGhast;
import net.minecraft.client.renderer.entity.RenderGiantZombie;
import net.minecraft.client.renderer.entity.RenderGuardian;
import net.minecraft.client.renderer.entity.RenderHorse;
import net.minecraft.client.renderer.entity.RenderHusk;
import net.minecraft.client.renderer.entity.RenderIronGolem;
import net.minecraft.client.renderer.entity.RenderLeashKnot;
import net.minecraft.client.renderer.entity.RenderLightningBolt;
import net.minecraft.client.renderer.entity.RenderLlama;
import net.minecraft.client.renderer.entity.RenderLlamaSpit;
import net.minecraft.client.renderer.entity.RenderMagmaCube;
import net.minecraft.client.renderer.entity.RenderMinecart;
import net.minecraft.client.renderer.entity.RenderMinecartMobSpawner;
import net.minecraft.client.renderer.entity.RenderMooshroom;
import net.minecraft.client.renderer.entity.RenderOcelot;
import net.minecraft.client.renderer.entity.RenderPainting;
import net.minecraft.client.renderer.entity.RenderPig;
import net.minecraft.client.renderer.entity.RenderPigZombie;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RenderPolarBear;
import net.minecraft.client.renderer.entity.RenderPotion;
import net.minecraft.client.renderer.entity.RenderRabbit;
import net.minecraft.client.renderer.entity.RenderSheep;
import net.minecraft.client.renderer.entity.RenderShulker;
import net.minecraft.client.renderer.entity.RenderShulkerBullet;
import net.minecraft.client.renderer.entity.RenderSilverfish;
import net.minecraft.client.renderer.entity.RenderSkeleton;
import net.minecraft.client.renderer.entity.RenderSlime;
import net.minecraft.client.renderer.entity.RenderSnowMan;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.entity.RenderSpectralArrow;
import net.minecraft.client.renderer.entity.RenderSpider;
import net.minecraft.client.renderer.entity.RenderSquid;
import net.minecraft.client.renderer.entity.RenderStray;
import net.minecraft.client.renderer.entity.RenderTNTPrimed;
import net.minecraft.client.renderer.entity.RenderTippedArrow;
import net.minecraft.client.renderer.entity.RenderTntMinecart;
import net.minecraft.client.renderer.entity.RenderVex;
import net.minecraft.client.renderer.entity.RenderVillager;
import net.minecraft.client.renderer.entity.RenderVindicator;
import net.minecraft.client.renderer.entity.RenderWitch;
import net.minecraft.client.renderer.entity.RenderWither;
import net.minecraft.client.renderer.entity.RenderWitherSkeleton;
import net.minecraft.client.renderer.entity.RenderWolf;
import net.minecraft.client.renderer.entity.RenderXPOrb;
import net.minecraft.client.renderer.entity.RenderZombie;
import net.minecraft.client.renderer.entity.RenderZombieVillager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.RenderEnderCrystal;
import net.minecraft.client.renderer.tileentity.RenderItemFrame;
import net.minecraft.client.renderer.tileentity.RenderWitherSkull;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartMobSpawner;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.passive.EntityZombieHorse;
import net.minecraft.entity.projectile.EntityDragonFireball;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.init.Items;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderManager {
    public final Map<Class<? extends Entity>, Render<? extends Entity>> entityRenderMap = Maps.newHashMap();
    private final Map<String, RenderPlayer> skinMap = Maps.newHashMap();
    private final RenderPlayer playerRenderer;
    private FontRenderer textRenderer;
    private double renderPosX;
    private double renderPosY;
    private double renderPosZ;
    public TextureManager renderEngine;
    public World world;
    public Entity renderViewEntity;
    public Entity pointedEntity;
    public float playerViewY;
    public float playerViewX;
    public GameSettings options;
    public double viewerPosX;
    public double viewerPosY;
    public double viewerPosZ;
    private boolean renderOutlines;
    private boolean renderShadow = true;
    private boolean debugBoundingBox;

    public RenderManager(TextureManager p_i46180_1_, RenderItem p_i46180_2_) {
        this.renderEngine = p_i46180_1_;
        this.entityRenderMap.put(EntityCaveSpider.class, new RenderCaveSpider(this));
        this.entityRenderMap.put(EntitySpider.class, new RenderSpider(this));
        this.entityRenderMap.put(EntityPig.class, new RenderPig(this));
        this.entityRenderMap.put(EntitySheep.class, new RenderSheep(this));
        this.entityRenderMap.put(EntityCow.class, new RenderCow(this));
        this.entityRenderMap.put(EntityMooshroom.class, new RenderMooshroom(this));
        this.entityRenderMap.put(EntityWolf.class, new RenderWolf(this));
        this.entityRenderMap.put(EntityChicken.class, new RenderChicken(this));
        this.entityRenderMap.put(EntityOcelot.class, new RenderOcelot(this));
        this.entityRenderMap.put(EntityRabbit.class, new RenderRabbit(this));
        this.entityRenderMap.put(EntitySilverfish.class, new RenderSilverfish(this));
        this.entityRenderMap.put(EntityEndermite.class, new RenderEndermite(this));
        this.entityRenderMap.put(EntityCreeper.class, new RenderCreeper(this));
        this.entityRenderMap.put(EntityEnderman.class, new RenderEnderman(this));
        this.entityRenderMap.put(EntitySnowman.class, new RenderSnowMan(this));
        this.entityRenderMap.put(EntitySkeleton.class, new RenderSkeleton(this));
        this.entityRenderMap.put(EntityWitherSkeleton.class, new RenderWitherSkeleton(this));
        this.entityRenderMap.put(EntityStray.class, new RenderStray(this));
        this.entityRenderMap.put(EntityWitch.class, new RenderWitch(this));
        this.entityRenderMap.put(EntityBlaze.class, new RenderBlaze(this));
        this.entityRenderMap.put(EntityPigZombie.class, new RenderPigZombie(this));
        this.entityRenderMap.put(EntityZombie.class, new RenderZombie(this));
        this.entityRenderMap.put(EntityZombieVillager.class, new RenderZombieVillager(this));
        this.entityRenderMap.put(EntityHusk.class, new RenderHusk(this));
        this.entityRenderMap.put(EntitySlime.class, new RenderSlime(this));
        this.entityRenderMap.put(EntityMagmaCube.class, new RenderMagmaCube(this));
        this.entityRenderMap.put(EntityGiantZombie.class, new RenderGiantZombie(this, 6.0f));
        this.entityRenderMap.put(EntityGhast.class, new RenderGhast(this));
        this.entityRenderMap.put(EntitySquid.class, new RenderSquid(this));
        this.entityRenderMap.put(EntityVillager.class, new RenderVillager(this));
        this.entityRenderMap.put(EntityIronGolem.class, new RenderIronGolem(this));
        this.entityRenderMap.put(EntityBat.class, new RenderBat(this));
        this.entityRenderMap.put(EntityGuardian.class, new RenderGuardian(this));
        this.entityRenderMap.put(EntityElderGuardian.class, new RenderElderGuardian(this));
        this.entityRenderMap.put(EntityShulker.class, new RenderShulker(this));
        this.entityRenderMap.put(EntityPolarBear.class, new RenderPolarBear(this));
        this.entityRenderMap.put(EntityEvoker.class, new RenderEvoker(this));
        this.entityRenderMap.put(EntityVindicator.class, new RenderVindicator(this));
        this.entityRenderMap.put(EntityVex.class, new RenderVex(this));
        this.entityRenderMap.put(EntityDragon.class, new RenderDragon(this));
        this.entityRenderMap.put(EntityEnderCrystal.class, new RenderEnderCrystal(this));
        this.entityRenderMap.put(EntityWither.class, new RenderWither(this));
        this.entityRenderMap.put(Entity.class, new RenderEntity(this));
        this.entityRenderMap.put(EntityPainting.class, new RenderPainting(this));
        this.entityRenderMap.put(EntityItemFrame.class, new RenderItemFrame(this, p_i46180_2_));
        this.entityRenderMap.put(EntityLeashKnot.class, new RenderLeashKnot(this));
        this.entityRenderMap.put(EntityTippedArrow.class, new RenderTippedArrow(this));
        this.entityRenderMap.put(EntitySpectralArrow.class, new RenderSpectralArrow(this));
        this.entityRenderMap.put(EntitySnowball.class, new RenderSnowball(this, Items.SNOWBALL, p_i46180_2_));
        this.entityRenderMap.put(EntityEnderPearl.class, new RenderSnowball(this, Items.ENDER_PEARL, p_i46180_2_));
        this.entityRenderMap.put(EntityEnderEye.class, new RenderSnowball(this, Items.ENDER_EYE, p_i46180_2_));
        this.entityRenderMap.put(EntityEgg.class, new RenderSnowball(this, Items.EGG, p_i46180_2_));
        this.entityRenderMap.put(EntityPotion.class, new RenderPotion(this, p_i46180_2_));
        this.entityRenderMap.put(EntityExpBottle.class, new RenderSnowball(this, Items.EXPERIENCE_BOTTLE, p_i46180_2_));
        this.entityRenderMap.put(EntityFireworkRocket.class, new RenderSnowball(this, Items.FIREWORKS, p_i46180_2_));
        this.entityRenderMap.put(EntityLargeFireball.class, new RenderFireball(this, 2.0f));
        this.entityRenderMap.put(EntitySmallFireball.class, new RenderFireball(this, 0.5f));
        this.entityRenderMap.put(EntityDragonFireball.class, new RenderDragonFireball(this));
        this.entityRenderMap.put(EntityWitherSkull.class, new RenderWitherSkull(this));
        this.entityRenderMap.put(EntityShulkerBullet.class, new RenderShulkerBullet(this));
        this.entityRenderMap.put(EntityItem.class, new RenderEntityItem(this, p_i46180_2_));
        this.entityRenderMap.put(EntityXPOrb.class, new RenderXPOrb(this));
        this.entityRenderMap.put(EntityTNTPrimed.class, new RenderTNTPrimed(this));
        this.entityRenderMap.put(EntityFallingBlock.class, new RenderFallingBlock(this));
        this.entityRenderMap.put(EntityArmorStand.class, new RenderArmorStand(this));
        this.entityRenderMap.put(EntityEvokerFangs.class, new RenderEvokerFangs(this));
        this.entityRenderMap.put(EntityMinecartTNT.class, new RenderTntMinecart(this));
        this.entityRenderMap.put(EntityMinecartMobSpawner.class, new RenderMinecartMobSpawner(this));
        this.entityRenderMap.put(EntityMinecart.class, new RenderMinecart(this));
        this.entityRenderMap.put(EntityBoat.class, new RenderBoat(this));
        this.entityRenderMap.put(EntityFishHook.class, new RenderFish(this));
        this.entityRenderMap.put(EntityAreaEffectCloud.class, new RenderAreaEffectCloud(this));
        this.entityRenderMap.put(EntityHorse.class, new RenderHorse(this));
        this.entityRenderMap.put(EntitySkeletonHorse.class, new RenderAbstractHorse(this));
        this.entityRenderMap.put(EntityZombieHorse.class, new RenderAbstractHorse(this));
        this.entityRenderMap.put(EntityMule.class, new RenderAbstractHorse(this, 0.92f));
        this.entityRenderMap.put(EntityDonkey.class, new RenderAbstractHorse(this, 0.87f));
        this.entityRenderMap.put(EntityLlama.class, new RenderLlama(this));
        this.entityRenderMap.put(EntityLlamaSpit.class, new RenderLlamaSpit(this));
        this.entityRenderMap.put(EntityLightningBolt.class, new RenderLightningBolt(this));
        this.playerRenderer = new RenderPlayer(this);
        this.skinMap.put("default", this.playerRenderer);
        this.skinMap.put("slim", new RenderPlayer(this, true));
        RenderingRegistry.loadEntityRenderers(this, this.entityRenderMap);
    }

    public Map<String, RenderPlayer> getSkinMap() {
        return Collections.unmodifiableMap(this.skinMap);
    }

    public void setRenderPosition(double p_setRenderPosition_1_, double p_setRenderPosition_3_, double p_setRenderPosition_5_) {
        this.renderPosX = p_setRenderPosition_1_;
        this.renderPosY = p_setRenderPosition_3_;
        this.renderPosZ = p_setRenderPosition_5_;
    }

    public <T extends Entity> Render<T> getEntityClassRenderObject(Class<? extends Entity> p_getEntityClassRenderObject_1_) {
        Render<Entity> render = this.entityRenderMap.get(p_getEntityClassRenderObject_1_);
        if (render == null && p_getEntityClassRenderObject_1_ != Entity.class) {
            render = this.getEntityClassRenderObject(p_getEntityClassRenderObject_1_.getSuperclass());
            this.entityRenderMap.put(p_getEntityClassRenderObject_1_, render);
        }
        return render;
    }

    @Nullable
    public <T extends Entity> Render<T> getEntityRenderObject(T p_getEntityRenderObject_1_) {
        if (p_getEntityRenderObject_1_ instanceof AbstractClientPlayer) {
            String s = ((AbstractClientPlayer)p_getEntityRenderObject_1_).getSkinType();
            RenderPlayer renderplayer = this.skinMap.get(s);
            return renderplayer != null ? renderplayer : this.playerRenderer;
        }
        return this.getEntityClassRenderObject(p_getEntityRenderObject_1_.getClass());
    }

    public void cacheActiveRenderInfo(World p_cacheActiveRenderInfo_1_, FontRenderer p_cacheActiveRenderInfo_2_, Entity p_cacheActiveRenderInfo_3_, Entity p_cacheActiveRenderInfo_4_, GameSettings p_cacheActiveRenderInfo_5_, float p_cacheActiveRenderInfo_6_) {
        this.world = p_cacheActiveRenderInfo_1_;
        this.options = p_cacheActiveRenderInfo_5_;
        this.renderViewEntity = p_cacheActiveRenderInfo_3_;
        this.pointedEntity = p_cacheActiveRenderInfo_4_;
        this.textRenderer = p_cacheActiveRenderInfo_2_;
        if (p_cacheActiveRenderInfo_3_ instanceof EntityLivingBase && ((EntityLivingBase)p_cacheActiveRenderInfo_3_).isPlayerSleeping()) {
            IBlockState iblockstate = p_cacheActiveRenderInfo_1_.getBlockState(new BlockPos(p_cacheActiveRenderInfo_3_));
            Block block = iblockstate.getBlock();
            if (block.isBed(iblockstate, p_cacheActiveRenderInfo_1_, new BlockPos(p_cacheActiveRenderInfo_3_), (EntityLivingBase)p_cacheActiveRenderInfo_3_)) {
                int i = block.getBedDirection(iblockstate, p_cacheActiveRenderInfo_1_, new BlockPos(p_cacheActiveRenderInfo_3_)).getHorizontalIndex();
                this.playerViewY = i * 90 + 180;
                this.playerViewX = 0.0f;
            }
        } else {
            this.playerViewY = p_cacheActiveRenderInfo_3_.prevRotationYaw + (p_cacheActiveRenderInfo_3_.rotationYaw - p_cacheActiveRenderInfo_3_.prevRotationYaw) * p_cacheActiveRenderInfo_6_;
            this.playerViewX = p_cacheActiveRenderInfo_3_.prevRotationPitch + (p_cacheActiveRenderInfo_3_.rotationPitch - p_cacheActiveRenderInfo_3_.prevRotationPitch) * p_cacheActiveRenderInfo_6_;
        }
        if (p_cacheActiveRenderInfo_5_.thirdPersonView == 2) {
            this.playerViewY += 180.0f;
        }
        this.viewerPosX = p_cacheActiveRenderInfo_3_.lastTickPosX + (p_cacheActiveRenderInfo_3_.posX - p_cacheActiveRenderInfo_3_.lastTickPosX) * (double)p_cacheActiveRenderInfo_6_;
        this.viewerPosY = p_cacheActiveRenderInfo_3_.lastTickPosY + (p_cacheActiveRenderInfo_3_.posY - p_cacheActiveRenderInfo_3_.lastTickPosY) * (double)p_cacheActiveRenderInfo_6_;
        this.viewerPosZ = p_cacheActiveRenderInfo_3_.lastTickPosZ + (p_cacheActiveRenderInfo_3_.posZ - p_cacheActiveRenderInfo_3_.lastTickPosZ) * (double)p_cacheActiveRenderInfo_6_;
    }

    public void setPlayerViewY(float p_setPlayerViewY_1_) {
        this.playerViewY = p_setPlayerViewY_1_;
    }

    public boolean isRenderShadow() {
        return this.renderShadow;
    }

    public void setRenderShadow(boolean p_setRenderShadow_1_) {
        this.renderShadow = p_setRenderShadow_1_;
    }

    public void setDebugBoundingBox(boolean p_setDebugBoundingBox_1_) {
        this.debugBoundingBox = p_setDebugBoundingBox_1_;
    }

    public boolean isDebugBoundingBox() {
        return this.debugBoundingBox;
    }

    public boolean isRenderMultipass(Entity p_isRenderMultipass_1_) {
        return this.getEntityRenderObject(p_isRenderMultipass_1_).isMultipass();
    }

    public boolean shouldRender(Entity p_shouldRender_1_, ICamera p_shouldRender_2_, double p_shouldRender_3_, double p_shouldRender_5_, double p_shouldRender_7_) {
        Render<Entity> render = this.getEntityRenderObject(p_shouldRender_1_);
        return render != null && render.shouldRender(p_shouldRender_1_, p_shouldRender_2_, p_shouldRender_3_, p_shouldRender_5_, p_shouldRender_7_);
    }

    public void renderEntityStatic(Entity p_renderEntityStatic_1_, float p_renderEntityStatic_2_, boolean p_renderEntityStatic_3_) {
        if (p_renderEntityStatic_1_.ticksExisted == 0) {
            p_renderEntityStatic_1_.lastTickPosX = p_renderEntityStatic_1_.posX;
            p_renderEntityStatic_1_.lastTickPosY = p_renderEntityStatic_1_.posY;
            p_renderEntityStatic_1_.lastTickPosZ = p_renderEntityStatic_1_.posZ;
        }
        double d0 = p_renderEntityStatic_1_.lastTickPosX + (p_renderEntityStatic_1_.posX - p_renderEntityStatic_1_.lastTickPosX) * (double)p_renderEntityStatic_2_;
        double d1 = p_renderEntityStatic_1_.lastTickPosY + (p_renderEntityStatic_1_.posY - p_renderEntityStatic_1_.lastTickPosY) * (double)p_renderEntityStatic_2_;
        double d2 = p_renderEntityStatic_1_.lastTickPosZ + (p_renderEntityStatic_1_.posZ - p_renderEntityStatic_1_.lastTickPosZ) * (double)p_renderEntityStatic_2_;
        float f = p_renderEntityStatic_1_.prevRotationYaw + (p_renderEntityStatic_1_.rotationYaw - p_renderEntityStatic_1_.prevRotationYaw) * p_renderEntityStatic_2_;
        int i = p_renderEntityStatic_1_.getBrightnessForRender(p_renderEntityStatic_2_);
        if (p_renderEntityStatic_1_.isBurning()) {
            i = 0xF000F0;
        }
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, j, k);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.doRenderEntity(p_renderEntityStatic_1_, d0 - this.renderPosX, d1 - this.renderPosY, d2 - this.renderPosZ, f, p_renderEntityStatic_2_, p_renderEntityStatic_3_);
    }

    public void doRenderEntity(Entity p_doRenderEntity_1_, double p_doRenderEntity_2_, double p_doRenderEntity_4_, double p_doRenderEntity_6_, float p_doRenderEntity_8_, float p_doRenderEntity_9_, boolean p_doRenderEntity_10_) {
        block9: {
            Render<Entity> render = null;
            try {
                render = this.getEntityRenderObject(p_doRenderEntity_1_);
                if (render == null || this.renderEngine == null) break block9;
                try {
                    render.setRenderOutlines(this.renderOutlines);
                    render.doRender(p_doRenderEntity_1_, p_doRenderEntity_2_, p_doRenderEntity_4_, p_doRenderEntity_6_, p_doRenderEntity_8_, p_doRenderEntity_9_);
                }
                catch (Throwable throwable1) {
                    throw new ReportedException(CrashReport.makeCrashReport(throwable1, "Rendering entity in world"));
                }
                try {
                    if (!this.renderOutlines) {
                        render.doRenderShadowAndFire(p_doRenderEntity_1_, p_doRenderEntity_2_, p_doRenderEntity_4_, p_doRenderEntity_6_, p_doRenderEntity_8_, p_doRenderEntity_9_);
                    }
                }
                catch (Throwable throwable2) {
                    throw new ReportedException(CrashReport.makeCrashReport(throwable2, "Post-rendering entity in world"));
                }
                if (!this.debugBoundingBox || p_doRenderEntity_1_.isInvisible() || p_doRenderEntity_10_ || Minecraft.getMinecraft().isReducedDebug()) break block9;
                try {
                    this.renderDebugBoundingBox(p_doRenderEntity_1_, p_doRenderEntity_2_, p_doRenderEntity_4_, p_doRenderEntity_6_, p_doRenderEntity_8_, p_doRenderEntity_9_);
                }
                catch (Throwable throwable) {
                    throw new ReportedException(CrashReport.makeCrashReport(throwable, "Rendering entity hitbox in world"));
                }
            }
            catch (Throwable throwable3) {
                CrashReport crashreport = CrashReport.makeCrashReport(throwable3, "Rendering entity in world");
                CrashReportCategory crashreportcategory = crashreport.makeCategory("Entity being rendered");
                p_doRenderEntity_1_.addEntityCrashInfo(crashreportcategory);
                CrashReportCategory crashreportcategory1 = crashreport.makeCategory("Renderer details");
                crashreportcategory1.addCrashSection("Assigned renderer", render);
                crashreportcategory1.addCrashSection("Location", CrashReportCategory.getCoordinateInfo(p_doRenderEntity_2_, p_doRenderEntity_4_, p_doRenderEntity_6_));
                crashreportcategory1.addCrashSection("Rotation", Float.valueOf(p_doRenderEntity_8_));
                crashreportcategory1.addCrashSection("Delta", Float.valueOf(p_doRenderEntity_9_));
                throw new ReportedException(crashreport);
            }
        }
    }

    public void renderMultipass(Entity p_renderMultipass_1_, float p_renderMultipass_2_) {
        if (p_renderMultipass_1_.ticksExisted == 0) {
            p_renderMultipass_1_.lastTickPosX = p_renderMultipass_1_.posX;
            p_renderMultipass_1_.lastTickPosY = p_renderMultipass_1_.posY;
            p_renderMultipass_1_.lastTickPosZ = p_renderMultipass_1_.posZ;
        }
        double d0 = p_renderMultipass_1_.lastTickPosX + (p_renderMultipass_1_.posX - p_renderMultipass_1_.lastTickPosX) * (double)p_renderMultipass_2_;
        double d1 = p_renderMultipass_1_.lastTickPosY + (p_renderMultipass_1_.posY - p_renderMultipass_1_.lastTickPosY) * (double)p_renderMultipass_2_;
        double d2 = p_renderMultipass_1_.lastTickPosZ + (p_renderMultipass_1_.posZ - p_renderMultipass_1_.lastTickPosZ) * (double)p_renderMultipass_2_;
        float f = p_renderMultipass_1_.prevRotationYaw + (p_renderMultipass_1_.rotationYaw - p_renderMultipass_1_.prevRotationYaw) * p_renderMultipass_2_;
        int i = p_renderMultipass_1_.getBrightnessForRender(p_renderMultipass_2_);
        if (p_renderMultipass_1_.isBurning()) {
            i = 0xF000F0;
        }
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, j, k);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        Render<Entity> render = this.getEntityRenderObject(p_renderMultipass_1_);
        if (render != null && this.renderEngine != null) {
            render.renderMultipass(p_renderMultipass_1_, d0 - this.renderPosX, d1 - this.renderPosY, d2 - this.renderPosZ, f, p_renderMultipass_2_);
        }
    }

    private void renderDebugBoundingBox(Entity p_renderDebugBoundingBox_1_, double p_renderDebugBoundingBox_2_, double p_renderDebugBoundingBox_4_, double p_renderDebugBoundingBox_6_, float p_renderDebugBoundingBox_8_, float p_renderDebugBoundingBox_9_) {
        GlStateManager.depthMask(false);
        GlStateManager.disableTexture2D();
        GlStateManager.disableLighting();
        GlStateManager.disableCull();
        GlStateManager.disableBlend();
        float f = p_renderDebugBoundingBox_1_.width / 2.0f;
        AxisAlignedBB axisalignedbb = p_renderDebugBoundingBox_1_.getEntityBoundingBox();
        RenderGlobal.drawBoundingBox(axisalignedbb.minX - p_renderDebugBoundingBox_1_.posX + p_renderDebugBoundingBox_2_, axisalignedbb.minY - p_renderDebugBoundingBox_1_.posY + p_renderDebugBoundingBox_4_, axisalignedbb.minZ - p_renderDebugBoundingBox_1_.posZ + p_renderDebugBoundingBox_6_, axisalignedbb.maxX - p_renderDebugBoundingBox_1_.posX + p_renderDebugBoundingBox_2_, axisalignedbb.maxY - p_renderDebugBoundingBox_1_.posY + p_renderDebugBoundingBox_4_, axisalignedbb.maxZ - p_renderDebugBoundingBox_1_.posZ + p_renderDebugBoundingBox_6_, 1.0f, 1.0f, 1.0f, 1.0f);
        Entity[] aentity = p_renderDebugBoundingBox_1_.getParts();
        if (aentity != null) {
            for (Entity entity : aentity) {
                double d0 = (entity.posX - entity.prevPosX) * (double)p_renderDebugBoundingBox_9_;
                double d1 = (entity.posY - entity.prevPosY) * (double)p_renderDebugBoundingBox_9_;
                double d2 = (entity.posZ - entity.prevPosZ) * (double)p_renderDebugBoundingBox_9_;
                AxisAlignedBB axisalignedbb1 = entity.getEntityBoundingBox();
                RenderGlobal.drawBoundingBox(axisalignedbb1.minX - this.renderPosX + d0, axisalignedbb1.minY - this.renderPosY + d1, axisalignedbb1.minZ - this.renderPosZ + d2, axisalignedbb1.maxX - this.renderPosX + d0, axisalignedbb1.maxY - this.renderPosY + d1, axisalignedbb1.maxZ - this.renderPosZ + d2, 0.25f, 1.0f, 0.0f, 1.0f);
            }
        }
        if (p_renderDebugBoundingBox_1_ instanceof EntityLivingBase) {
            float f1 = 0.01f;
            RenderGlobal.drawBoundingBox(p_renderDebugBoundingBox_2_ - (double)f, p_renderDebugBoundingBox_4_ + (double)p_renderDebugBoundingBox_1_.getEyeHeight() - (double)0.01f, p_renderDebugBoundingBox_6_ - (double)f, p_renderDebugBoundingBox_2_ + (double)f, p_renderDebugBoundingBox_4_ + (double)p_renderDebugBoundingBox_1_.getEyeHeight() + (double)0.01f, p_renderDebugBoundingBox_6_ + (double)f, 1.0f, 0.0f, 0.0f, 1.0f);
        }
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        Vec3d vec3d = p_renderDebugBoundingBox_1_.getLook(p_renderDebugBoundingBox_9_);
        vertexbuffer.begin(3, DefaultVertexFormats.POSITION_COLOR);
        vertexbuffer.pos(p_renderDebugBoundingBox_2_, p_renderDebugBoundingBox_4_ + (double)p_renderDebugBoundingBox_1_.getEyeHeight(), p_renderDebugBoundingBox_6_).color(0, 0, 255, 255).endVertex();
        vertexbuffer.pos(p_renderDebugBoundingBox_2_ + vec3d.xCoord * 2.0, p_renderDebugBoundingBox_4_ + (double)p_renderDebugBoundingBox_1_.getEyeHeight() + vec3d.yCoord * 2.0, p_renderDebugBoundingBox_6_ + vec3d.zCoord * 2.0).color(0, 0, 255, 255).endVertex();
        tessellator.draw();
        GlStateManager.enableTexture2D();
        GlStateManager.enableLighting();
        GlStateManager.enableCull();
        GlStateManager.disableBlend();
        GlStateManager.depthMask(true);
    }

    public void setWorld(World p_setWorld_1_) {
        this.world = p_setWorld_1_;
        if (p_setWorld_1_ == null) {
            this.renderViewEntity = null;
        }
    }

    public double getDistanceToCamera(double p_getDistanceToCamera_1_, double p_getDistanceToCamera_3_, double p_getDistanceToCamera_5_) {
        double d0 = p_getDistanceToCamera_1_ - this.viewerPosX;
        double d1 = p_getDistanceToCamera_3_ - this.viewerPosY;
        double d2 = p_getDistanceToCamera_5_ - this.viewerPosZ;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public FontRenderer getFontRenderer() {
        return this.textRenderer;
    }

    public void setRenderOutlines(boolean p_setRenderOutlines_1_) {
        this.renderOutlines = p_setRenderOutlines_1_;
    }
}

