/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelMinecart;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderMinecart<T extends EntityMinecart>
extends Render<T> {
    private static final ResourceLocation MINECART_TEXTURES = new ResourceLocation("textures/entity/minecart.png");
    protected ModelBase modelMinecart = new ModelMinecart();

    public RenderMinecart(RenderManager p_i46155_1_) {
        super(p_i46155_1_);
        this.shadowSize = 0.5f;
    }

    @Override
    public void doRender(T p_doRender_1_, double p_doRender_2_, double p_doRender_4_, double p_doRender_6_, float p_doRender_8_, float p_doRender_9_) {
        IBlockState lvt_28_1_;
        GlStateManager.pushMatrix();
        this.bindEntityTexture(p_doRender_1_);
        long lvt_10_1_ = (long)((Entity)p_doRender_1_).getEntityId() * 493286711L;
        lvt_10_1_ = lvt_10_1_ * lvt_10_1_ * 4392167121L + lvt_10_1_ * 98761L;
        float lvt_12_1_ = (((float)(lvt_10_1_ >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float lvt_13_1_ = (((float)(lvt_10_1_ >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float lvt_14_1_ = (((float)(lvt_10_1_ >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        GlStateManager.translate(lvt_12_1_, lvt_13_1_, lvt_14_1_);
        double lvt_15_1_ = ((EntityMinecart)p_doRender_1_).lastTickPosX + (((EntityMinecart)p_doRender_1_).posX - ((EntityMinecart)p_doRender_1_).lastTickPosX) * (double)p_doRender_9_;
        double lvt_17_1_ = ((EntityMinecart)p_doRender_1_).lastTickPosY + (((EntityMinecart)p_doRender_1_).posY - ((EntityMinecart)p_doRender_1_).lastTickPosY) * (double)p_doRender_9_;
        double lvt_19_1_ = ((EntityMinecart)p_doRender_1_).lastTickPosZ + (((EntityMinecart)p_doRender_1_).posZ - ((EntityMinecart)p_doRender_1_).lastTickPosZ) * (double)p_doRender_9_;
        double lvt_21_1_ = 0.3f;
        Vec3d lvt_23_1_ = ((EntityMinecart)p_doRender_1_).getPos(lvt_15_1_, lvt_17_1_, lvt_19_1_);
        float lvt_24_1_ = ((EntityMinecart)p_doRender_1_).prevRotationPitch + (((EntityMinecart)p_doRender_1_).rotationPitch - ((EntityMinecart)p_doRender_1_).prevRotationPitch) * p_doRender_9_;
        if (lvt_23_1_ != null) {
            Vec3d lvt_25_1_ = ((EntityMinecart)p_doRender_1_).getPosOffset(lvt_15_1_, lvt_17_1_, lvt_19_1_, 0.3f);
            Vec3d lvt_26_1_ = ((EntityMinecart)p_doRender_1_).getPosOffset(lvt_15_1_, lvt_17_1_, lvt_19_1_, -0.3f);
            if (lvt_25_1_ == null) {
                lvt_25_1_ = lvt_23_1_;
            }
            if (lvt_26_1_ == null) {
                lvt_26_1_ = lvt_23_1_;
            }
            p_doRender_2_ += lvt_23_1_.xCoord - lvt_15_1_;
            p_doRender_4_ += (lvt_25_1_.yCoord + lvt_26_1_.yCoord) / 2.0 - lvt_17_1_;
            p_doRender_6_ += lvt_23_1_.zCoord - lvt_19_1_;
            Vec3d lvt_27_1_ = lvt_26_1_.addVector(-lvt_25_1_.xCoord, -lvt_25_1_.yCoord, -lvt_25_1_.zCoord);
            if (lvt_27_1_.lengthVector() != 0.0) {
                lvt_27_1_ = lvt_27_1_.normalize();
                p_doRender_8_ = (float)(Math.atan2(lvt_27_1_.zCoord, lvt_27_1_.xCoord) * 180.0 / Math.PI);
                lvt_24_1_ = (float)(Math.atan(lvt_27_1_.yCoord) * 73.0);
            }
        }
        GlStateManager.translate((float)p_doRender_2_, (float)p_doRender_4_ + 0.375f, (float)p_doRender_6_);
        GlStateManager.rotate(180.0f - p_doRender_8_, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate(-lvt_24_1_, 0.0f, 0.0f, 1.0f);
        float lvt_25_2_ = (float)((EntityMinecart)p_doRender_1_).getRollingAmplitude() - p_doRender_9_;
        float lvt_26_2_ = ((EntityMinecart)p_doRender_1_).getDamage() - p_doRender_9_;
        if (lvt_26_2_ < 0.0f) {
            lvt_26_2_ = 0.0f;
        }
        if (lvt_25_2_ > 0.0f) {
            GlStateManager.rotate(MathHelper.sin(lvt_25_2_) * lvt_25_2_ * lvt_26_2_ / 10.0f * (float)((EntityMinecart)p_doRender_1_).getRollingDirection(), 1.0f, 0.0f, 0.0f);
        }
        int lvt_27_2_ = ((EntityMinecart)p_doRender_1_).getDisplayTileOffset();
        if (this.renderOutlines) {
            GlStateManager.enableColorMaterial();
            GlStateManager.enableOutlineMode(this.getTeamColor(p_doRender_1_));
        }
        if ((lvt_28_1_ = ((EntityMinecart)p_doRender_1_).getDisplayTile()).getRenderType() != EnumBlockRenderType.INVISIBLE) {
            GlStateManager.pushMatrix();
            this.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
            float lvt_29_1_ = 0.75f;
            GlStateManager.scale(0.75f, 0.75f, 0.75f);
            GlStateManager.translate(-0.5f, (float)(lvt_27_2_ - 8) / 16.0f, 0.5f);
            this.renderCartContents(p_doRender_1_, p_doRender_9_, lvt_28_1_);
            GlStateManager.popMatrix();
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            this.bindEntityTexture(p_doRender_1_);
        }
        GlStateManager.scale(-1.0f, -1.0f, 1.0f);
        this.modelMinecart.render((Entity)p_doRender_1_, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.popMatrix();
        if (this.renderOutlines) {
            GlStateManager.disableOutlineMode();
            GlStateManager.disableColorMaterial();
        }
        super.doRender(p_doRender_1_, p_doRender_2_, p_doRender_4_, p_doRender_6_, p_doRender_8_, p_doRender_9_);
    }

    @Override
    protected ResourceLocation getEntityTexture(T p_getEntityTexture_1_) {
        return MINECART_TEXTURES;
    }

    protected void renderCartContents(T p_renderCartContents_1_, float p_renderCartContents_2_, IBlockState p_renderCartContents_3_) {
        GlStateManager.pushMatrix();
        Minecraft.getMinecraft().getBlockRendererDispatcher().renderBlockBrightness(p_renderCartContents_3_, ((Entity)p_renderCartContents_1_).getBrightness(p_renderCartContents_2_));
        GlStateManager.popMatrix();
    }
}

